/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.EgDiscoveryUtils;
import com.eg.apm.Process;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;

public final class JcmdUtils {
    private static final String fileSep = File.separator;
    private static final String JCMD = EgInstallInfo.getInstallDir() + fileSep + "jre" + fileSep + "bin" + fileSep + "jcmd";
    private static final String VM_SYSTEM_PROPERTIES = "VM.system_properties";
    private static final String VM_COMMAND_LINE = "VM.command_line";
    private static final String loggerDispStr = "[JcmdUtils]";
    private static final JcmdUtils INSTANCE = new JcmdUtils();

    private JcmdUtils() {
    }

    public static JcmdUtils getInstance() {
        return INSTANCE;
    }

    public String getCommandLine(String string, String string2) {
        try {
            String string3 = APMUtils.getFullCmd(string2, JCMD + " " + string + " " + VM_COMMAND_LINE);
            ArrayList arrayList = APMUtils.executeCmd(string3, ApmConfigManager.getInstance().getAppDiscoveryExecTimeOut(), string3);
            if (arrayList != null && arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string4 = (String)arrayList.get(i);
                    if (string4 == null || !string4.contains("java_command:")) continue;
                    return string4.replace("java_command: ", "");
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to parse jvm option for  : {}", new Object[]{loggerDispStr, string, exception});
        }
        return "";
    }

    public ArrayList getSystemProperties(String string, String string2) {
        try {
            String string3 = APMUtils.getFullCmd(string2, JCMD + " " + string + " " + VM_SYSTEM_PROPERTIES);
            ArrayList arrayList = APMUtils.executeCmd(string3, ApmConfigManager.getInstance().getAppDiscoveryExecTimeOut(), string3);
            if (arrayList != null && arrayList.size() > 0) {
                return arrayList;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get jvm properties for  : {}", new Object[]{loggerDispStr, string, exception});
        }
        return null;
    }

    public ArrayList getSystemProperties(String string, String string2, String string3) {
        try {
            String string4 = "";
            if (APMUtils.isWindows()) {
                string4 = APMUtils.getFullCmd(string2, JCMD + " " + string + " " + VM_SYSTEM_PROPERTIES);
            } else if (APMUtils.isLinux()) {
                string4 = APMUtils.getFullCmd(string2, EgInstallInfo.getInstallDir() + "/lib/apm/Java/auto-attach/apm_exec.sh" + " jcmd " + string3 + " " + string + " " + VM_SYSTEM_PROPERTIES);
            }
            ArrayList arrayList = APMUtils.executeCmd(string4, ApmConfigManager.getInstance().getAppDiscoveryExecTimeOut(), string4);
            if (arrayList != null && arrayList.size() > 0) {
                return arrayList;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get jvm properties for  : {}", new Object[]{loggerDispStr, string, exception});
        }
        return null;
    }

    void processJcmdLeftOvers(ArrayList arrayList, Hashtable hashtable, EgDiscoveryUtils egDiscoveryUtils) {
        if (arrayList != null && arrayList.size() > 0) {
            long l = System.currentTimeMillis();
            long l2 = 300000L;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    Process process = (Process)arrayList.get(i);
                    if (process.getUser().endsWith("\\SYSTEM")) {
                        long l3 = l - process.getUptime();
                        if (l3 >= l2) {
                            String string = process.getPid();
                            String string2 = (String)hashtable.get(string);
                            if (string2 != null && string2.length() > 0 && string2.contains(JCMD) && (string2.contains(VM_SYSTEM_PROPERTIES) || string2.contains(VM_COMMAND_LINE))) {
                                arrayList2.add(string);
                                continue;
                            }
                            APMDiscoveryLogger.discoveryLogger.debug("{} processJcmdLeftOvers() cmdline not matched with jcmd cmds, Current cmdline : {}", (Object)loggerDispStr, (Object)string2);
                            continue;
                        }
                        APMDiscoveryLogger.discoveryLogger.trace("{} processJcmdLeftOvers() uptime difference not met with 5 min Threshold, Current uptime difference : {}", (Object)loggerDispStr, (Object)l3);
                        continue;
                    }
                    APMDiscoveryLogger.discoveryLogger.trace("{} processJcmdLeftOvers() username not matched with SYSTEM, Current username : {}", (Object)loggerDispStr, (Object)process.getUser());
                    continue;
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} processJcmdLeftOvers() Unable to verify jcmd process ", (Object)loggerDispStr, (Object)exception);
                }
            }
            if (arrayList2.size() > 0) {
                egDiscoveryUtils.killProcess(arrayList2, "[Terminate JCMD LEFT-OVER process]");
            }
        }
    }
}

