/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeCpuFunction {
    private int id = -1;
    private int selfTime = 0;
    private int totalTime = 0;
    private double percentage = 0.0;
    private List<Integer> children;
    private String funcName = "";
    private String functionPath = "";
    private String fqcn = "";
    private String callingAppFuncPath = "-";
    private String callingAppFuncName = "-";
    public static Comparator<NodeCpuFunction> executionTimeComprator = new Comparator<NodeCpuFunction>(){

        @Override
        public int compare(NodeCpuFunction selfTime0, NodeCpuFunction selfTime1) {
            return selfTime1.getSelfTime() - selfTime0.getSelfTime();
        }
    };

    public NodeCpuFunction(String funcName, String functionPath, int id, int selfTime, String callingAppFuncPath, String callingAppFuncName) {
        this.id = id;
        this.funcName = funcName;
        this.selfTime = selfTime;
        this.totalTime = this.getSelfTime();
        this.children = new ArrayList<Integer>();
        if (callingAppFuncPath == null) {
            callingAppFuncPath = "-";
        }
        if (callingAppFuncName == null) {
            callingAppFuncName = "-";
        }
        this.callingAppFuncPath = callingAppFuncPath;
        this.callingAppFuncName = callingAppFuncName;
        if (functionPath == null || functionPath.isEmpty()) {
            this.functionPath = "-";
            this.fqcn = funcName;
        } else {
            this.functionPath = functionPath;
            this.fqcn = String.valueOf(funcName) + " " + functionPath;
        }
    }

    public void addChildren(int id) {
        this.children.add(id);
    }

    public String getFunctionPath() {
        return this.functionPath;
    }

    public void setFunctionPath(String functionPath) {
        this.functionPath = functionPath;
    }

    public String getFqcn() {
        return this.fqcn;
    }

    public void setFqcn(String fqcn) {
        this.fqcn = fqcn;
    }

    public List<Integer> getChildren() {
        return this.children;
    }

    public String getFunctionName() {
        return this.funcName;
    }

    public int getSelfTime() {
        return this.selfTime;
    }

    public void setSelfTime(int selfTime) {
        this.selfTime = selfTime;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public void addTotalTime(int totalTime) {
        this.totalTime += totalTime;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double percentage) {
        this.percentage = (double)Math.round(percentage * 10000.0) / 100.0;
    }

    public int getId() {
        return this.id;
    }

    public String getCallingAppFuncPath() {
        return this.callingAppFuncPath;
    }

    public String getCallingAppFuncName() {
        return this.callingAppFuncName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\n'functionName': '");
        sb.append(this.getFunctionName());
        sb.append("',\n 'functionPath': ");
        sb.append(this.getFunctionPath());
        sb.append("',\n 'selfTime': ");
        sb.append(this.getSelfTime());
        sb.append(",\n 'totalTime': ");
        sb.append(this.getTotalTime());
        sb.append(",\n 'percentage': ");
        sb.append(this.getPercentage());
        sb.append(",\n 'Calling App Func Name': ");
        sb.append(this.callingAppFuncName);
        sb.append(",\n 'Calling App Func path': ");
        sb.append(this.callingAppFuncPath);
        sb.append("\n}");
        return sb.toString();
    }
}

