/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.NodeCpuFunction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeCpuProfileParser {
    private static final int MINTIME = 0;
    private int totalTime = 0;
    private List<NodeCpuFunction> nodesArray = new ArrayList<NodeCpuFunction>();
    Comparator<NodeCpuFunction> nodeComparator = null;

    /*
     * WARNING - void declaration
     */
    public void parse(JSONObject cpuProfile) {
        if (cpuProfile == null) {
            System.out.println("NodeCpuProfileParser - JSONObject is null, returning");
            return;
        }
        try {
            Stack<JSONObject> stack = new Stack<JSONObject>();
            JSONObject head = (JSONObject)cpuProfile.get((Object)"head");
            if (head == null) {
                System.out.println("NodeCpuProfileParser - JSONObject head is null, returning");
                return;
            }
            stack.push(head);
            TreeMap<Integer, NodeCpuFunction> sortedNode = new TreeMap<Integer, NodeCpuFunction>();
            while (!stack.isEmpty()) {
                JSONObject jsonNode = (JSONObject)stack.pop();
                String functionPath = this.getFuncPath(jsonNode);
                String string = this.getFuncName(jsonNode);
                int id = NodeCpuProfileParser.getIntFromJson(jsonNode, "id");
                int selfTime = NodeCpuProfileParser.getIntFromJson(jsonNode, "hitCount");
                String callingAppFuncPath = NodeCpuProfileParser.getStringFromJson(jsonNode, "callingAppFuncPath");
                String callingAppFuncName = NodeCpuProfileParser.getStringFromJson(jsonNode, "callingAppFuncName");
                NodeCpuFunction nodeObj = new NodeCpuFunction(string, functionPath, id, selfTime, callingAppFuncPath, callingAppFuncName);
                sortedNode.put(nodeObj.getId(), nodeObj);
                if (!this.isIgnore(nodeObj)) {
                    this.addTotalTime(nodeObj.getSelfTime());
                }
                boolean isAppFunction = this.isAppFunction(functionPath);
                JSONArray children = (JSONArray)jsonNode.get((Object)"children");
                if (children == null || children.size() <= 0) continue;
                for (JSONObject childNodeObj : children) {
                    int childId = NodeCpuProfileParser.getIntFromJson(childNodeObj, "id");
                    nodeObj.addChildren(childId);
                    if (isAppFunction) {
                        childNodeObj.put((Object)"callingAppFuncPath", (Object)functionPath);
                        childNodeObj.put((Object)"callingAppFuncName", (Object)string);
                    } else {
                        childNodeObj.put((Object)"callingAppFuncPath", (Object)callingAppFuncPath);
                        childNodeObj.put((Object)"callingAppFuncName", (Object)callingAppFuncName);
                    }
                    stack.push(childNodeObj);
                }
            }
            int lastEntryKey = -1;
            HashMap<String, NodeCpuFunction> groupedNodes = new HashMap<String, NodeCpuFunction>();
            while (true) {
                void var7_14;
                Object var7_11 = null;
                if (lastEntryKey == -1) {
                    Map.Entry entry = sortedNode.lastEntry();
                } else {
                    Map.Entry entry = sortedNode.lowerEntry(lastEntryKey);
                }
                if (var7_14 == null) break;
                NodeCpuFunction node = (NodeCpuFunction)var7_14.getValue();
                lastEntryKey = node.getId();
                if (this.isIgnore(node)) continue;
                List<Integer> childer = node.getChildren();
                int i = childer.size() - 1;
                while (i > -1) {
                    int id = childer.get(i);
                    NodeCpuFunction childNode = (NodeCpuFunction)sortedNode.get(id);
                    node.addTotalTime(childNode.getTotalTime());
                    sortedNode.remove(id);
                    --i;
                }
                NodeCpuFunction processedNode = (NodeCpuFunction)groupedNodes.get(node.getFqcn());
                if (processedNode != null) {
                    processedNode.setSelfTime(processedNode.getSelfTime() + node.getSelfTime());
                    processedNode.addTotalTime(node.getTotalTime());
                    continue;
                }
                groupedNodes.put(node.getFqcn(), node);
            }
            for (Map.Entry entry : groupedNodes.entrySet()) {
                NodeCpuFunction node = (NodeCpuFunction)entry.getValue();
                node.setPercentage((double)node.getSelfTime() / (double)this.getTotalTime());
                this.nodesArray.add(node);
            }
            this.nodesArray.sort(NodeCpuFunction.executionTimeComprator);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isAppFunction(String functionPath) {
        if (functionPath == null || functionPath.isEmpty()) {
            return false;
        }
        String[] notAppFunc = new String[]{"\\node_modules\\", "/node_modules/", "node:internal/", "node:", "(root)"};
        int i = 0;
        while (i < notAppFunc.length) {
            if (functionPath.contains(notAppFunc[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isIgnore(NodeCpuFunction node) {
        return node.getFqcn().equalsIgnoreCase("(idle)");
    }

    public List<NodeCpuFunction> getCpuIntensiveFunc(int topMax) {
        if (topMax == 0 || topMax >= this.nodesArray.size()) {
            return this.nodesArray;
        }
        return this.nodesArray.subList(0, topMax);
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    private void addTotalTime(int totalTime) {
        this.totalTime += totalTime;
    }

    private String getFuncName(JSONObject node) {
        String funcName = NodeCpuProfileParser.getStringFromJson(node, "functionName");
        if (funcName == null || funcName.isEmpty()) {
            funcName = "(anonymous function)";
        }
        return funcName;
    }

    private String getFuncPath(JSONObject node) {
        String functionPath = NodeCpuProfileParser.getStringFromJson(node, "url");
        if (functionPath != null && !functionPath.isEmpty()) {
            functionPath = String.valueOf(functionPath) + ':' + NodeCpuProfileParser.getIntFromJson(node, "lineNumber");
        }
        return functionPath;
    }

    private static String getStringFromJson(JSONObject node, String key) {
        return (String)node.get((Object)key);
    }

    public static int getIntFromJson(JSONObject node, String key) {
        return ((Long)node.get((Object)key)).intValue();
    }
}

