/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.ProcessBasedDiscoveryManager;

public class ProcessBasedDiscoveryThread
extends Thread {
    private static ProcessBasedDiscoveryThread discoveryThread = null;
    protected static String loggerDispStr = "[ProcessBasedDiscoveryThread]";
    private volatile boolean runThis = true;
    private static final String threadName_prefix = "eG_ProcessBasedDiscoveryThread";
    private String threadName;

    private ProcessBasedDiscoveryThread() {
        try {
            this.threadName = threadName_prefix;
            this.setName(this.threadName);
            this.setDaemon(true);
            this.start();
            APMDiscoveryLogger.discoveryLogger.info("{} {} - started..", (Object)loggerDispStr, (Object)this.threadName);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred while starting the thread {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    public void run() {
        ApmConfigManager apmConfigManager = ApmConfigManager.getInstance();
        APMUtils.sleep(apmConfigManager.getJavaProcessDiscoveryStartupDelay());
        while (this.runThis) {
            try {
                ProcessBasedDiscoveryManager.getInstance().startDiscovery(true);
                APMUtils.sleep(apmConfigManager.getJavaProcessDiscoveryRediscoverPeriod());
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred while doing process discovery {}", (Object)loggerDispStr, (Object)exception);
            }
        }
        APMDiscoveryLogger.discoveryLogger.info("{} {} - Stopped..", (Object)loggerDispStr, (Object)this.threadName);
        discoveryThread = null;
        this.runThis = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProcessBasedDiscoveryThread getInstance() {
        if (discoveryThread != null) return discoveryThread;
        Class<ProcessBasedDiscoveryThread> clazz = ProcessBasedDiscoveryThread.class;
        synchronized (ProcessBasedDiscoveryThread.class) {
            if (discoveryThread != null) return discoveryThread;
            discoveryThread = new ProcessBasedDiscoveryThread();
            // ** MonitorExit[var0] (shouldn't be in output)
            return discoveryThread;
        }
    }

    public static ProcessBasedDiscoveryThread getInstance(boolean bl) {
        return discoveryThread;
    }

    public void setRunThis(boolean bl) {
        this.runThis = bl;
    }
}

