/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.AgentStartupLogger;
import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import eu.bitwalker.useragentutils.Version;
import java.util.Hashtable;

public class UserAgentUtil {
    public static UserAgent getParsedUserAgent(String userAgent) {
        UserAgent userAgentObj = null;
        try {
            userAgentObj = UserAgent.parseUserAgentString((String)userAgent);
        }
        catch (Exception e) {
            AgentStartupLogger.logger.warn("Exception while parsing UserAgent !!.. so set the default value...{} ", (Throwable)e);
        }
        return userAgentObj;
    }

    public static String getDevice(UserAgent userAgent) {
        String device2 = "Unknown";
        if (userAgent == null) {
            return device2;
        }
        try {
            OperatingSystem osAgent = userAgent.getOperatingSystem();
            if (osAgent != null && (device2 = osAgent.getDeviceType().getName()).equalsIgnoreCase("Computer")) {
                device2 = "Desktop";
            }
        }
        catch (Exception e) {
            AgentStartupLogger.logger.warn("Exception while getting device details !!.. so set the default value...{}", (Throwable)e);
        }
        return device2;
    }

    public static String getOs(UserAgent userAgent) {
        String os = "Unknown";
        if (userAgent == null) {
            return os;
        }
        try {
            OperatingSystem osAgent = userAgent.getOperatingSystem();
            if (osAgent != null) {
                os = osAgent.getName();
                String osLrCase = os.toLowerCase();
                if (osLrCase.indexOf("iphone") > -1 || osLrCase.indexOf("ipod") > -1) {
                    os = "iOS - iPhone";
                } else if (osLrCase.indexOf("ipad") > -1) {
                    os = "iOS - iPad";
                } else if (osLrCase.indexOf("phone") > -1) {
                    if (osLrCase.indexOf("win") > -1 || os.indexOf("windows") > -1) {
                        os = "Windows Mobile";
                    }
                } else if (osLrCase.indexOf("win") > -1 || os.indexOf("windows") > -1) {
                    os = "Windows";
                } else if (osLrCase.indexOf("mac") > -1) {
                    os = "Mac";
                } else if (osLrCase.indexOf("android") > -1) {
                    os = "Android";
                }
            }
        }
        catch (Exception e) {
            AgentStartupLogger.logger.warn("Exception while getting os details !!.. so set the default value...{}", (Throwable)e);
        }
        return os;
    }

    public static String getBrowser(UserAgent userAgent) {
        String browser = "Unknown";
        if (userAgent == null) {
            return browser;
        }
        try {
            Browser brwAgent = userAgent.getBrowser();
            if (brwAgent != null) {
                browser = brwAgent.getGroup().getName();
            }
        }
        catch (Exception e) {
            AgentStartupLogger.logger.warn("Exception while getting browser details !!.. so set the default value...{}", (Throwable)e);
        }
        return browser;
    }

    public static String getBrowserVersion(UserAgent userAgent) {
        String browserVersion = "Unknown";
        if (userAgent == null) {
            return browserVersion;
        }
        try {
            Version brwVersion = userAgent.getBrowserVersion();
            if (brwVersion != null) {
                browserVersion = brwVersion.getVersion();
            }
        }
        catch (Exception e) {
            AgentStartupLogger.logger.warn("Exception while getting browser version details !!.. so set the default value...{}", (Throwable)e);
        }
        return browserVersion;
    }

    public static Hashtable getUserAgentDetails(String userAgent) {
        Hashtable<String, String> userAgentDetails = new Hashtable<String, String>();
        UserAgent userAgentObj = UserAgentUtil.getParsedUserAgent(userAgent);
        userAgentDetails.put("DEVICE", UserAgentUtil.getDevice(userAgentObj));
        userAgentDetails.put("OS", UserAgentUtil.getOs(userAgentObj));
        userAgentDetails.put("BROWSER", UserAgentUtil.getBrowser(userAgentObj));
        userAgentDetails.put("Browser_version", UserAgentUtil.getBrowserVersion(userAgentObj));
        return userAgentDetails;
    }
}

