/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm.util;

import com.egurkha.util.IPAddressUtils;
import org.apache.commons.lang.StringUtils;

public class IPAddressMaskHelper {
    private static String maskIPV4(String ipAddress, String maskChar) {
        Object[] temp = ipAddress.split("\\.");
        temp[3] = maskChar;
        return StringUtils.join((Object[])temp, (String)".");
    }

    private static String appendNtimesMask(String string, int n, String maskChar) {
        StringBuilder sb = new StringBuilder(string);
        int i = 0;
        while (i < n) {
            sb.append(":" + maskChar);
            ++i;
        }
        return sb.toString();
    }

    private static String maskIPV6(String ipAddress, String maskChar) {
        int compressLocation = ipAddress.indexOf("::");
        String result0 = ipAddress;
        if (compressLocation != -1) {
            String[] octets = ipAddress.split("::");
            int nTimes = 8 - (octets[0].split(":").length + octets[1].split(":").length);
            result0 = new StringBuffer(IPAddressMaskHelper.appendNtimesMask(octets[0], nTimes, maskChar)).append(":").append(octets[1]).toString();
        }
        StringBuilder result1 = new StringBuilder();
        int count = 0;
        String[] stringArray = result0.split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (count < 2) {
                ++count;
                result1.append(string).append(":");
            } else if (count < 3) {
                ++count;
                result1.append(string);
            } else {
                result0 = IPAddressMaskHelper.appendNtimesMask(result1.toString(), 5, maskChar);
            }
            ++n2;
        }
        return result0;
    }

    public static String maskIPAddress(String ipAddress, boolean isMaskAllIP, boolean isMaskPublicIPOnly, String maskChar) {
        if (ipAddress == null) {
            throw new RuntimeException("ipAddress is null : " + ipAddress);
        }
        if (ipAddress.indexOf("%") > -1) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf("%"));
        }
        if (!IPAddressUtils.isValidIPAddress((String)ipAddress)) {
            throw new RuntimeException("invalid ipAddress format : " + ipAddress);
        }
        if (isMaskAllIP) {
            if (IPAddressUtils.isValidIPV4((String)ipAddress)) {
                return IPAddressMaskHelper.maskIPV4(ipAddress, maskChar);
            }
            return IPAddressMaskHelper.maskIPV6(ipAddress, maskChar);
        }
        if (!isMaskAllIP && isMaskPublicIPOnly) {
            if (IPAddressUtils.isValidPublicIp((String)ipAddress, (boolean)false)) {
                if (IPAddressUtils.isValidIPV4((String)ipAddress)) {
                    return IPAddressMaskHelper.maskIPV4(ipAddress, maskChar);
                }
                return IPAddressMaskHelper.maskIPV6(ipAddress, maskChar);
            }
        } else {
            System.out.println("Exception occurred while checking ipAddress : " + ipAddress);
        }
        return ipAddress;
    }

    public static String maskIPAddress(String ipAddress, boolean isMaskAllIP, boolean isMaskPublicIPOnly) {
        if (ipAddress == null) {
            throw new RuntimeException("ipAddress is null : " + ipAddress);
        }
        if (ipAddress.indexOf("%") > -1) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf("%"));
        }
        if (!IPAddressUtils.isValidIPAddress((String)ipAddress)) {
            throw new RuntimeException("invalid ipAddress format : " + ipAddress);
        }
        if (isMaskAllIP) {
            if (IPAddressUtils.isValidIPV4((String)ipAddress)) {
                return IPAddressMaskHelper.maskIPV4(ipAddress, "x");
            }
            return IPAddressMaskHelper.maskIPV6(ipAddress, "x");
        }
        if (!isMaskAllIP && isMaskPublicIPOnly) {
            if (IPAddressUtils.isValidPublicIp((String)ipAddress, (boolean)false)) {
                if (IPAddressUtils.isValidIPV4((String)ipAddress)) {
                    return IPAddressMaskHelper.maskIPV4(ipAddress, "x");
                }
                return IPAddressMaskHelper.maskIPV6(ipAddress, "x");
            }
        } else {
            System.out.println("Exception occurred while checking ipAddress : " + ipAddress);
        }
        return ipAddress;
    }

    public static void main(String[] args) {
        System.out.println(IPAddressMaskHelper.maskIPV4("192.168.8.4", "x"));
        System.out.println(IPAddressMaskHelper.maskIPV6("FFED::4562", "z"));
    }
}

