/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BaseDatabaseInfo;
import com.eg.jtm.StringMaker;
import com.eg.org.slf4j.Logger;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoSqlDatabaseInfo
extends BaseDatabaseInfo {
    private static final String MONGO_URL_PREFIX = "mongodb://";
    private static final String DEFAULT_PORT = "27017";

    public MongoSqlDatabaseInfo(String jdbcUrl, String dbType, Logger logger) {
        super(jdbcUrl, dbType, logger);
    }

    @Override
    public Hashtable<String, String> getDBInfo() {
        this.parseUrl();
        Hashtable<String, String> nonsqlDetails = new Hashtable<String, String>();
        nonsqlDetails.put("SERVERTYPE", this.dbType);
        if (this.isParsingFailure) {
            nonsqlDetails.put("SERVERNAME", this.jdbcUrl);
            nonsqlDetails.put("DATABASENAME", "-");
            nonsqlDetails.put("PORTNUMBER", "-");
        } else if (this.hostName == null || this.portNo == null) {
            nonsqlDetails.put("SERVERNAME", this.jdbcUrl);
            nonsqlDetails.put("DATABASENAME", "-");
            nonsqlDetails.put("PORTNUMBER", "-");
        } else {
            nonsqlDetails.put("SERVERNAME", this.hostName);
            nonsqlDetails.put("DATABASENAME", this.databaseName);
            nonsqlDetails.put("PORTNUMBER", this.portNo);
        }
        return nonsqlDetails;
    }

    private void parseUrl() {
        if (this.jdbcUrl == null) {
            this.logger.warn("[" + this.dbType + "  - parseUrl] jdbcUrl must not be null");
            return;
        }
        try {
            String normalizedUrl = this.jdbcUrl.toLowerCase();
            StringMaker maker = new StringMaker(normalizedUrl);
            if (normalizedUrl.startsWith(MONGO_URL_PREFIX)) {
                String hostPortDbString = maker.after(MONGO_URL_PREFIX).before("?").value().trim();
                String propertyString = maker.next().value();
                this.logger.warn("[" + this.dbType + "  - parseUrl] propertyString :" + propertyString);
                int socket_index = propertyString.indexOf("socketfactory");
                int named_pipe = propertyString.indexOf("namedpipepath");
                if (socket_index > -1 || named_pipe > -1) {
                    this.isParsingFailure = true;
                } else {
                    this.parseConnectionUrl(hostPortDbString);
                }
            } else {
                this.isParsingFailure = true;
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.dbType + "  - parseUrl] Exception occured while parsing JDBC Url :" + this.jdbcUrl);
            this.isParsingFailure = true;
        }
        if (this.databaseName == null) {
            this.databaseName = "-";
        }
    }

    private void parseConnectionUrl(String hostPortDbString) {
        this.logger.debug("[" + this.dbType + "  - parseUrl] hostPortDbString :" + hostPortDbString);
        int slash_index = hostPortDbString.indexOf("/");
        if (slash_index >= 0) {
            String databaseString = hostPortDbString.substring(slash_index + 1);
            hostPortDbString = hostPortDbString.substring(0, slash_index);
            this.logger.debug("[" + this.dbType + "  - parseUrl] databaseString :" + databaseString);
            this.databaseName = databaseString != null && databaseString.length() > 0 ? databaseString : "-";
        }
        if (hostPortDbString != null) {
            int comma_index = hostPortDbString.indexOf(",");
            int brace_index = hostPortDbString.indexOf(")");
            int equal_index = hostPortDbString.indexOf("=");
            int at_index = hostPortDbString.indexOf("@");
            if (comma_index > 0 || brace_index > 0 || equal_index > 0 || at_index > 0) {
                this.logger.debug("[" + this.dbType + "  - parseUrl]. It is cluster or other kind of JDBC Url");
                this.isParsingFailure = true;
            } else {
                this.assignHostNameAndPort(hostPortDbString, DEFAULT_PORT);
            }
        }
        if (this.portNo == null) {
            this.portNo = DEFAULT_PORT;
        }
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
        this.logger.debug("[" + this.dbType + "  - parseConnectionUrl] hostName :" + this.hostName + " PORT : " + this.portNo + " DB : " + this.databaseName);
    }
}

