/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BaseDatabaseInfo;
import com.eg.jtm.StringMaker;
import com.eg.org.slf4j.Logger;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDatabaseInfo
extends BaseDatabaseInfo {
    private static final String MYSQL_URL_PREFIX = "jdbc:mysql://";
    private static final String MARIA_URL_PREFIX = "jdbc:mariadb://";
    private static final String DATADIRECT_URL_PREFIX = "jdbc:datadirect:mysql://";
    private static final String DEFAULT_PORT = "3306";

    public MySqlDatabaseInfo(String string, String string2, Logger logger) {
        super(string, string2, logger);
    }

    @Override
    public Hashtable<String, String> getDBInfo() {
        this.parseUrl();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("SERVERTYPE", this.dbType);
        if (this.isParsingFailure) {
            hashtable.put("SERVERNAME", this.jdbcUrl);
            hashtable.put("DATABASENAME", "-");
            hashtable.put("PORTNUMBER", "-");
        } else if (this.hostName == null || this.portNo == null) {
            hashtable.put("SERVERNAME", this.jdbcUrl);
            hashtable.put("DATABASENAME", "-");
            hashtable.put("PORTNUMBER", "-");
        } else {
            hashtable.put("SERVERNAME", this.hostName);
            hashtable.put("DATABASENAME", this.databaseName);
            hashtable.put("PORTNUMBER", this.portNo);
        }
        return hashtable;
    }

    private void parseUrl() {
        if (this.jdbcUrl == null) {
            this.logger.warn("[" + this.dbType + "  - parseUrl] jdbcUrl must not be null");
            return;
        }
        try {
            String string = this.jdbcUrl.toLowerCase();
            if (!string.startsWith("jdbc:")) {
                string = "jdbc:" + string;
            }
            StringMaker stringMaker = new StringMaker(string);
            if (string.startsWith(MYSQL_URL_PREFIX)) {
                String string2 = stringMaker.after(MYSQL_URL_PREFIX).before("?").value().trim();
                String string3 = stringMaker.next().value();
                this.logger.warn("[" + this.dbType + "  - parseUrl] propertyString :" + string3);
                int n = string3.indexOf("socketfactory");
                int n2 = string3.indexOf("namedpipepath");
                if (n > -1 || n2 > -1) {
                    this.isParsingFailure = true;
                } else {
                    this.parseConnectionUrl(string2);
                }
            } else if (string.startsWith(MARIA_URL_PREFIX)) {
                String string4 = stringMaker.after(MARIA_URL_PREFIX).before("?").value().trim();
                this.parseConnectionUrl(string4);
                this.dbType = "Maria_server";
            } else if (string.startsWith(DATADIRECT_URL_PREFIX)) {
                stringMaker.after(DATADIRECT_URL_PREFIX);
                this.parseWeblogicConnectionUrl(stringMaker, DEFAULT_PORT);
            } else {
                this.isParsingFailure = true;
            }
        }
        catch (Exception exception) {
            this.logger.warn("[" + this.dbType + "  - parseUrl] Exception occured while parsing JDBC Url :" + this.jdbcUrl);
            this.isParsingFailure = true;
        }
        if (this.databaseName == null) {
            this.databaseName = "-";
        }
    }

    private void parseConnectionUrl(String string) {
        this.logger.debug("[" + this.dbType + "  - parseUrl] hostPortDbString :" + string);
        int n = string.indexOf("/");
        if (n >= 0) {
            String string2 = string.substring(n + 1);
            string = string.substring(0, n);
            this.logger.debug("[" + this.dbType + "  - parseUrl] databaseString :" + string2);
            this.databaseName = string2 != null && string2.length() > 0 ? string2 : "-";
        }
        if (string != null) {
            int n2 = string.indexOf(",");
            int n3 = string.indexOf(")");
            int n4 = string.indexOf("=");
            int n5 = string.indexOf("@");
            if (n2 > 0 || n3 > 0 || n4 > 0 || n5 > 0) {
                this.logger.debug("[" + this.dbType + "  - parseUrl]. It is cluster or other kind of JDBC Url");
                this.isParsingFailure = true;
            } else {
                this.assignHostNameAndPort(string, DEFAULT_PORT);
            }
        }
        if (this.portNo == null) {
            this.portNo = DEFAULT_PORT;
        }
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
        this.logger.debug("[" + this.dbType + "  - parseConnectionUrl] hostName :" + this.hostName + " PORT : " + this.portNo + " DB : " + this.databaseName);
    }

    public static void main(String[] stringArray) {
        String string = "jdbc:mysql://localhost:3306/HerongDB?user=Herong&password=TopSecret";
        string = "jdbc:mysql://:3306/HerongDB?user=Herong&password=TopSecret";
        string = "jdbc:mysql://localhost/HerongDB?user=Herong&password=TopSecret";
        string = "jdbc:mysql://localhost:3310/?user=Herong&password=TopSecret";
        string = "jdbc:mysql://localhost/?user=Herong&password=TopSecret";
        string = "jdbc:mysql://:3361/?user=Herong&password=TopSecret";
        string = "jdbc:mysql:///HerongDB?user=Herong&password=TopSecret";
        string = "jdbc:mysql:///?user=Herong&password=TopSecret";
        string = "jdbc:mysql://root:root@192.168.8.252:3306/priyadb";
        MySqlDatabaseInfo mySqlDatabaseInfo = new MySqlDatabaseInfo(string, "MySql_server", null);
        Hashtable<String, String> hashtable = mySqlDatabaseInfo.getDBInfo();
        System.out.println(" result :" + hashtable);
    }
}

