/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.JDBCStringParsingException;
import com.eg.jtm.Token;
import java.util.ArrayList;
import java.util.List;

public class OracleNetConnectionDescriptorTokenizer {
    public static final char TOKEN_EQUAL = '=';
    public static final char TOKEN_KEY_START = '(';
    public static final char TOKEN_KEY_END = ')';
    private static final char TOKEN_COMMA = ',';
    private static final char TOKEN_BKSLASH = '\\';
    private static final char TOKEN_DQUOTE = '\"';
    private static final char TOKEN_SQUOTE = '\'';
    public static final int TYPE_KEY_START = 0;
    public static final Token TOKEN_KEY_START_OBJECT = new Token(String.valueOf('('), 0);
    public static final int TYPE_KEY_END = 1;
    public static final Token TOKEN_KEY_END_OBJECT = new Token(String.valueOf(')'), 1);
    public static final int TYPE_EQUAL = 2;
    public static final Token TOKEN_EQUAL_OBJECT = new Token(String.valueOf('='), 2);
    public static final int TYPE_LITERAL = 3;
    public static final int TYPE_EOF = -1;
    public static final Token TOKEN_EOF_OBJECT = new Token("EOF", -1);
    private final List<Token> tokenList = new ArrayList<Token>();
    private int tokenPosition = 0;
    private final String connectionString;
    private int position = 0;

    public OracleNetConnectionDescriptorTokenizer(String string) {
        if (string == null) {
            throw new NullPointerException("connectionString");
        }
        this.connectionString = string;
    }

    public void parse() {
        int n = this.connectionString.length();
        while (this.position < n) {
            char c = this.connectionString.charAt(this.position);
            if (!this.isWhiteSpace(c)) {
                switch (c) {
                    case '(': {
                        this.tokenList.add(TOKEN_KEY_START_OBJECT);
                        break;
                    }
                    case '=': {
                        this.tokenList.add(TOKEN_EQUAL_OBJECT);
                        break;
                    }
                    case ')': {
                        this.tokenList.add(TOKEN_KEY_END_OBJECT);
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case ',': 
                    case '\\': {
                        throw new JDBCStringParsingException("unsupported token:" + c);
                    }
                    default: {
                        String string = this.parseLiteral();
                        this.addToken(string, 3);
                    }
                }
            }
            ++this.position;
        }
        this.tokenList.add(TOKEN_EOF_OBJECT);
    }

    String parseLiteral() {
        int n;
        int n2;
        this.position = n2 = this.trimLeft();
        while (this.position < this.connectionString.length()) {
            n = this.connectionString.charAt(this.position);
            switch (n) {
                case 40: 
                case 41: 
                case 61: {
                    int n3 = this.trimRight(this.position);
                    --this.position;
                    return this.connectionString.substring(n2, n3);
                }
            }
            ++this.position;
        }
        n = this.trimRight(this.position);
        return this.connectionString.substring(n2, n);
    }

    int trimRight(int n) {
        int n2;
        for (n2 = n; n2 > 0; --n2) {
            char c = this.connectionString.charAt(n2 - 1);
            if (this.isWhiteSpace(c)) continue;
            return n2;
        }
        return n2;
    }

    int trimLeft() {
        int n;
        int n2 = this.connectionString.length();
        for (n = this.position; n < n2; ++n) {
            char c = this.connectionString.charAt(n);
            if (this.isWhiteSpace(c)) continue;
            return n;
        }
        return n;
    }

    private void addToken(String string, int n) {
        Token token = new Token(string, n);
        this.tokenList.add(token);
    }

    private boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public Token nextToken() {
        if (this.tokenList.size() <= this.tokenPosition) {
            return null;
        }
        Token token = this.tokenList.get(this.tokenPosition);
        ++this.tokenPosition;
        return token;
    }

    public void nextPosition() {
        if (this.tokenList.size() <= this.tokenPosition) {
            return;
        }
        ++this.tokenPosition;
    }

    public Token lookAheadToken() {
        if (this.tokenList.size() <= this.tokenPosition) {
            return null;
        }
        return this.tokenList.get(this.tokenPosition);
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public void checkStartToken() {
        Token token = this.nextToken();
        if (token == null) {
            throw new JDBCStringParsingException("parse error. token is null");
        }
        if (token != TOKEN_KEY_START_OBJECT) {
            throw new JDBCStringParsingException("syntax error. Expected token='(' :" + token.getToken());
        }
    }

    public void checkEqualToken() {
        Token token = this.nextToken();
        if (token == null) {
            throw new JDBCStringParsingException("parse error. token is null. Expected token='='");
        }
        if (token != TOKEN_EQUAL_OBJECT) {
            throw new JDBCStringParsingException("Syntax error. Expected token='=' :" + token.getToken());
        }
    }

    public void checkEndToken() {
        Token token = this.nextToken();
        if (token == null) {
            throw new JDBCStringParsingException("parse error. token is null. Expected token=')");
        }
        if (token != TOKEN_KEY_END_OBJECT) {
            throw new JDBCStringParsingException("Syntax error. Expected token=')' :" + token.getToken());
        }
    }

    public Token getLiteralToken() {
        Token token = this.nextToken();
        if (token == null) {
            throw new JDBCStringParsingException("parse error. token is null. Expected token='LITERAL'");
        }
        if (token.getType() != 3) {
            throw new JDBCStringParsingException("Syntax error. Expected token='LITERAL'' :" + token.getToken());
        }
        return token;
    }

    public Token getLiteralToken(String string) {
        Token token = this.nextToken();
        if (token == null) {
            throw new JDBCStringParsingException("parse error. token is null. Expected token='LITERAL'");
        }
        if (token.getType() != 3) {
            throw new JDBCStringParsingException("Syntax error. Expected token='LITERAL' :" + token.getToken());
        }
        if (!string.equals(token.getToken())) {
            throw new JDBCStringParsingException("Syntax error. Expected token=" + string + "' :" + token.getToken());
        }
        return token;
    }
}

