/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.apm.APMUtils;
import com.eg.apm.JavaBTMOffloadLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;

public final class PropsManager {
    public static final String requestIDSep = " @ ";
    private final int defaultLimit = 10;
    private int Max_Slow_URLs = 10;
    private int Max_Error_URLs = 10;
    private int Max_Healthy_URLs = 10;
    private int Max_Stalled_URLs = 10;
    private double Sql_Exec_CutOff = 10.0;
    private boolean TraceHealthyURL = true;
    String BTM_NODE_ID = "NONE";
    private long egMeasPeriod;
    public long RASwitchOverCutoff;
    private static final String[] subCompNames = new String[]{"ALL_URLS", "SLOW_URLS", "ERROR_URLS", "STALLED_URLS", "SQL", "FIRST_ALL", "FIRST_SLOW", "FIRST_ERROR", "FIRST_STALLED", "CPU_TIME", "BLOCK_TIME", "WAIT_TIME"};
    private Properties BTMProps = new Properties();
    private int URLLevel = 3;
    public int lazyTimeInseconds = 180;
    private long pojoTracePeriod;
    private long maxTracePeriod = this.pojoTracePeriod = 10000L;
    public static final String STALLED_THRESHOLD_PERIOD = "STALLED_THRESHOLD_PERIOD";
    private static final String MAX_SQL_ERROR_QUERY_COUNT = "MAX_SQL_ERROR_QUERY_COUNT";
    private static final String MAX_EXCE_STACK_TRACE_CAPTURE_LIMIT = "MAX_EXCE_STACK_TRACE_CAPTURE_LIMIT";
    private static final String MAX_EXCE_FQEN_CAPTURE_LIMIT = "MAX_EXCE_FQEN_CAPTURE_LIMIT";
    private static final String MAX_EXCE_TRACE_COUNT_LIMIT = "MAX_EXCE_TRACE_COUNT_LIMIT";
    private static final String MAX_POJO_CALL_TRACE_COUNT = "MAX_POJO_CALL_TRACE_COUNT";
    private static final String MAX_POJO_CALL_TRACE_TIME = "MAX_POJO_CALL_TRACE_TIME";
    private static final String MAX_SQL_QUERY_COUNT = "MAX_SQL_QUERY_COUNT";
    private static final String Chars_TO_Exclude = "Chars_TO_Exclude";
    private static final String IGNORE_EXCEPTIONS = "IGNORE_EXCEPTIONS";
    private static final String INCLUDE_EXCEPTIONS = "INCLUDE_EXCEPTIONS";
    private static final String MAX_EXCEPTION_TRACE_LINE_COUNT = "MAX_EXCEPTION_TRACE_LINE_COUNT";
    private static final String MAX_POINTCUT_LIMIT = "MAX_POINTCUT_LIMIT";
    private static final String RECURSION_TRACE_LIMIT = "RECURSION_TRACE_LIMIT";
    private static final String MAX_MONGODB_QUERY_LENGTH = "MAX_MONGODB_QUERY_LENGTH";
    private static final String MONITORING_MODE = "Monitoring_Mode";
    private static final String MAX_URL_SEGMENTS = "Max_URL_Segments";
    private static final String EXCLUDED_PATTERNS = "Excluded_Patterns";
    private static final String MANUAL_EXCLUDED_PATTERNS = "Manual_Excluded_Patterns";
    private static final String SLOW_URL_THRESHOLD = "Slow_URL_Threshold";
    private static final String STALLED_URL_THRESHOLD = "Stalled_URL_Threshold";
    private static final String METHOD_EXEC_CUTOFF = "Method_Exec_CutOff";
    private static final String SQL_EXEC_CUTOFF = "SQL_Exec_CutOff";
    private static final String MAX_SLOW_URLS_PER_TEST_PERIOD = "Max_Slow_URLs_Per_Test_Period";
    private static final String MAX_ERROR_URLS_PER_TEST_PERIOD = "Max_Error_URLs_Per_Test_Period";
    private static final String MAX_HEALTHY_URLS_PER_TEST_PERIOD = "Max_Healthy_URLs_Per_Test_Period";
    private static final String MAX_STALLED_URLS_PER_TEST_PERIOD = "Max_Stalled_URLs_Per_Test_Period";
    private static final String HEALTHY_URL_TRACE = "Healthy_URL_Trace";
    private static final String EGMEASPERIOD = "egMeasPeriod";
    private static final String URL_PATTERNS = "URL_Patterns";
    public static final String OFFLOAD_GUID = "COMPONENT_GUID";
    public static final String OFFLOAD_NODE_ID = "NODE_ID";
    private static final String MAX_AUTO_GROUPED_URLS = "MAX_AUTO_GROUPED_URLS";
    private static final String MAX_MANUAL_GROUPED_URLS = "MAX_MANUAL_GROUPED_URLS";
    private final int defaultLimit4GroupedURL = 50;
    private int maxLimit4AutoGroupedURL = 50;
    private int maxLimit4ManualGroupedURL = 50;
    private static final String HTTP_STATUS_CODE = "HTTP_STATUS_CODE";
    private static final String HTTP_COOKIES = "HTTP_COOKIES";
    private static final String HTTP_HEADERS = "HTTP_HEADERS";
    private static final String TRACK_CPU_TIME = "TRACK_CPU_TIME";
    private static final String TRACK_BLOCKED_WAITED_TIME = "TRACK_BLOCKED_WAITED_TIME";
    private static final String DEFAULT_EXCLUDED_URL = "*.ttf,*.otf,*.woff,*.woff2,*.eot,*.cff,*.afm,*.lwfn,*.ffil,*.fon,*.pfm,*.pfb,*.std,*.pro,*.xsf,*.jpg,*.jpeg,*.jpe,*.jif,*.jfif,*.jfi,*.jp2,*.j2k,*.jpf,*.jpx,*.jpm,*.jxr,*.hdp,*.wdp,*.mj2,*.webp,*.gif,*.png,*.apng,*.mng,*.tiff,*.tif,*.xbm,*.bmp,*.dib,*.svg,*.svgz,*.mpg,*.mpeg,*.mpeg2,*.avi,*.wmv,*.mov,*.rm,*.ram,*.swf,*.flv,*.ogg,*.webm,*.mp4,*.ts,*.mid,*.midi,*.rm,*.ram,*.wma,*.aac,*.wav,*.ogg,*.mp3,*.mp4,*.css,*.js,*.ico,*.cur,/egurkha*";
    public Vector autoFilteredPatternsList = new Vector();
    public Vector manualFilteredPatternsList = new Vector();
    protected static String logPrefix = "PropsManager";
    protected static String loggerDispStr = "[" + logPrefix + "]";

    public void initProps() {
        this.BTMProps.clear();
        this.BTMProps.put(MONITORING_MODE, "1");
        this.BTMProps.put(MAX_URL_SEGMENTS, "3");
        this.BTMProps.put(EXCLUDED_PATTERNS, DEFAULT_EXCLUDED_URL);
        this.BTMProps.put(SLOW_URL_THRESHOLD, "4000.0");
        this.BTMProps.put(STALLED_URL_THRESHOLD, "60000.0");
        this.BTMProps.put(METHOD_EXEC_CUTOFF, "250.0");
        this.BTMProps.put(SQL_EXEC_CUTOFF, "10.0");
        this.BTMProps.put(MAX_SLOW_URLS_PER_TEST_PERIOD, "10");
        this.BTMProps.put(MAX_ERROR_URLS_PER_TEST_PERIOD, "10");
        this.BTMProps.put(MAX_STALLED_URLS_PER_TEST_PERIOD, "10");
        this.BTMProps.put(MAX_HEALTHY_URLS_PER_TEST_PERIOD, "10");
        this.BTMProps.put(HEALTHY_URL_TRACE, "true");
        this.BTMProps.put(EGMEASPERIOD, "300");
        this.BTMProps.put(MANUAL_EXCLUDED_PATTERNS, DEFAULT_EXCLUDED_URL);
        this.BTMProps.put(OFFLOAD_NODE_ID, "None");
        this.BTMProps.put(URL_PATTERNS, "None");
        this.BTMProps.put(MAX_POJO_CALL_TRACE_COUNT, "1000");
        this.BTMProps.put(MAX_POJO_CALL_TRACE_TIME, "10");
        this.BTMProps.put(RECURSION_TRACE_LIMIT, "1000");
        this.BTMProps.put(MAX_POINTCUT_LIMIT, "1000");
        this.BTMProps.put(MAX_EXCEPTION_TRACE_LINE_COUNT, "10");
        this.BTMProps.put(INCLUDE_EXCEPTIONS, "None");
        this.BTMProps.put(IGNORE_EXCEPTIONS, "None");
        this.BTMProps.put(Chars_TO_Exclude, "\\");
        this.BTMProps.put(MAX_AUTO_GROUPED_URLS, "50");
        this.BTMProps.put(MAX_MANUAL_GROUPED_URLS, "50");
        this.BTMProps.put(MAX_SQL_QUERY_COUNT, "500");
        this.BTMProps.put(HTTP_STATUS_CODE, "false");
        this.BTMProps.put(HTTP_COOKIES, "false");
        this.BTMProps.put(HTTP_HEADERS, "false");
        this.BTMProps.put(TRACK_CPU_TIME, "false");
        this.BTMProps.put(TRACK_BLOCKED_WAITED_TIME, "false");
        this.BTMProps.put(MAX_MONGODB_QUERY_LENGTH, "1024");
        this.BTMProps.put(MAX_SQL_ERROR_QUERY_COUNT, "10");
        this.BTMProps.put(MAX_EXCE_STACK_TRACE_CAPTURE_LIMIT, "5");
        this.BTMProps.put(MAX_EXCE_FQEN_CAPTURE_LIMIT, "100");
        this.BTMProps.put(MAX_EXCE_TRACE_COUNT_LIMIT, "1000");
    }

    public Properties getBTMprops() {
        return this.BTMProps;
    }

    public void handlePropChangesFromTest(ArrayList CliList, String entityName) {
        String currPropVal;
        JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Received props from agent: {} from {}", new Object[]{loggerDispStr, CliList, entityName});
        boolean btmTest = false;
        if (entityName.equals("BusinessTransTest") || entityName.equals("NodeTransTest")) {
            btmTest = true;
        }
        int list_size = CliList.size();
        int old_props_size = 26;
        String monitoringMode = (String)CliList.get(0);
        this.isIntegerPropUpdated(MONITORING_MODE, monitoringMode);
        if (btmTest) {
            String urlLevel = (String)CliList.get(1);
            this.isIntegerPropUpdated(MAX_URL_SEGMENTS, urlLevel);
        } else {
            currPropVal = (String)CliList.get(1);
            this.isStringPropUpdated(URL_PATTERNS, this.cleanupPatternStr(currPropVal, true));
        }
        if (btmTest) {
            currPropVal = (String)CliList.get(2);
            this.isStringPropUpdated(EXCLUDED_PATTERNS, this.cleanupFilteredPatternStr(currPropVal));
        } else {
            currPropVal = (String)CliList.get(2);
            this.isStringPropUpdated(MANUAL_EXCLUDED_PATTERNS, this.cleanupFilteredPatternStr(currPropVal));
        }
        currPropVal = (String)CliList.get(3);
        this.isDoublePropUpdated(SLOW_URL_THRESHOLD, currPropVal);
        currPropVal = (String)CliList.get(4);
        this.isDoublePropUpdated(STALLED_URL_THRESHOLD, currPropVal);
        currPropVal = (String)CliList.get(5);
        this.isDoublePropUpdated(METHOD_EXEC_CUTOFF, currPropVal);
        currPropVal = (String)CliList.get(6);
        if (this.isDoublePropUpdated(SQL_EXEC_CUTOFF, currPropVal)) {
            this.setSqlExecCutOff(currPropVal);
        }
        if (this.isIntegerPropUpdated(MAX_SLOW_URLS_PER_TEST_PERIOD, currPropVal = (String)CliList.get(7))) {
            this.setMaxSlowURLs(currPropVal);
        }
        if (this.isIntegerPropUpdated(MAX_ERROR_URLS_PER_TEST_PERIOD, currPropVal = (String)CliList.get(8))) {
            this.setMaxErrorURLs(currPropVal);
        }
        if (this.isIntegerPropUpdated(MAX_HEALTHY_URLS_PER_TEST_PERIOD, currPropVal = (String)CliList.get(9))) {
            this.setHealthyURLs(currPropVal);
        }
        if (this.isIntegerPropUpdated(MAX_STALLED_URLS_PER_TEST_PERIOD, currPropVal = (String)CliList.get(10))) {
            this.setMaxStalledURLs(currPropVal);
        }
        if (this.isStringPropUpdated(HEALTHY_URL_TRACE, currPropVal = (String)CliList.get(11))) {
            this.setHealthyUrlTrace(currPropVal);
        }
        if (this.isLongPropUpdated(EGMEASPERIOD, currPropVal = (String)CliList.get(12))) {
            this.setEgMeasPeriod(currPropVal);
        }
        currPropVal = (String)CliList.get(13);
        this.isLongPropUpdated(MAX_POJO_CALL_TRACE_COUNT, currPropVal);
        currPropVal = (String)CliList.get(14);
        this.isIntegerPropUpdated(MAX_POJO_CALL_TRACE_TIME, currPropVal);
        currPropVal = (String)CliList.get(15);
        this.isLongPropUpdated(RECURSION_TRACE_LIMIT, currPropVal);
        currPropVal = (String)CliList.get(16);
        this.isLongPropUpdated(MAX_POINTCUT_LIMIT, currPropVal);
        currPropVal = (String)CliList.get(17);
        this.isIntegerPropUpdated(MAX_EXCEPTION_TRACE_LINE_COUNT, currPropVal);
        currPropVal = (String)CliList.get(18);
        this.isStringPropUpdated(INCLUDE_EXCEPTIONS, currPropVal);
        currPropVal = (String)CliList.get(19);
        this.isStringPropUpdated(IGNORE_EXCEPTIONS, currPropVal);
        currPropVal = (String)CliList.get(20);
        this.isStringPropUpdated(Chars_TO_Exclude, currPropVal);
        if (btmTest) {
            currPropVal = (String)CliList.get(21);
            if (this.isIntegerPropUpdated(MAX_AUTO_GROUPED_URLS, currPropVal)) {
                this.setMaxLimit4AutoGroupedURL(currPropVal);
            }
        } else {
            currPropVal = (String)CliList.get(21);
            if (this.isIntegerPropUpdated(MAX_MANUAL_GROUPED_URLS, currPropVal)) {
                this.setMaxLimit4ManualGroupedURL(currPropVal);
            }
        }
        currPropVal = (String)CliList.get(22);
        this.isIntegerPropUpdated(MAX_SQL_QUERY_COUNT, currPropVal);
        try {
            currPropVal = (String)CliList.get(23);
            this.isStringPropUpdated(HTTP_STATUS_CODE, currPropVal);
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Problem while getting value for {} , Assigning default value of \"false\"", (Object)loggerDispStr, (Object)HTTP_STATUS_CODE);
        }
        try {
            currPropVal = (String)CliList.get(24);
            this.isStringPropUpdated(HTTP_COOKIES, currPropVal);
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Problem while getting value for {} , Assigning default value of \"false\"", (Object)loggerDispStr, (Object)HTTP_COOKIES);
        }
        currPropVal = (String)CliList.get(25);
        try {
            this.isStringPropUpdated(HTTP_HEADERS, currPropVal);
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Problem while getting value for {} , Assigning default value of \"false\"", (Object)loggerDispStr, (Object)HTTP_HEADERS);
        }
        if (list_size > old_props_size) {
            int new_index = old_props_size;
            try {
                currPropVal = (String)CliList.get(new_index);
                if (!currPropVal.equalsIgnoreCase("-")) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.info("{} eG Agent Version is 6.3 or higher !!!.", (Object)loggerDispStr);
                }
                if (this.isStringPropUpdated(TRACK_CPU_TIME, currPropVal)) {
                    this.BTMProps.put(TRACK_CPU_TIME, currPropVal);
                }
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Problem while getting value for {} , Assigning default value of \"false\"", (Object)loggerDispStr, (Object)TRACK_CPU_TIME);
            }
            ++new_index;
            try {
                currPropVal = (String)CliList.get(new_index);
                this.isStringPropUpdated(TRACK_BLOCKED_WAITED_TIME, currPropVal);
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Problem while getting value for {} , Assigning default value of \"false\"", (Object)loggerDispStr, (Object)TRACK_BLOCKED_WAITED_TIME);
            }
            ++new_index;
            try {
                currPropVal = (String)CliList.get(new_index);
                this.isIntegerPropUpdated(MAX_MONGODB_QUERY_LENGTH, currPropVal);
            }
            catch (Exception ex) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Problem while getting value for {} , Assigning default value of \"false\"", (Object)loggerDispStr, (Object)MAX_MONGODB_QUERY_LENGTH);
            }
            ++new_index;
            try {
                currPropVal = (String)CliList.get(new_index);
                this.isIntegerPropUpdated(MAX_SQL_ERROR_QUERY_COUNT, currPropVal);
            }
            catch (Exception ex) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Problem while getting value for {} , Assigning default value of \"false\"", (Object)loggerDispStr, (Object)MAX_SQL_ERROR_QUERY_COUNT);
            }
            ++new_index;
            try {
                currPropVal = (String)CliList.get(new_index);
                this.isIntegerPropUpdated(MAX_EXCE_STACK_TRACE_CAPTURE_LIMIT, currPropVal);
            }
            catch (Exception ex) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Problem while getting value for {} , Assigning default value of \"false\"", (Object)loggerDispStr, (Object)MAX_EXCE_STACK_TRACE_CAPTURE_LIMIT);
            }
            ++new_index;
            try {
                currPropVal = (String)CliList.get(new_index);
                this.isIntegerPropUpdated(MAX_EXCE_FQEN_CAPTURE_LIMIT, currPropVal);
            }
            catch (Exception ex) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Problem while getting value for {} , Assigning default value of \"false\"", (Object)loggerDispStr, (Object)MAX_EXCE_FQEN_CAPTURE_LIMIT);
            }
            ++new_index;
            try {
                currPropVal = (String)CliList.get(new_index);
                this.isIntegerPropUpdated(MAX_EXCE_TRACE_COUNT_LIMIT, currPropVal);
            }
            catch (Exception ex) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Problem while getting value for {} , Assigning default value of \"false\"", (Object)loggerDispStr, (Object)MAX_EXCE_TRACE_COUNT_LIMIT);
            }
            ++new_index;
            try {
                String nodeIDString = (String)CliList.get(new_index);
                if (this.isStringPropUpdated(OFFLOAD_NODE_ID, nodeIDString)) {
                    this.setNodeID(nodeIDString);
                    this.BTMProps.setProperty(OFFLOAD_NODE_ID, nodeIDString);
                }
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Problem while getting value for {} , Assigning default value of \"None\"", (Object)loggerDispStr, (Object)OFFLOAD_NODE_ID);
            }
        }
    }

    public void applyBTMProps() {
        this.setSqlExecCutOff(this.BTMProps.getProperty(SQL_EXEC_CUTOFF));
        this.setMaxSlowURLs(this.BTMProps.getProperty(MAX_SLOW_URLS_PER_TEST_PERIOD));
        this.setMaxErrorURLs(this.BTMProps.getProperty(MAX_ERROR_URLS_PER_TEST_PERIOD));
        this.setHealthyURLs(this.BTMProps.getProperty(MAX_HEALTHY_URLS_PER_TEST_PERIOD));
        this.setHealthyUrlTrace(this.BTMProps.getProperty(HEALTHY_URL_TRACE));
        this.setEgMeasPeriod(this.BTMProps.getProperty(EGMEASPERIOD));
        this.setMaxLimit4AutoGroupedURL(this.BTMProps.getProperty(MAX_AUTO_GROUPED_URLS));
        this.setMaxLimit4ManualGroupedURL(this.BTMProps.getProperty(MAX_MANUAL_GROUPED_URLS));
    }

    public boolean isPropsFileValid(File propsFile) {
        if (propsFile != null) {
            boolean retBool = propsFile.exists() && propsFile.isFile() && propsFile.length() != 0L;
            return retBool;
        }
        return false;
    }

    private boolean isStringPropUpdated(String propName, String currValStr) {
        if (currValStr == null) {
            return false;
        }
        if (currValStr.length() != 0) {
            String prevValStr = this.BTMProps.getProperty(propName);
            if (!currValStr.equals(prevValStr)) {
                this.BTMProps.setProperty(propName, currValStr);
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Updated param {} with {} ", new Object[]{loggerDispStr, propName, currValStr});
                return true;
            }
            return false;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Cannot update property {} with blank value.", (Object)loggerDispStr, (Object)propName);
        return false;
    }

    private boolean isDoublePropUpdated(String propName, String currValStr) {
        if (currValStr == null) {
            return false;
        }
        double currVal = APMUtils.String2Double(currValStr);
        String prevValStr = this.BTMProps.getProperty(propName);
        if (currVal > -1.0) {
            double prevVal = APMUtils.String2Double(prevValStr);
            if (currVal != prevVal) {
                this.BTMProps.setProperty(propName, currValStr);
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Updated prop {} with {}", new Object[]{loggerDispStr, propName, currValStr});
                return true;
            }
            return false;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.warn("Value from manager for prop {} : {} was invalid. Using previous value {} ", new Object[]{propName, currValStr, prevValStr});
        return false;
    }

    private boolean isLongPropUpdated(String propName, String currValStr) {
        if (currValStr == null) {
            return false;
        }
        long currVal = APMUtils.String2Long(currValStr);
        String prevValStr = this.BTMProps.getProperty(propName);
        if (currVal > -1L) {
            long prevVal = APMUtils.String2Long(prevValStr);
            if (currVal != prevVal) {
                this.BTMProps.setProperty(propName, currValStr);
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Updated prop {} with {}", new Object[]{loggerDispStr, propName, currValStr});
                return true;
            }
            return false;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.warn("Value from manager for prop {} : {} was invalid. Using previous value {} ", new Object[]{propName, currValStr, prevValStr});
        return false;
    }

    private boolean isIntegerPropUpdated(String propName, String currValStr) {
        if (currValStr == null) {
            return false;
        }
        int currVal = APMUtils.String2Integer(currValStr);
        String prevValStr = this.BTMProps.getProperty(propName);
        if (currVal > -1) {
            int prevVal = APMUtils.String2Integer(prevValStr);
            if (currVal != prevVal) {
                this.BTMProps.setProperty(propName, currValStr);
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Updated prop {} with {}", new Object[]{loggerDispStr, propName, currValStr});
                return true;
            }
            return false;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.warn("Value from manager for prop {} : {} was invalid. Using previous value {} ", new Object[]{propName, currValStr, prevValStr});
        return false;
    }

    private String cleanupFilteredPatternStr(String patternsString) {
        if (patternsString == null) {
            return "None";
        }
        if (patternsString.trim().equalsIgnoreCase("None")) {
            return patternsString;
        }
        String[] patterns = patternsString.split(",");
        StringBuffer cleanedPatternsSB = new StringBuffer();
        ArrayList<String> tmpList = new ArrayList<String>();
        int i = 0;
        while (i < patterns.length) {
            String tempPatternString = patterns[i];
            if (tempPatternString != null && tempPatternString.trim().length() > 0 && !tmpList.contains(tempPatternString)) {
                tmpList.add(tempPatternString);
                if (cleanedPatternsSB.length() == 0) {
                    cleanedPatternsSB.append(tempPatternString);
                } else {
                    cleanedPatternsSB.append(",").append(tempPatternString);
                }
            }
            ++i;
        }
        tmpList.clear();
        return cleanedPatternsSB.toString();
    }

    private String cleanupPatternStr(String patternsString, boolean acceptNone) {
        if (patternsString == null) {
            return null;
        }
        if (acceptNone && patternsString.trim().equalsIgnoreCase("None")) {
            return patternsString;
        }
        String[] patterns = patternsString.split(",");
        StringBuffer cleanedPatternsSB = new StringBuffer();
        if (patterns.length != 0) {
            int i = 0;
            while (i < patterns.length) {
                if (this.ValidateSyntax(patterns[i])) {
                    if (cleanedPatternsSB.length() == 0) {
                        cleanedPatternsSB.append(patterns[i]);
                    } else {
                        cleanedPatternsSB.append(",").append(patterns[i]);
                    }
                }
                ++i;
            }
        }
        return cleanedPatternsSB.toString();
    }

    private boolean ValidateSyntax(String patternStr) {
        int delim = 58;
        int idx = patternStr.indexOf(delim);
        if (idx != -1) {
            return patternStr.substring(idx + 1).indexOf(delim) == -1;
        }
        return false;
    }

    public double getSQLExecCutOff() {
        return this.Sql_Exec_CutOff;
    }

    public void setSQLExecCutOff(double sqlcutoff) {
        this.Sql_Exec_CutOff = sqlcutoff;
    }

    public long getMaxTracePeriod() {
        return this.maxTracePeriod;
    }

    public void setHealthyUrlTrace(String traceString) {
        if (traceString != null && traceString.equalsIgnoreCase("true")) {
            this.TraceHealthyURL = true;
            JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Healthy URL Tracing flag set to true", (Object)loggerDispStr);
        } else {
            this.TraceHealthyURL = false;
            JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Healthy URL Tracing flag set to false", (Object)loggerDispStr);
        }
    }

    private void setHealthyURLs(String numURLsStr) {
        try {
            this.Max_Healthy_URLs = Integer.parseInt(numURLsStr);
        }
        catch (NumberFormatException nfe) {
            this.Max_Healthy_URLs = 10;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Maximum number of Healthy URLs  set to {} ", (Object)loggerDispStr, (Object)this.getHelathyURLs());
    }

    public int getHelathyURLs() {
        return this.Max_Healthy_URLs;
    }

    public int getMaxSlowURLs() {
        return this.Max_Slow_URLs;
    }

    public int getMaxStalledURLs() {
        return this.Max_Stalled_URLs;
    }

    private void setMaxStalledURLs(String numURLsStr) {
        try {
            this.Max_Stalled_URLs = Integer.parseInt(numURLsStr);
        }
        catch (NumberFormatException nfe) {
            this.Max_Stalled_URLs = 10;
        }
    }

    private void setMaxSlowURLs(String numURLsStr) {
        try {
            this.Max_Slow_URLs = Integer.parseInt(numURLsStr);
        }
        catch (NumberFormatException nfe) {
            this.Max_Slow_URLs = 10;
        }
    }

    public int getMaxErrorURLs() {
        return this.Max_Error_URLs;
    }

    private void setMaxErrorURLs(String numURLsStr) {
        try {
            this.Max_Error_URLs = Integer.parseInt(numURLsStr);
        }
        catch (NumberFormatException nfe) {
            this.Max_Error_URLs = 10;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Maximum number of Error URLs  set to {} ", (Object)loggerDispStr, (Object)this.getMaxErrorURLs());
    }

    public boolean isTraceHealthyURL() {
        return this.TraceHealthyURL;
    }

    private void setSqlExecCutOff(String sqlCutOff) {
        try {
            double sqlcutoff = Double.parseDouble(sqlCutOff);
            this.setSQLExecCutOff(sqlcutoff);
            JavaBTMOffloadLogger.btmOffLoadLogger.info("{} SQL execution cutoff parsed and set to {} milliseconds", (Object)loggerDispStr, (Object)sqlcutoff);
        }
        catch (NumberFormatException nfe) {
            this.setSQLExecCutOff(10.0);
        }
    }

    private void setNodeID(String nodeIDString) {
        if (nodeIDString != null && nodeIDString.length() != 0) {
            this.BTM_NODE_ID = nodeIDString;
            JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Node is assigned with an ID: {}", (Object)loggerDispStr, (Object)this.BTM_NODE_ID);
        } else {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Node is not able to assign with the given input: {}", (Object)loggerDispStr, (Object)nodeIDString);
        }
    }

    public String getNodeID() {
        return this.BTM_NODE_ID;
    }

    private void setEgMeasPeriod(String mpStr) {
        long currentMeasurePeriod = this.egMeasPeriod;
        try {
            long mesurePeriodFromAgent = Long.parseLong(mpStr) * 1000L;
            if (mesurePeriodFromAgent == currentMeasurePeriod) {
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Both Current Measure Period and Measure Period from eG Agent are same", (Object)loggerDispStr);
            } else {
                this.egMeasPeriod = mesurePeriodFromAgent;
                this.RASwitchOverCutoff = 10L * this.egMeasPeriod;
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Registered Agent Switchover cut off is {} ms ", (Object)loggerDispStr, (Object)this.RASwitchOverCutoff);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public long getEgMeasPeriod() {
        return this.egMeasPeriod;
    }

    public int getURLLevel() {
        return this.URLLevel;
    }

    public void setURLLevel(int uRLLevel) {
        this.URLLevel = uRLLevel;
    }

    public int getMaxLimit4AutoGroupedURL() {
        return this.maxLimit4AutoGroupedURL;
    }

    private void setMaxLimit4AutoGroupedURL(String maxLimitAuto) {
        if (maxLimitAuto != null && maxLimitAuto.length() > 0) {
            try {
                int autoLimit = Integer.parseInt(maxLimitAuto);
                if (autoLimit > 0) {
                    int currentValue = this.getMaxLimit4AutoGroupedURL();
                    if (currentValue != autoLimit) {
                        this.maxLimit4AutoGroupedURL = autoLimit;
                    }
                } else {
                    JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Assigned {} Value is less than zero.", (Object)loggerDispStr, (Object)MAX_AUTO_GROUPED_URLS);
                    this.maxLimit4AutoGroupedURL = 50;
                }
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} {} Value is invalid. Assigning default Value {} ", new Object[]{loggerDispStr, MAX_AUTO_GROUPED_URLS, 50});
                this.maxLimit4AutoGroupedURL = 50;
            }
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Assinging MAX_AUTO_GROUPED_URLS : {}", (Object)loggerDispStr, (Object)this.maxLimit4AutoGroupedURL);
    }

    public int getMaxLimit4ManualGroupedURL() {
        return this.maxLimit4ManualGroupedURL;
    }

    private void setMaxLimit4ManualGroupedURL(String maxLimit4ManualGroupedURL) {
        if (maxLimit4ManualGroupedURL != null && maxLimit4ManualGroupedURL.length() > 0) {
            try {
                int manualLimit = Integer.parseInt(maxLimit4ManualGroupedURL);
                if (manualLimit > 0) {
                    int currentValue = this.getMaxLimit4ManualGroupedURL();
                    if (currentValue != manualLimit) {
                        this.maxLimit4ManualGroupedURL = manualLimit;
                    }
                } else {
                    JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Assigned {} Value is less than zero.", (Object)loggerDispStr, (Object)MAX_MANUAL_GROUPED_URLS);
                    this.maxLimit4ManualGroupedURL = 50;
                }
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} {} Value is invalid.Assigning default Value {} ", new Object[]{loggerDispStr, MAX_MANUAL_GROUPED_URLS, 50});
                this.maxLimit4ManualGroupedURL = 50;
            }
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Assinging MAX_MANUAL_GROUPED_URLS : {}", (Object)loggerDispStr, (Object)maxLimit4ManualGroupedURL);
    }

    public static int getSubCompNameLength() {
        return subCompNames.length;
    }

    public static double String2Double(String str) {
        double result = -1.0;
        try {
            result = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Obtained invalid double value {} {} ", new Object[]{loggerDispStr, str, nfe});
        }
        return result;
    }

    public static long String2Long(String str) {
        long result = -1L;
        try {
            result = Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Obtained invalid long value {} {} ", new Object[]{loggerDispStr, str, nfe});
        }
        return result;
    }

    public static int String2Integer(String str) {
        int result = -1;
        try {
            result = Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Obtained invalid int value {} {} ", new Object[]{loggerDispStr, str, nfe});
        }
        return result;
    }

    public static long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public String toString() {
        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} BTM_NODE_ID : {}, BTM Props : {}, ", new Object[]{loggerDispStr, this.BTM_NODE_ID, this.getBTMprops()});
        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  isTraceHealthyURL()  : {}, getHelathyURLs(): {}, getMaxStalledURLs() : {}, getMaxSlowURLs() : {}, getMaxTracePeriod() : {} , getSQLExecCutOff() : {}", new Object[]{loggerDispStr, this.isTraceHealthyURL(), this.getHelathyURLs(), this.getMaxStalledURLs(), this.getMaxSlowURLs(), this.getMaxTracePeriod(), this.getSQLExecCutOff()});
        return this.getBTMprops().toString();
    }
}

