/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm.sampling;

import com.eg.apm.APMQueue;
import com.eg.apm.AgentStartupLogger;
import com.eg.jtm.sampling.SamplingData;
import com.eg.jtm.sampling.SamplingWorker;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseThreadPoolManager {
    private APMQueue<SamplingData> myQueue = null;
    private ArrayList<SamplingWorker> workerList = null;
    private static final String THREAD_NAME = "eG_Sampling_Worker_";
    protected static final String loggerDispStr = "[SamplingThreadPoolManager]";
    private static final int DEFAULT_WORKERS = 1;
    private static final int DEFAULT_CAPACITY = 100000;
    private int maxQueueCapacity = 100000;
    private int maxWorkers = 1;

    public BaseThreadPoolManager(int n, APMQueue<SamplingData> aPMQueue) {
        this.maxWorkers = n;
        this.myQueue = aPMQueue;
        this.workerList = new ArrayList();
    }

    public void initAllConsumers(boolean bl) {
        for (int i = 1; i <= this.maxWorkers; ++i) {
            SamplingWorker samplingWorker = new SamplingWorker(bl);
            Thread thread = new Thread(samplingWorker);
            thread.setDaemon(true);
            thread.setName("eG_Sampling_Worker_ " + i);
            thread.start();
            this.workerList.add(samplingWorker);
        }
        if (bl) {
            AgentStartupLogger.logger.info("{} Sampling threadpool created (for data analysis) with - maxWokers {} , workers {} & queue size {} ", new Object[]{loggerDispStr, this.workerList.size(), this.maxQueueCapacity});
        } else {
            AgentStartupLogger.logger.info("{} Sampling threadpool created (for data transmission) with - maxWokers {} , workers {} & queue size {} ", new Object[]{loggerDispStr, this.workerList.size(), this.maxQueueCapacity});
        }
    }

    public void submitTask(SamplingData samplingData) {
        this.myQueue.enqueue(samplingData);
    }

    public int getQueueSize() {
        return this.myQueue.getSize();
    }

    public void shutdownWorker() {
        if (this.workerList != null && this.workerList.size() > 0) {
            int n = this.workerList.size();
            AgentStartupLogger.logger.warn("{} Tyrying to close sampling worker threads", (Object)loggerDispStr);
            AgentStartupLogger.logger.info("{} No.of running workers : {}", (Object)loggerDispStr, (Object)n);
            for (int i = 0; i < n; ++i) {
                SamplingWorker samplingWorker = this.workerList.get(i);
                samplingWorker.setRunThis(false);
                this.submitTask(new SamplingData());
            }
        }
        this.workerList = new ArrayList();
        this.myQueue = null;
    }

    public abstract void clearThreadPoolManager();
}

