/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm.sampling;

import com.eg.apm.APMQueue;
import com.eg.jtm.sampling.BTMSamplingConfiguration;
import com.eg.jtm.sampling.Sample;
import com.eg.jtm.sampling.SamplingData;
import com.eg.jtm.sampling.SamplingFilter;
import com.eg.jtm.sampling.SamplingResultThreadPoolManager;
import com.eg.jtm.sampling.SamplingThreadPoolManager;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplingController {
    private APMQueue<SamplingData> samplesQueue = null;
    private APMQueue<SamplingData> resultsQueue = null;
    private boolean samplingEnabled = false;
    private static SamplingController instance = null;
    private SamplingFilter samplingFilter;
    private SamplingThreadPoolManager samplingThreadPoolManager;
    private SamplingResultThreadPoolManager samplingResultThreadPoolManager;

    private SamplingController() {
        this.init();
    }

    private void init() {
        BTMSamplingConfiguration bTMSamplingConfiguration = BTMSamplingConfiguration.getBTMSamplingConfiguration("eg_apm.ini");
        this.samplingEnabled = bTMSamplingConfiguration.isSamplingEnabled();
        this.samplesQueue = new APMQueue(bTMSamplingConfiguration.getQueueSize());
        this.resultsQueue = new APMQueue(bTMSamplingConfiguration.getQueueSize());
        String[] stringArray = bTMSamplingConfiguration.getIncludeMethods();
        String[] stringArray2 = bTMSamplingConfiguration.getExcludeMethods();
        this.samplingFilter = new SamplingFilter(stringArray, stringArray2);
        if (this.samplingEnabled) {
            this.samplingThreadPoolManager = SamplingThreadPoolManager.getThreadPoolManager(true, bTMSamplingConfiguration.getWorkersSize(), this.samplesQueue);
            this.samplingResultThreadPoolManager = SamplingResultThreadPoolManager.getThreadPoolManager(true, bTMSamplingConfiguration.getWorkersSize(), this.resultsQueue);
        }
    }

    public void reinit(boolean bl) {
        if (bl && !this.samplingEnabled) {
            this.init();
        } else if (!bl && this.samplingEnabled) {
            this.samplingThreadPoolManager.clearThreadPoolManager();
            this.samplingResultThreadPoolManager.clearThreadPoolManager();
            this.samplingThreadPoolManager = null;
            this.samplingResultThreadPoolManager = null;
            this.samplesQueue = null;
            this.resultsQueue = null;
            this.samplingEnabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SamplingController getInstance() {
        if (instance != null) return instance;
        Class<SamplingController> clazz = SamplingController.class;
        synchronized (SamplingController.class) {
            if (instance != null) return instance;
            instance = new SamplingController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isSamplingEnabled() {
        return this.samplingEnabled;
    }

    public void addSamplingData(ArrayList<Sample> arrayList, String string, String string2, String string3) {
        if (this.samplingEnabled) {
            SamplingData samplingData = new SamplingData(arrayList, string, string2, string3);
            this.samplesQueue.enqueue(samplingData);
        }
    }

    void addResultData(SamplingData samplingData) {
        this.resultsQueue.enqueue(samplingData);
    }

    public SamplingData getSamplingSourceData() {
        SamplingData samplingData = null;
        try {
            samplingData = this.samplesQueue.dequeue(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return samplingData;
    }

    public SamplingData getSamplingResultData() {
        SamplingData samplingData = null;
        try {
            samplingData = this.resultsQueue.dequeue(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return samplingData;
    }

    SamplingFilter getFilter() {
        return this.samplingFilter;
    }
}

