/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm.sampling;

import com.eg.apm.DataTransmitter;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.jtm.sampling.BaseWorker;
import com.eg.jtm.sampling.Sample;
import com.eg.jtm.sampling.SamplingController;
import com.eg.jtm.sampling.SamplingData;
import com.eg.jtm.sampling.StackTraceAnalyzer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public final class SamplingWorker
extends BaseWorker {
    private boolean sampleAnalyzer = false;
    private static final String FINAL_SERVLET_COM_EG_APM_APM_ACTION_SERVLET = "/final/servlet/com.eg.apm.APMActionServlet";

    public SamplingWorker(boolean bl) {
        this.sampleAnalyzer = bl;
    }

    private void doAnalyze(SamplingController samplingController) {
        do {
            boolean bl = false;
            try {
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} runThis : {}", (Object)this.loggerDispStr, (Object)this.runThis);
                while (!bl && this.runThis) {
                    SamplingData samplingData = samplingController.getSamplingSourceData();
                    String string = samplingData.getBaseMethod();
                    ArrayList<Sample> arrayList = samplingData.getSampleList();
                    if (string != null) {
                        string = string.replaceAll("/", ".");
                    }
                    try {
                        StackTraceAnalyzer stackTraceAnalyzer = new StackTraceAnalyzer(arrayList, string);
                        stackTraceAnalyzer.analyze(samplingController.getFilter());
                        LinkedList<ArrayList> linkedList = stackTraceAnalyzer.getCallTreeData();
                        if (linkedList.size() > 0) {
                            samplingData.setCallTreeData(linkedList);
                            samplingController.addResultData(samplingData);
                        } else {
                            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} No callgraph data available in the list, therefore stopped the sending of data to next queue for further process", (Object)this.loggerDispStr);
                        }
                    }
                    catch (Exception exception) {
                        JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Problem occurred while analyzing samples {}", (Object)this.loggerDispStr, (Object)exception);
                    }
                    this.sleep(1L);
                }
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Exception occured in the worker thread {}", (Object)this.loggerDispStr, (Object)exception);
                bl = true;
                break;
            }
            this.sleep(100L);
        } while (this.runThis);
    }

    public void handleResult(SamplingController samplingController) {
        do {
            boolean bl = false;
            try {
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} runThis : {}", (Object)this.loggerDispStr, (Object)this.runThis);
                while (!bl && this.runThis) {
                    try {
                        SamplingData samplingData = samplingController.getSamplingResultData();
                        if (samplingData != null) {
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            hashMap.put("analyzedSample", samplingData.getCallTreeData());
                            hashMap.put("GUID", samplingData.getGuidString());
                            hashMap.put("nodeOrder", samplingData.getNodeOrder());
                            HashMap<String, HashMap<String, Object>> hashMap2 = new HashMap<String, HashMap<String, Object>>();
                            hashMap2.put("SamplingCallGraphDataDBInsertAction", hashMap);
                            HashMap hashMap3 = DataTransmitter.getInstance().transmitDataToManager(FINAL_SERVLET_COM_EG_APM_APM_ACTION_SERVLET, hashMap2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.sleep(1L);
                }
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Error occured while sending the analyzed stacktrace callgraph to the  {}", (Object)this.loggerDispStr, (Object)exception);
                bl = true;
                break;
            }
            this.sleep(100L);
        } while (this.runThis);
    }

    public void run() {
        String string = Thread.currentThread().getName() + ", id " + Thread.currentThread().getId();
        SamplingController samplingController = SamplingController.getInstance();
        if (this.sampleAnalyzer) {
            this.loggerDispStr = "[SamplingAnalyzer] [" + string + "]";
            this.doAnalyze(samplingController);
        } else {
            this.loggerDispStr = "[SamplingResult] [" + string + "]";
            this.handleResult(samplingController);
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Exiting worker thread - runThis : {}", (Object)this.loggerDispStr, (Object)this.runThis);
    }
}

