## print time stamp
echo ""
echo "$(date)"

## Finding whether Docker Engine 

FILE=/var/run/docker.sock
count=`ps -aef | grep docker | grep -v grep | wc -l`

if [ $count -eq 0 ]
then 
count=`ps -aef | grep containerd.sock | grep -v grep | wc -l`
fi


if [ $count -ge 1 ]
then
    sudo apt-get install docker-ce-cli -y

    sudo useradd docker
    
    getgroupid=`stat -c %g /var/run/docker.sock`

    echo "$getgroupid" >> /tmp/doc.txt

    getgroup=`grep $getgroupid /etc/group | cut -f1,1 -d:`

    egdocker=$getgroup

   if [ -z "$egdocker" ]
   then
      sudo groupmod -g $getgroupid docker
      sudo usermod -aG docker egurkha
      egagent=docker
    else
      sudo usermod -aG $egdocker egurkha
      egagent=$egdocker
    fi
else 
 echo ""
fi

FILE=/var/run/containerd/containerd.sock

if [ -S $FILE ]
then
   
    if [ -f /mnt/bin/crictl ]
    then
	sudo ln -s /mnt/bin/crictl /bin/crictl
        sudo sh -c "echo 'CONTAINER_RUNTIME_ENDPOINT=unix:///var/run/containerd/containerd.sock' >> /etc/environment"
        sudo sh -c "echo 'IMAGE_SERVICE_ENDPOINT=unix:///var/run/containerd/containerd.sock' >> /etc/environment"
        sudo apt-get install libseccomp-dev  -y
        sudo apt update
        sudo apt install runc
    fi

    if [ -f /mnt/usr/bin/crictl ]
    then
        sudo ln -s /mnt/usr/bin/crictl /bin/crictl
        sudo ln -s /mnt/usr/bin/crictl /mnt/bin/crictl
        sudo sh -c "echo 'CONTAINER_RUNTIME_ENDPOINT=unix:///var/run/containerd/containerd.sock' >> /etc/environment"
        sudo sh -c "echo 'IMAGE_SERVICE_ENDPOINT=unix:///var/run/containerd/containerd.sock' >> /etc/environment"
        sudo apt-get install libseccomp-dev  -y
        sudo apt update
        sudo apt install runc
    fi

    if [ -f /mnt/usr/local/bin/crictl ]
    then
    
        sudo ln -s /mnt/usr/local/bin/crictl /bin/crictl
        sudo ln -s /mnt/usr/local/bin/crictl /mnt/bin/crictl
        sudo sh -c "echo 'CONTAINER_RUNTIME_ENDPOINT=unix:///var/run/containerd/containerd.sock' >> /etc/environment"
        sudo sh -c "echo 'IMAGE_SERVICE_ENDPOINT=unix:///var/run/containerd/containerd.sock' >> /etc/environment"
        sudo apt-get install libseccomp-dev  -y
        sudo apt update
        sudo apt install runc
    fi
fi


FILE=/var/run/crio/crio.sock

if [ -S $FILE ]
then
    if [ -f /mnt/bin/crictl ]
    then
        sudo ln -s /mnt/bin/crictl /bin/crictl
        sudo sh -c "echo 'CONTAINER_RUNTIME_ENDPOINT=unix:///var/run/crio/crio.sock' >> /etc/environment"
        sudo sh -c "echo 'IMAGE_SERVICE_ENDPOINT=unix:///var/run/crio/crio.sock' >> /etc/environment"
        sudo apt-get install libseccomp-dev  -y
        sudo apt update
        sudo apt install runc
    fi

    if [ -f /mnt/usr/bin/crictl ]
    then
        sudo ln -s /mnt/usr/bin/crictl /bin/crictl
        sudo ln -s /mnt/usr/bin/crictl /mnt/bin/crictl
        sudo sh -c "echo 'CONTAINER_RUNTIME_ENDPOINT=unix:///var/run/crio/crio.sock' >> /etc/environment"
        sudo sh -c "echo 'IMAGE_SERVICE_ENDPOINT=unix:///var/run/crio/crio.sock' >> /etc/environment"
        sudo apt-get install libseccomp-dev  -y
        sudo apt update
        sudo apt install runc
    fi
    
    if [ -f /mnt/usr/local/bin/crictl ]
    then
        sudo ln -s /mnt/usr/local/bin/crictl /bin/crictl
        sudo ln -s /mnt/usr/local/bin/crictl /mnt/bin/crictl
        sudo sh -c "echo 'CONTAINER_RUNTIME_ENDPOINT=unix:///var/run/crio/crio.sock' >> /etc/environment"
        sudo sh -c "echo 'IMAGE_SERVICE_ENDPOINT=unix:///var/run/crio/crio.sock' >> /etc/environment"
        sudo apt-get install libseccomp-dev  -y
        sudo apt update
        sudo apt install runc
    fi
fi


#echo $getgroupid
# Find the Host Docker group ID matches with any of the group in the container

#echo $getgroup

# If the Host Docker Group ID matches with any group insde the container then we will add  egurkha user in to that group else we will change the Docker group ID in the Container which matches the host docker group id


if [ -z "$EG_AGENT_IDENTIFIER_ID" ]
then

	echo "[NICKNAME]" > /opt/egurkha/agent/config/eg_nick.ini
        echo "Nick=$HOSTNAME" >> /opt/egurkha/agent/config/eg_nick.ini

else
        echo "[UAID]" > /opt/egurkha/agent/config/eg_uaid.ini
        echo "UID=$EG_AGENT_IDENTIFIER_ID" >> /opt/egurkha/agent/config/eg_uaid.ini
fi

##Creating Soft link for Cntainerd and crio

if [ -d /var/run/crio ]
then
	echo "/var/run/crio directory exists"  >> /tmp/doc.txt
else 
	if [ -w /var/run ]
	then
		echo "/var/run : write permission"  >> /tmp/doc.txt
		mkdir -p /var/run/crio
	else
		echo "/var/run: No write permission"  >> /tmp/doc.txt
	fi
fi

if [ -S /var/run/containerd/containerd.sock ] && [ -d /var/run/crio ]
then
	echo "/var/run/containerd/containerd.sock available"  >> /tmp/doc.txt
	sudo ln -s /var/run/containerd/containerd.sock /var/run/crio/crio.sock
fi

if [ -f /mnt/usr/local/bin/crictl ]
then
	echo "/mnt/usr/local/bin/crictl available"  >> /tmp/doc.txt
	sudo ln -s /mnt/usr/local/bin/crictl /usr/bin/crictl
	sudo ln -s /mnt/usr/local/bin/crictl /mnt/bin/crictl
fi

###This will clear if there are any old fiels avaialble in the Host
`sudo rm -fr /opt/egbtm/*.*`

##Copy btm files to the Host mount folder to enable BTM montioring on the containers


`chmod 755 -R /opt/egurkha/lib/apm/Java/default/`

`sudo cp -r /opt/egurkha/lib/apm/Java/default/*.* /opt/egbtm/`

`sudo chmod 755 -R /opt/egbtm/`

## eG Agent - logger enabling

if [ "$DEBUG" = true ]
then
	echo "********* DEBUG enabled *******"
	sed -i -e "s|level=WARN|level=ALL|g" -e "s|level=INFO|level=ALL|g" /opt/egurkha/lib/eg_logback.properties
	echo "/opt/egurkha/lib/eg_logback.properties :"
	grep -i "level=" /opt/egurkha/lib/eg_logback.properties
        #sed -i 's/\/dev\/null 2>\/dev\/null &/\/opt\/egurkha\/agent\/logs\/a.out 2\>\/opt\/egurkha\/agent\/logs\/a.err \&/g' /opt/egurkha/bin/start_agent
	echo ""
	cp /opt/egurkha/agent/config/eg_outputy.ini /opt/egurkha/agent/config/eg_output.ini
	echo "/opt/egurkha/agent/config/eg_output.ini: "
	grep -i "output" /opt/egurkha/agent/config/eg_output.ini
	#grep -i "a.out" /opt/egurkha/bin/start_agent
	echo "*******************************"
else
	echo ""
fi

if [ -z $EG_HOST_IP ]
then
	echo "" ## $EG_HOST_IP is empty, do nothing
else
	echo ""
	echo EG_HOST_IP=$EG_HOST_IP
	echo ""
	`sed -i -e "s|-Deg.name=EgMainAgent|-Deg.name=EgMainAgent -DeG_BTM_Server_Socket_Bind_IP=$EG_HOST_IP |g" /opt/egurkha/bin/start_agent`
fi 

if [ -z $egagent ]
 then
    /opt/egurkha/bin/stop_agent 0 && /opt/egurkha/bin/start_agent
 else
    newgrp $egagent
    sg $egagent -c "/opt/egurkha/bin/stop_agent 0 && /opt/egurkha/bin/start_agent"
fi


## Fail safe for agent start
agentrunning=`ps -e -o pid,args | grep "EgMain" | grep -v grep | grep "java " | wc -l`

##echo user $egagent
##echo containerd.sock count: $count
##echo agent running $agentrunning
##echo $(ps -e -o pid,args | grep "EgMain" | grep -v grep | grep "java ")

if [ $agentrunning -eq 0 ]
then 
    /opt/egurkha/bin/stop_agent 0 && /opt/egurkha/bin/start_agent
fi

