/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.http.HttpConnectionHandler;
import org.sblim.wbem.http.HttpServerWorker;
import org.sblim.wbem.http.HttpSocketFactory;
import org.sblim.wbem.util.SessionProperties;
import org.sblim.wbem.util.ThreadPool;

public class HttpServerConnection
implements Runnable {
    private int iPort;
    private ServerSocket iServerSocket;
    private HttpConnectionHandler iHandler;
    private HttpConnectionDispatcher iDispatcher;
    private boolean iClose = true;
    private String iServerName;
    private boolean iSsl;
    private Thread iRunner;
    private SessionProperties iSessionProperties;

    public HttpServerConnection(HttpConnectionHandler handler, int port, boolean ssl, SessionProperties properties) throws IOException {
        this.iPort = port;
        this.iHandler = handler;
        this.iSsl = ssl;
        this.iServerName = "HTTP" + (ssl ? "S Server" : " Server");
        this.iSessionProperties = properties != null ? properties : SessionProperties.getGlobalProperties();
        this.iServerSocket = HttpSocketFactory.getInstance().getServerSocketFactory(ssl, this.iSessionProperties).createServerSocket(port);
    }

    public HttpServerConnection(HttpConnectionHandler handler, int port, boolean ssl) throws IOException {
        this(handler, port, ssl, null);
    }

    public HttpServerConnection(HttpConnectionHandler handler, int port) throws IOException {
        this(handler, port, false, null);
    }

    public void setName(String name) {
        if (this.iRunner != null) {
            this.iRunner.setName(name);
        }
    }

    public int getPort() {
        return this.iServerSocket.getLocalPort();
    }

    public String getHostIP() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public boolean isSSL() {
        return this.iSsl;
    }

    public void start() {
        if (this.iClose) {
            this.iClose = false;
            ThreadGroup group = new ThreadGroup("CIMListener on port " + String.valueOf(this.iPort));
            this.iDispatcher = new HttpConnectionDispatcher(group, this.iHandler, new ThreadPool(1, 16, group, "Handler "));
            this.iDispatcher.start();
            this.iRunner = new Thread(group, this, this.iServerName);
            this.iRunner.setDaemon(true);
            this.iRunner.start();
        }
    }

    public void run() {
        block15: {
            Logger logger;
            while (!this.iClose) {
                try {
                    Socket socket;
                    block14: {
                        socket = this.iServerSocket.accept();
                        try {
                            socket.setKeepAlive(true);
                            socket.setTcpNoDelay(true);
                            socket.setSoTimeout(10000);
                        }
                        catch (IOException e) {
                            Logger logger2 = SessionProperties.getGlobalProperties().getLogger();
                            if (!logger2.isLoggable(Level.WARNING)) break block14;
                            logger2.log(Level.WARNING, "Exception while adjusting socket options", e);
                        }
                    }
                    this.iDispatcher.dispatch(socket);
                }
                catch (Throwable t) {
                    if (t instanceof SocketException && this.iClose) break;
                    try {
                        logger = SessionProperties.getGlobalProperties().getLogger();
                        if (!logger.isLoggable(Level.SEVERE)) continue;
                        logger.log(Level.SEVERE, "Exception while waiting for incoming http connections");
                    }
                    catch (Throwable t2) {}
                }
            }
            try {
                Logger logger3 = SessionProperties.getGlobalProperties().getLogger();
                if (logger3.isLoggable(Level.INFO)) {
                    logger3.log(Level.INFO, "Shutting down CIMListener on port " + this.iPort);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.iDispatcher.close();
            }
            catch (Exception e) {
                logger = SessionProperties.getGlobalProperties().getLogger();
                if (!logger.isLoggable(Level.WARNING)) break block15;
                logger.log(Level.WARNING, "Exception while closing http connection dispatcher", e);
            }
        }
        this.iDispatcher = null;
        this.iRunner = null;
    }

    public void close() {
        block3: {
            if (!this.iClose) {
                this.iClose = true;
                try {
                    this.iServerSocket.close();
                    this.iServerSocket = null;
                }
                catch (Exception e) {
                    Logger logger = SessionProperties.getGlobalProperties().getLogger();
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    logger.log(Level.WARNING, "Exception while closing server socket", e);
                }
            }
        }
    }

    private static class HttpConnectionDispatcher
    extends Thread {
        private List iConnectionPool = new LinkedList();
        private boolean iAlive = true;
        private HttpConnectionHandler iHandler;
        private ThreadPool iThreadPool;

        public HttpConnectionDispatcher(ThreadGroup pGroup, HttpConnectionHandler pHandler, ThreadPool pPool) {
            super(pGroup, "Connection Dispatcher");
            this.setDaemon(true);
            this.iHandler = pHandler;
            this.iThreadPool = pPool;
        }

        public List getConnectionPool() {
            return this.iConnectionPool;
        }

        public synchronized void dispatch(Socket pSocket) {
            this.iConnectionPool.add(pSocket);
            this.notify();
        }

        public synchronized Socket getConnection() {
            while (this.iConnectionPool.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.iAlive) continue;
                return null;
            }
            Socket socket = null;
            if (this.iConnectionPool != null) {
                socket = (Socket)this.iConnectionPool.remove(0);
            }
            return socket;
        }

        public void run() {
            block10: {
                Logger logger;
                block9: {
                    while (this.iAlive) {
                        try {
                            Socket socket = this.getConnection();
                            if (socket == null) continue;
                            this.iThreadPool.execute(new HttpServerWorker(this.iHandler, socket));
                        }
                        catch (Throwable t) {
                            try {
                                logger = SessionProperties.getGlobalProperties().getLogger();
                                if (!logger.isLoggable(Level.SEVERE)) continue;
                                logger.log(Level.SEVERE, "Exception while submitting worker to thread pool", t);
                            }
                            catch (Throwable t1) {}
                        }
                    }
                    try {
                        this.iHandler.close();
                    }
                    catch (Exception e) {
                        logger = SessionProperties.getGlobalProperties().getLogger();
                        if (!logger.isLoggable(Level.WARNING)) break block9;
                        logger.log(Level.WARNING, "Exception while closing http connection handler", e);
                    }
                }
                try {
                    this.iThreadPool.shutdown();
                }
                catch (Exception e) {
                    logger = SessionProperties.getGlobalProperties().getLogger();
                    if (!logger.isLoggable(Level.WARNING)) break block10;
                    logger.log(Level.WARNING, "Exception during shut down of thread pool", e);
                }
            }
        }

        public synchronized void close() {
            this.iAlive = false;
            this.notifyAll();
        }
    }
}

