/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketPermission;
import java.net.URI;
import java.security.Permission;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.http.AuthorizationHandler;
import org.sblim.wbem.http.HttpClient;
import org.sblim.wbem.http.HttpClientPool;
import org.sblim.wbem.util.GlobalProperties;

public class HttpUrlConnection
extends HttpURLConnection {
    private static final String CLASSNAME = "org.sblim.wbem.http.HttpUrlConnection";
    private InputStream iInputStream;
    private boolean iConnected;
    public HttpClient iHttpClient;
    protected URI iUrl;
    private HttpClientPool iHttpClientPool;
    AuthorizationHandler iAuthHandler;
    private Logger iLogger = null;

    public HttpUrlConnection(URI uri, HttpClientPool httpClientPool, AuthorizationHandler auth_handler) {
        super(null);
        this.iUrl = uri;
        this.iHttpClientPool = httpClientPool;
        this.iAuthHandler = auth_handler;
        this.iLogger = GlobalProperties.getLogger();
    }

    public String toString() {
        return "HttpUrlConnection=[url=" + this.iUrl + ",PoolSize=" + this.iHttpClientPool.getNumberOfAvailableConnections() + "," + this.iAuthHandler + "]";
    }

    public Permission getPermission() throws IOException {
        int port = this.iUrl.getPort();
        port = port < 0 ? 80 : port;
        String host = this.iUrl.getHost() + ":" + port;
        SocketPermission permission = new SocketPermission(host, "connect");
        return permission;
    }

    public synchronized void connect() throws IOException {
        if (!this.iConnected) {
            this.getClient();
        }
        this.iHttpClient.connect();
    }

    private synchronized void getClient() {
        if (this.iConnected) {
            return;
        }
        this.iHttpClient = HttpClient.getClient(this.iUrl, this.iHttpClientPool, this.iAuthHandler);
        this.iHttpClient.reset();
        this.iConnected = true;
    }

    public synchronized void setRequestMethod(String pMethod) {
        if (!this.iConnected) {
            this.getClient();
        }
        this.iHttpClient.setRequestMethod(pMethod);
        this.method = pMethod;
    }

    public synchronized void setRequestProperty(String key, String value) {
        if (!this.iConnected) {
            this.getClient();
        }
        this.iHttpClient.setRequestProperty(key, value);
    }

    public synchronized void disconnect() {
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, "disconnect()");
        }
        if (this.iConnected) {
            this.iConnected = false;
            this.iHttpClient.disconnect();
            if (this.iHttpClientPool != null) {
                this.iHttpClientPool.removeConnectionFromPool(this.iHttpClient);
                this.iHttpClient = null;
            }
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.exiting(CLASSNAME, "disconnect()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean pKeepActive) {
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, "close()");
        }
        if (this.iHttpClientPool != null) {
            HttpClientPool httpClientPool = this.iHttpClientPool;
            synchronized (httpClientPool) {
                this.iHttpClientPool.closePool(pKeepActive);
                this.iHttpClientPool = null;
            }
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.exiting(CLASSNAME, "close()");
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.iInputStream != null) {
            return this.iInputStream;
        }
        if (!this.iConnected) {
            this.getClient();
        }
        try {
            return this.iHttpClient.getInputStream();
        }
        catch (RuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (!this.iConnected) {
            this.getClient();
        }
        try {
            return this.iHttpClient.getOutputStream();
        }
        catch (RuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    public boolean usingProxy() {
        return false;
    }

    public synchronized HttpClient getHttpClient() {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient;
    }

    public synchronized String getHeaderField(String name) {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getHeaderField(name);
    }

    public synchronized String getHeaderFieldKey(int index) {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getHeaderFieldKey(index);
    }

    public synchronized String getHeaderField(int index) {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getHeaderField(index);
    }

    public synchronized String getRequestProperty(String key) {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getRequestProperty(key);
    }

    public synchronized String getRequestMethod() {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getRequestMethod();
    }

    public synchronized void reset() {
        if (!this.iConnected) {
            this.getClient();
        }
        this.iHttpClient.reset();
    }

    public synchronized int getResponseCode() throws IOException {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getResponseCode();
    }

    public synchronized String getResponseMessage() {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getResponseMessage();
    }

    public synchronized void useHttp11(boolean bool) {
        if (!this.iConnected) {
            this.getClient();
        }
        this.iHttpClient.useHttp11(bool);
    }
}

