/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite;

import com.ibm.jtopenlite.Connection;
import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.DataStreamException;
import com.ibm.jtopenlite.EncryptPassword;
import com.ibm.jtopenlite.Message;
import com.ibm.jtopenlite.SystemInfo;
import com.ibm.jtopenlite.Trace;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class HostServerConnection
implements Connection {
    private final SystemInfo info_;
    private final String user_;
    private final String jobName_;
    private boolean closed_ = false;
    private final Socket socket_;
    protected final HostInputStream in_;
    protected final HostOutputStream out_;

    protected HostServerConnection(SystemInfo systemInfo, String string, String string2, Socket socket, HostInputStream hostInputStream, HostOutputStream hostOutputStream) {
        this.info_ = systemInfo;
        this.user_ = string;
        this.jobName_ = string2;
        this.socket_ = socket;
        this.in_ = hostInputStream;
        this.out_ = hostOutputStream;
    }

    public static boolean isDefaultDatastreamDebug() {
        return Trace.isStreamTracingEnabled();
    }

    public static void setDefaultDatastreamDebug(boolean bl) {
        HostInputStream.setAllDebug(bl);
        HostOutputStream.setAllDebug(bl);
    }

    public long getBytesReceived() {
        return this.in_.getBytesReceived();
    }

    public long getBytesSent() {
        return this.out_.getBytesSent();
    }

    public boolean isDatastreamDebug() {
        return this.in_.debug_;
    }

    public void setDatastreamDebug(boolean bl) {
        this.in_.setDebug(bl);
        this.out_.setDebug(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        if (this.closed_) {
            return;
        }
        try {
            this.sendEndJobRequest();
        }
        finally {
            this.closed_ = true;
            this.forceClose();
        }
    }

    protected abstract void sendEndJobRequest() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceClose() throws IOException {
        block12: {
            SocketException socketException = null;
            try {
                this.in_.close();
                this.out_.close();
            }
            catch (SocketException socketException2) {
                if (socketException2.toString().indexOf("Socket closed") >= 0) {
                    break block12;
                }
                socketException = socketException2;
                throw socketException;
            }
            finally {
                block13: {
                    try {
                        this.socket_.close();
                    }
                    catch (SocketException socketException3) {
                        if (socketException3.toString().indexOf("Socket closed") >= 0 || socketException != null) break block13;
                        throw socketException3;
                    }
                }
            }
        }
    }

    protected final void finalize() throws Throwable {
        this.close();
    }

    public final boolean isClosed() {
        return this.closed_;
    }

    public final SystemInfo getInfo() {
        return this.info_;
    }

    public final String getUser() {
        return this.user_;
    }

    public final String getJobName() {
        return this.jobName_;
    }

    protected static byte[] getEncryptedPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n) throws IOException {
        boolean bl = n >= 2;
        byte[] byArray5 = null;
        byArray5 = bl ? EncryptPassword.encryptPasswordSHA(byArray, byArray2, byArray3, byArray4) : EncryptPassword.encryptPasswordDES(byArray, byArray2, byArray3, byArray4);
        return byArray5;
    }

    protected static String connect(SystemInfo systemInfo, HostOutputStream hostOutputStream, HostInputStream hostInputStream, int n, String string, String string2) throws IOException {
        long l = HostServerConnection.sendExchangeRandomSeedsRequest(hostOutputStream, n);
        byte[] byArray = Conv.longToByteArray(l);
        hostOutputStream.flush();
        int n2 = hostInputStream.readInt();
        if (n2 < 20) {
            throw DataStreamException.badLength("exchangeRandomSeeds-" + n, n2);
        }
        hostInputStream.skipBytes(16);
        int n3 = hostInputStream.readInt();
        if (n3 != 0) {
            throw DataStreamException.badReturnCode("exchangeRandomSeeds-" + n, n3);
        }
        byte[] byArray2 = new byte[8];
        hostInputStream.readFully(byArray2);
        byte[] byArray3 = HostServerConnection.getUserBytes(string, systemInfo.getPasswordLevel());
        byte[] byArray4 = HostServerConnection.getPasswordBytes(string2, systemInfo.getPasswordLevel());
        string2 = null;
        byte[] byArray5 = HostServerConnection.getEncryptedPassword(byArray3, byArray4, byArray, byArray2, systemInfo.getPasswordLevel());
        hostInputStream.end();
        byte[] byArray6 = systemInfo.getPasswordLevel() < 2 ? byArray3 : HostServerConnection.getUserBytes(string, 0);
        HostServerConnection.sendStartServerRequest(hostOutputStream, byArray6, byArray5, n);
        hostOutputStream.flush();
        n2 = hostInputStream.readInt();
        if (n2 < 20) {
            throw DataStreamException.badLength("startServer-" + n, n2);
        }
        hostInputStream.skipBytes(16);
        n3 = hostInputStream.readInt();
        if (n3 != 0) {
            String string3 = HostServerConnection.getReturnCodeMessage(n3);
            throw string3 == null ? DataStreamException.badReturnCode("startServer-" + n, n3) : DataStreamException.errorMessage("startServer-" + n, new Message(String.valueOf(n3), string3));
        }
        String string4 = null;
        int n4 = n2 - 24;
        while (n4 > 10) {
            int n5 = hostInputStream.readInt();
            int n6 = hostInputStream.readShort();
            n4 -= 6;
            if (n6 == 4383) {
                hostInputStream.skipBytes(4);
                n4 -= 4;
                int n7 = n5 - 10;
                byte[] byArray7 = new byte[n7];
                hostInputStream.readFully(byArray7);
                string4 = Conv.ebcdicByteArrayToString(byArray7, 0, n7);
                n4 -= n7;
                continue;
            }
            hostInputStream.skipBytes(n5 - 6);
            n4 -= n5 - 6;
        }
        hostInputStream.skipBytes(n4);
        hostInputStream.end();
        return string4;
    }

    private static String getReturnCodeMessage(int n) {
        if ((n & 0xFFFF0000) == 65536) {
            return "Error on request data";
        }
        if ((n & 0xFFFF0000) == 262144) {
            return "General security error, function not performed";
        }
        if ((n & 0xFFFF0000) == 393216) {
            return "Authentication Token error";
        }
        switch (n) {
            case 131073: {
                return "Userid error: User Id unknown";
            }
            case 131074: {
                return "Userid error: User Id valid, but revoked";
            }
            case 131075: {
                return "Userid error: User Id mismatch with authentication token";
            }
            case 196619: {
                return "Password error: Password or Passphrase incorrect";
            }
            case 196620: {
                return "Password error: User profile will be revoked on next invalid password or passphrase";
            }
            case 196621: {
                return "Password error: Password or Passphrase correct, but expired";
            }
            case 196622: {
                return "Password error: Pre-V2R2 encrypted password";
            }
            case 196624: {
                return "Password error: Password is *NONE";
            }
        }
        return null;
    }

    static void sendStartServerRequest(HostOutputStream hostOutputStream, byte[] byArray, byte[] byArray2, int n) throws IOException {
        hostOutputStream.writeInt(44 + byArray2.length);
        hostOutputStream.writeByte(2);
        hostOutputStream.writeByte(0);
        hostOutputStream.writeShort(n);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeShort(2);
        hostOutputStream.writeShort(28674);
        hostOutputStream.writeByte(byArray2.length == 8 ? 1 : 3);
        hostOutputStream.writeByte(1);
        hostOutputStream.writeInt(6 + byArray2.length);
        hostOutputStream.writeShort(4357);
        hostOutputStream.write(byArray2);
        hostOutputStream.writeInt(16);
        hostOutputStream.writeShort(4356);
        hostOutputStream.write(byArray);
    }

    static long sendExchangeRandomSeedsRequest(HostOutputStream hostOutputStream, int n) throws IOException {
        hostOutputStream.writeInt(28);
        hostOutputStream.writeByte(1);
        hostOutputStream.writeByte(0);
        hostOutputStream.writeShort(n);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeShort(8);
        hostOutputStream.writeShort(28673);
        long l = System.currentTimeMillis();
        hostOutputStream.writeLong(l);
        return l;
    }

    static byte[] getUserBytes(String string, int n) throws IOException {
        if (n < 2) {
            if (string.length() > 10) {
                throw new IOException("User too long");
            }
            byte[] byArray = Conv.blankPadEBCDIC10(string.toUpperCase());
            return byArray;
        }
        byte[] byArray = new byte[20];
        Conv.stringToBlankPadUnicodeByteArray(string.toUpperCase(), byArray, 0, 20);
        return byArray;
    }

    static byte[] getPasswordBytes(String string, int n) throws IOException {
        if (n < 2) {
            if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
                string = "Q" + string;
            }
            if (string.length() > 10) {
                throw new IOException("Password too long");
            }
            byte[] byArray = Conv.blankPadEBCDIC10(string.toUpperCase());
            return byArray;
        }
        return Conv.stringToUnicodeByteArray(string);
    }

    protected static void writePadEBCDIC10(String string, HostOutputStream hostOutputStream) throws IOException {
        Conv.writePadEBCDIC10(string, hostOutputStream);
    }

    protected static void writePadEBCDIC(String string, int n, HostOutputStream hostOutputStream) throws IOException {
        Conv.writePadEBCDIC(string, n, hostOutputStream);
    }

    protected static void writeStringToUnicodeBytes(String string, HostOutputStream hostOutputStream) throws IOException {
        Conv.writeStringToUnicodeBytes(string, hostOutputStream);
    }

    protected static final class HostOutputStream {
        static SimpleDateFormat formatter_ = new SimpleDateFormat("EEE MMM d HH:mm:ss:SSS z yyyy");
        static final char[] CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        private static boolean allDebug_ = false;
        private final OutputStream out_;
        private boolean debug_;
        private int debugCounter_ = 0;
        private int bytesSent_ = 0;
        private PrintStream tracePrintStream = null;

        public static void setAllDebug(boolean bl) {
            allDebug_ = bl;
        }

        public long getBytesSent() {
            return this.bytesSent_;
        }

        public HostOutputStream(OutputStream outputStream) {
            this.out_ = outputStream;
            this.debug_ = Trace.isStreamTracingEnabled();
            if (this.debug_ || allDebug_) {
                this.tracePrintStream = Trace.getPrintStream();
                if (this.tracePrintStream == null) {
                    this.tracePrintStream = System.out;
                }
            }
        }

        public void setDebug(boolean bl) {
            this.debug_ = bl;
            if (this.debug_) {
                this.tracePrintStream = Trace.getPrintStream();
            }
        }

        public void writeInt(int n) throws IOException {
            this.out_.write(n >> 24);
            this.out_.write(n >> 16);
            this.out_.write(n >> 8);
            this.out_.write(n);
            this.bytesSent_ += 4;
            if (this.debug_) {
                this.debugInt(n);
            }
        }

        private void debugInt(int n) {
            this.debugByte(n >> 24);
            this.debugByte(n >> 16);
            this.debugByte(n >> 8);
            this.debugByte(n);
        }

        private void debugShort(int n) {
            this.debugByte(n >> 8);
            this.debugByte(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void debugByte(int n) {
            if (this.tracePrintStream != null) {
                if (this.debugCounter_ == 0) {
                    SimpleDateFormat simpleDateFormat = formatter_;
                    synchronized (simpleDateFormat) {
                        this.tracePrintStream.print(formatter_.format(new Date()));
                        this.tracePrintStream.println(" Data stream sent...");
                    }
                }
                int n2 = (0xFF & n) >> 4;
                int n3 = 0xF & n;
                this.tracePrintStream.print(CHAR[n2]);
                this.tracePrintStream.print(CHAR[n3]);
                if (++this.debugCounter_ % 16 == 0) {
                    this.tracePrintStream.println();
                } else {
                    this.tracePrintStream.print(" ");
                }
            }
        }

        private void debugBytes(byte[] byArray, int n, int n2) {
            for (int i = n; i < n + n2; ++i) {
                this.debugByte(byArray[i]);
            }
        }

        public void writeShort(int n) throws IOException {
            this.out_.write(n >> 8);
            this.out_.write(n);
            this.bytesSent_ += 2;
            if (this.debug_) {
                this.debugShort(n);
            }
        }

        public void writeLong(long l) throws IOException {
            int n = (int)(l >> 32);
            int n2 = (int)l;
            this.writeInt(n);
            this.writeInt(n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.out_.write(byArray, 0, byArray.length);
            this.bytesSent_ += byArray.length;
            if (this.debug_) {
                this.debugBytes(byArray, 0, byArray.length);
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out_.write(byArray, n, n2);
            this.bytesSent_ += n2;
            if (this.debug_) {
                this.debugBytes(byArray, n, n2);
            }
        }

        public void write(int n) throws IOException {
            this.out_.write(n);
            ++this.bytesSent_;
            if (this.debug_) {
                this.debugByte(n);
            }
        }

        public void writeByte(int n) throws IOException {
            this.out_.write(n);
            ++this.bytesSent_;
            if (this.debug_) {
                this.debugByte(n);
            }
        }

        public void close() throws IOException {
            this.out_.close();
            if (this.debug_ && this.tracePrintStream != null) {
                this.tracePrintStream.println();
                this.debugCounter_ = 0;
            }
        }

        public void flush() throws IOException {
            this.out_.flush();
            if (this.debug_ && this.tracePrintStream != null) {
                this.tracePrintStream.println();
                this.debugCounter_ = 0;
            }
        }
    }

    protected static final class HostInputStream {
        private static boolean allDebug_ = false;
        private final InputStream in_;
        private boolean debug_;
        private int debugCounter_ = 0;
        private final byte[] shortArray_ = new byte[2];
        private final byte[] intArray_ = new byte[4];
        private final byte[] longArray_ = new byte[8];
        private PrintStream tracePrintStream = null;
        private long bytesReceivedAtLastReset_ = 0L;
        private long latestBytesReceived_ = 0L;

        public static void setAllDebug(boolean bl) {
            allDebug_ = bl;
        }

        public HostInputStream(InputStream inputStream) {
            this.in_ = inputStream;
            this.debug_ = Trace.isStreamTracingEnabled();
            if (this.debug_ || allDebug_) {
                this.tracePrintStream = Trace.getPrintStream();
                if (this.tracePrintStream == null) {
                    this.tracePrintStream = System.out;
                }
            }
        }

        public void resetLatestBytesReceived() {
            this.bytesReceivedAtLastReset_ += this.latestBytesReceived_;
            this.latestBytesReceived_ = 0L;
        }

        public long getLatestBytesReceived() {
            return this.latestBytesReceived_;
        }

        public long getBytesReceived() {
            return this.bytesReceivedAtLastReset_ + this.latestBytesReceived_;
        }

        public void setDebug(boolean bl) {
            this.debug_ = bl;
            if (this.debug_) {
                this.tracePrintStream = Trace.getPrintStream();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void debugByte(int n) {
            if (this.tracePrintStream != null) {
                if (this.debugCounter_ == 0) {
                    SimpleDateFormat simpleDateFormat = HostOutputStream.formatter_;
                    synchronized (simpleDateFormat) {
                        this.tracePrintStream.print(HostOutputStream.formatter_.format(new Date()));
                        this.tracePrintStream.println(" Data stream data received...");
                    }
                }
                int n2 = (0xFF & n) >> 4;
                int n3 = 0xF & n;
                this.tracePrintStream.print(HostOutputStream.CHAR[n2]);
                this.tracePrintStream.print(HostOutputStream.CHAR[n3]);
                if (++this.debugCounter_ % 16 == 0) {
                    this.tracePrintStream.println();
                } else {
                    this.tracePrintStream.print(" ");
                }
            }
        }

        private void debugBytes(byte[] byArray, int n, int n2) {
            for (int i = n; i < n + n2; ++i) {
                this.debugByte(byArray[i]);
            }
        }

        public void end() {
            if (this.debug_ && this.tracePrintStream != null) {
                this.tracePrintStream.println();
                this.debugCounter_ = 0;
            }
        }

        public int read() throws IOException {
            int n = this.in_.read();
            if (n < 0) {
                throw new EOFException();
            }
            if (this.debug_) {
                this.debugByte(n);
            }
            ++this.latestBytesReceived_;
            return n;
        }

        public int readByte() throws IOException {
            return this.read();
        }

        public int readShort() throws IOException {
            int n = this.in_.read(this.shortArray_);
            if (n != 2) {
                int n2 = n >= 0 ? n : 0;
                this.latestBytesReceived_ += (long)n2;
                while (n >= 0 && n2 < 2) {
                    this.latestBytesReceived_ += (long)(n2 += (n = this.in_.read(this.shortArray_, n2, 2 - n2)) >= 0 ? n : 0);
                }
                if (n2 < 2) {
                    throw new EOFException();
                }
            } else {
                this.latestBytesReceived_ += 2L;
            }
            if (this.debug_) {
                this.debugBytes(this.shortArray_, 0, 2);
            }
            return (this.shortArray_[0] & 0xFF) << 8 | this.shortArray_[1] & 0xFF;
        }

        public int readInt() throws IOException {
            int n = this.in_.read(this.intArray_);
            if (n != 4) {
                int n2 = n >= 0 ? n : 0;
                this.latestBytesReceived_ += (long)n2;
                while (n >= 0 && n2 < 4) {
                    this.latestBytesReceived_ += (long)(n2 += (n = this.in_.read(this.intArray_, n2, 4 - n2)) >= 0 ? n : 0);
                }
                if (n2 < 4) {
                    throw new EOFException();
                }
            } else {
                this.latestBytesReceived_ += 4L;
            }
            if (this.debug_) {
                this.debugBytes(this.intArray_, 0, 4);
            }
            return Conv.byteArrayToInt(this.intArray_, 0);
        }

        public long readLong() throws IOException {
            int n = this.in_.read(this.longArray_);
            if (n != 8) {
                int n2 = n >= 0 ? n : 0;
                this.latestBytesReceived_ += (long)n2;
                while (n >= 0 && n2 < 8) {
                    this.latestBytesReceived_ += (long)(n2 += (n = this.in_.read(this.longArray_, n2, 8 - n2)) >= 0 ? n : 0);
                }
                if (n2 < 8) {
                    throw new EOFException();
                }
            } else {
                this.latestBytesReceived_ += 8L;
            }
            if (this.debug_) {
                this.debugBytes(this.longArray_, 0, 8);
            }
            return Conv.byteArrayToLong(this.longArray_, 0);
        }

        public int skipBytes(int n) throws IOException {
            if (this.debug_) {
                int n2;
                for (n2 = 0; n2 < n; ++n2) {
                    this.read();
                }
                return n2;
            }
            int n3 = (int)this.in_.skip(n);
            if (n3 != n) {
                int n4 = n3 >= 0 ? n3 : 0;
                this.latestBytesReceived_ += (long)n4;
                while (n3 >= 0 && n4 < n) {
                    this.latestBytesReceived_ += (long)(n4 += (n3 = (int)this.in_.skip(n - n4)) >= 0 ? n3 : 0);
                }
                if (n4 < n) {
                    throw new EOFException();
                }
            } else {
                this.latestBytesReceived_ += (long)n;
            }
            return n3;
        }

        public void close() throws IOException {
            this.in_.close();
            if (this.debug_ && this.tracePrintStream != null) {
                this.tracePrintStream.println();
                this.debugCounter_ = 0;
            }
        }

        public void readFully(byte[] byArray) throws IOException {
            int n = this.in_.read(byArray);
            if (n != byArray.length) {
                int n2 = n >= 0 ? n : 0;
                this.latestBytesReceived_ += (long)n2;
                while (n >= 0 && n2 < byArray.length) {
                    this.latestBytesReceived_ += (long)(n2 += (n = this.in_.read(byArray, n2, byArray.length - n2)) >= 0 ? n : 0);
                }
                if (n2 < byArray.length) {
                    throw new EOFException();
                }
            } else {
                this.latestBytesReceived_ += (long)n;
            }
            if (this.debug_) {
                this.debugBytes(byArray, 0, byArray.length);
            }
        }

        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.in_.read(byArray, n, n2);
            if (n3 != n2) {
                int n4 = n3 >= 0 ? n3 : 0;
                this.latestBytesReceived_ += (long)n4;
                while (n3 >= 0 && n4 < n2) {
                    this.latestBytesReceived_ += (long)(n4 += (n3 = this.in_.read(byArray, n + n4, n2 - n4)) >= 0 ? n3 : 0);
                }
                if (n4 < n2) {
                    throw new EOFException();
                }
            } else {
                this.latestBytesReceived_ += (long)n2;
            }
            if (this.debug_) {
                this.debugBytes(byArray, n, n2);
            }
        }
    }
}

