/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite;

import com.ibm.jtopenlite.Message;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageException
extends IOException {
    private static final long serialVersionUID = 3994984723312909458L;
    private final String text_;
    private Message[] messages_;
    private List<Message> messagesList_;

    public MessageException(String string, Message[] messageArray) {
        super(MessageException.buildString(string, messageArray));
        this.text_ = string;
        this.messages_ = messageArray;
        this.messagesList_ = null;
    }

    public MessageException(String string, List<Message> list) {
        super(MessageException.buildString(string, list));
        this.text_ = string;
        this.messagesList_ = list;
        this.messages_ = null;
    }

    public MessageException(Message[] messageArray) {
        super(MessageException.buildString(null, messageArray));
        this.text_ = null;
        this.messages_ = messageArray;
        this.messagesList_ = null;
    }

    public MessageException(List<Message> list) {
        super(MessageException.buildString(null, list));
        this.text_ = null;
        this.messages_ = null;
        this.messagesList_ = list;
    }

    private static final String buildString(String string, List<Message> list) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        stringBuffer.append(list.get(0).toString());
        for (int i = 1; i < list.size(); ++i) {
            stringBuffer.append("\n");
            stringBuffer.append(list.get(i).toString());
        }
        return stringBuffer.toString();
    }

    private static final String buildString(String string, Message[] messageArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            stringBuffer.append(messageArray[0].toString());
        } else {
            stringBuffer.append(string);
            stringBuffer.append("\n");
            stringBuffer.append(messageArray[0].toString());
        }
        for (int i = 1; i < messageArray.length; ++i) {
            stringBuffer.append("\n");
            stringBuffer.append(messageArray[i].toString());
        }
        return stringBuffer.toString();
    }

    public String getPreamble() {
        return this.text_;
    }

    public Message[] getMessages() {
        if (this.messages_ == null && this.messagesList_ != null) {
            this.messages_ = new Message[this.messagesList_.size()];
            for (int i = 0; i < this.messages_.length; ++i) {
                this.messages_[i] = this.messagesList_.get(i);
            }
        }
        return this.messages_;
    }

    public List<Message> getMessagesList() {
        if (this.messagesList_ == null && this.messages_ != null) {
            this.messagesList_ = new LinkedList<Message>();
            for (int i = 0; i < this.messages_.length; ++i) {
                this.messagesList_.add(this.messages_[i]);
            }
        }
        return this.messagesList_;
    }
}

