/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.ddm;

import com.ibm.jtopenlite.ddm.DDMField;

public class DDMRecordFormat {
    private final String library_;
    private final String file_;
    private final String name_;
    private final String type_;
    private final String text_;
    private final DDMField[] fields_;
    private final int totalLength_;

    DDMRecordFormat(String string, String string2, String string3, String string4, String string5, DDMField[] dDMFieldArray, int n) {
        this.library_ = string;
        this.file_ = string2;
        this.name_ = string3;
        this.type_ = string4;
        this.text_ = string5;
        this.fields_ = dDMFieldArray;
        this.totalLength_ = n;
    }

    public DDMRecordFormat newCopy() {
        DDMField[] dDMFieldArray = new DDMField[this.fields_.length];
        for (int i = 0; i < this.fields_.length; ++i) {
            dDMFieldArray[i] = this.fields_[i].newCopy();
        }
        return new DDMRecordFormat(this.library_, this.file_, this.name_, this.type_, this.text_, dDMFieldArray, this.totalLength_);
    }

    public String getName() {
        return this.name_;
    }

    public String getLibrary() {
        return this.library_;
    }

    public String getFile() {
        return this.file_;
    }

    public String getType() {
        return this.type_;
    }

    public String getText() {
        return this.text_;
    }

    public int getLength() {
        return this.totalLength_;
    }

    public int getRecommendedBatchSize() {
        int n = this.totalLength_ + 16;
        int n2 = 32768 / n - 1;
        if (n2 <= 0) {
            return 1;
        }
        return n2;
    }

    public int getFieldCount() {
        return this.fields_.length;
    }

    public DDMField getField(int n) {
        return n >= 0 && n < this.fields_.length ? this.fields_[n] : null;
    }

    public DDMField getField(String string) {
        return this.getField(this.getIndex(string));
    }

    private int getIndex(String string) {
        for (int i = 0; i < this.fields_.length; ++i) {
            if (!this.fields_[i].getName().equals(string)) continue;
            return i;
        }
        return -1;
    }
}

