/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ContainerType;
import com.vmware.vcloud.api.rest.schema.QueryResultRecordsType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.ReferencesType;
import com.vmware.vcloud.sdk.RecordResult;
import com.vmware.vcloud.sdk.Result;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;

public class ReferenceResult
extends Result<ReferencesType> {
    private List<ReferenceType> references;

    ReferenceResult(VcloudClient client, ReferencesType referencesType) {
        super(client, (ContainerType)referencesType);
        this.sortReferences_v1_5();
    }

    private void sortReferences_v1_5() {
        if (this.references == null) {
            this.references = new ArrayList<ReferenceType>();
        }
        for (JAXBElement referenceType : this.getResource().getReference()) {
            this.references.add((ReferenceType)referenceType.getValue());
        }
    }

    @Override
    public ReferencesType getResource() {
        return (ReferencesType)super.getResource();
    }

    public List<ReferenceType> getReferences() {
        if (this.references == null) {
            this.references = new ArrayList<ReferenceType>();
        }
        return this.references;
    }

    public ReferenceResult getFirstPage() throws VCloudException {
        if (this.hasFirstPage().booleanValue()) {
            return new ReferenceResult(this.getVcloudClient(), (ReferencesType)SdkUtil.get(this.getVcloudClient(), this.getFirstPageReference().getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceResult getPreviousPage() throws VCloudException {
        if (this.hasPreviousPage().booleanValue()) {
            return new ReferenceResult(this.getVcloudClient(), (ReferencesType)SdkUtil.get(this.getVcloudClient(), this.getPreviousPageReference().getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceResult getNextPage() throws VCloudException {
        if (this.hasNextPage().booleanValue()) {
            return new ReferenceResult(this.getVcloudClient(), (ReferencesType)SdkUtil.get(this.getVcloudClient(), this.getNextPageReference().getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceResult getLastPage() throws VCloudException {
        if (this.hasLastPage().booleanValue()) {
            return new ReferenceResult(this.getVcloudClient(), (ReferencesType)SdkUtil.get(this.getVcloudClient(), this.getLastPageReference().getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public RecordResult getRecordResult() throws VCloudException {
        if (this.hasAlternateRecordsRefResult().booleanValue()) {
            return new RecordResult(this.getVcloudClient(), (QueryResultRecordsType)SdkUtil.get(this.getVcloudClient(), this.getAlternateRecordRef().getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public RecordResult getIdRecordResult() throws VCloudException {
        if (this.hasAlternateIdRecordsRefResult().booleanValue()) {
            return new RecordResult(this.getVcloudClient(), (QueryResultRecordsType)SdkUtil.get(this.getVcloudClient(), this.getAlternateIdRecordRef().getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

