/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.OperatingSystemFamilyInfoType;
import com.vmware.vcloud.api.rest.schema.OperatingSystemInfoType;
import com.vmware.vcloud.api.rest.schema.OrgListType;
import com.vmware.vcloud.api.rest.schema.QueryResultFileDescriptorRecordType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.SessionType;
import com.vmware.vcloud.api.rest.schema.SupportedOperatingSystemsInfoType;
import com.vmware.vcloud.api.rest.schema.VdcTemplateListType;
import com.vmware.vcloud.api.rest.schema.versioning.SupportedVersionsType;
import com.vmware.vcloud.api.rest.schema.versioning.VersionInfoType;
import com.vmware.vcloud.sdk.QueryService;
import com.vmware.vcloud.sdk.RecordResult;
import com.vmware.vcloud.sdk.ReferenceResult;
import com.vmware.vcloud.sdk.Response;
import com.vmware.vcloud.sdk.RestUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.admin.VcloudAdmin;
import com.vmware.vcloud.sdk.admin.extensions.VcloudAdminExtension;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.Version;
import com.vmware.vcloud.sdk.constants.query.FormatType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class VcloudClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private String vCloudApiURL;
    private DefaultHttpClient client;
    private String userName;
    private String orgName;
    private HashMap<String, ReferenceType> orgRefsByName;
    private String vCloudTokenHeader;
    private String vCloudToken;
    HashMap<String, VersionInfoType> supportedApiVersions;
    static final HashMap<Version, String> SUPPORTED_SDK_VERSIONS = new HashMap();
    Version vcloudClientVersion;

    public Version getVcloudClientVersion() throws VCloudException {
        return this.vcloudClientVersion;
    }

    String getVcloudTokenHeader() throws VCloudException {
        if (this.vCloudTokenHeader != null) {
            return this.vCloudTokenHeader;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.LOGIN_ERROR_MSG));
    }

    private void setVcloudTokenHeader(String vcloudTokenHeader) {
        this.vCloudTokenHeader = vcloudTokenHeader;
    }

    public String getVcloudToken() throws VCloudException {
        if (this.vCloudToken != null) {
            return this.vCloudToken;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.LOGIN_ERROR_MSG));
    }

    public void setVcloudToken(String vcloudToken) {
        this.vCloudToken = vcloudToken;
        this.vCloudTokenHeader = "x-vcloud-authorization";
    }

    public VcloudClient(String vCloudUrl, Version version) {
        try {
            if (!vCloudUrl.endsWith("/") && !vCloudUrl.endsWith("\\")) {
                vCloudUrl = vCloudUrl + "/";
            }
            new URL(vCloudUrl);
        }
        catch (MalformedURLException e) {
            throw new VCloudRuntimeException(e);
        }
        this.setVCloudApiURL(vCloudUrl + "api");
        this.vcloudClientVersion = version;
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager();
        this.client = new DefaultHttpClient((ClientConnectionManager)connectionManager);
    }

    public void setConnectionTimeout(int milliseconds) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.client.getParams(), (int)milliseconds);
    }

    public void setSocketTimeout(int milliseconds) {
        HttpConnectionParams.setSoTimeout((HttpParams)this.client.getParams(), (int)milliseconds);
    }

    public HashMap<String, VersionInfoType> getSupportedVersions() throws VCloudException {
        if (this.supportedApiVersions == null) {
            Response response;
            this.supportedApiVersions = new HashMap();
            try {
                response = RestUtil.getSupportedVersions(this, this.getVcloudApiURL() + "/versions");
            }
            catch (VCloudRuntimeException e) {
                throw new VCloudRuntimeException(e);
            }
            SupportedVersionsType supportedVersionsType = null;
            if (response.isExpected(200)) {
                supportedVersionsType = (SupportedVersionsType)response.getResource();
            } else {
                response.handleUnExpectedResponse();
            }
            if (supportedVersionsType != null) {
                for (VersionInfoType version : supportedVersionsType.getVersionInfo()) {
                    this.supportedApiVersions.put(version.getVersion(), version);
                }
            }
        }
        return this.supportedApiVersions;
    }

    public void setMaxConnections(int maxConnections) {
        ((ThreadSafeClientConnManager)this.client.getConnectionManager()).setDefaultMaxPerRoute(maxConnections);
        if (maxConnections > 20) {
            ((ThreadSafeClientConnManager)this.client.getConnectionManager()).setMaxTotal(maxConnections);
        }
    }

    public void setProxy(String proxyHost, int port, String scheme) {
        HttpHost proxy = new HttpHost(proxyHost, port, scheme);
        this.client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }

    public void setProxyCredentials(String username, String password) {
        HttpHost httpHost = (HttpHost)this.client.getParams().getParameter("http.route.default-proxy");
        if (httpHost != null) {
            this.client.getCredentialsProvider().setCredentials(new AuthScope(httpHost.getHostName(), httpHost.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        }
    }

    public void login(String userName, String password) throws VCloudException {
        String userPart = userName.substring(0, userName.lastIndexOf("@"));
        try {
            userPart = URLEncoder.encode(userPart, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new VCloudRuntimeException(e);
        }
        userName = userPart + userName.substring(userName.lastIndexOf("@"));
        Header authHeader = BasicScheme.authenticate((Credentials)new UsernamePasswordCredentials(userName, password), (String)"UTF-8", (boolean)false);
        VersionInfoType versionInfo = this.getSupportedVersions().get(this.vcloudClientVersion.value());
        if (versionInfo == null) {
            throw new VCloudException(this.vcloudClientVersion.value() + " " + SdkUtil.getI18nString(SdkMessage.VERSION_NOT_SUPPORTED));
        }
        Response response = RestUtil.login(this, versionInfo.getLoginUrl(), authHeader);
        this.client.getCookieStore().clear();
        if (!response.isExpected(200)) {
            response.handleUnExpectedResponse();
        }
        SessionType session = (SessionType)response.getResource();
        this.setOrgName(session.getOrg());
        this.setUserName(session.getUser());
    }

    public void ssoLogin(Element tokenElement, String orgName) throws VCloudException {
        this.ssoLogin(this.getSamlAssertionXML(tokenElement), orgName);
    }

    public void ssoLogin(String samlAssertionXML, String orgName) throws VCloudException {
        this.samlSsoLogin(samlAssertionXML, orgName, null, null);
    }

    public void ssoLogin(Element hokToken, String orgName, String signature, String signature_algorithm) throws VCloudException {
        this.ssoLogin(this.getSamlAssertionXML(hokToken), orgName, signature, signature_algorithm);
    }

    public void ssoLogin(String samlAssertionXML, String orgName, String signature, String signature_algorithm) throws VCloudException {
        this.samlSsoLogin(samlAssertionXML, orgName, signature, signature_algorithm);
    }

    private String getSamlAssertionXML(Element tokenElement) {
        Transformer transformer;
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try {
            transformer = transFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new VCloudRuntimeException(e);
        }
        StringWriter buffer = new StringWriter();
        try {
            transformer.transform(new DOMSource(tokenElement), new StreamResult(buffer));
        }
        catch (TransformerException e) {
            throw new VCloudRuntimeException(e);
        }
        return buffer.toString();
    }

    private void samlSsoLogin(String samlAssertionXML, String orgName, String signature, String signature_algorithm) throws VCloudException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gout = new GZIPOutputStream(out);
            gout.write(samlAssertionXML.getBytes());
            gout.close();
        }
        catch (IOException e) {
            throw new VCloudRuntimeException(e);
        }
        VersionInfoType versionInfo = this.getSupportedVersions().get(this.vcloudClientVersion.value());
        if (versionInfo == null) {
            throw new VCloudException(this.vcloudClientVersion.value() + " " + SdkUtil.getI18nString(SdkMessage.VERSION_NOT_SUPPORTED));
        }
        String output = new Base64(0).encodeToString(out.toByteArray());
        String compressedEncodedSAMLAssertionXML = output.replaceAll(System.getProperty("line.separator"), "");
        BasicHeader samlAuthHeader = signature != null && signature_algorithm != null ? (orgName.equalsIgnoreCase("System") ? new BasicHeader("Authorization", "SIGN token=\"" + compressedEncodedSAMLAssertionXML + "\"" + "," + "signature" + "=\"" + signature + "\"" + "," + "signature_alg" + "=\"" + signature_algorithm + "\"") : new BasicHeader("Authorization", "SIGN token=\"" + compressedEncodedSAMLAssertionXML + "\"," + "org" + "=" + "\"" + orgName + "\"" + "," + "signature" + "=\"" + signature + "\"" + "," + "signature_alg" + "=\"" + signature_algorithm + "\"")) : (orgName.equalsIgnoreCase("System") ? new BasicHeader("Authorization", "SIGN token=\"" + compressedEncodedSAMLAssertionXML + "\"") : new BasicHeader("Authorization", "SIGN token=\"" + compressedEncodedSAMLAssertionXML + "\"," + "org" + "=" + "\"" + orgName + "\""));
        Response response = RestUtil.login(this, versionInfo.getLoginUrl(), (Header)samlAuthHeader);
        this.client.getCookieStore().clear();
        if (!response.isExpected(200)) {
            response.handleUnExpectedResponse();
        }
        SessionType session = (SessionType)response.getResource();
        this.setOrgName(session.getOrg());
        this.setUserName(session.getUser());
    }

    public void logout() throws VCloudException {
        SdkUtil.delete(this, this.getVcloudApiURL() + "/session", 204);
        this.setVcloudTokenHeader(null);
        this.setVcloudToken(null);
        logger.info(SdkUtil.getI18nString(SdkMessage.LOGOUT_INFO_MSG));
    }

    public HashMap<String, ReferenceType> getOrgRefsByName() throws VCloudException {
        return this.orgRefsByName == null ? this.getOrgReferences() : this.orgRefsByName;
    }

    public HashMap<String, ReferenceType> getUpdatedOrgList() throws VCloudException {
        return this.getOrgReferences();
    }

    public ReferenceType getOrgRefByName(String orgName) throws VCloudException {
        return this.orgRefsByName == null ? this.getOrgReferences().get(orgName) : this.orgRefsByName.get(orgName);
    }

    public Collection<ReferenceType> getOrgRefs() throws VCloudException {
        return this.orgRefsByName == null ? this.getOrgReferences().values() : this.orgRefsByName.values();
    }

    private HashMap<String, ReferenceType> getOrgReferences() throws VCloudException {
        String orgListUrl = this.getVcloudApiURL() + "/org/";
        logger.info(orgListUrl);
        OrgListType orgListType_v1_5 = (OrgListType)SdkUtil.get(this, orgListUrl, 200);
        this.orgRefsByName = new HashMap();
        if (orgListType_v1_5 == null || orgListType_v1_5.getOrg().size() == 0) {
            logger.warn(SdkUtil.getI18nString(SdkMessage.ORGS_EMPTY_INFO_MSG));
        }
        for (ReferenceType refType : orgListType_v1_5.getOrg()) {
            this.orgRefsByName.put(refType.getName(), refType);
        }
        return this.orgRefsByName;
    }

    public String getVcloudApiURL() {
        return this.vCloudApiURL;
    }

    void setVCloudApiURL(String cloudApiURL) {
        this.vCloudApiURL = cloudApiURL;
    }

    HttpClient getClient() {
        return this.client;
    }

    public VcloudAdmin getVcloudAdmin() throws VCloudException {
        return new VcloudAdmin(this);
    }

    public VcloudAdminExtension getVcloudAdminExtension() throws VCloudException {
        return new VcloudAdminExtension(this);
    }

    public static void setLogLevel(Level level) {
        if (level.getName() == "FINEST ") {
            LogManager.getRootLogger().setLevel(org.apache.log4j.Level.TRACE);
        }
        if (level.getName() == "FINER" || level.getName() == "FINE") {
            LogManager.getRootLogger().setLevel(org.apache.log4j.Level.DEBUG);
        }
        if (level.getName() == "INFO") {
            LogManager.getRootLogger().setLevel(org.apache.log4j.Level.INFO);
        }
        if (level.getName() == "WARNING") {
            LogManager.getRootLogger().setLevel(org.apache.log4j.Level.WARN);
        }
        if (level.getName() == "SEVERE") {
            LogManager.getRootLogger().setLevel(org.apache.log4j.Level.ERROR);
        }
        if (level.getName() == "OFF") {
            LogManager.getRootLogger().setLevel(org.apache.log4j.Level.OFF);
        }
        if (level.getName() == "ALL") {
            LogManager.getRootLogger().setLevel(org.apache.log4j.Level.ALL);
        }
    }

    public void registerScheme(String name, Integer port, SSLSocketFactory factory) {
        Scheme scheme = new Scheme(name, port.intValue(), (SchemeSocketFactory)factory);
        ((ThreadSafeClientConnManager)this.client.getConnectionManager()).getSchemeRegistry().register(scheme);
    }

    public QueryService getQueryService() {
        return new QueryService(this);
    }

    public String getUserName() {
        return this.userName;
    }

    private void setUserName(String userName) {
        this.userName = userName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    private void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Boolean extendSession() {
        try {
            SdkUtil.get(this, this.getVcloudApiURL() + "/session", 200);
            logger.info(this.getVcloudApiURL() + "/session");
        }
        catch (VCloudException e) {
            logger.info(SdkUtil.getI18nString(SdkMessage.SESSION_EXTENSION_FAILED));
            return false;
        }
        return true;
    }

    public HashMap<String, OperatingSystemFamilyInfoType> getOperatingSystemFamiliesByName() throws VCloudException {
        HashMap<String, OperatingSystemFamilyInfoType> osFamilyInfos = new HashMap<String, OperatingSystemFamilyInfoType>();
        SupportedOperatingSystemsInfoType supportedOperatingSystems = (SupportedOperatingSystemsInfoType)SdkUtil.get(this, this.getVcloudApiURL() + "/supportedSystemsInfo", 200);
        for (OperatingSystemFamilyInfoType osFamilyInfo : supportedOperatingSystems.getOperatingSystemFamilyInfo()) {
            osFamilyInfos.put(osFamilyInfo.getName(), osFamilyInfo);
        }
        return osFamilyInfos;
    }

    public HashMap<String, OperatingSystemInfoType> getOperatingSystemsByName() throws VCloudException {
        HashMap<String, OperatingSystemInfoType> osInfos = new HashMap<String, OperatingSystemInfoType>();
        SupportedOperatingSystemsInfoType supportedOses = (SupportedOperatingSystemsInfoType)SdkUtil.get(this, this.getVcloudApiURL() + "/supportedSystemsInfo", 200);
        for (OperatingSystemFamilyInfoType osFamilyInfo : supportedOses.getOperatingSystemFamilyInfo()) {
            for (OperatingSystemInfoType os : osFamilyInfo.getOperatingSystem()) {
                osInfos.put(os.getName(), os);
            }
        }
        return osInfos;
    }

    public ReferenceResult getServiceRefs() throws VCloudException {
        String query = this.getVcloudApiURL() + "/service" + "?" + this.getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.getQueryService().executeQuery(query);
    }

    public RecordResult<QueryResultFileDescriptorRecordType> getFileDescriptorRecords() throws VCloudException {
        String query = this.getVcloudApiURL() + "/files" + "?" + this.getQueryService().buildQuery(FormatType.RECORD_VIEW);
        return (RecordResult)this.getQueryService().executeQuery(query);
    }

    public InputStream getSchemaDefinition(String schemaFileName) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_SCHEMA_DEFINITION) + " - " + schemaFileName);
        String url = this.getVcloudApiURL() + "/" + "v1.5" + "/schema/" + schemaFileName;
        return RestUtil.downloadFile(this, url);
    }

    public Collection<ReferenceType> getVdcTemplateRefs() throws VCloudException {
        String url = this.getVcloudApiURL() + "/vdcTemplates";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VdcTemplateListType vdcTemplateListType = (VdcTemplateListType)SdkUtil.get(this, url, 200);
        return vdcTemplateListType.getVdcTemplate();
    }

    static {
        SUPPORTED_SDK_VERSIONS.put(Version.V1_5, "application/*+xml;version=1.5");
        SUPPORTED_SDK_VERSIONS.put(Version.V5_1, "application/*+xml;version=5.1");
        SUPPORTED_SDK_VERSIONS.put(Version.V5_5, "application/*+xml;version=5.5");
        SUPPORTED_SDK_VERSIONS.put(Version.V5_6, "application/*+xml;version=5.6");
        SUPPORTED_SDK_VERSIONS.put(Version.V5_7, "application/*+xml;version=5.7");
        SUPPORTED_SDK_VERSIONS.put(Version.V9_0, "application/*+xml;version=9.0");
        SUPPORTED_SDK_VERSIONS.put(Version.V20_0, "application/*+xml;version=20.0");
    }
}

