/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.AdminVdcStorageProfileType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminVdcStorageProfile
extends VcloudEntity<AdminVdcStorageProfileType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType adminVdcReference;

    AdminVdcStorageProfile(VcloudClient client, AdminVdcStorageProfileType adminVdcStorageProfileType) {
        super(client, adminVdcStorageProfileType);
        this.sortAdminVdcStorageProfileReferences();
    }

    public static AdminVdcStorageProfile getAdminVdcStorageProfileByReference(VcloudClient client, ReferenceType adminVdcStorageProfileRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + adminVdcStorageProfileRef.getHref());
        return new AdminVdcStorageProfile(client, (AdminVdcStorageProfileType)AdminVdcStorageProfile.getResourceByReference(client, adminVdcStorageProfileRef));
    }

    private void sortAdminVdcStorageProfileReferences() {
        for (LinkType storageProfileLink : ((AdminVdcStorageProfileType)this.getResource()).getLink()) {
            if (!storageProfileLink.getRel().equals("up") || !storageProfileLink.getType().equals("application/vnd.vmware.admin.vdc+xml")) continue;
            this.adminVdcReference = storageProfileLink;
        }
    }

    public ReferenceType getAdminVdcReference() throws VCloudException {
        if (this.adminVdcReference != null) {
            return this.adminVdcReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public AdminVdcStorageProfile updateAdminVdcStorageProfile(AdminVdcStorageProfileType adminVdcStorageProfileResource) throws VCloudException {
        String requestString = JAXBUtil.marshal(new ObjectFactory().createAdminVdcStorageProfile(adminVdcStorageProfileResource));
        return new AdminVdcStorageProfile(this.getVcloudClient(), (AdminVdcStorageProfileType)SdkUtil.put(this.getVcloudClient(), this.getReference().getHref(), requestString, "application/vnd.vmware.admin.vdcStorageProfile+xml", 200));
    }
}

