/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ProviderVdcType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.SelectorExtensionType;
import com.vmware.vcloud.api.rest.schema.SelectorExtensionsType;
import com.vmware.vcloud.api.rest.schema.VdcReferencesType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderVdc
extends VcloudEntity<ProviderVdcType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private VcloudClient client;
    private HashMap<String, ReferenceType> externalNetworkRefsByName;
    private HashMap<String, ReferenceType> networkPoolRefsByName;

    ProviderVdc(VcloudClient client, ProviderVdcType providerVdcType_v1_5) {
        super(client, providerVdcType_v1_5);
        this.sortRefs_v1_5();
        this.client = client;
    }

    public static ProviderVdc getProviderVdcByReference(VcloudClient client, ReferenceType providerVdcRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + providerVdcRef.getHref());
        return new ProviderVdc(client, (ProviderVdcType)ProviderVdc.getResourceByReference(client, providerVdcRef));
    }

    public static ProviderVdc getProviderVdcById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new ProviderVdc(client, (ProviderVdcType)ProviderVdc.getEntityById(client, vCloudId, "application/vnd.vmware.admin.providervdc+xml"));
    }

    private void sortRefs_v1_5() {
        this.externalNetworkRefsByName = new HashMap();
        this.networkPoolRefsByName = new HashMap();
        if (((ProviderVdcType)this.getResource()).getAvailableNetworks() != null) {
            for (ReferenceType externalNetworkRef : ((ProviderVdcType)this.getResource()).getAvailableNetworks().getNetwork()) {
                this.externalNetworkRefsByName.put(externalNetworkRef.getName(), externalNetworkRef);
            }
        }
        if (((ProviderVdcType)this.getResource()).getNetworkPoolReferences() != null) {
            for (ReferenceType networkPoolRef : ((ProviderVdcType)this.getResource()).getNetworkPoolReferences().getNetworkPoolReference()) {
                this.networkPoolRefsByName.put(networkPoolRef.getName(), networkPoolRef);
            }
        }
    }

    public static HashMap<String, ReferenceType> getAdminVdcRefsByName(VcloudClient client, ReferenceType vmwProviderVdcRef) throws VCloudException {
        String url = vmwProviderVdcRef.getHref() + "/vdcReferences";
        return ProviderVdc.getAdminVdcRefs(client, url);
    }

    public HashMap<String, ReferenceType> getAdminVdcRefsByName() throws VCloudException {
        String url = this.getReference().getHref() + "/vdcReferences";
        return ProviderVdc.getAdminVdcRefs(this.getVcloudClient(), url);
    }

    private static HashMap<String, ReferenceType> getAdminVdcRefs(VcloudClient client, String url) throws VCloudException {
        HashMap<String, ReferenceType> adminVdcRefs = new HashMap<String, ReferenceType>();
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VdcReferencesType vdcReferencesType = (VdcReferencesType)SdkUtil.get(client, url, 200);
        for (ReferenceType vdcReference : vdcReferencesType.getVdcReference()) {
            adminVdcRefs.put(vdcReference.getName(), vdcReference);
        }
        return adminVdcRefs;
    }

    public HashMap<String, ReferenceType> getExternalNetworkRefsByName() {
        return this.externalNetworkRefsByName;
    }

    public Collection<ReferenceType> getExternalNetworkRefs() {
        return this.externalNetworkRefsByName.values();
    }

    public ReferenceType getExternalNetworkRefByName(String externalNetworkName) {
        return this.externalNetworkRefsByName.get(externalNetworkName);
    }

    public HashMap<String, ReferenceType> getVMWNetworkPoolRefsByName() {
        return this.networkPoolRefsByName;
    }

    public Collection<ReferenceType> getVMWNetworkPoolRefs() {
        return this.networkPoolRefsByName.values();
    }

    public ReferenceType getVMWNetworkPoolRefByName(String networkPoolName) {
        return this.networkPoolRefsByName.get(networkPoolName);
    }

    public List<ReferenceType> getProviderVdcStorageProfileRefs() throws VCloudException {
        if (((ProviderVdcType)this.getResource()).getStorageProfiles() == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return ((ProviderVdcType)this.getResource()).getStorageProfiles().getProviderVdcStorageProfile();
    }

    public SelectorExtensionType createProviderVdcSelectorExtension(SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = ((ProviderVdcType)this.getResource()).getHref() + "/extension";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.post(this.client, url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 201);
    }

    public List<SelectorExtensionType> getProviderVdcSelectorExtension() throws VCloudException {
        String url = ((ProviderVdcType)this.getResource()).getHref() + "/extension";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        SelectorExtensionsType objectExtension = (SelectorExtensionsType)SdkUtil.get(this.client, url, 200);
        return objectExtension.getSelectorExtension();
    }

    public SelectorExtensionType getProviderVdcSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = ((ProviderVdcType)this.getResource()).getHref() + "/extension" + "/" + selectorExtensionId;
        return (SelectorExtensionType)SdkUtil.get(this.client, url, 200);
    }

    public SelectorExtensionType updateProviderVdcSelectorExtensionById(String selectorExtensionId, SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = ((ProviderVdcType)this.getResource()).getHref() + "/extension" + "/" + selectorExtensionId;
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.put(this.client, url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 200);
    }

    public void deleteProviderVdcSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = ((ProviderVdcType)this.getResource()).getHref() + "/extension" + "/" + selectorExtensionId;
        SdkUtil.delete(this.client, url, 204);
    }
}

