/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.GroupsListType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.ReferencesType;
import com.vmware.vcloud.api.rest.schema.UserType;
import com.vmware.vcloud.api.rest.schema.extension.EntityReferencesType;
import com.vmware.vcloud.api.rest.schema.extension.EntityRightsType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.UserEntityRightsType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class User
extends VcloudEntity<UserType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private HashMap<String, ReferenceType> groupRefsByName;

    User(VcloudClient client, UserType userType_v1_5) {
        super(client, userType_v1_5);
        this.sortReferences_v1_5();
    }

    private void sortReferences_v1_5() {
        this.groupRefsByName = new HashMap();
        GroupsListType groupList = ((UserType)this.getResource()).getGroupReferences();
        if (groupList != null) {
            for (ReferenceType groupRef : groupList.getGroupReference()) {
                this.groupRefsByName.put(groupRef.getName(), groupRef);
            }
        }
    }

    public static User getUserByReference(VcloudClient client, ReferenceType userRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + userRef.getHref());
        return new User(client, (UserType)User.getResourceByReference(client, userRef));
    }

    public static User getUserById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new User(client, (UserType)User.getEntityById(client, vCloudId, "application/vnd.vmware.admin.user+xml"));
    }

    public User updateUser(UserType userType) throws VCloudException {
        com.vmware.vcloud.api.rest.schema.ObjectFactory of = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String userUpdateUrl = this.getReference().getHref();
        String userUpdateRequestXmlString = JAXBUtil.marshal(of.createUser(userType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + userUpdateUrl);
        return new User(this.getVcloudClient(), (UserType)SdkUtil.put(this.getVcloudClient(), userUpdateUrl, userUpdateRequestXmlString, "application/vnd.vmware.admin.user+xml", 200));
    }

    public void delete() throws VCloudException {
        String userUrl = this.getReference().getHref();
        User.deleteUser(this.getVcloudClient(), userUrl);
    }

    public static void delete(VcloudClient client, ReferenceType userRef) throws VCloudException {
        User.deleteUser(client, userRef.getHref());
    }

    private static void deleteUser(VcloudClient client, String userUrl) throws VCloudException {
        SdkUtil.delete(client, userUrl, 204);
    }

    public void unlock() throws VCloudException {
        SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/unlock", null, null, 204);
    }

    public static void unlock(VcloudClient client, ReferenceType userRef) throws VCloudException {
        SdkUtil.post(client, userRef.getHref() + "/action/unlock", null, null, 204);
    }

    public ReferenceType getRoleReference() throws VCloudException {
        if (((UserType)this.getResource()).getRole() != null) {
            return ((UserType)this.getResource()).getRole();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public HashMap<String, ReferenceType> getGroupRefsByName() {
        return this.groupRefsByName;
    }

    public ReferenceType getGroupRefByName(String groupName) {
        return this.groupRefsByName.get(groupName);
    }

    public Collection<ReferenceType> getGroupRefs() {
        return this.groupRefsByName.values();
    }

    public List<EntityRightsType> getEntityRights(List<ReferenceType> entityRefs) throws VCloudException {
        EntityReferencesType entityRefsType = new EntityReferencesType();
        List jaxbEntityRefs = entityRefsType.getReference();
        for (ReferenceType entityRef : entityRefs) {
            jaxbEntityRefs.add(new com.vmware.vcloud.api.rest.schema.ObjectFactory().createReference(entityRef));
        }
        String requestString = JAXBUtil.marshal(new ObjectFactory().createEntityReferences(entityRefsType));
        UserEntityRightsType userEntityRightsType = (UserEntityRightsType)SdkUtil.post(this.getVcloudClient(), ((UserType)this.getResource()).getHref() + "/entityRights", requestString, "application/vnd.vmware.admin.entityReferences+xml", 200);
        return userEntityRightsType.getEntityRights();
    }

    public List<ReferenceType> getGrantedRights() throws VCloudException {
        ReferencesType grantedRights = (ReferencesType)SdkUtil.get(this.getVcloudClient(), ((UserType)this.getResource()).getHref() + "/grantedRights", 200);
        ArrayList<ReferenceType> grantedRightReferences = new ArrayList<ReferenceType>();
        for (JAXBElement grantedRight : grantedRights.getReference()) {
            grantedRightReferences.add((ReferenceType)grantedRight.getValue());
        }
        return grantedRightReferences;
    }

    public void takeOwnership() throws VCloudException {
        SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/takeOwnership", null, null, 204);
    }

    public static void takeOwnership(VcloudClient client, ReferenceType userRef) throws VCloudException {
        SdkUtil.post(client, userRef.getHref() + "/action/takeOwnership", null, null, 204);
    }
}

