/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions.service;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.ResourceClassActionType;
import com.vmware.vcloud.api.rest.schema.extension.ResourceClassType;
import com.vmware.vcloud.api.rest.schema.extension.ServiceResourceType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.ReferenceResult;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.admin.extensions.service.AdminResourceClassAction;
import com.vmware.vcloud.sdk.admin.extensions.service.AdminServiceResource;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.query.FormatType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminResourceClass
extends VcloudEntity<ResourceClassType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType adminServiceRef;

    AdminResourceClass(VcloudClient client, ResourceClassType resourceClassParams) {
        super(client, resourceClassParams);
        this.sortAdminResourceClassLinkRefs();
    }

    private void sortAdminResourceClassLinkRefs() {
        if (this.getResource() != null) {
            for (LinkType link : ((ResourceClassType)this.getResource()).getLink()) {
                if (!link.getRel().equals("up") || !link.getType().equals("application/vnd.vmware.admin.service+xml")) continue;
                this.adminServiceRef = link;
            }
        }
    }

    public static AdminResourceClass getAdminResourceClassByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new AdminResourceClass(client, (ResourceClassType)AdminResourceClass.getResourceByReference(client, reference));
    }

    public static AdminResourceClass getAdminResourceClassById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new AdminResourceClass(client, (ResourceClassType)AdminResourceClass.getEntityById(client, vCloudId, "application/vnd.vmware.admin.resourceClass+xml"));
    }

    public void delete() throws VCloudException {
        SdkUtil.delete(this.getVcloudClient(), this.getReference().getHref(), 204);
    }

    public ReferenceType getAdminServiceReference() throws VCloudException {
        if (this.adminServiceRef != null) {
            return this.adminServiceRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public AdminResourceClassAction registerAdminResourceClassAction(ResourceClassActionType resourceClasaActionParams) throws VCloudException {
        String requestXML = JAXBUtil.marshal(new ObjectFactory().createResourceClassAction(resourceClasaActionParams));
        return new AdminResourceClassAction(this.getVcloudClient(), (ResourceClassActionType)SdkUtil.post(this.getVcloudClient(), ((ResourceClassType)this.getResource()).getHref() + "/resourceclassactions", requestXML, "application/vnd.vmware.admin.resourceClassAction+xml", 201));
    }

    public AdminResourceClassAction registerResourceClassAction(String actionName, String actionHttpMethod, String actionURLPattern, String actionOperationKey) throws VCloudException {
        ResourceClassActionType actionParams = new ResourceClassActionType();
        actionParams.setName(actionName);
        actionParams.setHttpMethod(actionHttpMethod);
        actionParams.setUrlPattern(actionURLPattern);
        actionParams.setOperationKey(actionOperationKey);
        return this.registerAdminResourceClassAction(actionParams);
    }

    public ReferenceResult getAdminResourceClassActionRefs() throws VCloudException {
        String query = this.getReference().getHref() + "/resourceclassactions" + "?" + this.getVcloudClient().getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.getVcloudClient().getQueryService().executeQuery(query);
    }

    public AdminServiceResource registerAdminServiceResource(ServiceResourceType serviceResParams) throws VCloudException {
        String requestXML = JAXBUtil.marshal(new ObjectFactory().createServiceResource(serviceResParams));
        return new AdminServiceResource(this.getVcloudClient(), (ServiceResourceType)SdkUtil.post(this.getVcloudClient(), ((ResourceClassType)this.getResource()).getHref() + "/serviceresources", requestXML, "application/vnd.vmware.admin.serviceResource+xml", 201));
    }

    public ReferenceResult getAdminServiceResourceRefs() throws VCloudException {
        String query = this.getReference().getHref() + "/serviceresources" + "?" + this.getVcloudClient().getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.getVcloudClient().getQueryService().executeQuery(query);
    }
}

