/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions.service;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.extension.AclAccessType;
import com.vmware.vcloud.api.rest.schema.extension.AclRuleType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.ResourceClassActionType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.ReferenceResult;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.admin.extensions.service.AdminAclRule;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.query.FormatType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminResourceClassAction
extends VcloudEntity<ResourceClassActionType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType adminResourceClassRef;

    public AdminResourceClassAction(VcloudClient client, ResourceClassActionType resourceClassActionParams) {
        super(client, resourceClassActionParams);
        this.sortAdminResourceClassActionLinkRefs();
    }

    private void sortAdminResourceClassActionLinkRefs() {
        if (this.getResource() != null) {
            for (LinkType link : ((ResourceClassActionType)this.getResource()).getLink()) {
                if (!link.getRel().equals("up") || !link.getType().equals("application/vnd.vmware.admin.resourceClass+xml")) continue;
                this.adminResourceClassRef = link;
            }
        }
    }

    public static AdminResourceClassAction getAdminResourceClassActionByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new AdminResourceClassAction(client, (ResourceClassActionType)AdminResourceClassAction.getResourceByReference(client, reference));
    }

    public static AdminResourceClassAction getAdminResourceClassActionById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new AdminResourceClassAction(client, (ResourceClassActionType)AdminResourceClassAction.getEntityById(client, vCloudId, "application/vnd.vmware.admin.resourceClassAction+xml"));
    }

    public void delete() throws VCloudException {
        SdkUtil.delete(this.getVcloudClient(), this.getReference().getHref(), 204);
    }

    public ReferenceType getAdminResourceClassReference() throws VCloudException {
        if (this.adminResourceClassRef != null) {
            return this.adminResourceClassRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public AdminAclRule registerAdminAclRule(AclRuleType aclRuleParams) throws VCloudException {
        String requestXML = JAXBUtil.marshal(new ObjectFactory().createAclRule(aclRuleParams));
        return new AdminAclRule(this.getVcloudClient(), (AclRuleType)SdkUtil.post(this.getVcloudClient(), ((ResourceClassActionType)this.getResource()).getHref() + "/aclrules", requestXML, "application/vnd.vmware.admin.aclRule+xml", 201));
    }

    public AdminAclRule registerACLRule(String ruleName, AclAccessType serviceAclAccess, AclAccessType orgAccess, AclAccessType principalAccess) throws VCloudException {
        AclRuleType ruleParams = new AclRuleType();
        ruleParams.setName(ruleName);
        ruleParams.setServiceResourceAccess(serviceAclAccess);
        ruleParams.setOrganizationAccess(orgAccess);
        ruleParams.setPrincipalAccess(principalAccess);
        return this.registerAdminAclRule(ruleParams);
    }

    public ReferenceResult getAdminAclRuleRefs() throws VCloudException {
        String query = this.getReference().getHref() + "/aclrules" + "?" + this.getVcloudClient().getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.getVcloudClient().getQueryService().executeQuery(query);
    }
}

