/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimer;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimerQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ADManager {
    private static final Log Trace = LogFactory.getLog(ADManager.class);
    private long lastTransportAcked = 0L;
    private long lastMessageIdSent = 0L;
    private long lastMessageIdAcked = 0L;
    protected JCSMPTimer _ackTimer;
    protected Object _ackTimerLock = new Object();
    protected JCSMPTimerQueue _timerQueue = null;
    protected final ContextImpl context;
    private boolean _isInit = false;

    protected ADManager(ContextImpl context) {
        this._timerQueue = context.getIOReactor();
        this.context = context;
    }

    protected void reInit() {
        this._isInit = true;
    }

    public abstract void startADTimer();

    public long getLastTransportAcked() {
        return this.lastTransportAcked;
    }

    public void setLastTransportAcked(long id) {
        this.lastTransportAcked = id;
        if (this.lastMessageIdAcked > this.lastTransportAcked) {
            this.lastTransportAcked = this.lastMessageIdAcked;
        }
    }

    public long getLastMessageIdSent() {
        return this.lastMessageIdSent;
    }

    public void setLastMessageIdSent(long id) {
        this.lastMessageIdSent = id;
    }

    public long getLastMessageIdAcked() {
        return this.lastMessageIdAcked;
    }

    public void setLastMessageIdAcked(long id) {
        this.lastMessageIdAcked = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearADTimer() {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Clear AD timer");
        }
        Object object = this._ackTimerLock;
        synchronized (object) {
            if (this._ackTimer != null) {
                this._timerQueue.cancelTimer(this._ackTimer);
            }
        }
    }

    public abstract String toString();

    protected boolean isInitialized() {
        return this._isInit;
    }

    protected void validateIsInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(JCSMPRB.BUNDLE.getStringSafely("ADManager.notInitialized"));
        }
    }
}

