/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solacesystems.jcsmp.impl.BufferCloningPool;
import com.solacesystems.jcsmp.impl.BufferCloningUser;
import com.solacesystems.jcsmp.impl.ContentBuffer;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;

public class FastSmfParamContainer
implements BufferCloningUser {
    private int encodedParamsLen = 0;
    private ContentBuffer enc_cb;
    private byte[] encodedParams2;

    public FastSmfParamContainer() {
        this.enc_cb = new ContentBuffer(4096, false);
        this.encodedParams2 = this.enc_cb.getByteBufferRefInternal().array();
    }

    public FastSmfParamContainer(FastSmfParamContainer toclone, BufferCloningPool contentBufCloning) {
        this.enc_cb = contentBufCloning != null ? contentBufCloning.acquireCopy(toclone.enc_cb) : new ContentBuffer(toclone.enc_cb);
        this.encodedParams2 = this.enc_cb.getByteBufferRefInternal().array();
        this.encodedParamsLen = toclone.encodedParamsLen;
    }

    public void reset() {
        this.encodedParamsLen = 0;
    }

    public byte[] getBuffer() {
        return this.encodedParams2;
    }

    public ContentBuffer getContentBufferRefInternal() {
        return this.enc_cb;
    }

    public int getOffset() {
        return this.encodedParamsLen;
    }

    public void incrementOffset(int i) {
        this.encodedParamsLen += i;
    }

    public void addParam(int uh, int type, byte[] value) {
        int b = TlvCoderUtil.writeTlvParam(this.encodedParams2, this.encodedParamsLen, uh, type, value);
        this.encodedParamsLen += b;
    }

    public void addParamAssuredCtrl(int uh, int type, byte[] value) {
        int b = TlvCoderUtil.writeTlvParamAssuredCtrl(this.encodedParams2, this.encodedParamsLen, uh, type, value);
        this.encodedParamsLen += b;
    }

    public void addEncodedParam(byte[] encodedParam) {
        System.arraycopy(encodedParam, 0, this.encodedParams2, this.encodedParamsLen, encodedParam.length);
        this.encodedParamsLen += encodedParam.length;
    }

    public int getEncodedParamsLen() {
        return this.encodedParamsLen;
    }

    public int getEncodedParams(byte[] paramData) {
        return 0;
    }

    @Override
    public void releaseContentBuffer(BufferCloningPool bufCloningPool) {
        bufCloningPool.release(this.enc_cb);
    }
}

