/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.smf.ClientCtrlTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.SmfExtendedStreamTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.SmfExtendedTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.GrowableByteBuffer;
import com.solacesystems.jcsmp.protocol.smf.impl.NetworkIOUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFNumericConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class TlvCoderUtil
implements SMFNumericConstants {
    private static final String STR_INVALID_LEN = "Parsed invalid length ";

    public static int readTlvParam(InputStream in, int bytesRead, int hdrLenBytes, HeaderDescriptionBean h, boolean[] known_params) throws IOException {
        byte[] onebyte = new byte[1];
        byte[] fourbyte = new byte[4];
        NetworkIOUtil.readDataSafely(in, onebyte, 0, 1);
        ++bytesRead;
        long oneByteLong = NetworkByteOrderNumberUtil.oneByteToUInt(onebyte[0]);
        int uh = (int)BitTwiddleUtil.extractBits(oneByteLong, 2L, 6L);
        int type = (int)BitTwiddleUtil.extractBits(oneByteLong, 6L, 0L);
        int typeEnum = 0 | type;
        if (typeEnum == 0) {
            int bytesToEnd = hdrLenBytes - bytesRead;
            assert (bytesToEnd < 4);
            NetworkIOUtil.skipDataSafely(in, bytesToEnd);
            bytesRead += bytesToEnd;
        } else {
            byte[] value;
            NetworkIOUtil.readDataSafely(in, onebyte, 0, 1);
            ++bytesRead;
            oneByteLong = NetworkByteOrderNumberUtil.oneByteToUInt(onebyte[0]);
            int length = (int)BitTwiddleUtil.extractBits(oneByteLong, 8L, 0L);
            if (length > 0) {
                if (length < 2 || length > 255) {
                    throw new IOException(STR_INVALID_LEN + length);
                }
                value = new byte[length - 2];
                NetworkIOUtil.readDataSafely(in, value, 0, value.length);
            } else {
                NetworkIOUtil.readDataSafely(in, fourbyte, 0, 4);
                length = (int)NetworkByteOrderNumberUtil.fourByteToUInt(fourbyte);
                bytesRead += 4;
                if (length < 6) {
                    throw new IOException(STR_INVALID_LEN + length);
                }
                value = new byte[length - 6];
                NetworkIOUtil.readDataSafely(in, value, 0, value.length);
            }
            bytesRead += value.length;
            if (TlvCoderUtil.isUnknownParam(typeEnum, known_params)) {
                h.setParamAction(uh);
                h.setUnkParamFlag(true);
            } else {
                SmfTLVParameter smf_p = new SmfTLVParameter(uh, typeEnum, value);
                h.addParam(smf_p);
            }
        }
        return bytesRead;
    }

    public static int readClientCtrlTlvParam(InputStream in, int bytesRead, int hdrLenBytes, HeaderDescriptionBean h, boolean[] known_params) throws IOException {
        byte[] fivebytes = new byte[5];
        NetworkIOUtil.readDataSafely(in, fivebytes, 0, 5);
        bytesRead += 5;
        long onebyteLong = NetworkByteOrderNumberUtil.oneByteToUInt(fivebytes[0]);
        int paramlen = (int)NetworkByteOrderNumberUtil.fourByteToUInt(fivebytes, 1);
        int uh = (int)BitTwiddleUtil.extractBits(onebyteLong, 1L, 7L);
        int typeenum = (int)BitTwiddleUtil.extractBits(onebyteLong, 7L, 0L);
        byte[] value = new byte[paramlen -= 5];
        NetworkIOUtil.readDataSafely(in, value, 0, paramlen);
        bytesRead += paramlen;
        if (TlvCoderUtil.isUnknownParam(typeenum, known_params)) {
            h.setParamAction(uh);
            h.setUnkParamFlag(true);
        } else {
            ClientCtrlTLVParameter cl_p = new ClientCtrlTLVParameter(uh, typeenum, value);
            h.addParam(cl_p);
        }
        return bytesRead;
    }

    public static int writeTlvParam(GrowableByteBuffer bufToWriteTo, SmfTLVParameter p) {
        int uh = p.uh;
        long enumtype = p.type;
        byte[] value = p.value;
        if (p instanceof SmfExtendedStreamTLVParameter) {
            SmfExtendedStreamTLVParameter esp = (SmfExtendedStreamTLVParameter)p;
            int bytesWritten = TlvCoderUtil.encodeTL(bufToWriteTo, uh, enumtype, esp.getSmfEncodedValueLength());
            for (SmfExtendedTLVParameter ep : esp.getParameters()) {
                bytesWritten += TlvCoderUtil.encodeTL(bufToWriteTo, ep.uh, ep.preamble, (long)ep.type, ep.value.length);
                bufToWriteTo.put(ep.value);
                bytesWritten += ep.value.length;
            }
            return bytesWritten;
        }
        int bytesWritten = TlvCoderUtil.encodeTL(bufToWriteTo, uh, enumtype, value.length);
        bufToWriteTo.put(value);
        return bytesWritten += value.length;
    }

    public static int writeTlvParamAssuredCtrl(GrowableByteBuffer bufToWriteTo, SmfTLVParameter p) {
        int uh = p.uh;
        long enumtype = p.type;
        byte[] value = p.value;
        int bytesWritten = TlvCoderUtil.encodeTLAssuredCtrl(bufToWriteTo, uh, enumtype, value.length);
        bufToWriteTo.put(value);
        return bytesWritten += value.length;
    }

    public static int writeTlvParam(GrowableByteBuffer bufToWriteTo, int uh, long enumtype, byte[] value) {
        int bytesWritten = TlvCoderUtil.encodeTL(bufToWriteTo, uh, enumtype, value.length);
        bufToWriteTo.put(value);
        return bytesWritten += value.length;
    }

    public static int writeTlvParam(byte[] out, int offset, int uh, long enumtype, byte[] value) {
        int bytesWritten = TlvCoderUtil.encodeTL(out, offset, uh, enumtype, value.length);
        System.arraycopy(value, 0, out, offset + bytesWritten, value.length);
        return bytesWritten += value.length;
    }

    public static int writeTlvParamAssuredCtrl(byte[] out, int offset, int uh, long enumtype, byte[] value) {
        int bytesWritten = TlvCoderUtil.encodeTLAssuredCtrl(out, offset, uh, enumtype, value.length);
        System.arraycopy(value, 0, out, offset + bytesWritten, value.length);
        return bytesWritten += value.length;
    }

    public static int writeTlvParam(ByteBuffer bufToWriteTo, ClientCtrlTLVParameter p) {
        int uh = p.uh;
        long enumtype = p.type;
        byte[] value = p.value;
        int param_len = p.getSmfEncodedLength();
        long byte1 = 0L;
        byte1 = BitTwiddleUtil.setBits(byte1, uh, 1, 7);
        byte1 = BitTwiddleUtil.setBits(byte1, enumtype, 7, 0);
        bufToWriteTo.put(NetworkByteOrderNumberUtil.intToOneByte((int)byte1));
        bufToWriteTo.put(NetworkByteOrderNumberUtil.intToFourByte(param_len));
        bufToWriteTo.put(value);
        return param_len;
    }

    public static int encodeTL(GrowableByteBuffer bufToWriteTo, int uh, long enumtype, int valueLen) {
        long lightweightmask = 32L;
        long byte1 = 0L;
        long byte2 = 0L;
        int bytesWritten = 0;
        if ((enumtype & lightweightmask) != 0L) {
            byte1 = BitTwiddleUtil.setBits(byte1, uh, 2, 6);
            byte1 = BitTwiddleUtil.setBits(byte1, enumtype, 6, 0);
            byte1 = BitTwiddleUtil.setBits(byte1, valueLen - 1 + 1, 2, 0);
            bufToWriteTo.put(NetworkByteOrderNumberUtil.intToOneByte((int)byte1));
            ++bytesWritten;
        } else {
            byte1 = BitTwiddleUtil.setBits(byte1, uh, 2, 6);
            byte1 = BitTwiddleUtil.setBits(byte1, enumtype, 6, 0);
            bufToWriteTo.put(NetworkByteOrderNumberUtil.intToOneByte((int)byte1));
            ++bytesWritten;
            if (valueLen > 253) {
                byte2 = 0L;
                bufToWriteTo.put(NetworkByteOrderNumberUtil.intToOneByte((int)byte2));
                int param_len = 6 + valueLen;
                bufToWriteTo.put(NetworkByteOrderNumberUtil.intToFourByte(param_len));
                bytesWritten += 5;
            } else {
                byte2 = valueLen + 2;
                bufToWriteTo.put(NetworkByteOrderNumberUtil.intToOneByte((int)byte2));
                ++bytesWritten;
            }
        }
        return bytesWritten;
    }

    public static int encodeTL(GrowableByteBuffer bufToWriteTo, int uh, int preamble, long enumtype, int valueLen) {
        long byte1And2 = 0L;
        byte1And2 = BitTwiddleUtil.setBits(byte1And2, uh, 1, 15);
        byte1And2 = BitTwiddleUtil.setBits(byte1And2, preamble, 3, 12);
        byte1And2 = BitTwiddleUtil.setBits(byte1And2, enumtype, 12, 0);
        bufToWriteTo.put(NetworkByteOrderNumberUtil.intToTwoByte((int)byte1And2));
        bufToWriteTo.put(NetworkByteOrderNumberUtil.intToTwoByte(valueLen + 4));
        return 4;
    }

    public static int encodeTLAssuredCtrl(GrowableByteBuffer bufToWriteTo, int uh, long enumtype, int valueLen) {
        long byte1 = 0L;
        long byte2 = 0L;
        int bytesWritten = 0;
        byte1 = BitTwiddleUtil.setBits(byte1, uh, 2, 6);
        byte1 = BitTwiddleUtil.setBits(byte1, enumtype, 6, 0);
        bufToWriteTo.put(NetworkByteOrderNumberUtil.intToOneByte((int)byte1));
        ++bytesWritten;
        if (valueLen > 253) {
            byte2 = 0L;
            bufToWriteTo.put(NetworkByteOrderNumberUtil.intToOneByte((int)byte2));
            int param_len = 6 + valueLen;
            bufToWriteTo.put(NetworkByteOrderNumberUtil.intToFourByte(param_len));
            bytesWritten += 5;
        } else {
            byte2 = valueLen + 2;
            bufToWriteTo.put(NetworkByteOrderNumberUtil.intToOneByte((int)byte2));
            ++bytesWritten;
        }
        return bytesWritten;
    }

    public static int encodeTL(byte[] out, int offset, int uh, long enumtype, int valueLen) {
        long lightweightmask = 32L;
        long byte1 = 0L;
        long byte2 = 0L;
        int bytesWritten = 0;
        if ((enumtype & lightweightmask) != 0L) {
            byte1 = BitTwiddleUtil.setBits(byte1, uh, 2, 6);
            byte1 = BitTwiddleUtil.setBits(byte1, enumtype, 6, 0);
            byte1 = BitTwiddleUtil.setBits(byte1, valueLen - 1 + 1, 2, 0);
            out[offset + bytesWritten] = NetworkByteOrderNumberUtil.intToOneByte((int)byte1);
            ++bytesWritten;
        } else {
            byte1 = BitTwiddleUtil.setBits(byte1, uh, 2, 6);
            byte1 = BitTwiddleUtil.setBits(byte1, enumtype, 6, 0);
            out[offset + bytesWritten] = NetworkByteOrderNumberUtil.intToOneByte((int)byte1);
            ++bytesWritten;
            if (valueLen > 253) {
                byte2 = 0L;
                out[offset + bytesWritten] = NetworkByteOrderNumberUtil.intToOneByte((int)byte2);
                int param_len = 6 + valueLen;
                NetworkByteOrderNumberUtil.intToFourByte(param_len, out, offset + ++bytesWritten);
                bytesWritten += 4;
            } else {
                byte2 = valueLen + 2;
                out[offset + bytesWritten] = NetworkByteOrderNumberUtil.intToOneByte((int)byte2);
                ++bytesWritten;
            }
        }
        return bytesWritten;
    }

    public static int encodeTLAssuredCtrl(byte[] out, int offset, int uh, long enumtype, int valueLen) {
        long byte1 = 0L;
        long byte2 = 0L;
        int bytesWritten = 0;
        byte1 = BitTwiddleUtil.setBits(byte1, uh, 2, 6);
        byte1 = BitTwiddleUtil.setBits(byte1, enumtype, 6, 0);
        out[offset + bytesWritten] = NetworkByteOrderNumberUtil.intToOneByte((int)byte1);
        ++bytesWritten;
        if (valueLen > 253) {
            byte2 = 0L;
            out[offset + bytesWritten] = NetworkByteOrderNumberUtil.intToOneByte((int)byte2);
            int param_len = 6 + valueLen;
            NetworkByteOrderNumberUtil.intToFourByte(param_len, out, offset + ++bytesWritten);
            bytesWritten += 4;
        } else {
            byte2 = valueLen + 2;
            out[offset + bytesWritten] = NetworkByteOrderNumberUtil.intToOneByte((int)byte2);
            ++bytesWritten;
        }
        return bytesWritten;
    }

    private static boolean isUnknownParam(int typeEnum, boolean[] known_params) {
        return !known_params[typeEnum];
    }

    public static byte[] toNullTermAscii(String s) {
        return TlvCoderUtil.toNullTermBinaryEnc(s, "US-ASCII");
    }

    public static byte[] toNullTermUtf8(String s) {
        return TlvCoderUtil.toNullTermBinaryEnc(s, "UTF-8");
    }

    private static byte[] toNullTermBinaryEnc(String s, String charset) {
        byte[] enc_chars = null;
        try {
            enc_chars = s.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            enc_chars = s.getBytes(Charset.defaultCharset());
        }
        byte[] nullterm_enc_chars = new byte[enc_chars.length + 1];
        System.arraycopy(enc_chars, 0, nullterm_enc_chars, 0, enc_chars.length);
        return nullterm_enc_chars;
    }

    public static String nullTermUtf8ToString(byte[] enc) {
        String str = "";
        try {
            str = new String(enc, 0, enc.length - 1, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public static String nullTermAsciiToString(byte[] enc) {
        String str = "";
        try {
            str = new String(enc, 0, enc.length - 1, "ASCII");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public static byte[] truncateNullTermBinaryString(byte[] input, int n) {
        if (input.length <= n) {
            return input;
        }
        byte[] truncString = new byte[n];
        System.arraycopy(input, 0, truncString, 0, truncString.length);
        truncString[n - 1] = 0;
        return truncString;
    }
}

