/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.jdbc.MongoColumnInfo;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonType;
import org.bson.BsonValue;

@AutoLoggable
public abstract class MongoResultSetMetaData
implements ResultSetMetaData,
LoggingAspect$ajcMightHaveAspect {
    protected final int UNKNOWN_LENGTH = 0;
    protected MongoLogger logger;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    public MongoResultSetMetaData(MongoLogger parentLogger, Integer statementId) {
        LoggingAspect.ajc$perObjectBind(this);
        this.UNKNOWN_LENGTH = 0;
        MongoLogger mongoLogger = statementId == null ? new MongoLogger(this.getClass().getCanonicalName(), parentLogger) : new MongoLogger(this.getClass().getCanonicalName(), parentLogger, statementId);
        MongoResultSetMetaData mongoResultSetMetaData = this;
        if (LoggingAspect.hasAspect(this)) {
            MongoResultSetMetaData.logger_aroundBody1$advice(this, mongoResultSetMetaData, mongoLogger, LoggingAspect.aspectOf(this), mongoLogger, null);
        } else {
            mongoResultSetMetaData.logger = mongoLogger;
        }
    }

    protected void checkBounds(int i) throws SQLException {
        try {
            if (i > this.getColumnCount()) {
                throw new SQLException("Index out of bounds: '" + i + "'.");
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            this.checkBounds(column);
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_2, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            this.checkBounds(column);
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            this.checkBounds(column);
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_4, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            this.checkBounds(column);
            return "";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    public abstract MongoColumnInfo getColumnInfo(int var1) throws SQLException;

    public abstract boolean hasColumnWithLabel(String var1) throws SQLException;

    public abstract int getColumnPositionFromLabel(String var1) throws SQLException;

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_5, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            this.checkBounds(column);
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_6, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            this.checkBounds(column);
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_7, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            this.checkBounds(column);
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    @Override
    public int isNullable(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_8, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return this.getColumnInfo(column).getNullability();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_9, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return this.getColumnInfo(column).getColumnAlias();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_10, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return this.getColumnInfo(column).getColumnName();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    @Override
    public String getTableName(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_11, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return this.getColumnInfo(column).getTableAlias();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_11);
            }
            throw exception;
        }
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_12, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return this.getColumnInfo(column).getDatabase();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_12);
            }
            throw exception;
        }
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_13, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return this.getColumnInfo(column).getJDBCType();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_13);
            }
            throw exception;
        }
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_14, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return this.getColumnInfo(column).getBsonTypeName();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_14);
            }
            throw exception;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Class<?> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_15, (Object)this, (Object)this, clazz));
            }
            return iface.isInstance(this);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_15);
            }
            throw exception;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Class<T> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_16, (Object)this, (Object)this, clazz));
            }
            return (T)this;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_16);
            }
            throw exception;
        }
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        int n = column;
        try {
            MongoColumnInfo ci;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_17, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            if ((ci = this.getColumnInfo(column)).isPolymorphic()) {
                return true;
            }
            BsonType t = ci.getBsonTypeEnum();
            switch (t) {
                case DOUBLE: 
                case DOCUMENT: 
                case ARRAY: 
                case BINARY: 
                case UNDEFINED: 
                case OBJECT_ID: 
                case BOOLEAN: 
                case DATE_TIME: 
                case NULL: 
                case DB_POINTER: 
                case INT32: 
                case TIMESTAMP: 
                case INT64: 
                case DECIMAL128: 
                case MIN_KEY: 
                case MAX_KEY: {
                    return false;
                }
                case STRING: 
                case REGULAR_EXPRESSION: 
                case JAVASCRIPT: 
                case SYMBOL: 
                case JAVASCRIPT_WITH_SCOPE: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_17);
            }
            throw exception;
        }
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        int n = column;
        try {
            MongoColumnInfo ci;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_18, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            if ((ci = this.getColumnInfo(column)).isPolymorphic()) {
                return true;
            }
            BsonType t = ci.getBsonTypeEnum();
            switch (t) {
                case DOUBLE: 
                case INT32: 
                case INT64: 
                case DECIMAL128: {
                    return true;
                }
                case STRING: 
                case DOCUMENT: 
                case ARRAY: 
                case BINARY: 
                case UNDEFINED: 
                case OBJECT_ID: 
                case BOOLEAN: 
                case DATE_TIME: 
                case NULL: 
                case REGULAR_EXPRESSION: 
                case DB_POINTER: 
                case JAVASCRIPT: 
                case SYMBOL: 
                case JAVASCRIPT_WITH_SCOPE: 
                case TIMESTAMP: 
                case MIN_KEY: 
                case MAX_KEY: {
                    return false;
                }
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_18);
            }
            throw exception;
        }
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int n = column;
        try {
            MongoColumnInfo ci;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_19, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            if ((ci = this.getColumnInfo(column)).isPolymorphic()) {
                return 0;
            }
            BsonType t = ci.getBsonTypeEnum();
            switch (t) {
                case ARRAY: {
                    return 0;
                }
                case BINARY: {
                    return 0;
                }
                case BOOLEAN: {
                    return 1;
                }
                case DATE_TIME: {
                    return 24;
                }
                case DB_POINTER: {
                    return 0;
                }
                case DECIMAL128: {
                    return 34;
                }
                case DOCUMENT: {
                    return 0;
                }
                case DOUBLE: {
                    return 15;
                }
                case INT32: {
                    return 10;
                }
                case INT64: {
                    return 19;
                }
                case JAVASCRIPT: {
                    return 0;
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return 0;
                }
                case MAX_KEY: {
                    return 0;
                }
                case MIN_KEY: {
                    return 0;
                }
                case NULL: {
                    return 0;
                }
                case OBJECT_ID: {
                    return 24;
                }
                case REGULAR_EXPRESSION: {
                    return 0;
                }
                case STRING: {
                    return 0;
                }
                case SYMBOL: {
                    return 0;
                }
                case TIMESTAMP: {
                    return 0;
                }
                case UNDEFINED: {
                    return 0;
                }
            }
            throw new SQLException("unknown bson type: " + (Object)((Object)t));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_19);
            }
            throw exception;
        }
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        int n = column;
        try {
            MongoColumnInfo ci;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_20, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            if ((ci = this.getColumnInfo(column)).isPolymorphic()) {
                return 0;
            }
            BsonType t = ci.getBsonTypeEnum();
            switch (t) {
                case ARRAY: {
                    return 0;
                }
                case BINARY: {
                    return 0;
                }
                case BOOLEAN: {
                    return 1;
                }
                case DATE_TIME: {
                    return 24;
                }
                case DB_POINTER: {
                    return 0;
                }
                case DECIMAL128: {
                    return 34;
                }
                case DOCUMENT: {
                    return 0;
                }
                case DOUBLE: {
                    return 15;
                }
                case INT32: {
                    return 10;
                }
                case INT64: {
                    return 19;
                }
                case JAVASCRIPT: {
                    return 0;
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return 0;
                }
                case MAX_KEY: {
                    return 0;
                }
                case MIN_KEY: {
                    return 0;
                }
                case NULL: {
                    return 0;
                }
                case OBJECT_ID: {
                    return 24;
                }
                case REGULAR_EXPRESSION: {
                    return 0;
                }
                case STRING: {
                    return 0;
                }
                case SYMBOL: {
                    return 0;
                }
                case TIMESTAMP: {
                    return 0;
                }
                case UNDEFINED: {
                    return 0;
                }
            }
            throw new SQLException("unknown bson type: " + (Object)((Object)t));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_20);
            }
            throw exception;
        }
    }

    @Override
    public int getScale(int column) throws SQLException {
        int n = column;
        try {
            MongoColumnInfo ci;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_21, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            if ((ci = this.getColumnInfo(column)).isPolymorphic()) {
                return 0;
            }
            BsonType t = ci.getBsonTypeEnum();
            switch (t) {
                case STRING: 
                case DOCUMENT: 
                case ARRAY: 
                case BINARY: 
                case UNDEFINED: 
                case OBJECT_ID: 
                case BOOLEAN: 
                case DATE_TIME: 
                case NULL: 
                case REGULAR_EXPRESSION: 
                case DB_POINTER: 
                case JAVASCRIPT: 
                case SYMBOL: 
                case JAVASCRIPT_WITH_SCOPE: 
                case INT32: 
                case TIMESTAMP: 
                case INT64: 
                case MIN_KEY: 
                case MAX_KEY: {
                    return 0;
                }
                case DECIMAL128: {
                    return 34;
                }
                case DOUBLE: {
                    return 15;
                }
            }
            throw new SQLException("unknown bson type: " + (Object)((Object)t));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_21);
            }
            throw exception;
        }
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_22, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            String intClassName = Integer.TYPE.getName();
            String booleanClassName = Boolean.TYPE.getName();
            String stringClassName = String.class.getName();
            String floatClassName = Float.TYPE.getName();
            String doubleClassName = Double.TYPE.getName();
            String bigDecimalClassName = BigDecimal.class.getName();
            String timestampClassName = Timestamp.class.getName();
            String bsonClassName = BsonValue.class.getName();
            int columnType = this.getColumnType(column);
            switch (columnType) {
                case 2003: {
                    break;
                }
                case -5: {
                    return intClassName;
                }
                case -2: {
                    break;
                }
                case -7: {
                    return booleanClassName;
                }
                case 2004: {
                    break;
                }
                case 16: {
                    return booleanClassName;
                }
                case 1: {
                    break;
                }
                case 2005: {
                    break;
                }
                case 70: {
                    break;
                }
                case 91: {
                    break;
                }
                case 3: {
                    return bigDecimalClassName;
                }
                case 2001: {
                    break;
                }
                case 8: {
                    return doubleClassName;
                }
                case 6: {
                    return floatClassName;
                }
                case 4: {
                    return intClassName;
                }
                case 2000: {
                    break;
                }
                case -16: {
                    return stringClassName;
                }
                case -4: {
                    break;
                }
                case -1: {
                    return stringClassName;
                }
                case -15: {
                    return stringClassName;
                }
                case 2011: {
                    break;
                }
                case 0: {
                    return null;
                }
                case 2: {
                    return doubleClassName;
                }
                case -9: {
                    return stringClassName;
                }
                case 1111: {
                    return bsonClassName;
                }
                case 7: {
                    break;
                }
                case 2006: {
                    break;
                }
                case 2012: {
                    break;
                }
                case -8: {
                    break;
                }
                case 5: {
                    return intClassName;
                }
                case 2009: {
                    break;
                }
                case 2002: {
                    break;
                }
                case 92: {
                    break;
                }
                case 2013: {
                    break;
                }
                case 93: {
                    return timestampClassName;
                }
                case 2014: {
                    break;
                }
                case -6: {
                    return intClassName;
                }
                case -3: {
                    break;
                }
                case 12: {
                    return stringClassName;
                }
            }
            throw new SQLException("getObject not supported for column type " + columnType);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_22);
            }
            throw exception;
        }
    }

    static {
        MongoResultSetMetaData.ajc$preClinit();
    }

    private static final /* synthetic */ Object logger_aroundBody1$advice(MongoResultSetMetaData ajc$this, MongoResultSetMetaData target, MongoLogger logger, LoggingAspect ajc$aspectInstance, MongoLogger arg, AroundClosure ajc$aroundClosure) {
        LoggingAspect.ajc$inlineAccessFieldSet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(ajc$aspectInstance, arg);
        AroundClosure aroundClosure = ajc$aroundClosure;
        MongoLogger mongoLogger = arg;
        target.logger = mongoLogger;
        return null;
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoResultSetMetaData.java", MongoResultSetMetaData.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "checkBounds", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "i", "java.sql.SQLException", "void"), 49);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAutoIncrement", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 56);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnName", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 114);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTableName", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 119);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCatalogName", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 124);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnType", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "int"), 129);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnTypeName", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 134);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWrapperFor", "com.mongodb.jdbc.MongoResultSetMetaData", "java.lang.Class", "iface", "java.sql.SQLException", "boolean"), 140);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unwrap", "com.mongodb.jdbc.MongoResultSetMetaData", "java.lang.Class", "iface", "java.sql.SQLException", "java.lang.Object"), 146);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCaseSensitive", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 151);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSigned", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 186);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnDisplaySize", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "int"), 221);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSearchable", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 62);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPrecision", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "int"), 276);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getScale", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "int"), 330);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnClassName", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 367);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCurrency", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 68);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemaName", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 74);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isReadOnly", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 86);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWritable", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 92);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDefinitelyWritable", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 98);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isNullable", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "int"), 104);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnLabel", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 109);
    }
}

