/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.MongoConnectionProperties;
import com.mongodb.jdbc.MongoPreparedStatement;
import com.mongodb.jdbc.MongoSQLDatabaseMetaData;
import com.mongodb.jdbc.MongoSQLStatement;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@AutoLoggable
public class MongoSQLConnection
extends MongoConnection
implements Connection,
LoggingAspect$ajcMightHaveAspect {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    public MongoSQLConnection(MongoConnectionProperties mongoConnectionProperties) {
        super(mongoConnectionProperties);
        LoggingAspect.ajc$perObjectBind(this);
        super.getLogger().log(Level.INFO, "Dialect is MongoSQL");
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_0, this, this));
            }
            this.checkConnection();
            try {
                return new MongoSQLStatement(this, this.currentDB);
            }
            catch (IllegalArgumentException e) {
                throw new SQLException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String string = sql;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, string));
            }
            try {
                return new MongoPreparedStatement(sql, new MongoSQLStatement(this, this.currentDB));
            }
            catch (IllegalArgumentException e) {
                throw new SQLException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_2, this, this));
            }
            return new MongoSQLDatabaseMetaData(this);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    static {
        MongoSQLConnection.ajc$preClinit();
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoSQLConnection.java", MongoSQLConnection.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createStatement", "com.mongodb.jdbc.MongoSQLConnection", "", "", "java.sql.SQLException", "java.sql.Statement"), 36);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.mongodb.jdbc.MongoSQLConnection", "java.lang.String", "sql", "java.sql.SQLException", "java.sql.PreparedStatement"), 46);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMetaData", "com.mongodb.jdbc.MongoSQLConnection", "", "", "java.sql.SQLException", "java.sql.DatabaseMetaData"), 55);
    }
}

