/*
 * Decompiled with CFR 0.152.
 */
package eu.bitwalker.useragentutils;

import eu.bitwalker.useragentutils.Version;
import eu.bitwalker.useragentutils.VersionFetcher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PatternBasedVersionFetcher
implements VersionFetcher {
    private final Pattern pattern;

    PatternBasedVersionFetcher(String regex) {
        this(Pattern.compile(regex, 2));
    }

    PatternBasedVersionFetcher(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public final Version version(String userAgentString) {
        Matcher matcher = this.pattern.matcher(userAgentString);
        boolean matchFound = matcher.find();
        if (!matchFound) {
            return null;
        }
        return this.createVersion(matcher);
    }

    protected Version createVersion(Matcher matcher) {
        String fullVersionString = matcher.group(1);
        String majorVersion = matcher.group(2);
        String minorVersion = "0";
        if (matcher.groupCount() > 2) {
            minorVersion = matcher.group(3);
        }
        return new Version(fullVersionString, majorVersion, minorVersion);
    }
}

