﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear
 
#<#
$testargs=$args
$reportingname='EXO\'+$testargs[0]
$rptTopNDD=($testargs[1]).ToString()
$userName=$testargs[2]
$Password=Eg-O365Dcr -EncStr $testargs[3]
$proxyUsr=$testargs[4]
$proxyPass=Eg-O365Dcr -EncStr $testargs[5]
$proxyipAnRcvQta=([String]$testargs[6]).Split('#')
$appDetails=$testargs[7]
$ExcludingNames=$testargs[8]
$proxyserverip=$proxyipAnRcvQta[0]
$recoverQuotaLmt=$proxyipAnRcvQta[1]

if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
#>

$rptPath='EXO\'+$testargs[0]
$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'


########### ARCHIVE MAILBOX - Start ######################
Function Start-SleepWithProgress {
	Param([int]$sleeptime)
	For ($i=0;$i -le $sleeptime;$i++){
		$timeleft = ($sleeptime - $i);
		Write-Progress -Activity "Sleeping" -CurrentOperation "$Timeleft More Seconds" -PercentComplete (($i/$sleeptime)*100);
		start-sleep 1
	}
	Write-Progress -Completed -Activity "Sleeping"
}

Function New-CleanO365Session {
    $Credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
    $i = 0
	while (($Credential -eq $Null) -and ($i -lt 5)){
		$script:Credential = Get-Credential -Message "Please provide your Exchange Online Credentials"
		$i++
	}
	if ($Credential -eq $null){
		Write-Error -Message "Failed to get credentials" -ErrorAction Stop
	}
    $getSession=Get-PSSession -ErrorAction SilentlyContinue
    if($getSession -ne $null -and $getSession -ne ''){
	    Disconnect-ExchangeOnline -Confirm:$false
    }
	[System.GC]::Collect()
	Start-SleepWithProgress -SleepTime 15
	$Error.Clear()
	
	# Create the session
	$sessionOption = New-PSSessionOption -SkipRevocationCheck
    if(!$proxyserverip.ToString().ToLower().Contains('none')){
        [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserverip)
	    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
	        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
            [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
            [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
	        $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
	    }
    }

	# Check for an error while creating the session
	if ($Error.Count -gt 0){
		$ErrorCount++
		if ($ErrorCount -gt 3){
			$deleky=0
            try{
                if(Test-Path -path $global:writeTmpCsv){
                    $null=Protect-File  $global:writeTmpCsv -Algorithm AES -KeyAsPlainText $global:WriteTmpKey -RemoveSource
                }
            }catch{                
            }
			exit
		}
		Start-SleepWithProgress -sleeptime 60
		New-CleanO365Session
	}
	else {
		$ErrorCount = 0
	}	
	# Connect the ExchangeOnline
    if($appDetails -and $appDetails -ne 'none'){
        Connect-ExchangeOnline -CertificateThumbPrint $thumbPrint -AppID $clientId -Organization $tenantName -PSSessionOption $sessionOption -ShowBanner:$false -WarningAction SilentlyContinue
    }else{
        Connect-ExchangeOnline  -ExchangeEnvironmentName $azureEnvArr[4] -ConnectionUri $azureEnvArr[1] -Credential $Credential -PSSessionOption $sessionOption -ShowBanner:$false
    }
	
	# Set the Start time for the current session
	Set-Variable -Scope script -Name SessionStartTime -Value (Get-Date)
}
New-CleanO365Session

$isExceptionOccured=$false 
$chkCSVPath=''
Try{
    $arMailBxWritArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "archivemailbox" -keyFileName "karchivemailbox" -EgPath $egurkhaPath
    $chkCSVPath=$arMailBxWritArr[1]
    Get-EXORecipient -PropertySets Archive -ResultSize Unlimited |select * |where{$_.ArchiveStatus -eq 'Active'}| Export-Csv $arMailBxWritArr[1] -Append -Encoding $encTyp
    $null=Protect-File  $arMailBxWritArr[1] -Algorithm AES -KeyAsPlainText $arMailBxWritArr[0] -RemoveSource
}Catch{
    $isExceptionOccured=$true
    $exoExcepMsg1='[EXOMbStats - Archivemailbox] Exception Occured in "Get-EXORecipient" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception+'!>'    
    Write-Host $exoExcepMsg1
}

$getSession=Get-PSSession -ErrorAction SilentlyContinue
if($getSession -ne $null -and $getSession -ne ''){
	Disconnect-ExchangeOnline -Confirm:$false
}

if(!$isExceptionOccured){
    $arMailBxReadArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "archivemailbox" -keyFileName "karchivemailbox" -EgPath $egurkhaPath
    if($arMailBxReadArr -ne $null -and [System.IO.File]::Exists($arMailBxReadArr[1]) -eq 'True'){
        $unProtctAct=$arMailBxReadArr[1] -replace (".csv",".dat") 
        $arPath=Unprotect-File $unProtctAct -Algorithm AES -KeyAsPlainText $arMailBxReadArr[0]
        $archivMailboxes= import-csv $arPath -Encoding $encTyp
        Remove-Item $arPath 
    }
}
else{
    if($chkCSVPath -ne $null -and $chkCSVPath -ne ''){
        if (Test-Path $chkCSVPath -PathType leaf){
            $dirNam=(get-item $chkCSVPath).DirectoryName
            $FileName=(get-item $chkCSVPath).BaseName
            Get-ChildItem -Path $dirNam |Where-Object {$_.Name -like '*'+$FileName+'*'}|ForEach-Object{if([System.IO.File]::Exists($_.FullName) -eq 'True'){Remove-Item -Path $_.FullName}}
        }
    }
}

########### ARCHIVE MAILBOX - End ######################

Function Get-MailStatsFile{
    $readfiles1=Eg-ReadFile -ComntRptPath $reportingname -FileName "statsmailbox" -keyFileName "kstatsmailbox" -EgPath $egurkhaPath
    <#if((Get-Item $readfiles1[1]).length -le 2kb){
        Remove-Item $readfiles1[1]
        Get-MailStatsFile
    }
    else{#>
        return $readfiles1
    #}
}
[System.GC]::GetTotalMemory($true) | out-null
$readMBS=Get-MailStatsFile
if($readMBS -ne $null -and [System.IO.File]::Exists($readMBS[1]) -eq 'True'){
    $mbsFileNam=$readMBS[1] -replace (".csv",".dat") 
    Write-Host $readMBS[1]
    $csvDatas=Unprotect-File $mbsFileNam -Algorithm AES -KeyAsPlainText $readMBS[0]	
    $mbStatReports= import-csv $csvDatas -Encoding $encTyp
    Remove-Item $csvDatas
}
$mailStats=$mbStatReports | select -First 1

$arMailBxCnt=0
if($mbStatReports -ne $null -and $mbStatReports -ne '' -and $archivMailboxes -ne $null -and $archivMailboxes -ne ''){
    foreach($arMailBx in $archivMailboxes){
        $arMailBxCnt++
        if($rptTopNDD.ToLower() -eq 'all'){
            $ddstng= '~!~'+$arMailBx.PrimarySmtpAddress+'~!~~!~~!~~!~~!~~!~~!~~!~'+$arMailBx.Identity+'~!~'+$arMailBx.ArchiveState+'~!~'+$arMailBx.ArchiveStatus+'~!~'+$arMailBx.ArchiveDatabase+'~!~'+$arMailBx.ArchiveGuid
            Write-host '#ddArchivemails' $ddstng
        }else{
            if($arMailBxCnt -le [int]$rptTopNDD){
                $ddstng= '~!~'+$arMailBx.PrimarySmtpAddress+'~!~~!~~!~~!~~!~~!~~!~~!~'+$arMailBx.Identity +'~!~'+$arMailBx.ArchiveState+'~!~'+$arMailBx.ArchiveStatus+'~!~'+$arMailBx.ArchiveDatabase+'~!~'+$arMailBx.ArchiveGuid
                Write-host '#ddArchivemails' $ddstng
            } 
        } 
    }
}

#$isPreviousScript=[bool]($mailStats.PSobject.Properties.name -match "PrimarySmtpAddress")
<#
if($isPreviousScript){
    $ErrorCount=0
    $readfiles=0
    $readfiles1=0
    try{   
        $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "mailbox" -keyFileName "kmailbox" -EgPath $egurkhaPath
        $datafile=$readfiles[1] -replace (".csv",".dat") 
        $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]
        $TotMailbxcnt= import-csv $csvfile
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'mailbox' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kmailbox' -InputFile $readfiles[4]
    }
    catch [System.Management.Automation.RuntimeException] {
	    $ErrorCount++	
        Write-Error -Message "File not found. The $reportingname location does not contain mailbox files."
    }
    catch{
    $ErrorCount++
        $errmsg=$_.Exception.Message
        $errstack=$_.Exception.StackTrace
        Write-Error -Message $errmsg
    }

    try{   
        $readfiles1=Get-MailStatsFile  #Eg-ReadFile -ComntRptPath $reportingname -FileName "statsmailbox" -keyFileName "kstatsmailbox" -EgPath $egurkhaPath
        $datafile1=$readfiles1[1] -replace (".csv",".dat") 
        $csvfile1=Unprotect-File $datafile1 -Algorithm AES -KeyAsPlainText $readfiles1[0]	
        $MailStatReport= import-csv $csvfile1
        Remove-Item $csvfile1
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'statsmailbox' -InputFile $readfiles1[3]
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'kstatsmailbox' -InputFile $readfiles1[4]
    }
    catch [System.Management.Automation.RuntimeException] {
    $ErrorCount++
        Write-Error -Message "File not found. The $reportingname location does not contain statsmailbox files."
        $MailStatReport= $null
    }
    catch{
    $ErrorCount++
        $errmsg=$_.Exception.Message
        $errstack=$_.Exception.StackTrace
        Write-Error -Message $errmsg
    }

    if( $MailStatReport -eq $null -or  $MailStatReport -eq ''){
        write-host "#TotMailbxcnt~-5"   
        write-host "#DbSndQte~-5" 
        write-host "#DbSndRecQte~-5" 
        Write-host '#MailbxOverQte~-5'
        write-host "#TotMailbxSize~-5" 
        write-host "#inactivecnt~-5" 
        write-host "#inactiveMailbxSize~-5" 
        Write-Host '#Arrcnt~-5'
        Write-Host '#Arrmailbxsize~-5'
        Write-Host '#ClutterEnabledcnt~-5'
        Write-Host '#ClutterDisabledcnt~-5'
        Write-Host '#ArchiveWarnMailscnt~-5'
        exit
    }
    Write-Host 'ReadFile:'$readfiles[3]','$readfiles1[3]

	$inactivecnt=0
	$Arrcnt=0
	$ClutterEnabledcnt=0
	$ClutterDisabledcnt=0
	$inactiveMailbxSize=0
	$SendQte=0
	$SendRecvQte=0
	$MailbxOverQte=0
	$Arrmailbxsize=0
	$TotMailbxSize=0
	$inact=0
    $ArrWarnMailcnt=0
    $ArchiveMailboxMap=@{}
    $ArchiveWarnMailboxsMap=@{}
    if($ErrorCount -eq 0){
	    $TotMailbxcnt= $TotMailbxcnt|where {$ExcludingNames -notcontains $_.DisplayName}
	    $MailStatReport=$MailStatReport|where {$ExcludingNames -notcontains $_.DisplayName}
	    $inactive=$TotMailbxcnt|Where{$_.WasInactiveMailbox -eq $true}|Select *
	    $ShrdMailboxes = $TotMailbxcnt|Where{$_.RecipientTypeDetails -eq 'SharedMailbox'}|Select *
	    $litigationhold=$TotMailbxcnt|Where{$_.LitigationHoldEnabled -eq $true}|Select *
	    $FrwdMailbx=$TotMailbxcnt|Where{$_.DeliverToMailboxAndForward -eq $true}|Select *
	    $Inplacehold=$TotMailbxcnt|Where{$_.InPlaceHolds -eq $true -and $_.InPlaceHolds -notcontains ' '}|Select *
	    foreach($Measures in $TotMailbxcnt){
		    $StatReport= $MailStatReport| Where {$_.PrimarySMTPAddress -eq $Measures.PrimarySmtpAddress }|Select PrimarySMTPAddress,IsArchiveMailbox,IsClutterEnabled,TotalItemSize,DatabaseIssueWarningQuota,DisplayName,ItemCount,DatabaseProhibitSendQuota,DatabaseProhibitSendReceiveQuota
            if($StatReport -ne $null) {
	            if($Measures.ArchiveStatus -eq 'Active'){
		            $Arrcnt++;
		            $repTot=[String]$StatReport.TotalItemSize
		            $resBytes= $repTot.Split('(')[1].Split(' ')
		            $Arrmailbxsize+=[double]$resBytes[0].Trim()
		            $ArchiveSize=[math]::round([double]$resBytes[0] /1Gb, 4)
		            $ArchiveQuota=[double]($Measures.ArchiveQuota).Split(' ')[0]
		            $ArchivewarnQuota=[double]($Measures.ArchiveWarningQuota).Split(' ')[0]
		            $ArchiveMailboxSize=[math]::round([double]$resBytes[0] /1Gb, 4)
		            $ddstng= $Measures.Name +'~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ '+ $Measures.ArchiveName +'~!~'+$Measures.ArchiveState +'~!~'+$ArchiveMailboxSize.tostring("#.##").replace(',','.') +'~!~'+$ArchiveQuota+'~!~'+$ArchivewarnQuota
		            $ArchiveMailboxMap[$ArchiveMailboxSize]=$ddstng
	                if($ArchiveMailboxSize -gt $ArchivewarnQuota){
	                $ArrWarnMailcnt++
	                $ArchiveWarnMailboxsMap[$ArchiveMailboxSize]=$ddstng           
	                }           
		        }
		        if($StatReport.IsClutterEnabled -eq $true){
		            $ClutterEnabledcnt++;
		        }
		        else{
		            $ClutterDisabledcnt++;
		        }

	            #Total MailBox Size
		        if($StatReport.TotalItemSize -ne $null){
		            $repOvrall=$StatReport.TotalItemSize
		            $restotBytes= $repOvrall.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
		            $TotMailbxSize+=[double]$restotBytes

	                #MailBox Over Quota
		            $DbWarn=[String]$Measures.IssueWarningQuota
    	            $DbWarnBytes= $DbWarn.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
                    if([double]$restotBytes -ge [double]$DbWarnBytes){
			            $MailbxOverQte++;
			            write-host " #ddOverWarning " $StatReport.DisplayName '~!~'  $Measures.UserPrincipalName '~!~' $StatReport.ItemCount '~!~'  $StatReport.totalItemSize  '~!~' $Measures.IssueWarningQuota  '~!~-~!~-'
		            }
		        }

                #MailBox Send Over Quota 
		        $SendQuota=[String]$Measures.ProhibitSendQuota
    	        $SendQuotaBytes= $SendQuota.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
		        if([double]$restotBytes -ge [double]$SendQuotaBytes){
			        $SendQte++;
			        write-host " #ddSendOverWarning " $StatReport.DisplayName '~!~'  $Measures.UserPrincipalName '~!~' $StatReport.ItemCount '~!~'  $StatReport.totalItemSize  '~!~-~!~' $Measures.ProhibitSendQuota '~!~-'
		        }
	
                #MailBox Send/recv Over Quota
		        $SendRecvQuota=[String]$Measures.ProhibitSendReceiveQuota
    	        $SendRecvQuotaBytes= $SendRecvQuota.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
		        if([double]$restotBytes -ge [double]$SendRecvQuotaBytes){
			        $SendRecvQte++;
			        write-host " #ddSendRecvOverWarning " $StatReport.DisplayName '~!~'  $Measures.UserPrincipalName '~!~' $StatReport.ItemCount '~!~'  $StatReport.totalItemSize  '~!~-~!~-~!~' $Measures.ProhibitSendReceiveQuota
		        }

                #Inactive MailBox Size

		        if($Measures.WasInactiveMailbox -eq $true){
                    $inactivecnt++
			        $inactSize=[String]$StatReport.TotalItemSize
			        $restotBytes= $inactSize.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
			        $inactiveMailbxSize+=[double]$restotBytes
		        }
	        }
        }

        foreach ( $in in $ArchiveMailboxMap.GetEnumerator() | sort -Property key  -Descending | select -first 10){
    	    Write-host '#ddArchivemails' $in.Value
        }

        foreach ( $in in $ArchiveWarnMailboxsMap.GetEnumerator() | sort -Property key  -Descending ){
    	    Write-host '#ddArchiveWarnMails' $in.Value
        }

	    $TotMailbxSize=[math]::round($TotMailbxSize /1Gb, 4)
	    $Arrmailbxsize=[math]::round($Arrmailbxsize /1Gb, 4)
		
	    # Top 10 Size DD
	    $ddlineMailbox= $MailStatReport| Select-Object DisplayName, @{name=”TotalItemSize_mb”;expression={[math]::Round((($_.TotalItemSize).Split(“(“)[1].Split(” “)[0].Replace(“,”,””)/1GB),4)}},PrimarySmtpAddress, ItemCount ,totalItemSize,DatabaseIssueWarningQuota,DatabaseProhibitSendQuota,DatabaseProhibitSendReceiveQuota | Sort-Object “TotalItemSize_mb” -Descending

	    For ($i=0; $i -lt 10; $i++) {
		    $ddline=$ddlineMailbox[$i]
			if($ddline -ne $null){
                $mailbx=$TotMailbxcnt | Where {$_.PrimarySMTPAddress -eq $Measures.PrimarySmtpAddress }|Select IssueWarningQuota,ProhibitSendQuota,ProhibitSendReceiveQuota
			    Write-Host  '#ddTop10Size '$ddline.DisplayName  '~!~' $ddline.ItemCount '~!~' $ddline.TotalItemSize_mb  '~!~' $mailbx.IssueWarningQuota.ToString().Split(" ")[0]  '~!~' $mailbx.ProhibitSendQuota.ToString().Split(" ")[0] '~!~' $mailbx.ProhibitSendReceiveQuota.ToString().Split(" ")[0]
			}
	    }
	
        #Inactive Measure DD
	    if($inactive -ne $null){
		    foreach($inact in $inactive){
		        $inactivecnt++
		        Write-Host '#ddinactive '$inact.DisplayName '~!~' $inact.PrimarySmtpAddress '~!~'$inact.WhenSoftDeleted
		    }
        }
    }
    #write-host "#TotMailbxcnt~" $TotMailbxcnt.Count
	write-host "#DbSndQte~" $SendQte
	write-host "#DbSndRecQte~" $SendRecvQte
	Write-host '#MailbxOverQte~'$MailbxOverQte
	write-host "#TotMailbxSize~" $TotMailbxSize.tostring("#.##").replace(',','.')
	write-host "#inactivecnt~" $inactivecnt
	write-host "#inactiveMailbxSize~" $inactiveMailbxSize.tostring("#.##").replace(',','.')
	Write-Host '#Arrcnt~' $Arrcnt
	Write-Host '#Arrmailbxsize~' $Arrmailbxsize.tostring("#.##").replace(',','.')
	Write-Host '#ClutterEnabledcnt~' $ClutterEnabledcnt
	Write-Host '#ClutterDisabledcnt~' $ClutterDisabledcnt
    Write-Host '#ArchiveWarnMailscnt~' $ArrWarnMailcnt
}
#>
#else{        
        $totMailBxSiz=0;$top10cnt=0;
        $iwarnQuotaCnt=0;$iwqCnt=0;
        $inActMBCnt=0;$iaCnt=0;
        $inactivMBSiz=0;
        $prohbtSndQuotaCnt=0;
        $prohbtSndRecvQCnt=0;
        $nearRecoverQuota=0;
        $mbStatReports|Where-Object {$_.IsDeleted -eq $false}|Sort-Object{ $_.StorageUsed -as [Long] } -Descending  | ForEach-Object{
            $totMailBxSiz+=$_.StorageUsed
            if($rptTopNDD.ToLower() -eq 'all'){
                $top10DD='#ddTop10Size '+$_.DisplayName+'~!~'+$_.ItemCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.IssueWarningQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.ProhibitSendQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.'ProhibitSend/ReceiveQuota'/(1024*1024*1024)),2)
                Write-Host $top10DD
            }else{
                if($top10cnt -lt [int]$rptTopNDD){
                    $top10cnt++
                    $top10DD='#ddTop10Size '+$_.DisplayName+'~!~'+$_.ItemCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.IssueWarningQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.ProhibitSendQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.'ProhibitSend/ReceiveQuota'/(1024*1024*1024)),2)
                    Write-Host $top10DD
                }
            }

            if([long]$_.StorageUsed -ge [long]$_.IssueWarningQuota){
                $iwarnQuotaCnt++
                if($rptTopNDD.ToLower() -eq 'all'){
                    $iwqDD='#ddOverWarning '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~'+$_.ItemCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.IssueWarningQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.ProhibitSendQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.'ProhibitSend/ReceiveQuota'/(1024*1024*1024)),2)+'~!~-~!~-'
                    Write-Host $iwqDD
                }else{
                    if($iwqCnt -lt [int]$rptTopNDD){
                        $iwqCnt++
                        $iwqDD='#ddOverWarning '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~'+$_.ItemCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.IssueWarningQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.ProhibitSendQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.'ProhibitSend/ReceiveQuota'/(1024*1024*1024)),2)+'~!~-~!~-'
                        Write-Host $iwqDD
                    }
                }
            }

            if([long]$_.StorageUsed -ge [long]$_.ProhibitSendQuota){
                $prohbtSndQuotaCnt++
            }
            if([long]$_.StorageUsed -ge [long]$_.'ProhibitSend/ReceiveQuota'){
                $prohbtSndRecvQCnt++
            }   
            [Double]$rcvQuotaPercent=0
            $rcvQuotaPercent=[math]::Round((([Double]$_.DeletedItemSize/[Double]$_.DeletedItemQuota)*100),2)
            if($rcvQuotaPercent -gt [Double]$recoverQuotaLmt){
                $nearRecoverQuota++
				if($rptTopNDD.ToLower() -eq 'all'){
                	$nearRecoverQuota_DD='#ddnearRecoverQuota '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~'+$_.DeletedItemCount+'~!~'+[math]::Round(($_.DeletedItemSize/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.DeletedItemQuota/(1024*1024*1024)),2)+'~!~'+$rcvQuotaPercent
                    Write-Host $nearRecoverQuota_DD				
                }else{
					if($nearRecoverQuota -le [int]$rptTopNDD){
						$nearRecoverQuota_DD='#ddnearRecoverQuota '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~'+$_.DeletedItemCount+'~!~'+[math]::Round(($_.DeletedItemSize/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.DeletedItemQuota/(1024*1024*1024)),2)+'~!~'+$rcvQuotaPercent
                        Write-Host $nearRecoverQuota_DD					
                    }
				}  
            }     
        }

        $mbStatReports|Sort-Object{ $_.LastActivityDate -as [DateTime] } | ForEach-Object{
            if($_.LastActivityDate -ne $null -and $_.LastActivityDate -ne ''){
                $tDat=(Get-Date).AddDays(-30)
                $ldat=[String]($_.LastActivityDate)
                $lstActDat=[DateTime]$ldat.Trim()
                if($lstActDat -lt $tDat){
                    $inActMBCnt++
                    $inactivMBSiz+=$_.StorageUsed
                    if($rptTopNDD.ToLower() -eq 'all'){
                        if($_.IsDeleted -eq $true){
                                $inactivDD='#ddinactive '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~'+$_.DeletedDate
                            }else{
                                $inactivDD='#ddinactive '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~-'
                            }
                            Write-Host $inactivDD
                    }
                    else{
                        if($iaCnt -lt [int]$rptTopNDD){
                            $iaCnt++
                            if($_.IsDeleted -eq $true){
                                $inactivDD='#ddinactive '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~'+$_.DeletedDate
                            }else{
                                $inactivDD='#ddinactive '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~-'
                            }
                            Write-Host $inactivDD
                        }
                    }
                }
            }
        }

        $totMailBxSiz=[math]::Round(($totMailBxSiz/(1024*1024*1024)),2)
        write-host "#TotMailbxSize~"$totMailBxSiz
        Write-host '#MailbxOverQte~'$iwarnQuotaCnt
        write-host "#inactivecnt~"$inActMBCnt
        $inactivMBSiz=[math]::Round(($inactivMBSiz/(1024*1024*1024)),2)
        write-host "#inactiveMailbxSize~"$inactivMBSiz
        Write-Host '#Arrcnt~'$arMailBxCnt
	    Write-Host '#Arrmailbxsize~-5'
	    Write-Host '#ClutterEnabledcnt~-5'
	    Write-Host '#ClutterDisabledcnt~-5'
        write-host "#DbSndQte~"$prohbtSndQuotaCnt
		write-host "#DbSndRecQte~"$prohbtSndRecvQCnt
        Write-Host '#ArchiveWarnMailscnt~-5'
        Write-Host '#nearRecoverQuota~'$nearRecoverQuota
#}
[System.GC]::GetTotalMemory($true) | out-null
# SIG # Begin signature block
# MIIlUgYJKoZIhvcNAQcCoIIlQzCCJT8CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQU7tt0UT7nIdSeD+PqcyKhdIjx
# Kj6ggh54MIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhN
# hpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0
# MjM1OTU5WjBMMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4x
# JDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZI
# hvcNAQEBBQADggIPADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
# 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y
# 1vmE8Zg+C78KhBJxbKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFq
# RUIjQVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJH
# GVvimC6P0Mo//8ZnzzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHV
# GBS3BEXz4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vI
# CNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90
# QQqvuY4J03ShL7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2x
# wafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK
# 2jCQa+5vdcCwNiayCDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2
# QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTq
# J+7+fXprAgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
# ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjAL
# BglghkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
# VR0OBBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0
# dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZT
# SEEyNTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsG
# AQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0
# dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQw
# OTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0t
# I3Sm0fX46kuZPwHk9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4q
# OVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KEr
# lribVakaa33R9QIJT4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
# y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZj
# IGvL8nvQNeNKcEiptucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiL
# fmSiZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp4
# 3UZ3Lht6wDOK+EoojBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pI
# allDrl/q+A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVr
# NQ6F1uAszOAMJLh8UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBF
# ThIcFClYzG/Tf8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdj
# OEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjEL
# MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
# LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
# IENvZGUgU2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAw
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFM5VI3rX
# GWszOuk6VxaMXOax/QOvMA0GCSqGSIb3DQEBAQUABIICADmOmMOlMJ0McM+TLfx5
# lrLRZHROuTUKA1yRvSwcN1uAru/LzBXrWNFx7zQz0Ap/5xSjrWhWCYsEnD2iemqB
# weMKuDhWzRkZe2Cqx34nagzUQ4PyEX7bkTWA6AUMG9PLQ3aeKUOKAWQOULs6t/qA
# DNsyIgA+T5aUZSjyTV82oAswx/yBfMp2Esiia2lY68QEvMQ/ebLlvg9u7uU+tnGz
# QeRqpF3BHp+KkJg8x5/9/u51LWDgR7YlNO0jdsd6/jklmfuXVtKhE+qk7mbs5wDw
# j06sNJMXEI1dwTPUyFL17JNGPFqAGZkPHSUCvJGI53aVyqOPTf04x697akd+4loD
# nWs1Dy/ZgHRwwy8tmXkGakLa6v0iGmQjElrbhKYgKYFlYSMpmUzG48rmagaJwV34
# zT+Mdhps6u1wX165NES13Qp5BvFINXmAK7ylpfJNjfV+HXceLnh1yedxDKy1drtu
# V+XH8cSIXFdT7kuA8TL9iWyzJKL7T/0/yk2Qy9MV7jJfzFWkChxFn3jIyhQbulIy
# VaLKqCHe6W5gp2UpyhvPsDynMUpY48CIcy/bUzCldCq+F8Nh5DdzLSUfoHbGmM9D
# tm/QL4bj+XmPueT3QJ8tC38EQSum5Dm9P928yM6PvA9wPd9jOXmAvnDBmJkIkWFo
# pYwVm/XYJyA3HVvS9lBAjZJqoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEB
# MHcwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYD
# VQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFt
# cGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqG
# SIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDkxMjA0MDk0
# OFowLwYJKoZIhvcNAQkEMSIEICaQ2VA1ZxFt48HlEbC77+hgUivppbKcNNWNSi+e
# Qy6ZMA0GCSqGSIb3DQEBAQUABIICAHKFdx1XFHXPW6rGDk+IECAB99hg7U4no3pN
# 78wwstuUkFoXgdZJufAFTQ42yiPtrY0vzDSX8bPXXix9i79p7v2synvTG476fyuO
# TG6C18uXfv0t1TiQRZi1OlHhcA44Wy28tgBDRPHtmox9CN2Z/mKBK6ycCh0wQ9A4
# eO9TT25eiaARaHJdO8ANOn5MqzN3ypTKkQtqFhCX1Du0xnc2VckRQOqNPuyKzpDr
# K3hSUYN6B/sBm9PPOcx0x1GxsLmFEOKVzDhvUVpDfMnPjlZs29hfO5YuvgbMHGVt
# MJUmNUHPVG/Oyj5A660k+zr92qlZMDKo3zm+OoXCMO57ICWDb8bf5cPL1MYaNSiM
# tZLypTxs3yr12Ibzq0W33UOlYBDcnwRFf3o/yzgGUp/Fb30wbelNegUUELPH+NXp
# +hynZri8StM7Oc9fdud7mRoavpdVAi/qzbVCv4yq2HOaPj0fF09hS9oEGW57sLsM
# JeynYTdQd7dXmr++nlThlR3DQibI1XPPzIHWZG1Ziv+6l9pnKrk3k/kPzke6cj0g
# bmoTuyoPwz/waJIbR78t8Qa5WNxpkT90nAomyXcd7ZvQC+xYI7c1Dngocv07MDC2
# okzJssG9kimC7ND92Nk8CJG3IyS15VccsshMK1khGt5u5QkLRco1PRuNhVL14KkD
# F4bTMC/X
# SIG # End signature block
