# This Script will give all details of Citrix XenDesktop Site in Citrix Excalibur
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Add-PSSnapin "Citrix.Common.Commands"
Add-PSSnapin "Citrix.Host.Admin.V2"
Add-PSSnapin "Citrix.Broker.Admin.V2"
Add-PSSnapin "Citrix.ADIdentity.Admin.V2"
Add-PSSnapin "Citrix.Configuration.Admin.V2"
Add-PSSnapin "Citrix.MachineCreation.Admin.V2"
Add-PSSnapin "Citrix.Licensing.Admin.V1"
Add-PSSnapin "Citrix.DelegatedAdmin.Admin.V1"
Add-PSSnapin "Citrix.Monitor.Admin.V1"
Add-PSSnapin "Citrix.ConfigurationLogging.Admin.V1"
Add-PSSnapin "Citrix.AppLibrary.Admin.V1"

$ZoneControllersHash = @{}
$ConfiguredZones = Get-ConfigZone -EA 0
foreach($Zone in $ConfiguredZones)
{
	$ZoneControllersHash.Add($Zone.Name,$Zone.ControllerSids)
}

Write-Host "Site"
Write-Host "----"
$Site = Get-BrokerSite
if ($Site -ne $null)
{
	$LicenseEdition = $Site.LicenseEdition
	if ($LicenseEdition -eq $null -or $LicenseEdition.length -eq 0)
	{
		$LicenseEdition = "-"
	}

	$LicenseModel = $Site.LicenseModel
	if ($LicenseModel -eq $null -or $LicenseModel.length -eq 0)
	{
		$LicenseModel = "-"
	}

	$LicensingGraceHoursLeft = $Site.LicensingGraceHoursLeft
	if($LicensingGraceHoursLeft -eq $null -or $LicensingGraceHoursLeft.length -eq 0)
	{
		$LicensingGraceHoursLeft = "-"
	}
	Write-Host ($Site.Name,$Site.LicenseServerName,$Site.LicenseServerPort,$Site.LicensedSessionsActive,
	$LicenseEdition,$LicenseModel,$Site.LicensingBurnInDate,$Site.DnsResolutionEnabled,$Site.SecureIcaRequired,
	$Site.TrustRequestsSentToTheXmlServicePort,
	$Site.ConnectionLeasingEnabled,$Site.LicensingGracePeriodActive,$Site.LicensingOutOfBoxGracePeriodActive,$LicensingGraceHoursLeft) -Separator ";"
}

Write-Host "Hypervisor Details"
Write-Host "------------------"
$HypConnPath = "XDHyp:\Connections\"
$HypConnections = Get-ChildItem $HypConnPath
if ($HypConnections -ne $null)
{
	foreach ($HypConn in $HypConnections)
	{
		$ConnectionType = $HypConn.ConnectionType
		$HypervisorConnectionName = $HypConn.HypervisorConnectionName
		$HypervisorAddress = $HypConn.HypervisorAddress
		if ($HypervisorAddress -eq $null -or $HypervisorAddress.length -eq 0)
		{
			$HypervisorAddress = "-"
		}
		else
		{
			$HypvConn = ""
			$count = 0
			foreach ($key in $HypervisorAddress)
			{
				if ($count -eq 0)
				{
					$HypvConn = $key
				}
				else
				{
					$HypvConn = $HypvConn + "#" + $key
				}
				$count = $count + 1
			}
			if ($HypvConn -eq $null -or $HypvConn.length -eq 0)
			{
				$HypervisorAddress = "-"
			}
			else
			{
				$HypervisorAddress = $HypvConn
			}
		}
		$MaintenanceMode = $HypConn.MaintenanceMode
		$Persistent = $HypConn.Persistent
		$SupportsLocalStorageCaching = $HypConn.SupportsLocalStorageCaching
		$SupportsPvsVMs = $HypConn.SupportsPvsVMs
		$UserName = $HypConn.UserName
		$Scopes = $HypConn.Scopes
		if ($Scopes -eq $null -or $Scopes.length -eq 0)
		{
			$Scopes = "-"
		}
		$HypZone = $HypConn.ZoneName
		if($HypZone -eq $null -or $HypZone.length -eq 0)
		{
			$HypZone = "-"
		}
		# Hypervisor State
		# Unavailable - The broker is unable to contact the hypervisor.
		# InMaintenanceMode - The hosting server is in maintenance mode.
		# On - The broker is in contact with the hypervisor.
		$HyperConns = Get-BrokerHypervisorConnection -HypHypervisorConnectionUid $HypConn.HypervisorConnectionUid
		if($HyperConns -ne $null)
		{
			$State = $HyperConns.State
			$PreferredController = $HyperConns.PreferredController
			Write-Host ($HypervisorConnectionName,$State,$ConnectionType,$HypervisorAddress,$PreferredController,$MaintenanceMode,
			$Persistent,$SupportsLocalStorageCaching,$SupportsPvsVMs,$UserName,$Scopes,$HypZone) -Separator ";"
		}
	}
}

Write-Host "Controllers"
Write-Host "-----------"
$Controllers = Get-BrokerController
if($Controllers -ne $null)
{
	foreach($Controller in $Controllers)
	{
		$DNSName = $Controller.DNSName
		$ControllerSid = $Controller.SID
		if ($DNSName -eq $null -or $DNSName.length -eq 0)
		{
			$DNSName = "-"
		}
		$ControllerZoneName = "-"
		if($ZoneControllersHash.Count -gt 0)
		{
			$ZoneKeys = $ZoneControllersHash.KEYS.GetEnumerator()
			foreach($ZoneKey in $ZoneKeys)
			{
				$ZoneValues = $ZoneControllersHash[$ZoneKey]
				if($ZoneValues.Contains($ControllerSid) -eq $true)
				{
					$ControllerZoneName = $ZoneKey
				}
			}
		}
		$OSType = $Controller.OSType
		if ($OSType -eq $null -or $OSType.length -eq 0)
		{
			$OSType = "-"
		}
		$OSVersion = $Controller.OSVersion
		if ($OSVersion -eq $null -or $OSVersion.length -eq 0)
		{
			$OSVersion = "-"
		}

		Write-Host($DNSName,$Controller.MachineName,$Controller.State,$Controller.DesktopsRegistered,
		$Controller.ControllerVersion,$OSType,$OSVersion,$Controller.LastActivityTime,$Controller.LastStartTime,$ControllerZoneName) -Separator ";"
	}
}

Write-Host "Controller Services"
Write-Host "-------------------"
if($Controllers -ne $null)
{
	foreach($Controller in $Controllers)
	{
		$DNSName = $Controller.DNSName
		if ($DNSName -eq $null -or $DNSName.length -eq 0)
		{
			continue
		}
		#$DNSName = $DNSName.Substring($DNSName.indexOf('.'))
		$State = $Controller.State
		if ($State -eq $null -or $State.length -eq 0)
		{
			continue
		}
		if ($State -eq "Off" -or $State -eq "Failed")
		{
			continue
		}

		$ADIdentityStatus = Get-AcctServiceStatus -AdminAddress $DNSName
		if ($ADIdentityStatus -eq $null -or $ADIdentityStatus.length -eq 0)
		{
			$ADIdentityStatus = "-"
		}
		$BrokerStatus = Get-BrokerServiceStatus -AdminAddress $DNSName
		if ($BrokerStatus -eq $null -or $BrokerStatus.length -eq 0)
		{
			$BrokerStatus = "-"
		}
		$ConfigStatus = Get-ConfigServiceStatus -AdminAddress $DNSName
		if ($ConfigStatus -eq $null -or $ConfigStatus.length -eq 0)
		{
			$ConfigStatus = "-"
		}
		$HypStatus = Get-HypServiceStatus -AdminAddress $DNSName
		if ($HypStatus -eq $null -or $HypStatus.length -eq 0)
		{
			$HypStatus = "-"
		}
		$MachineCreationStatus = Get-ProvServiceStatus -AdminAddress $DNSName
		if ($MachineCreationStatus -eq $null -or $MachineCreationStatus.length -eq 0)
		{
			$MachineCreationStatus = "-"
		}
		$AdminServiceStatus = Get-AdminServiceStatus -AdminAddress $DNSName
		if ($AdminServiceStatus -eq $null -or $AdminServiceStatus.length -eq 0)
		{
			$AdminServiceStatus = "-"
		}
		#$LicServiceStatus = Get-LicServiceStatus -AdminAddress $DNSName
		#if ($LicServiceStatus -eq $null -or $LicServiceStatus.length -eq 0)
		#{
			$LicServiceStatus = "-"
		#}
		$MonitorServiceStatus = Get-MonitorServiceStatus -AdminAddress $DNSName
		if ($MonitorServiceStatus -eq $null -or $MonitorServiceStatus.length -eq 0)
		{
			$MonitorServiceStatus = "-"
		}
		$LogServiceStatus = "-"
		$LogServiceStatusObj = Get-LogServiceStatus -AdminAddress $DNSName
		if ($LogServiceStatusObj -ne $null)
		{
			$LogServiceStatus = $LogServiceStatusObj.ServiceStatus
			if ($LogServiceStatus -eq $null -or $LogServiceStatus.length -eq 0)
			{
				$LogServiceStatus = "-"
			}
		}
		Write-Host($DNSName,$ADIdentityStatus,$BrokerStatus,$ConfigStatus,$HypStatus,$MachineCreationStatus,
		$AdminServiceStatus,$LicServiceStatus,$MonitorServiceStatus,$LogServiceStatus) -Separator ";"
	}
}

Write-Host "Machine Catalogs"
Write-Host "----------------"
$Catalogs = Get-BrokerCatalog -MaxRecordCount 2147483647
if($Catalogs -ne $null)
{
	foreach($Catalog in $Catalogs)
	{
		$Description = "-"
		$PvsAddress = $Catalog.PvsAddress 
		if ($PvsAddress -eq $null -or $PvsAddress.length -eq 0)
		{
			$PvsAddress = "-"
		}
		$PvsDomain = $Catalog.PvsDomain
		if ($PvsDomain -eq $null -or $PvsDomain.length -eq 0)
		{
			$PvsDomain = "-"
		}
		$Description = $Catalog.Description
		if ($Description -eq $null -or $Description.length -eq 0)
		{
			$Description = "-"
		}
		$Scopes = $Catalog.Scopes
		if ($Scopes -eq $null -or $Scopes.length -eq 0)
		{
			$Scopes = "-"
		}
		$ZoneName = $Catalog.ZoneName
		if ($ZoneName -eq $null -or $ZoneName.length -eq 0)
		{
			$ZoneName = "-"
		}
		Write-Host ($Catalog.Name,$Catalog.AllocationType,$Catalog.AssignedCount,$Catalog.AvailableAssignedCount,$Catalog.AvailableCount,
		$Catalog.AvailableUnassignedCount,$Catalog.UnassignedCount,$Catalog.UsedCount,$Catalog.MachinesArePhysical,$PvsAddress,
		$PvsDomain,$Catalog.PersistUserChanges,$Catalog.ProvisioningType,$Catalog.SessionSupport,$Description,$Scopes,$ZoneName) -Separator ";"
	}
}


Write-Host "Zones"
Write-Host "------"
foreach($Zone in $ConfiguredZones)
{
	Write-Host($Zone.Name,$Zone.IsPrimary) -Separator ";"
}

Remove-PSSnapin "Citrix.Common.Commands"
Remove-PSSnapin "Citrix.Host.Admin.V2"
Remove-PSSnapin "Citrix.Broker.Admin.V2"
Remove-PSSnapin "Citrix.ADIdentity.Admin.V2"
Remove-PSSnapin "Citrix.Configuration.Admin.V2"
Remove-PSSnapin "Citrix.MachineCreation.Admin.V2"
Remove-PSSnapin "Citrix.Licensing.Admin.V1"
Remove-PSSnapin "Citrix.DelegatedAdmin.Admin.V1"
Remove-PSSnapin "Citrix.Monitor.Admin.V1"
Remove-PSSnapin "Citrix.ConfigurationLogging.Admin.V1"
Remove-PSSnapin "Citrix.AppLibrary.Admin.V1"



# SIG # Begin signature block
# MIIbjAYJKoZIhvcNAQcCoIIbfTCCG3kCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUfINqt8qE3+gqpgIj1c1OVPVN
# SuSgghWiMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHOFADw3TANBgkqhkiG9w0B
# AQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEwMTAwMDAwMFoXDTMxMDEw
# NjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpja1HXOhFCvQp1dU2UtAxQ
# tSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9NmqB+in43Stwhd4CGPN4
# bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaPxqPhLxs6t2HWc+xObTOK
# fF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsOjizVI9r0TXhG4wODMSlK
# XAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7EdMMKbaYK02/xWVLwfoYer
# vnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmEvQECAwEAAaOCAbgwggG0
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsG
# AQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkwJwYIKwYBBQUHAgEWG2h0
# dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSMEGDAWgBT0tuEgHf4prtLk
# YaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgtHUQ23eNqerwwcQYDVR0f
# BGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFz
# c3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NB
# LmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7znGucgDo5nRv1CclF0CiNH
# o6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJmTe1ppA/2uHDPYuj1UUp4
# eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3Y18jUmmDgvoaU+2QzI2h
# F3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74wOFcz8QRcucbZEnYIpp1
# FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPWH1ub9y4bTxMd90oNcX6X
# t/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHLKNpbh6aKLzCCBTAwggQY
# oAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
# MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBD
# QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsx
# SRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3Gde2qvCchqXYJawO
# eSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJ
# RdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/6XzLkqHlOzEc
# z+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE86xnTrXE94zRICUj6whk
# PlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+mM6n9Gd8l
# k9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD
# AgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggrBgEF
# BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
# Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
# Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5k
# aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsME8GA1UdIARI
# MEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
# Y2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7KgqjpepxA8Bg
# +S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzANBgkqhkiG
# 9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134LYP3DPQ/E
# r4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GOYw4TS63XX0R58zYUBor3
# nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRHoXpo
# aK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhCMrI2iiQC/i9yfhzXSUWW
# 6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
# 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEwggQZoAMCAQICEAqhJdbW
# Mht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
# A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
# MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lD
# ZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGln
# aUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZI
# hvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0Uz
# URB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+
# X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPu
# XciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z9
# 8OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQ
# hBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4w
# ggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2Ny
# bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNV
# HSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cu
# ZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEB
# AHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFa
# KrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUME
# aLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
# 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEm
# tmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR7
# 9VYzIi8iNrJLokqV2PWmjlIwggYzMIIFG6ADAgECAhAImnSeuC3D7CfqZerb+DUx
# MA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwHhcNMjEwNTI1MDAw
# MDAwWhcNMjQwNTI5MjM1OTU5WjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
# IEplcnNleTEPMA0GA1UEBxMGSXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9u
# cywgSW5jLjEdMBsGA1UEAxMUZUcgSW5ub3ZhdGlvbnMsIEluYy4wggIiMA0GCSqG
# SIb3DQEBAQUAA4ICDwAwggIKAoICAQDEZQnSmuNt/FyaBkaN3skPE6zuzJIe9pDf
# AZHYpsPdplqB5IT6QbS0qQSxDidrxuc1WJj/MXg9ujRmRi0zMkiTQBlcNMy9ev+Y
# S+YrEJuIkVMKkqSZnixrkFl87uKAi9w1JrTMgjZrmOJAkXLzmP5/0jgSBOj05x1V
# 4g1eGBDbFnpOMQr6luGqZVe+vwMHbolyU5p53QvlWzv4JsbNm4qJ+DEvaLx3kUPO
# SFlJl90K0a0S8Tmkt6xdJZ+nNR128I1GKwg8YHuaD5GWfZe9RnLJpFRG2XHXWlh8
# n8o1gCRQIvbeueHfz+ZrG1K916KhgGPjEvK3umhAEb5vS7MKOBEAN7f+TQ22JXAk
# ijRkSxTIMA2nskgiMx4/Ow4xjN8w/KLxyUDB8FhzZeFK5RxffIp/iSlEWYKVh8rk
# uy0ZBE1s42OmwIFMSBm7AR+R05TSuZozLBkVUscSmalhl4/PszdWE35pXnqRH95+
# jx4PzUTlUNCqYmIZYqr+z2OFuRgfuDa6EvYxdv+5GyFUNI6QVG8ggP+X7IMmiAMG
# lp7fHai/li+NjxmjxEXS1e/JLSt+wO8A1nDuam3MefQGWbDmW6DcXYJUmk1vNvUe
# YAfqTTIUeZZgKhQA1sEHRhH+Tgm+BjZvK20XtxA8nKXtQj0K7gpMCDtE6YaTB0uG
# Zeg8IFyjQQIDAQABo4IBxDCCAcAwHwYDVR0jBBgwFoAUWsS5eyoKo6XqcQPAYPkt
# 9mV1DlgwHQYDVR0OBBYEFPnIRJrP2BNJLxoE1rWvfgwwDjZKMA4GA1UdDwEB/wQE
# AwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWgM6Axhi9odHRw
# Oi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDA1oDOg
# MYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5j
# cmwwSwYDVR0gBEQwQjA2BglghkgBhv1sAwEwKTAnBggrBgEFBQcCARYbaHR0cDov
# L3d3dy5kaWdpY2VydC5jb20vQ1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUH
# MAKGQmh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1
# cmVkSURDb2RlU2lnbmluZ0NBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEB
# CwUAA4IBAQCUCOdwU+8srLBP/gMQIbtsdu2JWX666Z9GPZisW4KGyCS/U+ZCmB/K
# nELeD4StX3JFXz5ddILA5oone/pEud+mEuETBhzb7RCz82WJvk0DEMa4hzMAh5c5
# zmRFGm8WxDZdI20ztcvW0sObqn9UbsGhQDKpFeww91ZtOQ3/2d0KYZKypzGMba53
# w7pWG170nktocFWTeUhkAy0foAJ2jlBOszj2dshTxAa5Fg1dkpEsBS7oiAPpYkox
# V9ldaXJ8Px1navd6PpDW4A781u13f3tP4FVCsNYw4bz4Z5GInCh6/FshaHRJ6dk5
# SsCr29MlpK8UxK9y2Qmb+jEtRxR0QZLfMYIFVDCCBVACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFNAUyCtXah6h4bzP
# xjnpCijnPENiMA0GCSqGSIb3DQEBAQUABIICALyF5gCiMwBtlfjdsC0UnZlaysUU
# ht+fglUASJgJjgGLp1GFDw4iGUmgwXiCdXMnyuabn+OdLTXDvwxA/JihvPHHZndO
# FUYCQec9RtLhadRVS/3VP1lYPafKEvOmYbduuVVhn1ohXxxXHYRt9MRlOfx4oD9o
# u5I2bauEpk+Z+7WrD9/302F4fCskV499y07V6Cg89ZYScOWnmBB7xaoHJ+Qvpjx1
# 2WS28DAxIRmoPAr+HTfWH6t6OxuWCVZfE6gJ8bYLcTwf5m3Jx/AI5gLA/Ht+pCwF
# ywefOJJ4HylVsCwy8EhR8pvASKhTpQVNn7CbtE2ICYACeF32kTf/ZlMntTmqN7Rh
# 4b8sPNZIP6imHaQUdR5tZT7jZvM3OnPpRDrNZxlisMj83VxAPJ2KmAxOJpA14eeo
# G9hU49FmRoCnqRXGpKAitw9XJYw5Symzs0ixNRegLyDrRat33uSF+0Chipo6Ab81
# bT6hzT08/Kf4jm/+a9ZrACQuM8uWGkbit8gmTGpb545bcTRwTsnbAl59dvTSmew3
# hYl4yLQyo7stsA2FdSH5JUuwZEBWueE59wHov1VuhtyhrMRpemTZnzGt/8qCZfqx
# edA3OxK4d20HtVL8SxCBHjy8iZLu6HhC7qAXL/6aW68GyRIGq1BWccywtVdwr1+k
# UWYTD6nL75YEjQpEoYICMDCCAiwGCSqGSIb3DQEJBjGCAh0wggIZAgEBMIGGMHIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJ
# RCBUaW1lc3RhbXBpbmcgQ0ECEA1CSuC+Ooj/YEAhzhQA8N0wDQYJYIZIAWUDBAIB
# BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0y
# MTA5MDExMjM3MTJaMC8GCSqGSIb3DQEJBDEiBCCR4qMlFikjlIxBFTEg0El0AYnr
# yuH7VUMmcCHWAqmjGzANBgkqhkiG9w0BAQEFAASCAQBZpU7GQqk2RstjotejwHif
# wYGJADXULrKT4YC/a5XSs3AsaB19F40rSVJ0dUBnbfS6U/ua4Gi2qscU50/N01Hn
# A6Ci2R1YEjAd3oalaaSr0kx0iJLxK5tP9gGcGSSuLsBPrgAFtsjG6S2g5pBv4GOh
# GNw3zXorG15dBXiBha3y/BAa5FlSlD6EFj0XQxU4NaJXr7GaAlqeZie9zFV121D+
# SpG+GO8VPns8psqR9BvDN72LPoQBC0Vqa/8kwWqrUaOubIGorhds5Sh0fqmhE6eq
# tzIW99IVOnaOuX+Iqxoi7GDnT6BZBkCauAlzc/tiS/W9Y9TOclDqMH5dBUow/pf3
# SIG # End signature block
