$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

if($args.count -eq 0)
{
	Write-Host "AADConnect.ps1 <Username> <Password> <Tenant ID> <eG Install Dir>"
	break
}

$Username = $args[0]
$Password = $args[1]
$TenantId = $args[2]
$eGInstallDir = $args[3]
$OEFile = $eGInstallDir + "\lib\OE.exe" 
& $OEFile $Password | Tee-Object -Variable Password | Out-Null # Decrypt Password

try
{
	$MSOnline = Get-Module -Name 'MSonline'-ListAvailable -EA Stop
}
catch
{
	$ErrorMessage = $_.Exception.message
	Write-Host $ErrorMessage
	exit
}

$Password = ConvertTo-SecureString $Password -AsPlainText -Force
$Credential = New-Object System.Management.Automation.PSCredential ($Username, $Password)

$isAuthenticated = $false
try
{
	Connect-MsolService -Credential $Credential
	$isAuthenticated = $true
}
catch
{
	$($_.Exception.Message) 
}

if($isAuthenticated -eq $false)
{
	Write-Host "Authentication Failed"
	exit
}

$CompanyInfo = Get-MsolCompanyInformation -TenantId $TenantId
if($CompanyInfo -ne $null)
{
	$DisplayName = $CompanyInfo.DisplayName
	$DirectorySynchronizationEnabled = $CompanyInfo.DirectorySynchronizationEnabled
	$LastDirSyncTime = $CompanyInfo.LastDirSyncTime
	$LastPasswordSyncTime = $CompanyInfo.LastPasswordSyncTime
	$PasswordSynchronizationEnabled = $CompanyInfo.PasswordSynchronizationEnabled
	$LastPasswordSyncTime = $CompanyInfo.LastPasswordSyncTime
	$CurrentTimeUTC = (Get-Date).ToUniversalTime()
	$TimeSpan = New-TimeSpan -Start $LastDirSyncTime -End $CurrentTimeUTC
	$SyncinMin = $TimeSpan.Minutes
	$TimeSpan = New-TimeSpan -Start $LastPasswordSyncTime -End $CurrentTimeUTC
	$PwdSyncinMin = $TimeSpan.Minutes
	#https://docs.microsoft.com/en-us/azure/active-directory/hybrid/how-to-connect-sync-feature-scheduler
	$Scheduler = Get-ADSyncScheduler
	$NextSync = $Scheduler.NextSyncCycleStartTimeInUTC
	$SyncCycleEnabled = $Scheduler.SyncCycleEnabled
	$MaintenanceEnabled = $Scheduler.MaintenanceEnabled
	$StagingModeEnabled = $Scheduler.StagingModeEnabled
	$SchedulerSuspended = $Scheduler.SchedulerSuspended
	$SyncCycleInProgress = $Scheduler.SyncCycleInProgress
	Write-Host ("Success", $DisplayName, $DirectorySynchronizationEnabled, $PasswordSynchronizationEnabled, $LastDirSyncTime,
		    $LastPasswordSyncTime, $NextSync, $SyncinMin, $SyncCycleEnabled, $MaintenanceEnabled, $StagingModeEnabled,
		    $SchedulerSuspended, $SyncCycleInProgress,$PwdSyncinMin) -Separator "#~#" 
}

$ErrList = Get-MsolDirSyncProvisioningError -All -TenantId $TenantId
if ($ErrList -ne $null)
{
	foreach ($Err in $ErrList)
	{
		$ProvList = $Err.ProvisioningErrors
		foreach ($Prov in $ProvList)
		{
			$ProxyAddresses  = @($Err.ProxyAddresses) -ne '' -join '|'

			Write-Host ("ProvisioningError", $Err.DisplayName, $Err.ImmutableId, $Err.ObjectType, $Prov.ErrorCategory, $Prov.PropertyName, $Prov.PropertyValue, $Prov.WhenStarted,
				     $ProxyAddresses, $Err.ObjectId, $Err.LastDirSyncTime) -Separator "#~#"
		}
	}
}



