﻿$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

# Get all replication groups
$replicationgroups = dfsradmin rg list;

# Reduce loop by 3 lines to filter out junk from dfsradmin
$i = 0;
$imax = ($replicationgroups.count -3);

# Loop through each replication group
foreach ($replicationgroup in $replicationgroups)
{
 
    # Exclude first and last two lines as junk, and exclude the domain system volume
    if (($i -ge 1) -and ($i -le $imax) -and ($replicationgroup -notlike "*domain system volume*"))
    {
        # Format replication group name
        $replicationgroup = $replicationgroup.split(" ");
        $replicationgroup[-1] = "";
        $replicationgroup = ($replicationgroup.trim() -join " ").trim();
 
        # Get and format replication folder name
        $replicationfolder = & cmd /c ("dfsradmin rf list /rgname:`"{0}`"" -f $replicationgroup);
        $replicationfolder = (($replicationfolder[1].split("\"))[0]).trim();
 
        # Get servers for the current replication group
        $replicationservers = & cmd /c ("dfsradmin conn list /rgname:`"{0}`"" -f $replicationgroup);
 
        # Reduce loop by 3 lines to filter out junk from dfsradmin 
        $j = 0;
        $jmax = ($replicationservers.count -3);
 
        # Loop through each replication member server
        foreach ($replicationserver in $replicationservers)
        {
            # Exclude first and last two lines as junk
            if (($j -ge 1) -and ($j -le $jmax))
            {
                # Format server names
                $sendingserver = ($replicationserver.split(" "))[0].trim();
                $receivingserver = ($replicationserver.split(" "))[2].trim();
 
                # Get backlog count with dfsrdiag
                $backlog = & cmd /c ("dfsrdiag backlog /rgname:`"{0}`" /rfname:`"{1}`" /smem:{2} /rmem:{3}" -f $replicationgroup, $replicationfolder, $sendingserver,  $receivingserver);

                $backlogcount = ($backlog[1]).split(":")[1];
 
                # Format backlog count
                if ($backlogcount -ne $null) {

                    $backlogcount = $backlogcount.trim();
                }
                else {
                    
                    $backlogcount = 0;
                }
 
                # Create output string to <replication group> <replication folder> <sending server> <receiving server> <backlog count>;
                #$outline = $replicationgroup + " Folder: " + $replicationfolder + " From: " + $sendingserver + " To: " + $receivingserver + " Backlog: " + $backlogcount;
		$replicationgroup = getValidValue($replicationgroup);
		$replicationfolder = getValidValue($replicationfolder);
		$sendingserver = getValidValue($sendingserver);
		$receivingserver = getValidValue($receivingserver);
		$backlogcount = getValidValue($backlogcount);

		Write-Host ($replicationgroup, $replicationfolder, $sendingserver, $receivingserver, $backlogcount) -Separator "#@#"
             }
            $j = $j + 1;
        }
    }
    $i = $i + 1;
}


function getValidValue($givenValue)
{
	$validValue = $givenValue;
	if(($givenValue -eq $null) -or ($givenValue.trim().Length == 0))
	{
		$validValue = "-";
	}
	return $validValue;
}


