# The following is a Hash Table containing information used to 
# map the Apple Device User Agent to it's corresponding iOS version (pre iOS 6)
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$iOSVersions=@{"508.11"="iOS 2.2.1";
		"701.341"="iOS 3.0.0";
		"701.400"="iOS 3.0.1";
		"702.367"="iOS 3.2";
		"702.405"="iOS 3.21";
		"702.5"="iOS 3.3";
		"703.144"="iOS 3.1";
		"704.11"="iOS 3.1.2";
		"705.18"="iOS 3.1.3";
		"801.293"="iOS 4.0.0";
		"801.306"="iOS 4.0.1";
		"801.400"="iOS 4.0.2";
		"802.117"="iOS 4.1";
		"803.148"="iOS 4.2.1";
		"806.190"="iOS 4.3";
		"806.191"="iOS 4.3";
		"807.4"="iOS 4.3.1";
		"808.7"="iOS 4.3.2";
		"810.2"="iOS 4.3.3";
		"811.2"="iOS 4.3.4";
		"812.1"="iOS 4.3.5";
		"901.334"="iOS 5";
		"901.403"="iOS 5.0.1";
		"901.405"="iOS 5.0.1";
        "901.406"="iOS 5.0.1";
        "902.176"="iOS 5.1";
        "902.179"="iOS 5.1";
        "902.206"="iOS 5.1.1"};

# Retrieve mailboxes of users who have a connected ActiveSync Device
$CASMailboxes = Get-CASMailbox -Filter {hasactivesyncdevicepartnership -eq $true -and -not displayname -like "CAS_{*"} -ResultSize Unlimited;
[array]$Mailboxes = $CASMailboxes | Get-Mailbox
# Perform a set of actions against each mailbox retrieved 
foreach ($Mailbox in $Mailboxes)
{
	# Retrieve the ActiveSync Device Statistics for the associated user mailbox
	[array]$ActiveSyncDeviceStatistics = Get-ActiveSyncDeviceStatistics -Mailbox $Mailbox.Identity
	# Use the information retrieved above to store information one by one about each ActiveSync Device
	foreach ($Device in $ActiveSyncDeviceStatistics)
	{
		$iOSVersion = $null;
		$iOSVersion = $Device.DeviceOS;
        $iOSModel = $Device.DeviceFriendlyName;
        # First check if it's iOS 6 or higher, which reports the iOS version:
        # Where possible use the information stored in the Device User Agent to understand the iOS device version in use
    	if ($Device.DeviceOS -notlike "iOS*" -and $Device.DeviceUserAgent -like "*/*") 
        {
        	$rawiOSVersion = ($Device.DeviceUserAgent).Substring(($Device.DeviceUserAgent).IndexOf("/")+1);
    		if ($iOSVersions[$rawiOSVersion])
    		{
    			$iOSVersion = $iOSVersions[$rawiOSVersion];
    		}
    		$iOSModel = $Device.DeviceModel;
        }
		
		if ($iOSVersion)
        {
    		$username = $Mailbox.UserPrincipalName
			$displayname = $Mailbox.DisplayName
			$devicetype = $Device.DeviceType
			$devicemodel = $iOSModel
			$version = $iOSVersion
			$deviceid = $Device.DeviceID
			$status = $Device.Status
			$devicepolicyapplied = $Device.DevicePolicyApplied
			$devicepolicyapplicationstatus = $Device.DevicePolicyApplicationStatus
			$lastsuccesssync = $Device.LastSuccessSync
			$lastsyncattempttime = $Device.LastSyncAttemptTime
			$lastpolicyupdatetime = $Device.LastPolicyUpdateTime
			$firstsynctime = $Device.FirstSyncTime
			Write-Host ($username,$displayname,$devicetype,$devicemodel,$version,$deviceid,$status,$devicepolicyapplied,$devicepolicyapplicationstatus,$lastsuccesssync,$lastsyncattempttime,$lastpolicyupdatetime,$firstsynctime) -Separator ";"
		}
	}
}
