﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy


$testargs=$args
$Rptcrds=$testargs[0].split("#")
$reportingname='MTM/'+$Rptcrds[0]
$testFrequency=$Rptcrds[1]
	
$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
$pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp

$CultureDateTimeFormat = (Get-Culture).DateTimeFormat
$DateFormat = $CultureDateTimeFormat.ShortDatePattern
$TimeFormat = $CultureDateTimeFormat.LongTimePattern
$DateTimeFormat = "$DateFormat $TimeFormat"
$hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt').Trim()
if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}

try{
    $readFilePath=$egurkhaPath+'/agent/'+$reportingname+'/'
    if(!(Test-Path -Path $readFilePath )){
       $null =  New-Item -ItemType directory -Path $readFilePath -WarningAction SilentlyContinue
    }
    $fileRead=Get-ChildItem -Path $readFilePath |Where-Object {$_.Name -like 'MTDAuditOper*.dat'}| Sort-Object LastWriteTime -Descending | Select-Object -first 1|Select Name
    if($fileRead){
	    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "MTDAuditOper" -keyFileName "kMTDAuditOper" -EgPath $egurkhaPath
        if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
    	    $datafile=$readfiles[1] -replace (".csv",".dat") 
    	    $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]
    	    $usractivites= import-csv $csvfile -Encoding $encTyp | Where-Object { $_.RecordType -eq 'MicrosoftTeams' -and $_.Operations -eq 'TeamsSessionStarted'} | select CreationDate,UserIds | Sort-Object { Eg-ParseExact -dateStr $_.CreationDate -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt } -Descending

    	    Remove-Item $csvfile       
    	    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'MTDAuditOper' -InputFile $readfiles[3]
    	    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kMTDAuditOper' -InputFile $readfiles[4]
    	    Write-Host "ReadFile:"$readfiles[3]
        }
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}
[System.GC]::GetTotalMemory($true) | out-null
$latestUsrlogins=@{}
if($usractivites)
{
    foreach($usrlogin in $usractivites)
    {
        if(!$latestUsrlogins[$usrlogin.UserIds])
        {
          try{
            #$UsrCrtionDate=EG-GetCultureDateTime -inpDatStr $usrlogin.CreationDate
            $inpDatStr=([String]$usrlogin.CreationDate).Trim()
            if($inpDatStr -ne $null -and $inpDatStr -ne ''){
                $UsrCrtionDate=Eg-ParseExact -dateStr $inpDatStr -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
            } 
          }
          catch{
              $exceptionmsg=($_.Exception.Message)+($_.ScriptStackTrace) 
	          Write-error "Error Occured in Teams User logins Test --  $exceptionmsg"
              $UsrCrtionDate=$usrlogin.CreationDate
          }
          $latestUsrlogins[$usrlogin.UserIds]=$UsrCrtionDate  
          Write-Host 'userlogin#' $usrlogin.UserIds ~!~ $UsrCrtionDate
        }
    }

}
[System.GC]::GetTotalMemory($true) | out-null

