﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy


$testargs=$args
$Rptcrds=$testargs[0].split("#")
$reportingname='MTM/'+$Rptcrds[0]
$testFrequency=$Rptcrds[1]

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

try{
    $readFilePath=$egurkhaPath+'/agent/'+$reportingname+'/'
    if(!(Test-Path -Path $readFilePath )){
       $null =  New-Item -ItemType directory -Path $readFilePath -WarningAction SilentlyContinue
    }
    $fileRead=Get-ChildItem -Path $readFilePath |Where-Object {$_.Name -like 'MTMdAuditOper*.dat'}| Sort-Object LastWriteTime -Descending | Select-Object -first 1|Select Name
    if($fileRead){
        $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "MTMdAuditOper" -keyFileName "kMTMdAuditOper" -EgPath $egurkhaPath
        if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
            $datafile=$readfiles[1] -replace (".csv",".dat") 
            $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
            $usractivites= import-csv $csvfile -Encoding $encTyp
            Remove-Item $csvfile       
            Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'MTMdAuditOper' -InputFile $readfiles[3]
            Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kMTMdAuditOper' -InputFile $readfiles[4]
            Write-Host "ReadFile:"$readfiles[3]
        }
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}
[System.GC]::GetTotalMemory($true) | out-null
$botsAdditnCnt=0
$botsRemvedCnt=0
$chanlsAddtionCnt=0
$chanlsDeltionsCnt=0
$teamCreatedCnt=0
$CnnctorAddsToChnlCnt=0
$TabAddedtoChnlCnt=0
$ConnctorRmvdToChnlCnt=0
$TabRmvedtoChnlCnt=0
$ConnctorModifdInChnlCnt=0
$TabModifdInChnlCnt=0
$empty=''

$BotAdded_Hash=@{}
$ChnlAdded_Hash=@{}
$ChnlDeleted_Hash=@{}
$BotRemoved_Hash=@{}
$TeamCreated_Hash=@{}
$CnctrAdded_Hash=@{}
$TabAdded_Hash=@{}
$CnctrRemoved_Hash=@{}
$TabRemoved_Hash=@{}
$TabUpdated_Hash=@{}
$CnctrUpdated_Hash=@{}

foreach($input in $usractivites){

    $operation=$input.Operations
    $auditdata=$input.AuditData | ConvertFrom-Json
    $auditdata.CreationTime=($auditdata.CreationTime).Replace("T"," ")
    $usertype=[int]$auditdata.UserType
    if($usertype -eq 0) { $auditdata.UserType ="Regular user" }
    if($usertype -eq 2) { $auditdata.UserType ="Administrator" }
    if($usertype -eq 3) { $auditdata.UserType ="Microsoft datacenter administrator" }
    if($usertype -eq 4) { $auditdata.UserType ="System Account" }
    if($usertype -eq 5) { $auditdata.UserType ="An Application" }
    if($usertype -eq 6) { $auditdata.UserType ="Service principal" }
    if($usertype -eq 7) { $auditdata.UserType ="Custom policy" }
    if($usertype -eq 8) { $auditdata.UserType ="System policy" }        

    if($operation -eq 'BotAddedToTeam'){           
        $BotAddedkey=$auditdata.CreationTime+'#'+$auditdata.TeamName
        if(!$BotAdded_Hash.ContainsKey($BotAddedkey) -or $BotAdded_Hash.Count -eq 0){
            $BotAddedDD='BotAddedToTeamdd#'+$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$empty+'~!~'+$auditdata.AddOnName+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid+'~!~'+$empty+'~!~'+$auditdata.AddOnGuid
            $BotAdded_Hash.Add($BotAddedkey,$BotAddedDD)
            $botsAdditnCnt++
        }
    }        

    if($operation -eq 'ChannelAdded'){  
        $ChnlAddedkey=$auditdata.CreationTime+'#'+$auditdata.TeamName+'#'+$auditdata.ChannelName
        if(!$ChnlAdded_Hash.ContainsKey($ChnlAddedkey) -or $ChnlAdded_Hash.Count -eq 0){
            $ChnlAddedDD='ChannelAddeddd#'+$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$auditdata.ChannelName+'~!~'+$empty+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid+'~!~'+$auditdata.ChannelGuid
            $ChnlAdded_Hash.Add($ChnlAddedkey,$ChnlAddedDD)
            $chanlsAddtionCnt++
        }             
    }
        
    if($operation -eq 'ChannelDeleted'){  
        $ChnlDeletedkey=$auditdata.CreationTime+'#'+$auditdata.TeamName+'#'+$auditdata.ChannelName
        if(!$ChnlDeleted_Hash.ContainsKey($ChnlDeletedkey) -or $ChnlDeleted_Hash.Count -eq 0){
            $ChnlDeletedDD='ChannelDeleteddd#'+$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$auditdata.ChannelName+'~!~'+$empty+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid+'~!~'+$auditdata.ChannelGuid
            $ChnlDeleted_Hash.Add($ChnlDeletedkey,$ChnlDeletedDD)
            $chanlsDeltionsCnt++ 
        }     
    }
        
    if($operation -eq 'BotRemovedFromTeam'){  
        $BotRemovedkey=$auditdata.CreationTime+'#'+$auditdata.TeamName
        if(!$BotRemoved_Hash.ContainsKey($BotRemovedkey) -or $BotRemoved_Hash.Count -eq 0){
            $BotRemovedDD='BotRemovedFromTeamdd#'+$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$empty+'~!~'+$auditdata.AddOnName+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid+'~!~'+$empty+'~!~'+$auditdata.AddOnGuid
            $BotRemoved_Hash.Add($BotRemovedkey,$BotRemovedDD)
            $botsRemvedCnt++ 
        }
    }
        
    if($operation -eq 'TeamCreated'){
        $tmCreatedDD='TeamCreateddd#'+$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$empty+'~!~'+$empty+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid
        $tmCreatedKey=$auditdata.CreationTime+'#'+$auditdata.TeamName
        if(!$TeamCreated_Hash.ContainsKey($tmCreatedKey) -or $TeamCreated_Hash.Count -eq 0){
            $TeamCreated_Hash.Add($tmCreatedKey,$tmCreatedDD)
            $teamCreatedCnt++
        }
    }
       
    if($operation -eq 'ConnectorAdded'){
        $CnctrAdded_Key=$auditdata.CreationTime+'#'+$auditdata.TeamName+'#'+$auditdata.ChannelName
        if(!$CnctrAdded_Hash.ContainsKey($CnctrAdded_Key) -or $CnctrAdded_Hash.Count -eq 0){
            $CnctrAdded_DD='ConnectorAddeddd#'+$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$auditdata.ChannelName+'~!~'+$auditdata.AddOnName+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid+'~!~'+$auditdata.ChannelGuid+'~!~'+$auditdata.AddOnGuid
            $CnctrAdded_Hash.Add($CnctrAdded_Key,$CnctrAdded_DD)
            $CnnctorAddsToChnlCnt++
        }  
    }

    if($operation -eq 'TabAdded'){
        $TabAdded_Key=$auditdata.CreationTime+'#'+$auditdata.TeamName+'#'+$auditdata.ChannelName
        if(!$TabAdded_Hash.ContainsKey($TabAdded_Key) -or $TabAdded_Hash.Count -eq 0){
            $TabAdded_DD='TabAddeddd#'+$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$auditdata.ChannelName+'~!~'+$auditdata.TabType+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid+'~!~'+$auditdata.ChannelGuid+'~!~'+$auditdata.AddOnGuid
            $TabAdded_Hash.Add($TabAdded_Key,$TabAdded_DD)
            $TabAddedtoChnlCnt++
        }  
    }

    if($operation -eq 'ConnectorRemoved'){
        $CnctrRemoved_Key=$auditdata.CreationTime+'#'+$auditdata.TeamName+'#'+$auditdata.ChannelName
        if(!$CnctrRemoved_Hash.ContainsKey($CnctrRemoved_Key) -or $CnctrRemoved_Hash.Count -eq 0){
            $CnctrRemoved_DD='ConnectorRemoved#'+$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$auditdata.ChannelName+'~!~'+$auditdata.AddOnName+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid+'~!~'+$auditdata.ChannelGuid+'~!~'+$auditdata.AddOnGuid
            $CnctrRemoved_Hash.Add($CnctrRemoved_Key,$CnctrRemoved_DD)
            $ConnctorRmvdToChnlCnt++
        }
    }

    if($operation -eq 'TabRemoved'){
        $TabRemoved_Key=$auditdata.CreationTime+'#'+$auditdata.TeamName+'#'+$auditdata.ChannelName
        if(!$TabRemoved_Hash.ContainsKey($TabRemoved_Key) -or $TabRemoved_Hash.Count -eq 0){
            $TabRemoved_DD='TabRemoveddd#'+$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$auditdata.ChannelName+'~!~'+$auditdata.TabType+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid+'~!~'+$auditdata.ChannelGuid+'~!~'+$auditdata.AddOnGuid
            $TabRemoved_Hash.Add($TabRemoved_Key,$TabRemoved_DD)
            $TabRmvedtoChnlCnt++
        }
    }
        
    if($operation -eq 'TabUpdated'){
        $TabUpdated_Key=$auditdata.CreationTime+'#'+$auditdata.TeamName+'#'+$auditdata.ChannelName
        if(!$TabUpdated_Hash.ContainsKey($TabUpdated_Key) -or $TabUpdated_Hash.Count -eq 0){

            foreach($keyvalue in $auditdata.ExtraProperties)
            {
                if($keyvalue.key -eq "OldAddOnGuid"){$OldAddOnGuid = $keyvalue.Value}
                if($keyvalue.key -eq "OldTabType"){$OldTabType = $keyvalue.Value}
            }
            $TabUpdated_DD='TabUpdateddd#'+$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$auditdata.ChannelName+'~!~'+$auditdata.TabType+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid+'~!~'+$auditdata.ChannelGuid+'~!~'+$auditdata.AddOnGuid+'~!~'+$OldAddOnGuid+'~!~'+$OldTabType
            $TabUpdated_Hash.Add($TabUpdated_Key,$TabUpdated_DD)
            $TabModifdInChnlCnt++
        }
    }
       
    if($operation -eq 'ConnectorUpdated'){
        #$CnctrUpdated_Hash
        $CnctrUpdated_Key=$auditdata.CreationTime+'#'+$auditdata.TeamName+'#'+$auditdata.ChannelName
        if(!$CnctrUpdated_Hash.ContainsKey($CnctrUpdated_Key) -or $CnctrUpdated_Hash.Count -eq 0){
            $CnctrUpdated_DD='ConnectorUpdated#'+$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$auditdata.ChannelName+'~!~'+$auditdata.AddOnName+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid+'~!~'+$auditdata.ChannelGuid+'~!~'+$auditdata.AddOnGuid
            $CnctrUpdated_Hash.Add($CnctrUpdated_Key,$CnctrUpdated_DD)
            $ConnctorModifdInChnlCnt++
        }
    }
}


foreach($ddStr in $BotAdded_Hash.Keys){
    Write-Host $BotAdded_Hash[$ddStr]
}

foreach($ddStr in $ChnlAdded_Hash.Keys){
    Write-Host $ChnlAdded_Hash[$ddStr]
}

foreach($ddStr in $ChnlDeleted_Hash.Keys){
    Write-Host $ChnlDeleted_Hash[$ddStr]
}

foreach($ddStr in $BotRemoved_Hash.Keys){
    Write-Host $BotRemoved_Hash[$ddStr]
}

foreach($ddStr in $TeamCreated_Hash.Keys){
    Write-Host $TeamCreated_Hash[$ddStr]
}

foreach($ddStr in $CnctrAdded_Hash.Keys){
    Write-Host $CnctrAdded_Hash[$ddStr]
}

foreach($ddStr in $TabAdded_Hash.Keys){
    Write-Host $TabAdded_Hash[$ddStr]
}

foreach($ddStr in $CnctrRemoved_Hash.Keys){
    Write-Host $CnctrRemoved_Hash[$ddStr]
}

foreach($ddStr in $TabRemoved_Hash.Keys){
    Write-Host $TabRemoved_Hash[$ddStr]
}

foreach($ddStr in $TabUpdated_Hash.Keys){
    Write-Host $TabUpdated_Hash[$ddStr]
}

foreach($ddStr in $CnctrUpdated_Hash.Keys){
    Write-Host $CnctrUpdated_Hash[$ddStr]
}

Write-host 'measures'$botsAdditnCnt ~ $botsRemvedCnt ~ $chanlsAddtionCnt ~ $chanlsDeltionsCnt ~ $teamCreatedCnt ~ $CnnctorAddsToChnlCnt ~ $TabAddedtoChnlCnt ~ $ConnctorRmvdToChnlCnt ~ $TabRmvedtoChnlCnt ~ $ConnctorModifdInChnlCnt ~ $TabModifdInChnlCnt
[System.GC]::GetTotalMemory($true) | out-null