﻿##/*****************************************************************************
##Author                :               Guravareddy.T
##Purpose               :               O365 Dynamic Distribution Groups Types And ount
##Created               :               11/1/2017
##Modified By		: 
##/*****************************************************************************
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy


$testargs=$args
$reportingname='EXO/'+$testargs[0]
$testFrequency=$testargs[1]

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
$pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp

function Convert-UnixTime {
 
Param(
[Parameter(Mandatory=$true)][int32]$udate
) 
    # Retrieve start of UNIX Format
    $orig = (Get-Date -Year 1970 -Month 1 -Day 1 -hour 0 -Minute 0 -Second 0 -Millisecond 0) 
    # Return final time
    return $orig.AddSeconds($udate)
}
    $CultureDateTimeFormat = (Get-Culture).DateTimeFormat
    $DateFormat = $CultureDateTimeFormat.ShortDatePattern
    $TimeFormat = $CultureDateTimeFormat.LongTimePattern
    $DateTimeFormat = "$DateFormat $TimeFormat"
    $hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt').Trim()
    if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}
try{
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "dynamicdistgroups" -keyFileName "kdynamicdistgroups" -EgPath $egurkhaPath
    if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
        $datafile=$readfiles[1] -replace (".csv",".dat") 
        $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
        $recipnt= import-csv $csvfile -Encoding $encTyp
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'dynamicdistgroups' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kdynamicdistgroups' -InputFile $readfiles[4]
        Write-Host "ReadFile:"$readfiles[3]
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}
    [System.GC]::GetTotalMemory($true) | out-null
        try{
            $datpos = $readfiles[3].IndexOf(".dat")
	        $length='dynamicdistgroups'.Length  
            $tmpvalue = $readfiles[3].toString().substring($length,($datpos-$length))
    		$readtime= Convert-UnixTime $tmpvalue
    		$readfiledif=NEW-TIMESPAN –Start $readtime –End (Get-Date) | Select-Object TotalMinutes
    		$dfnmb=[int]($readfiledif.TotalMinutes/(-$testFrequency))
    		$dfnmb=$dfnmb+1
    	}
    	catch{
    		$dfnmb=1
    	}
    $LastMsmtTime = ((Get-Date).AddMinutes($dfnmb*($testfrequency))).ToUniversalTime()



    try{
        $filepath=$egurkhaPath+'/agent/'+$reportingname+'/'
	    $fileread2=Get-ChildItem -Path $filepath |Where-Object {$_.Name -like 'dynamicdistgroups*.dat'}| Sort-Object LastWriteTime -Descending | Select-Object -index 1|Select Name
        if($fileread2 -ne $null){
	        $filepath2=$filepath+$fileread2.Name
	        $datpos = $fileread2.name.IndexOf(".dat")
	        $length='dynamicdistgroups'.Length
	        $tmpvalue = $fileread2.name.toString().substring($length,($datpos-$length)) 
	        $kfileval2 = "kdynamicdistgroups"+$tmpvalue+".dat"
   	        $kfile2=Get-ChildItem -Path $filepath |Where-Object {$_.Name -eq $kfileval2}| Sort-Object LastWriteTime -Descending | Select-Object -first 1|Select Name
	        $kfilename2=([String]$kfile2.Name).Trim()
	        $kvalue2=Get-Content -Path $filepath$kfilename2 -Encoding $encTyp
	        $decrypPath2=$filepath2 -replace (".csv",".dat") 
	        $recpFile2=Unprotect-File $decrypPath2 -Algorithm AES -KeyAsPlainText $kvalue2	
	        $recipnt2= import-csv $recpFile2 -Encoding $encTyp
            if([System.IO.File]::Exists($recpFile2) -eq 'True'){
	            Remove-Item $recpFile2
            }
        }
    }
    catch{
    $recpFile2=""
        $errmsg=$_.Exception.Message
        Write-Host $errmsg
    }

	$dycdsbgrp_changedcnt =0
	$dycdsbgrp_createdcnt =0
	$dycdsbgrp_totalcnt =0
	$dycdsbgrp_orphancnt =0
	$dycdsbgrp_emptycnt =0
	$dycdsbgrp_softdeletcnt=0


	foreach($total in $recipnt)
	{
	    $totChangedUTC=([String]$total.WhenChangedUTC.Replace('??','')).Trim()
        $totCreatedUTC=([String]$total.WhenCreatedUTC.Replace('??','')).Trim()
    try{
        if($totChangedUTC -ne $null -and $totChangedUTC -ne ''){
            $total.WhenChangedUTC=Eg-ParseExact -dateStr $totChangedUTC -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
        }
        if($totCreatedUTC -ne $null -and $totCreatedUTC -ne ''){
            $total.WhenCreatedUTC=Eg-ParseExact -dateStr $totCreatedUTC -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
        }
        }catch{
            $exp=$_.Exception.Message
            Write-Error 'error occures while changing data format in 1st loop' $exp 
        }
            if($total.WhenSoftDeleted -eq "" -or $total.WhenSoftDeleted -eq $null)
            {
	        $dycdsbgrp_totalcnt++
            }
	    $status=$total.isvalid
	    if($status -eq 'True')
	    {
		$status='Active'
	    }
	    else
	    {
		 $status='Inactive'
	    }

	    if($total.ManagedBy -eq "" -or  $total.ManagedBy -eq $Null) 
	    {
		Write-Host 'dycdsbgrp_orphnedgrps##'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status '~!~' $total.GroupMemberscount '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		$dycdsbgrp_orphancnt++
	    }


	    if ($total.WhenChangedUTC -ne "" -and [DateTime]($total.WhenChangedUTC) -gt $LastMsmtTime)  
	    {
		Write-Host 'dycdsbgrp_changedutc##'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status '~!~' $total.GroupMemberscount '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		$dycdsbgrp_changedcnt++
	    }

	    if ($total.WhenCreatedUTC -ne "" -and [DateTime]($total.WhenCreatedUTC) -gt $LastMsmtTime)  
	    {
		Write-Host 'dycdsbgrp_createdutc##'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status '~!~' $total.GroupMemberscount '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		$dycdsbgrp_createdcnt++
	    }
	    if ($total.GroupMemberscount -eq 0)
	    {
		Write-Host 'dycdsbgrp_emptygrps##'$total.DisplayName'~!~'$total.PrimarySmtpAddress'~!~'$total.Alias'~!~'$status '~!~' '-5' '~!~'$total.WhenChangedUTC'~!~'$total.WhenCreatedUTC
		$dycdsbgrp_emptycnt++
	    }
        
	}
    if($recipnt2 -ne "" -and $recipnt2 -ne $null){
      foreach($total2 in $recipnt2)
      {
	    $tot2ChangedUTC=([String]$total2.WhenChangedUTC.Replace('??','')).Trim()
        $tot2CreatedUTC=([String]$total2.WhenCreatedUTC.Replace('??','')).Trim()
        try{
            if($tot2ChangedUTC -ne $null -and $tot2ChangedUTC -ne ''){
                $total2.WhenChangedUTC=Eg-ParseExact -dateStr $tot2ChangedUTC -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
            }
            if($tot2CreatedUTC -ne $null -and $tot2CreatedUTC -ne ''){
                $total2.WhenCreatedUTC=Eg-ParseExact -dateStr $tot2CreatedUTC -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
            }
        }catch{
        $excp=$_.Exception.Message
        Write-Error 'error occures while changing data format in 2nd loop' $excp
        }

        $status=$total2.isvalid
	    if($status -eq 'True')
	    {
		$status='Active'
	    }
	    else
	    {
		 $status='Inactive'
	    }        
        $smtpadrs=$total2.PrimarySmtpAddress
        $bolean=$false
        foreach($total in $recipnt)
	    {
        
            if($smtpadrs -eq $total.PrimarySmtpAddress)
            {
                $bolean=$true
	        }
        }

        if($recipnt2 -ne "" -and $recipnt2 -ne $null -and $bolean -eq $false)
        {
            Write-Host 'dycdsbgrp_softdeleted##'$total2.DisplayName'~!~'$total2.PrimarySmtpAddress'~!~'$total2.Alias'~!~'$status '~!~' $total2.GroupMemberscount '~!~'$total2.WhenChangedUTC'~!~'$total2.WhenCreatedUTC
	        $dycdsbgrp_softdeletcnt++
	    }
       }
     }

	Write-Host 'dycdsbgrp_changedcnt' $dycdsbgrp_changedcnt 
	Write-Host 'dycdsbgrp_createdcnt' $dycdsbgrp_createdcnt 
	Write-Host 'dycdsbgrp_TotalCount' $dycdsbgrp_totalcnt 
	Write-Host 'dycdsbgrp_ownlesscount' $dycdsbgrp_orphancnt 
	Write-Host 'dycdsbgrp_membcount' $dycdsbgrp_emptycnt 
	Write-Host 'dycdsbgrp_softcount' $dycdsbgrp_softdeletcnt 
[System.GC]::GetTotalMemory($true) | out-null