﻿##/******************************************************************************************
##Author                :     MohanRaj S
##Purpose               :     Display the License available in O365 and their License details
##Created               :     06/12/2017
##Modified By		    :     Prabaharan.T

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear
#<#
$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$RptnameProxyhost=($TestInputs[4]).ToString().Split("#")
$reportingNam=$RptnameProxyhost[0]
$proxyserverip=($RptnameProxyhost[1]).ToString().trim()
$appDetails=$TestInputs[5]
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
#>

$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
$pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }

Try{
    $cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)

    if(!$proxyserverip.Contains('none')){
        $proxyserver='http://'+$proxyserverip
        [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
        if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
            $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
            [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
            [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
        }
     }


    if($appDetails -and $appDetails -ne 'none'){
        $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName 
    }else{
    	Connect-MsolService -Credential $cred -AzureEnvironment $azureEnvArr[0]
    }
    $subercnt = 0
    $msolaccnt = 0
    $rptPath='O365/'+$reportingNam

    #---------------START CMDLET------------------
    Try{
        $writmsolacc = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365msolAccsku" -keyFileName "kO365msolAccsku" -EgPath $egurkhaPath
        if($appDetails -and $appDetails -ne 'none'){
            Get-AzureADSubscribedSku | Select-Object -Property @{Name='AccountSkuID';Expression={$_.SkuPartNumber }},@{Name='SkuID';Expression={$_.SkuId}},@{Name='ActiveUnits';Expression={$_.PrepaidUnits.Enabled}},@{Name='ConsumedUnits';Expression={$_.ConsumedUnits}},@{Name='WarningUnits';Expression={$_.PrepaidUnits.Warning}}|Export-Csv $writmsolacc[1] -Encoding $encTyp
        }else{
		Get-MsolAccountSku |select AccountSkuID,SkuID,ActiveUnits,ConsumedUnits,WarningUnits |Export-Csv $writmsolacc[1] -Encoding $encTyp
	}
        $null=Protect-File  $writmsolacc[1] -Algorithm AES -KeyAsPlainText $writmsolacc[0] -RemoveSource
    }Catch{
        $exceptionmsg=($_.Exception.Message)+($_.ScriptStackTrace) 
	    Write-Error $exceptionmsg
    }

    Try{
        $readmsolacc=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365msolAccsku" -keyFileName "kO365msolAccsku" -EgPath $egurkhaPath
        if($readmsolacc -ne $null -and [System.IO.File]::Exists($readmsolacc[1]) -eq 'True'){
            $unProtctMUsr=$readmsolacc[1] -replace (".csv",".dat") 
            $msolaccPath=Unprotect-File $unProtctMUsr -Algorithm AES -KeyAsPlainText $readmsolacc[0]	
            $MsolAccountSkus= import-csv $msolaccPath -Encoding $encTyp
            Remove-Item $msolaccPath

            Eg-DeleteFiles -FilePath $readmsolacc[2] -Pattern 'O365msolAccsku' -InputFile $readmsolacc[3]
            Eg-DeleteFiles -FilePath $readmsolacc[2] -Pattern 'kO365msolAccsku' -InputFile $readmsolacc[4]
        }
    }
    Catch{
        $errmsg=$_.Exception.Message
        Write-Error -Message $errmsg
    }
    [System.GC]::GetTotalMemory($true) | out-null

    #---------------START CMDLET------------------
    if(!$appDetails -or $appDetails -eq 'none'){
        Try{
            $writmsolsub = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365msolsub" -keyFileName "kO365msolsub" -EgPath $egurkhaPath
            Get-MsolSubscription |  select DateCreated,SkuId,OwnerObjectId,NextLifecycleDate,Status,IsTrial,TotalLicenses |Export-Csv $writmsolsub[1] -Encoding $encTyp
            $null=Protect-File  $writmsolsub[1] -Algorithm AES -KeyAsPlainText $writmsolsub[0] -RemoveSource
        }Catch{
            $exceptionmsg=($_.Exception.Message)+($_.ScriptStackTrace) 
	        Write-Error $exceptionmsg
        }

        Try{
            $readmsolsub=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365msolsub" -keyFileName "kO365msolsub" -EgPath $egurkhaPath
            if($readmsolsub -ne $null -and [System.IO.File]::Exists($readmsolsub[1]) -eq 'True'){
                $unProtctMUsr=$readmsolsub[1] -replace (".csv",".dat") 
                $msolsubPath=Unprotect-File $unProtctMUsr -Algorithm AES -KeyAsPlainText $readmsolsub[0]	
                $suber= import-csv $msolsubPath -Encoding $encTyp
                Remove-Item $msolsubPath

                Eg-DeleteFiles -FilePath $readmsolsub[2] -Pattern 'O365msolsub' -InputFile $readmsolsub[3]
                Eg-DeleteFiles -FilePath $readmsolsub[2] -Pattern 'kO365msolsub' -InputFile $readmsolsub[4]
            }
        }
        Catch{
            $errmsg1=$_.Exception.Message
            Write-Error -Message $errmsg1
        }
        [System.GC]::GetTotalMemory($true) | out-null
    }
    #---------------START CMDLET------------------
    <#
    Try{
        $writmsolLUsr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
        Get-MsolUser -All |select IsLicensed,Licenses| ForEach-Object {$val=$_.Licenses.AccountSkuId -join '~';$_ | Add-Member -MemberType NoteProperty -Name 'AccId' -Value $val -PassThru} | Export-Csv -Path $writmsolLUsr[1]
        $null=Protect-File  $writmsolLUsr[1] -Algorithm AES -KeyAsPlainText $writmsolLUsr[0] -RemoveSource
    }Catch{Write-Host $_.Exception.Message}
    #>
    try{
        $readmsolLUsr=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
        if($readmsolLUsr -ne $null -and [System.IO.File]::Exists($readmsolLUsr[1]) -eq 'True'){
            $unProtctLUsr=$readmsolLUsr[1] -replace (".csv",".dat") 
            $mlUsrPath=Unprotect-File $unProtctLUsr -Algorithm AES -KeyAsPlainText $readmsolLUsr[0]	
            $mlicUser= import-csv $mlUsrPath -Encoding $encTyp
            Remove-Item $mlUsrPath

            Eg-DeleteFiles -FilePath $readmsolLUsr[2] -Pattern 'O365msolUsr' -InputFile $readmsolLUsr[3]
            Eg-DeleteFiles -FilePath $readmsolLUsr[2] -Pattern 'kO365msolUsr' -InputFile $readmsolLUsr[4]
        }
        [System.GC]::GetTotalMemory($true) | out-null
    }
    catch{
        $errmsg_msol=$_.Exception.Message
		Write-Error -Message $errmsg_msol
    }

    $CultureDateTimeFormat = (Get-Culture).DateTimeFormat
    $DateFormat = $CultureDateTimeFormat.ShortDatePattern
    $TimeFormat = $CultureDateTimeFormat.LongTimePattern
    $DateTimeFormat = "$DateFormat $TimeFormat"
    $hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt').Trim()
    if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}
    
    foreach($licnt in $MsolAccountSkus){
      $msolaccnt ++
    }
    
    if(!$appDetails -or $appDetails -eq 'none'){
        foreach($cnt in $suber){
            $subercnt ++
        }
        $SubscrCount = $subercnt
    }
    $LicCount = $msolaccnt
        for($i=0; $i -lt $LicCount; $i++){
            $AccountSkuID = $MsolAccountSkus[$i].AccountSkuID
            $SkuID = $MsolAccountSkus[$i].SkuID
            $ActiveUnits = $MsolAccountSkus[$i].ActiveUnits
            $ConsumedUnits = $MsolAccountSkus[$i].ConsumedUnits
            $WarningUnits = $MsolAccountSkus[$i].WarningUnits
            $LicUsers = $mlicUser | where {$_.IsLicensed -eq $True -and $_.AccId -like '*'+$AccountSkuID+'*'} | select IsLicensed                
            $LicUsersCount = 0
            if($LicUsers -and $LicUsers.Count -gt 0){
                $LicUsersCount=$LicUsers.Count
            }
            if(!$appDetails -or $appDetails -eq 'none'){
        for($j=0; $j -lt $SubscrCount; $j++){
            $SubscrSKUID = $suber[$j].SkuID 
            if($SubscrSKUID -eq $SkuID){  
                $SubscrStatus= $suber[$j].Status
                $SubscrTrial = $suber[$j].IsTrial
                $SubscrTotal = $suber[$j].TotalLicenses
                $Subscrdate = $suber[$j].NextLifecycleDate
                if($Subscrdate -eq $null){
                    $Subscrdate=0
                }
                $ishavExpireDat= $false
                    if($Subscrdate -ne $null -and $Subscrdate -ne ''){
                        $ishavExpireDat=$true
                        $tempdate=([String]$suber[$j].NextLifecycleDate).Trim()
			            if($tempdate-ne $null -and $tempdate -ne ''){
                            if($tempdate.Length -gt 11){
                                $StartDate =Eg-ParseExact -dateStr $tempdate -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                            }else{
                                $StartDate =Eg-ParseExact -dateStr $tempdate -DateTimeFormat $DateFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                            }
                            $EndDate=(GET-DATE)
                            $DaysToExpireTmp = NEW-TIMESPAN –Start $EndDate –End $StartDate
                            $DaysToExpire=$DaysToExpireTmp.Days
                        }else{
                            $DaysToExpire='-5'
                        }
                    }

                $suDatCreatd=[String]$suber[$j].DateCreated
                if($suDatCreatd -eq $null -or $suDatCreatd -eq ''){$suDatCreatd='-'}
                $suSkuID=[String]$suber[$j].SkuId
                if($suSkuID -eq $null -or $suSkuID -eq ''){$suSkuID='-'}
                $suOwner=[String]$suber[$j].OwnerObjectId
                if($suOwner -eq $null -or $suOwner -eq ''){$suOwner='-'}
                $suNextLyfCycl=[String]$suber[$j].NextLifecycleDate
                if($suNextLyfCycl -eq $null -or $suNextLyfCycl -eq ''){$suNextLyfCycl='-'}
                $suStat=[String]$suber[$j].Status
                if($suStat -eq $null -or $suStat -eq ''){$suStat='-'}
                $suTrial=[String]$suber[$j].IsTrial
                if($suTrial -eq $null -or $suTrial -eq ''){$suTrial='-'}
                $suTotLic=[String]$suber[$j].TotalLicenses
                if($suTotLic -eq $null -or $suTotLic -eq ''){$suTotLic='-'}

              if($ishavExpireDat -eq $true){
                        Write-host 'AccountSkuID~'$AccountSkuID '~' $ActiveUnits '~' $ConsumedUnits '~' $WarningUnits '~' $LicUsersCount '~' $SubscrStatus '~' $SubscrTrial '~' $SubscrTotal '~' $Subscrdate '~' $DaysToExpire
                        $ddStr='DDInformation~'+$suDatCreatd+'~'+$suSkuID+'~'+$suOwner+'~'+$suNextLyfCycl+'~'+$suStat+'~'+$suTrial+'~'+$suTotLic
                        Write-Host $ddStr
                        #Write-Host 'DDInformation~'$suber[$j].DateCreated '~' $suber[$j].SkuId '~' $suber[$j].OwnerObjectId
              }else{
                        Write-host 'AccountSkuID~'$AccountSkuID'~'$ActiveUnits '~' $ConsumedUnits '~' $WarningUnits '~' $LicUsersCount '~' $SubscrStatus '~' $SubscrTrial '~' $SubscrTotal '~' $Subscrdate '~' 'NIL'
                        $ddStr='DDInformation~'+$suDatCreatd+'~'+$suSkuID+'~'+$suOwner+'~'+$suNextLyfCycl+'~'+$suStat+'~'+$suTrial+'~'+$suTotLic
                        Write-Host $ddStr
                        #Write-Host 'DDInformation~'$suber[$j].DateCreated '~' $suber[$j].SkuId '~' $suber[$j].OwnerObjectId
              }
        }
    }
            }else{
                Write-host 'AccountSkuID~'$AccountSkuID '~' $ActiveUnits '~' $ConsumedUnits '~' $WarningUnits '~' $LicUsersCount '~-5~-5~-5~-5~-5'
                $ddStr='DDInformation~-5~-5~-5~-5~-5~-5~-5'
                Write-Host $ddStr
                #Write-Host 'DDInformation~'$suber[$j].DateCreated '~' $suber[$j].SkuId '~' $suber[$j].OwnerObjectId
	    }
	}
}Catch{
    $exceptionmsg=($_.Exception.Message)+($_.ScriptStackTrace) 
	Write-error "Error Occured in Licene Usage Test --  $exceptionmsg"
}
[System.GC]::GetTotalMemory($true) | out-null
