﻿##/**************************************************************************
##Author                :       Vishnu V
##Purpose               :       Display the list of domains available in O365
##Created               :       14/12/2017
##Modified By		    : 
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear

$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserverip=($TestInputs[4]).ToString().trim()
$appDetails=$TestInputs[5]
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }

Try{
$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
 


$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)    
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }

if($appDetails -and $appDetails -ne 'none'){
    $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName -AzureEnvironmentName AzureCloud
    $measure=Get-AzureADDomain |select * 
    foreach($out in $measure){
        if($out.SupportedServices -and $out.SupportedServices.Count -le 0){
            $out.SupportedServices=''
        }else{
            $out.SupportedServices=$out.SupportedServices -join ', '
        }
        Write-Host $out.Name'~'$out.AuthenticationType'~'$out.SupportedServices'~'$out.IsDefault'~'$out.IsInitial'~'$out.IsVerified'~-5~-5'
    }
}else{
    Connect-MsolService -Credential $cred -AzureEnvironment $azureEnvArr[0]

    $measure=Get-MsolDomain |select * 
    foreach($out in $measure){
        if($out.Capabilities -eq 'none'){
            $out.Capabilities=''
        }
    	Write-Host $out.Name'~'$out.Authentication'~'$out.Capabilities'~'$out.IsDefault'~'$out.IsInitial'~'$out.Status'~'$out.VerificationMethod'~'$out.RootDomain
    }
}
}Catch{
	Write-Host "Error Occured in O365MsolDomain -- " $_.Exception.Message
}

Try{
	$tempPath=[System.Environment]::GetEnvironmentVariable('temp','machine')
	$temp=$tempPath+'\tmp*'
	Get-Item –Path $temp -Force | Where-Object {($_.LastWriteTime -lt (Get-Date).AddHours(-8))} | Remove-Item -Force -Confirm:$false -Recurse
}Catch{
	Write-Host "[O365MsolDomain] Error Occured in Deleting temp files -- " $_.Exception.Message
}

[System.GC]::GetTotalMemory($true) | out-null