﻿#$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
#$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
<# 
This script can be called in two ways - one is by passing arguments from SaaS manager, another is thorugh manually. if u dont pass any arguments to script, it will open a input window. 
#>
clear
$Error.clear()
#$args=@('monitoring@365rpt.onmicrosoft.com','abc123ABC','none','none','none','none','BoxManual_30','eGservicmon256','eGservicmon@2019')
$TestInputs=$args
if($TestInputs.Count -ne 0){
    $AdminuserName=$TestInputs[0]
    $password=$TestInputs[1]
    $proxyHost=$TestInputs[2]
    $proxyPort=$TestInputs[3]
    $proxyUsr=$TestInputs[4]
    $proxyPass=$TestInputs[5]
    $nickNam=$TestInputs[6]
    $monitorUser=$TestInputs[7]
    $monitorPassword=$TestInputs[8]

    if($monitorUser -eq 'none'){
        $monitorUser='eGservicmon'
        $monitorPassword='eGservicmon@2019'
    }  
}else{
    $nickNam='none'
}
$grp="eGMonitoring-role"
$runningManually=$true
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$chkDir=$egurkhaPath+'\agent'
if((Test-Path -Path $chkDir)){
    $runningManually=$False
}

function validateBoxesAndCombos(){
     $checkPassword=$mntrPassTxtBx.Text
     if(!($checkPassword.length -gt 8) -and !($checkPassword –cmatch '[^a-zA-Z0-9]') -and !($checkPassword -cmatch " "))
     {
       $result = [System.Windows.Forms.MessageBox]::Show('Please provide strong password', 'Alert', 'OK', 'Warning')
     }
}

$writGDir=$egurkhaPath+'\agent\O365\MsGraph'
if(!(Test-Path -Path $writGDir)){
    $null=New-Item -ItemType directory -Path $writGDir
}

if($runningManually){
    # Write Output in file
    $driveRoot=''
    $drives=Get-PSDrive
    foreach($drive in $drives){
        if(($drive.Name).ToLower() -eq 'c'){
            $driveRoot=$drive.Root
            break;
        }elseif(($drive.Name).ToLower() -eq 'd'){
            $driveRoot=$drive.Root
            break;
        }elseif(($drive.Name).ToLower() -eq 'e'){
            $driveRoot=$drive.Root
            break;
        }
    }
    $fileDir=$driveRoot+'egurkha'
    if(!(Test-Path -Path $fileDir)){
        $null=New-Item -ItemType directory -Path $fileDir
    }
    #$filePath=$fileDir+'\O365Dtls.txt'
    #if(!(Test-Path -Path $filePath -PathType Leaf)){
    #    $null=New-Item -ItemType File -Path $filePath 
    #}
    #Write-Host 'OutFile writing path -- '$filePath

    #LOGFILE
    $logFile=$fileDir+'\O365.log'
}
else{
    $egEncryPath=$egurkhaPath+"\lib\EGFileEncryption.psm1"
    Import-Module $egEncryPath

    $writDir=$egurkhaPath+'\agent\O365'
    
    if(!(Test-Path -Path $writDir)){
        $null=New-Item -ItemType directory -Path $writDir
    }
    $logFile=$writDir+'\O365_prerequisites.log'
}

Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G 
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

$chkWinrm=([String](& cmd /c "`"winrm get winrm/config/client/auth`"")).Trim().Replace(' ','')
if($chkWinrm -notmatch 'Basic=true'){
    Write-Host 'WINRM BASIC AUTHENTICATION IS NOT ENABLED. PLEASE ENABLE...' -ForegroundColor Red
    O365-WriteLog -writString ("WINRM BASIC AUTHENTICATION IS NOT ENABLED. PLEASE ENABLE..."+$chkWinrm) -LogPath $logFile -ReportingName 'ERROR'
    exit
}

$isRunGraphOnly=$false
$ismbroleOnly=$False
$ismbroleUser=''
Add-Type -AssemblyName  Microsoft.VisualBasic,PresentationCore,PresentationFramework,System.Drawing,System.Windows.Forms,WindowsBase,WindowsFormsIntegration
[System.Windows.Forms.Application]::EnableVisualStyles()
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Drawing") 
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms")
if($TestInputs.Count -eq 0){
     ######***GUI  form ****#######
    $form = New-Object System.Windows.Forms.Form
    $flowlayoutpanel = New-Object System.Windows.Forms.FlowLayoutPanel
    $buttonOK = New-Object System.Windows.Forms.Button

    $O365DtlsLbl=New-Object System.Windows.Forms.Label
    $O365UsrLbl=New-Object System.Windows.Forms.Label
    $O365PassLbl=New-Object System.Windows.Forms.Label
    $O365UsrTxtBx=New-Object System.Windows.Forms.TextBox
    $O365PassTxtBx=New-Object System.Windows.Forms.TextBox 
    
    $prxyDtlsLbl=New-Object System.Windows.Forms.Label
    $prxyHostLbl=New-Object System.Windows.Forms.Label
    $prxyPortLbl=New-Object System.Windows.Forms.Label
    $prxyUsrLbl=New-Object System.Windows.Forms.Label
    $prxyPassLbl=New-Object System.Windows.Forms.Label
    $prxyHostTxtBx=New-Object System.Windows.Forms.TextBox
    $prxyPortTxtBx=New-Object System.Windows.Forms.TextBox
    $prxyUsrTxtBx=New-Object System.Windows.Forms.TextBox
    $prxyPassTxtBx=New-Object System.Windows.Forms.TextBox
    
    $grphAPIChkbx= New-object System.Windows.Forms.CheckBox
    $mbrolChkbx=New-object System.Windows.Forms.CheckBox
    $mbrolTxtBx=New-Object System.Windows.Forms.TextBox
      
    $monitorlabel=New-Object System.Windows.Forms.Label
    $RadioButton1 = New-Object System.Windows.Forms.RadioButton
    $RadioButton2 = New-Object System.Windows.Forms.RadioButton
    $mntrUsrLbl=New-Object System.Windows.Forms.Label
    $mntrUsrTxtBx=New-Object System.Windows.Forms.TextBox    
    $mntrPassLbl=New-Object System.Windows.Forms.Label
    $mntrPassTxtBx=New-Object System.Windows.Forms.TextBox
    $mntrRoleLbl=New-Object System.Windows.Forms.Label
    $mntrRoleTxtBx=New-Object System.Windows.Forms.TextBox

    $infoLabel=New-Object System.Windows.Forms.Label
    $infoLabel1=New-Object System.Windows.Forms.Label
    $infoLabel2=New-Object System.Windows.Forms.Label
  
    $formsize = 502
    $form.Controls.Add($O365DtlsLbl)
    $form.Controls.Add($O365UsrLbl)
    $form.Controls.Add($O365UsrTxtBx)
    $form.Controls.Add($O365PassLbl)
    $form.Controls.Add($O365PassTxtBx)

    $form.Controls.Add($prxyDtlsLbl)
    $form.Controls.Add($prxyHostLbl)
    $form.Controls.Add($prxyHostTxtBx)
    $form.Controls.Add($prxyPortLbl)
    $form.Controls.Add($prxyPortTxtBx)
    $form.Controls.Add($prxyUsrLbl)
    $form.Controls.Add($prxyUsrTxtBx)
    $form.Controls.Add($prxyPassLbl)
    $form.Controls.Add($prxyPassTxtBx)

    $form.Controls.Add($grphAPIChkbx)
    $form.Controls.Add($mbrolChkbx)
    $form.Controls.Add($mbrolTxtBx)

    $form.Controls.Add($RadioButton1)
    $form.Controls.Add($RadioButton2)

    $form.Controls.Add($monitorlabel)
    $form.Controls.Add($mntrUsrLbl)
    $form.Controls.Add($mntrUsrTxtBx)
    $form.Controls.Add($mntrPassLbl)
    $form.Controls.Add($mntrPassTxtBx)
    $form.Controls.Add($mntrRoleLbl)
    $form.Controls.Add($mntrRoleTxtBx)

    $form.Controls.Add($infoLabel)
    $form.Controls.Add($infoLabel1)

    $form.Controls.Add($buttonOK)

    $form.AcceptButton = $buttonOK
    $form.AutoScaleDimensions = '8, 17'
    $form.AutoScaleMode = 'Font'
    $form.ClientSize = "428 , $formsize"
    $form.FormBorderStyle = 'FixedDialog'
    $form.Margin = '5, 5, 5, 5'
    $form.MaximizeBox = $False
    $form.MinimizeBox = $False
    $form.Name = 'form1'
    $form.StartPosition = 'CenterScreen'
    $form.Text = 'O365 Set Roles and Permissions'
    $form.FormBorderStyle = [System.Windows.Forms.FormBorderStyle]::Fixed3D

    $O365DtlsLbl.Location="38,15"
    $O365DtlsLbl.Anchor="Bottom, Left"
    $O365DtlsLbl.Text="&Global Admin Credentails (Only non MFA):"
    $O365DtlsLbl.Size="230,20"
    $O365UsrLbl.Location="58,38"
    $O365UsrLbl.Anchor="Bottom, Left"
    $O365UsrLbl.Text="&Username"
    $O365UsrLbl.Size="115,20"
    $O365UsrTxtBx.Location="175,38"
    $O365UsrTxtBx.Name="O365User"
    $O365UsrTxtBx.Size="200,20"
    $O365UsrTxtBx.Text=""
    $O365PassLbl.Location="58,67"
    $O365PassLbl.Anchor="Bottom, Left"
    $O365PassLbl.Text="&Password"
    $O365PassLbl.Size="115,20"
    $O365PassTxtBx.Location="175,67"
    $O365PassTxtBx.Name="O365Pass"
    $O365PassTxtBx.Size="200,20"
    $O365PassTxtBx.Text=""
    $O365PassTxtBx.PasswordChar='*'

    $prxyDtlsLbl.Location="38,95"
    $prxyDtlsLbl.Anchor="Bottom, Left"
    $prxyDtlsLbl.Text="&Proxy Details :"
    $prxyDtlsLbl.Size="100,20"
    $prxyHostLbl.Location="58,118"
    $prxyHostLbl.Anchor="Bottom, Left"
    $prxyHostLbl.Text="&Host IP"
    $prxyHostLbl.Size="115,20"
    $prxyHostTxtBx.Location="175,118"
    $prxyHostTxtBx.Name="ProxyHost"
    $prxyHostTxtBx.Size="120,20"
    $prxyHostTxtBx.Text="none"
    $prxyPortLbl.Location="298,119"
    $prxyPortLbl.Anchor="Bottom, Left"
    $prxyPortLbl.Text="&Port"
    $prxyPortLbl.Size="25,20"
    $prxyPortTxtBx.Location="325,118"
    $prxyPortTxtBx.Name="Port"
    $prxyPortTxtBx.Size="50,20"
    $prxyPortTxtBx.Text="none"
    $prxyUsrLbl.Location="58,145"
    $prxyUsrLbl.Anchor="Bottom, Left"
    $prxyUsrLbl.Text="&Username"
    $prxyUsrLbl.Size="115,20"
    $prxyUsrTxtBx.Location="175,145"
    $prxyUsrTxtBx.Name="ProxyUser"
    $prxyUsrTxtBx.Size="200,20"
    $prxyUsrTxtBx.Text="none"
    $prxyPassLbl.Location="58,173"
    $prxyPassLbl.Anchor="Bottom, Left"
    $prxyPassLbl.Text="&Password"
    $prxyPassLbl.Size="115,20"
    $prxyPassTxtBx.Location="175,173"
    $prxyPassTxtBx.Name="ProxyPass"
    $prxyPassTxtBx.Size="200,20"
    $prxyPassTxtBx.Text="none"
    $prxyPassTxtBx.PasswordChar='*'

    $grphAPIChkbx.Location="38,205"
    $grphAPIChkbx.Text="Create ONLY MS Graph App"
    $grphAPIChkbx.Size="200,20"
    $grphAPIChkbx.Add_CheckStateChanged({  
        if($grphAPIChkbx.Checked -eq $False){
            $mbrolChkbx.Enabled=$true
            $monitorlabel.Enabled = $true
            $RadioButton1.Enabled = $true
            $RadioButton2.Enabled = $true
            $mntrUsrLbl.Enabled = $true       
            $mntrUsrTxtBx.Enabled = $true
            $mntrPassLbl.Enabled = $true
            $mntrPassTxtBx.Enabled = $true
            $mntrRoleLbl.Enabled = $true
            $mntrRoleTxtBx.Enabled = $true
            $infoLabel.Enabled = $true
            $infoLabel1.Enabled = $true

        }else{
            $mbrolChkbx.Enabled=$False
            $monitorlabel.Enabled = $False
            $RadioButton1.Enabled = $False
            $RadioButton2.Enabled = $False
            $mntrUsrLbl.Enabled = $False       
            $mntrUsrTxtBx.Enabled = $False
            $mntrPassLbl.Enabled = $False
            $mntrPassTxtBx.Enabled = $False
            $mntrRoleLbl.Enabled = $False
            $mntrRoleTxtBx.Enabled = $False
            $infoLabel.Enabled = $False
            $infoLabel1.Enabled = $False
        }
    })


    $mbrolChkbx.Location="38,235"
    $mbrolChkbx.Text="Assign Mailbox Import Export role to user"
    $mbrolChkbx.Size="230,20"
    $mbrolTxtBx.Location="55,258"
    $mbrolTxtBx.Name="mbRoleTxt"
    $mbrolTxtBx.Size="320,20"
    $mbrolTxtBx.Text=""
    $mbrolTxtBx.Enabled=$false
    $mbrolChkbx.Add_CheckStateChanged({  
        if($mbrolChkbx.Checked -eq $False){
            $grphAPIChkbx.Enabled=$true
            $mbrolTxtBx.Enabled=$false
            $monitorlabel.Enabled = $true
            $RadioButton1.Enabled = $true
            $RadioButton2.Enabled = $true
            $mntrUsrLbl.Enabled = $true       
            $mntrUsrTxtBx.Enabled = $true
            $mntrPassLbl.Enabled = $true
            $mntrPassTxtBx.Enabled = $true
            $mntrRoleLbl.Enabled = $true
            $mntrRoleTxtBx.Enabled = $true
            $infoLabel.Enabled = $true
            $infoLabel1.Enabled = $true

        }else{
            $grphAPIChkbx.Enabled=$False
            $mbrolTxtBx.Enabled=$true
            $monitorlabel.Enabled = $False
            $RadioButton1.Enabled = $False
            $RadioButton2.Enabled = $False
            $mntrUsrLbl.Enabled = $False       
            $mntrUsrTxtBx.Enabled = $False
            $mntrPassLbl.Enabled = $False
            $mntrPassTxtBx.Enabled = $False
            $mntrRoleLbl.Enabled = $False
            $mntrRoleTxtBx.Enabled = $False
            $infoLabel.Enabled = $False
            $infoLabel1.Enabled = $False
        }
    })

    $monitorlabel.Location="38,285"  
    $monitorlabel.Anchor="Bottom, Left"
    $monitorlabel.Text="&eG Monitor User Credentails:"
    $monitorlabel.Size="200,20"

    $RadioButton1.Location ="58,305"
    $RadioButton1.Size ="115,20"
    $RadioButton1.Checked = $true
    $RadioButton1.text = "New User"
    $RadioButton2.Location ="175,305"
    $RadioButton2.Size ="115,20"
    $RadioButton2.Checked = $false
    $RadioButton2.text = "Existing User"

    $RadioButton1.Add_Click({
        $mntrPassLbl.Enabled=$true
        $mntrPassTxtBx.Enabled=$true
        $mntrUsrTxtBx.Text="eGmonitor"
        $infoLabel.Location="58,416"
        $infoLabel.Anchor="Bottom, Left"
        $infoLabel.Text="&*"
        $infoLabel.Font=New-Object System.Drawing.Font("Lucida Console",13,[System.Drawing.FontStyle]::Regular)
        $infoLabel.Size="17,10"
        $infoLabel.ForeColor='Red'
        $infoLabel1.Location="72,416"
        $infoLabel1.Anchor="Bottom, Left"
        $infoLabel1.Text="&New user and MSGraph App will be created with the required roles/permissions"#
        $infoLabel1.Size="375,25"
        $infoLabel1.ForeColor='blue'
    })
    $RadioButton2.Add_Click({
        $mntrPassLbl.Enabled=$false
        $mntrPassTxtBx.Enabled=$false
        $mntrUsrTxtBx.Text=""
        $infoLabel.Location="58,416"
        $infoLabel.Anchor="Bottom, Left"
        $infoLabel.Text="&*"
        $infoLabel.Font=New-Object System.Drawing.Font("Lucida Console",13,[System.Drawing.FontStyle]::Regular)
        $infoLabel.Size="17,10"
        $infoLabel.ForeColor='Red'
        $infoLabel1.Location="72,416"
        $infoLabel1.Anchor="Bottom, Left"
        $infoLabel1.Text="&Existing user and MSGraph App will be provided the required roles/permissions"
        $infoLabel1.Size="375,25"
        $infoLabel1.ForeColor='blue'
    })

    $mntrUsrLbl.Location="58,334"  
    $mntrUsrLbl.Anchor="Bottom, Left"
    $mntrUsrLbl.Text="&Monitoring User:"
    $mntrUsrLbl.Size="115,20"
    $mntrUsrTxtBx.Location="175,334"  
    $mntrUsrTxtBx.Name="monitorUser"
    $mntrUsrTxtBx.Size="200,20"
    $mntrUsrTxtBx.Text="eGmonitor"
    $mntrPassLbl.Location="58,361" 
    $mntrPassLbl.Anchor="Bottom, Left"
    $mntrPassLbl.Text="&Monitoring Password:"
    $mntrPassLbl.Size="115,20"
    $mntrPassTxtBx.Location="175,361"
    $mntrPassTxtBx.Name="monitorPassword"
    $mntrPassTxtBx.Size="200,20"
    $mntrPassTxtBx.Text=""
    $mntrPassTxtBx.PasswordChar='*'
    $mntrPassTxtBx.MaxLength = 16
    $mntrPassTxtBx.Add_Leave({validateBoxesAndCombos})
    $mntrRoleLbl.Location="58,388" 
    $mntrRoleLbl.Anchor="Bottom, Left"
    $mntrRoleLbl.Text="&Monitoring Rolename:"
    $mntrRoleLbl.Size="115,20"
    $mntrRoleTxtBx.Location="175,388"   
    $mntrRoleTxtBx.Name="monitorUser"
    $mntrRoleTxtBx.Size="200,20"
    $mntrRoleTxtBx.Text="eGMonitoring-role"

    $infoLabel.Location="58,416"
    $infoLabel.Anchor="Bottom, Left"
    $infoLabel.Text="&*"
    $infoLabel.Font=New-Object System.Drawing.Font("Lucida Console",13,[System.Drawing.FontStyle]::Regular)
    $infoLabel.Size="17,10"
    $infoLabel.ForeColor='Red'
    $infoLabel1.Location="72,416"
    $infoLabel1.Anchor="Bottom, Left"
    $infoLabel1.Text="&New user and MSGraph App will be created with the required roles/permissions"
    $infoLabel1.Size="375,25"
    $infoLabel1.ForeColor='blue'
    
    $buttonOK.Anchor = 'Bottom, Right'
    $buttonOK.DialogResult = 'OK'
    $buttonOK.Location = "175, 456"
    $buttonOK.Margin = '4, 4, 4, 4'
    $buttonOK.Name = 'buttonOK'
    $buttonOK.Size = '100, 30'
    $buttonOK.TabIndex = 0
    $buttonOK.Text = '&OK'
    $frmDialog=$form.ShowDialog()

    if($frmDialog -eq 'OK' ){
        $proxyHost=$prxyHostTxtBx.Text
        $proxyPort=$prxyPortTxtBx.Text
        $proxyUsr=$prxyUsrTxtBx.Text
        $proxyPass=$prxyPassTxtBx.Text
        $AdminuserName=$O365UsrTxtBx.Text
        $password=$O365PassTxtBx.Text
        $monitorUser=$mntrUsrTxtBx.Text
        $monitorPassword=$mntrPassTxtBx.Text
        $grp=$mntrRoleTxtBx.Text

        if($grphAPIChkbx.Checked -eq $true){
            $isRunGraphOnly=$true
        }

        if($mbrolChkbx.Checked -eq $true){
            $ismbroleOnly=$true
            $ismbroleUser=$mbrolTxtBx.Text
        }

        if($proxyHost -eq "" -or $proxyport -eq "" -or $proxyUsr -eq "" -or $AdminuserName -eq "" -or $password -eq "" )
        {
            Write-Host "Re-run the script with all the inputs." -ForegroundColor Red 
            O365-WriteLog -writString  "Re-run the script with all the inputs." -LogPath $logFile -ReportingName 'ERROR'
            Exit
        }
    }
    else{
        Write-Host 'Exiting...'
        #O365-WriteLog -writString "Exiting..." -LogPath $logFile -ReportingName 'ClOSE'
        exit
    }
}


Function GetRequiredPermissions($requiredDelegatedPermissions, $requiredApplicationPermissions, $reqsp) {
    $sp = $reqsp
    $appid = $sp.AppId
    $requiredAccess = New-Object Microsoft.Open.AzureAD.Model.RequiredResourceAccess
    $requiredAccess.ResourceAppId = $appid
    $requiredAccess.ResourceAccess = New-Object System.Collections.Generic.List[Microsoft.Open.AzureAD.Model.ResourceAccess]
    if ($requiredDelegatedPermissions) {
        AddResourcePermission $requiredAccess -exposedPermissions $sp.Oauth2Permissions -requiredAccesses $requiredDelegatedPermissions -permissionType "Scope"
    } 
    if ($requiredApplicationPermissions) {
        AddResourcePermission $requiredAccess -exposedPermissions $sp.AppRoles -requiredAccesses $requiredApplicationPermissions -permissionType "Role"
    }
    return $requiredAccess
}
function O365-Enc(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$str
    )
    Process
    {
        $j=124;
        $eStr=[System.Text.Encoding]::UTF8
        $byt=$eStr.GetBytes($str)
        $bytArr=@()
        for($i=0;$i -lt $byt.count ;$i++){  
            $k=$j-$byt[$i]+$i*3
            $bt=[System.BitConverter]::GetBytes($k)
            $bytArr+=$bt[0]
        }
        $encStr=''
        for($i=$bytArr.count;$i -ge 0 ;$i--){
            $encStr+=$bytArr[$i]
            if($bytArr[$i] -ne 0){
                $encStr+=':'
            }
        }
        $encStr=$encStr.Substring(1,$encStr.Length-2)
        return $encStr
    }
}
$mn=O365-Enc -str $monitorUser

Function AddResourcePermission($requiredAccess, $exposedPermissions, $requiredAccesses, $permissionType) {
    foreach ($permission in $requiredAccesses) {
        $reqPermission = $null
        $reqPermission = $exposedPermissions | Where-Object {$_.Value -contains $permission.Value}
        #Write-Host "Collected information for $($reqPermission.Value) of type $permissionType" -ForegroundColor Green
        $resourceAccess = New-Object Microsoft.Open.AzureAD.Model.ResourceAccess
        $resourceAccess.Type = $permissionType
        $resourceAccess.Id = $reqPermission.Id    
        $requiredAccess.ResourceAccess.Add($resourceAccess)
    }
}

clear

#INPUT - for user-roles and  role-group and role-group roles 
$assgingUserRoles="Global Reader","Service Support Administrator","SharePoint Administrator","Teams Administrator"
$roleslist="View-Only Audit Logs","Mailbox Import Export","Mail Recipients","View-Only Recipients"   #,"View-Only Recipients"

#INPUT - for graph api
$applicationName='eGMsGraphRpt'
$KeyDesc='SecreteG'
#$identyUri='https://eGMsGraphRpt.com'
$srchStrArr=@()
$reqPermissionArr=@()
$configFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
$lines=get-content -Path $configFile
$isExist=$false
foreach($line in $lines){  
    if($isExist){
        if($line.StartsWith('APIs')){
            $apiStr=$line.Replace('APIs=','')
            $apiStr=$apiStr.Split('~')
            foreach($apiArr in $apiStr){
                $srchStrArr+=$apiArr
            }
        }
        if($line.StartsWith('Permissions')){
            $reqPerStr=$line.Replace('Permissions=','')
            $reqPerStr=$reqPerStr.Split('~')
            foreach($reqPerArr in $reqPerStr){
                $reqPermissionArr+=$reqPerArr
            }
            break;
        }  
    }
    if($line.StartsWith('[O365SetRolesAndpermissions')){
        $isExist=$true
    }
}

$m=O365-Enc -str $AdminuserName
$stTim3=Get-Date
O365-WriteLog -writString "******************************************** O365SetRolesAndpermissions ********************************************" -LogPath $logFile -ReportingName 'Script'
O365-WriteLog -writString "O365SetRolesAndpermissions started at $stTim3" -LogPath $logFile -ReportingName 'INFO'
#O365-WriteLog -writString  "OutFile writing path is $filePath" -LogPath $logFile -ReportingName 'INFO'



$cn=@('AzureChinaCloud','https://partner.outlook.cn/PowerShell','O365China')
$com=@('AzureCloud','https://outlook.office365.com/powershell-liveid/','O365Default')
$de=@('AzureGermanyCloud','https://outlook.office.de/powershell-liveid/','O365GermanyCloud')
$us=@('USGovernment','None','O365USGovDoD')
$s=O365-Enc -str $password
$azureCloud=$AdminuserName.Substring($AdminuserName.LastIndexOf('.')+1) 
$azureCloudArr=@()
if($monitorPassword -ne $null -and $monitorPassword -ne ''){
    $pn=O365-Enc -str $monitorPassword
}
if($azureCloud -eq 'com'){$azureCloudArr=$com}
elseif($azureCloud -eq 'cn'){$azureCloudArr=$cn}
elseif($azureCloud -eq 'de'){$azureCloudArr=$de}
elseif($azureCloud -eq 'us'){$azureCloudArr=$us}  
else{$azureCloudArr=$com}

$proxyserverip=$proxyHost+':'+$proxyPort
$y=$m+':991:'+$s
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred =New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

# 1.Installation - AzureAD,MSOnline
$insMod=@()
$installedModule=Get-InstalledModule | Where-Object{$_.Name -in @('AzureAD','MSOnline')} | Sort-Object -Property Name
if($installedModule.Count -ne 0){
    if($installedModule.Count -eq 1 ){
        if($installedModule[0].Name -eq 'AzureAD'){
            write-host 'Azure AD module is already installed'
            O365-WriteLog -writString "Azure AD module is already installed" -LogPath $logFile -ReportingName 'INFO'
            $insMod+='MSOnline'
        }else{
            write-host 'MSOnline module is already installed'
            O365-WriteLog -writString "MSOnline module is already installed" -LogPath $logFile -ReportingName 'INFO'
            $insMod+='AzureAD'
        }
    }else{
        write-host 'AzureAD and MSOnline modules are already installed'
        O365-WriteLog -writString "AzureAD and MSOnline modules are already installed" -LogPath $logFile -ReportingName 'INFO'
    }
}else{
    $insMod+='MSOnline'
    $insMod+='AzureAD'
}
$i=$b+'~'+$y
if($insMod.Count -ne 0){
    Set-PSRepository -Name PSGallery -InstallationPolicy Trusted
    foreach($ins in $insMod){
        if($proxyHost -ne 'none'){
            if($proxyUsr -ne 'none'){
                Install-Module $ins -Scope AllUsers -AllowClobber -Force -Proxy $proxyserver -ProxyCredential $proxyCred
            }else{
                Install-Module $ins -Scope AllUsers -AllowClobber -Force -Proxy $proxyserver
            }
        }else{
            Install-Module $ins -Scope AllUsers -AllowClobber -Force
        }
    }
}

$isGAdmin=$false
$c=$i+$a
$domain=''
$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $AdminuserName, $(convertto-securestring $password -asplaintext -force)
try{
    Import-Module MsOnline
    Connect-MsolService -Credential $credential -AzureEnvironment $azureCloudArr[0] 
    
    $chkGAdmin=Get-MsolRoleMember -RoleObjectId $(Get-MsolRole -RoleName "Company Administrator").ObjectId -ErrorAction SilentlyContinue |Select-Object -Property EmailAddress
    write-host $chkGAdmin[0]
    
    if($runningManually){
        O365-WriteLog -writString "Checking the permissions of the user provided. $c" -LogPath $logFile -ReportingName 'Info'
    }else{
        $timenow = [int][double]::Parse((Get-Date -UFormat %s)) 
        if($nickNam-ne $null -and $nickNam -ne 'none' -and $nickNam -ne ''){
            $adminWritDir=$egurkhaPath+'\agent\O365\'+$nickNam
            if(!(Test-Path -Path $adminWritDir)){
                $null=New-Item -ItemType directory -Path $adminWritDir
            }
        }else{
            $adminWritDir=$egurkhaPath+'\agent\O365\MsGraph'
        }
        Get-ChildItem -Path $adminWritDir |Where-Object {$_.Name -like 'KeGServic*.dat' -or $_.Name -like 'eGServic*.dat'}|ForEach-Object{
            $rmvFile=$adminWritDir+'\'+$_.Name
            Remove-Item -Path $rmvFile -Force
        }
        $adminKeyFileNam='\KeGServic'+$timenow+'.dat'
        $adminWritPath=$adminWritDir+'\eGServic'+$timenow+'.txt'
        $null=$c | Add-Content $adminWritPath
        $ADkey=Get-CryptoKey -FileDir $adminWritDir -FileName $adminKeyFileNam
        $null=Protect-File $adminWritPath -Algorithm AES -KeyAsPlainText $ADkey -RemoveSource      
    }
    foreach($GA in $chkGAdmin){
        if($GA.EmailAddress -eq $AdminuserName){
            $isGAdmin=$true
            $measure=Get-MsolDomain |select Name,IsInitial
            if($measure){
                $azureEnv= $measure|where{$_.IsInitial -eq $true}|select Name
                $domain=$azureEnv.Name
                if($monitorUser.Contains('@')){
                    $userdomain=$monitorUser.Split('@')[1].trim()
                    if(!$measure.PSobject.Properties.Name -contains $userdomain)
                    {
                        Write-Error "Given user $monitorUser domain does not exist in the tenant"
                        O365-WriteLog -writString "Given user $monitorUser domain does not exist in the tenant" -LogPath $logFile -ReportingName 'ERROR'
                        exit
                    }
                 }
                 else{
                    $monitorUser=$monitorUser+'@'+$domain
                 }
                $domainNam=$domain.Substring(0,$domain.IndexOf('.')).trim()
            }
            else{
                Write-Error "Intial domain is not found "
                O365-WriteLog -writString "Intial domain is not found " -LogPath $logFile -ReportingName 'ERROR'
                O365-WriteLog -writString "Re-run the script and give admin user along with domain name (Ex:- abc@eg.com)" -LogPath $logFile -ReportingName 'INFO'
                exit  
            }
            break;
        }
    }
}Catch{
    $message= $_.Exception.Message + $_.ScriptStackTrace 
    Write-Host $message
    O365-WriteLog -writString "Error while checking provided user having global admin role  $message " -LogPath $logFile -ReportingName 'Exception'
    $isGAdmin=$false
}

$replyUrl='https://'+$domainNam+'-my.sharepoint.com/'
if($isGAdmin){
if($ismbroleOnly -eq $False){
    if($isRunGraphOnly -eq $False){  
        #for session
        try{
            Write-host "Creating new session..."
            O365-WriteLog -writString "Creating new session..." -LogPath $logFile -ReportingName 'INFO'
            $sessionOption = New-PSSessionOption -SkipRevocationCheck
            if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
                [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
                [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
                $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
            }
            Connect-ExchangeOnline  -ExchangeEnvironmentName $azureCloudArr[2] -ConnectionUri $azureCloudArr[1] -Credential $credential -PSSessionOption $sessionOption	-WarningAction SilentlyContinue -InformationAction SilentlyContinue -ShowBanner:$false
        }catch{
            $message= $_.Exception.Message + $_.ScriptStackTrace 
            Write-Error "Error while creating session -> $message "
            O365-WriteLog -writString "Error while creating session is -> $message " -LogPath $logFile -ReportingName 'EXCEPTION'
            O365-WriteLog -writString "Exiting the script execution please check prerequsities and admin user credentials" -LogPath $logFile -ReportingName 'INFO'
            exit
        }

        Try{
            Enable-OrganizationCustomization -EA SilentlyContinue
        }Catch{}

        #2.USER CREATION, SETTING ROLES AND PERMISSIONS
        #creating user
        $user=$monitorUser
        $userlicence=$false
        $displayname=$user.Split('@')[0]
        $userprincipleName=$user
        $userprincipleName=$userprincipleName.ToString().trim()
        $UsageLocation=(Get-MsolUser -UserPrincipalName $AdminuserName | select UsageLocation).UsageLocation
        $userdetais=Get-MsolUser -UserPrincipalName $userprincipleName -ErrorAction SilentlyContinue | select * 
        if(!$userdetais){
            if($monitorPassword){
                Write-host "Checking user credentials..."
                O365-WriteLog -writString  "Checking user credentials..." -LogPath $logFile -ReportingName 'INFO'
                #Write-host "User $userprincipleName does not exist, so creating user..."
                #O365-WriteLog -writString  "User $userprincipleName does not exist, so creating user..." -LogPath $logFile -ReportingName 'INFO'
                $userdetais=New-MsolUser -UserPrincipalName $userprincipleName -Password $monitorPassword -DisplayName $displayname -FirstName $displayname -UsageLocation $UsageLocation -ForceChangePassword $false
                if($userdetais){
                    Write-host "    user $userprincipleName  is created without licence!" -ForegroundColor Green
                    O365-WriteLog -writString  "User $userprincipleName  created without licence!" -LogPath $logFile -ReportingName 'INFO'
                }
            }else{
                Write-error  "User $userprincipleName User does not exist or password is not provided in console. Re-run the script with right inputs."
                O365-WriteLog -writString  "User $userprincipleName User does not exist or password is not provided in console. Re-run the script with right inputs." -LogPath $logFile -ReportingName 'WARN'

            }       
        }
        else{
            $displayname=$userdetais.DisplayName
            O365-WriteLog -writString  "User $userprincipleName  is already existing" -LogPath $logFile -ReportingName 'INFO'
            Write-host "    User $userprincipleName is already existing" -ForegroundColor Green
        }
        if(!$userdetais){
            Write-Host "Unable to create user $userprincipleName $Error" -ForegroundColor Red 
            O365-WriteLog -writString  "Unable to create user $userprincipleName $Error" -LogPath $logFile -ReportingName 'ERROR'
            exit
        }

        #Assigning user roles
        try{
            Write-host "    Assigning user roles to $userprincipleName... " -ForegroundColor Magenta        
            $existeduserroles=(Get-MsolUserRole -UserPrincipalName $userprincipleName | select Name).Name
            foreach($Usrrole in $assgingUserRoles){
                $Usrrole=$Usrrole.ToString().trim()
                if($existeduserroles){
                    if(!$existeduserroles.contains($Usrrole)){
                        Add-MsolRoleMember -RoleName $Usrrole -RoleMemberEmailAddress $userprincipleName
                        Write-host "    '$Usrrole' user role is assigned to $userprincipleName!" -ForegroundColor Green
                        O365-WriteLog -writString  "'$Usrrole' user role is assigned to $userprincipleName!" -LogPath $logFile -ReportingName 'INFO'
                    }
                }
                else{
                    Add-MsolRoleMember -RoleName $Usrrole -RoleMemberEmailAddress $userprincipleName   
                    Write-host "    '$Usrrole' user role is assigned to $userprincipleName!" -ForegroundColor Green
                    O365-WriteLog -writString  "'$Usrrole' user role is assigned to $userprincipleName!" -LogPath $logFile -ReportingName 'INFO'
                }
            }
        }catch{
            $message= $_.Exception.Message + $_.ScriptStackTrace 
            Write-Host -Message "Error while assigning the user roles $message." -ForegroundColor Red 
            O365-WriteLog -writString "Error while assigning the user roles -> $message " -LogPath $logFile -ReportingName 'EXCEPTION'    
        }

        #Creating role group and assinging roles
                                                                                                                                                                                                                                                                try{
        Write-host "    Checking if user $userprincipleName exists or not..." -ForegroundColor Green
        O365-WriteLog -writString  "Working on role group  and assigning roles..." -LogPath $logFile -ReportingName 'INFO'
        $existedrolegroups=Get-RoleGroup | select Members,Roles,Identity
        if($grp){         
            $rolegroupdetails=$existedrolegroups | Where-Object {($_.Identity) -eq $grp} | select *
            if($rolegroupdetails){
                Write-host "$grp Role group already exists!"
                O365-WriteLog -writString  "$grp Role Group already exists!" -LogPath $logFile -ReportingName 'INFO'
                $existedroleslist=$rolegroupdetails.Roles
                foreach($role in $roleslist){
                    if(!$existedroleslist.contains($role)){
                        New-ManagementRoleAssignment -Role $role -SecurityGroup $grp
                        O365-WriteLog -writString  "Added role $role to role group $grp." -LogPath $logFile -ReportingName 'INFO'
                        Write-host "    Added role $role to role group $grp." -ForegroundColor Green
                    }
                }
                $existedmembers=$rolegroupdetails.Members
                if(!$existedmembers.contains($displayname)){
                    $Error.clear()
                    Start-sleep -Seconds 60
                    Add-RoleGroupMember $grp -Member $userprincipleName 
                    $count=0
                    while($Error){
                        Write-Host 'Sleeping for 30 seconds for adding role group member (Add-RoleGroupMember)' # to make user available for commandlets
                        Start-sleep -Seconds 30
                        $Error.clear()
                        Add-RoleGroupMember $grp -Member $userprincipleName 
                        $count++
                        if($count -gt 10){
                            Write-host "    Failed to add $userprincipleName as member to role group $grp, please re-run the script with same inputs." -ForegroundColor Green
                            O365-WriteLog -writString  "Failed to add $userprincipleName as member to role group $grp, please re-run the script with same inputs." -LogPath $logFile -ReportingName 'ERROR'
                            exit
                        }
                    }
                    O365-WriteLog -writString  "Added $userprincipleName as member to role group $grp" -LogPath $logFile -ReportingName 'INFO'
                    Write-host "    Added $userprincipleName as member to role group $grp" -ForegroundColor Green
                }
            }
            else{
                Start-sleep -Seconds 60
                $breaklimit=10
                Try{
                    $result=New-RoleGroup -Name $grp -Roles $roleslist -Members $userprincipleName -ManagedBy $AdminuserName -ErrorAction SilentlyContinue 
                }Catch{}
                while(!$result){
                    Write-Host 'sleep for 30 seconds for working on New-RoleGroup' # to make user available for commandlets
                    Start-sleep -Seconds 30
                    Try{
                        $result=New-RoleGroup -Name $grp -Roles $roleslist -Members $userprincipleName -ManagedBy $AdminuserName -ErrorAction SilentlyContinue 
                    }Catch{}
                    $result
                    $breaklimit--
                    if($breaklimit -lt 1){
                        break
                    }  
                }
                Write-host "    Created $grp role group with roles $roleslist!" -ForegroundColor Green
                O365-WriteLog -writString  "Created $grp role group with roles $roleslist!" -LogPath $logFile -ReportingName 'INFO'
            }
        }
    }
            catch{
                $message= $_.Exception.Message + $_.ScriptStackTrace 
                Write-Error -Message "Error while creating or assigining the role group and roles $message." 
                O365-WriteLog -writString "Error while creating or assigning the role group and roles -> $message." -LogPath $logFile -ReportingName 'EXCEPTION'    
            }
            $an='~'+$mn+':751:'+$pn
            O365-WriteLog -writString  "All permissions are set successfully for user $userprincipleName" -LogPath $logFile -ReportingName 'DONE'
            Write-host "All permissions are set successfully for user $userprincipleName"


            #TESTING
            Write-host  "checking user $userprincipleName existed or not..." 
            O365-WriteLog -writString  "checking user $userprincipleName existing or not" -LogPath $logFile -ReportingName 'TESTING'

            $chkAcc=$false
            $userdetais=Get-MsolUser -UserPrincipalName $userprincipleName -ErrorAction SilentlyContinue | select *    
                                                                                                                                                                                                                                                                                                                                                    if($userdetais){
            $chkAcc=$true
            $displayname=$userdetais.DisplayName   
            try{                    
                $existeduserroles=(Get-MsolUserRole -UserPrincipalName $userprincipleName | select Name).Name
                if($existeduserroles){

                    foreach($requirerole in $assgingUserRoles)
                    {
                       if(!$existeduserroles.contains($requirerole)){
                            Write-Host "'$requirerole' user role is not assigned to $userprincipleName." -ForegroundColor Red
                            O365-WriteLog -writString  "'$requirerole' user role is not assigned to $userprincipleName." -LogPath $logFile -ReportingName 'WARN'
                       }else{
                            Write-Host "    '$requirerole' user role assigned to $userprincipleName." -ForegroundColor Magenta
                            O365-WriteLog -writString  "'$requirerole' user role is assigned to $userprincipleName." -LogPath $logFile -ReportingName 'INFO'
                       }
                    }
                    Write-Host "Assigned user roles for $userprincipleName is $existeduserroles "
                    O365-WriteLog -writString  "Assigned user roles for $userprincipleName is $existeduserroles " -LogPath $logFile -ReportingName 'INFO'
                }
                else{
                    Write-Host "No user roles assigned for $userprincipleName" -ForegroundColor Red
                    O365-WriteLog -writString  "No user roles assigned for $userprincipleName , re-run the script " -LogPath $logFile -ReportingName 'WARN'
                }
            }
            catch{
                $message= $_.Exception.Message + $_.ScriptStackTrace 
                Write-Error -Message "Error while getting the user roles $message."
                O365-WriteLog -writString  "Error while getting the user roles $message." -LogPath $logFile -ReportingName 'ERROR'
            }

            try{

                $existedrolegroups=Get-RoleGroup | select Members,Roles,Identity
                $rolegroupdetails=$existedrolegroups | Where-Object {($_.Identity) -eq $grp} | select *  
            
                if($rolegroupdetails){
                    $existedroleslist=$rolegroupdetails.Roles
                    foreach($role in $roleslist){
                        if(!$existedroleslist.contains($role)){
                            O365-WriteLog -writString  "role '$role' is not available in  $grp role group." -LogPath $logFile -ReportingName 'WARN'
                            Write-host "role '$role' is not available in $grp role group." -ForegroundColor Red
                        }else{
                            O365-WriteLog -writString  "role '$role' is available in $grp role group!" -LogPath $logFile -ReportingName 'INFO'
                            Write-host "    role '$role' is available in $grp role group!" -ForegroundColor Magenta
                        }
                    }

                    $existedmembers=$rolegroupdetails.Members
                    $chkNam=$userprincipleName.Split('@')[0]
                    if(!$existedmembers.contains($chkNam)){
                            O365-WriteLog -writString  " $userprincipleName user is not a member in $grp rol group." -LogPath $logFile -ReportingName 'WARN'
                            Write-host "$userprincipleName user is not a member in $grp rol group." -ForegroundColor Red
                    }else{
                            O365-WriteLog -writString  " $userprincipleName user is a member in $grp role group!" -LogPath $logFile -ReportingName 'INFO'
                            Write-host "    $userprincipleName user is a member in $grp role group!" -ForegroundColor Magenta
                    }

                    Write-Host "Assigned roles for $grp group  is "
                    $writRoles=([String]$rolegroupdetails.Roles)
                    O365-WriteLog -writString  "Assigned roles for $grp group --> $writRoles " -LogPath $logFile -ReportingName 'INFO'
                    $rolegroupdetails.Roles
                }
                else{
                    write-host "Role $grp group does not exist-ForegroundColor Red"
                    O365-WriteLog -writString  "Role $grp group does not exist,re-run the script" -LogPath $logFile -ReportingName 'TESTING'
                }
            }
            catch{
                $message= $_.Exception.Message + $_.ScriptStackTrace 
                Write-Error -Message "Error while checking the assiged roles for the $grp group $message."
                O365-WriteLog -writString  "Error while checking the assiged roles for the $grp group $message." -LogPath $logFile -ReportingName 'ERROR'

            } 
    
            if($chkAcc){
                if($monitorPassword -ne $null -and $monitorPassword -ne ''){
                    $encPasswrd=O365-Enc -str $monitorPassword  
                }    
                if($runningManually){
                    #"["+$applicationName+"-"+$domain+"]"| Add-Content $filePath
                    #'Username~'+$monitorUser | Add-Content $filePath
                    #'password~'+$encPasswrd | Add-Content $filePath
                    #O365-WriteLog -writString  $an -LogPath $logFile -ReportingName 'INFO'
                }
                Write-Host '**Username~'$monitorUser
                Write-Host '**password~'$encPasswrd
                O365-WriteLog -writString  $an -LogPath $logFile -ReportingName 'INFO'
                #O365-WriteLog -writString  "Username is $monitorUser" -LogPath $logFile -ReportingName 'INFO'
                #O365-WriteLog -writString  "Password is $encPasswrd" -LogPath $logFile -ReportingName 'INFO'
            }             
        }
            else{
                O365-WriteLog -writString  "Unable to create user $userprincipleName, please re-run the script" -LogPath $logFile -ReportingName 'WARN'
                Write-host " Unable to create user $userprincipleName, please re-run the script " -ForegroundColor Red
                exit
            }

            #Get-PSSession | Remove-PSSession -Confirm:$false
            $getSession=Get-PSSession -ErrorAction SilentlyContinue
            if($getSession -ne $null -and $getSession -ne ''){
	            Disconnect-ExchangeOnline -Confirm:$false
            }
    }

    # 3.GRAPH API - GENERATING CILENTID AND SECRECT AND SET APP, DELEGATE PERMISSIONS

    #Get TenantId
    $azureAD=Connect-AzureAD -Credential $credential -AzureEnvironmentName $azureCloudArr[0] |select *
    $tenantId=$azureAD.TenantId

    $startDate = (Get-Date).AddDays(-1)
    $endDate = $startDate.AddMonths(24)
    $spArr=[System.Collections.ArrayList]@()
    O365-WriteLog -writString  "GRAPH API - started" -LogPath $logFile -ReportingName 'INFO'
    Connect-AzureAd  -AzureEnvironment $azureCloudArr[0] -Credential $credential
    $existingapp = $null
    $existingapp = get-azureadapplication -Filter "DisplayName eq '$applicationName'"
    if ($existingapp) {
        Remove-Azureadapplication -ObjectId $existingApp.objectId
    }
    $requiredResourcesAccess = New-Object System.Collections.Generic.List[Microsoft.Open.AzureAD.Model.RequiredResourceAccess]

    foreach($str in $srchStrArr){
        $srchStr=$str -split('#')
        $appArray = [System.Collections.ArrayList]@()
        $delArray = [System.Collections.ArrayList]@()
        $svcPrincipal=Get-AzureADServicePrincipal -SearchString $srchStr[1] | Where-Object {$_.DisplayName -eq $srchStr[1]}

        $spArr.Add($svcPrincipal)
        for($i=0;$i -lt $reqPermissionArr.Length;$i++ ){
            if($reqPermissionArr[$i].StartsWith($srchStr[0])){
                $grStr=$srchStr[0].ToString().Length
                $tmpnam=$srchStr[0]
                while($true){
                    if($reqPermissionArr[$i].StartsWith($tmpnam) -and $reqPermissionArr[$i].EndsWith('App')){
                        $displayNam=$reqPermissionArr[$i].Substring($grStr)
                        $appIdx=$displayNam.Length-3
                        $displayNam=$displayNam.Substring(0,$appIdx)
                        $appArray.Add($displayNam) 
                        if($i -lt $reqPermissionArr.Length-1){
                            $i++
                        }else{break;}
                    }else{
                        break;
                    }
                }
                while($true){
                    if($reqPermissionArr[$i].StartsWith($tmpnam) -and $reqPermissionArr[$i].EndsWith('Del')){     
                        $displayNam=$reqPermissionArr[$i].Substring($grStr)
                        $appIdx=$displayNam.Length-3
                        $displayNam=$displayNam.Substring(0,$appIdx)
                        $delArray.Add($displayNam)
                        if($i -lt $reqPermissionArr.Length-1){
                            $i++
                        }else{break;}
                    }else{
                        break;
                    }
                }
                $appValue=$svcPrincipal.AppRoles | Where-Object{$_.DisplayName -in $appArray}
                $delValue=$svcPrincipal.Oauth2Permissions | Where-Object{$_.AdminConsentDisplayName -in $delArray}
                $azureAppPermissions = GetRequiredPermissions -reqsp $svcPrincipal -requiredApplicationPermissions $appValue -requiredDelegatedPermissions $delValue
                $requiredResourcesAccess.Add($azureAppPermissions)
            }
        }
    }

    #create new Application
    $aadApplication = New-AzureADApplication -DisplayName $applicationName -ReplyUrls $replyUrl -RequiredResourceAccess $requiredResourcesAccess #-IdentifierUris $identyUri
    $null=Get-AzureADOAuth2PermissionGrant -All $true
    O365-WriteLog -writString  "New Application created" -LogPath $logFile -ReportingName 'INFO'

    #set the secret key for application
    $tmpCreVal=New-AzureADApplicationPasswordCredential -ObjectId $aadApplication.ObjectId -StartDate $startDate -EndDate $endDate -CustomKeyIdentifier $KeyDesc
    O365-WriteLog -writString  "Secret key generated" -LogPath $logFile -ReportingName 'INFO'

    #Assign application permissions to the application
    $servicePrincipal = New-AzureADServicePrincipal -AppId $aadApplication.AppId      
    foreach ($app in $requiredResourcesAccess){
        
        $reqAppSP = $spArr | Where-Object {$_.appid -contains $app.ResourceAppId}
        #Write-Host "Assigning Application permissions for $($reqAppSP.displayName)" -ForegroundColor DarkYellow 
         
        foreach ($resource in $app.ResourceAccess) {
            if ($resource.Type -match "Role") {
                New-AzureADServiceAppRoleAssignment -ObjectId $serviceprincipal.ObjectId -PrincipalId $serviceprincipal.ObjectId -ResourceId $reqAppSP.ObjectId -Id $resource.Id
            }
        }      
    }
    O365-WriteLog -writString  "App or Delegate permissions assigned" -LogPath $logFile -ReportingName 'INFO'

    #grant oauth2permissions
    Get-AzureADOAuth2PermissionGrant -All $true
    O365-WriteLog -writString  "App or Delegate permissions granted" -LogPath $logFile -ReportingName 'INFO'

    $client_id=$aadApplication.AppId
    $client_secret=$tmpCreVal.Value
    $tenantName=$domain #(Get-AzureADTenantDetail).VerifiedDomains.Name
    $authority = "https://login.microsoftonline.com/"
    $resource = "https://graph.microsoft.com"

    if($client_id -ne $null -and $client_id -ne ''){
        if($runningManually){
            if($client_id -ne $null -and $client_id -ne '' -and $client_secret -ne $null -and $client_secret -ne ''){
                O365-WriteLog -writString  "applicationName~$applicationName" -LogPath $logFile -ReportingName 'INFO'
                O365-WriteLog -writString  "client_id~$client_id" -LogPath $logFile -ReportingName 'INFO'
                O365-WriteLog -writString  "client_secret~$client_secret" -LogPath $logFile -ReportingName 'INFO'
                O365-WriteLog -writString  "TenantName~$tenantName" -LogPath $logFile -ReportingName 'INFO'
                O365-WriteLog -writString  "Authority~$authority" -LogPath $logFile -ReportingName 'INFO'
                O365-WriteLog -writString  "Resource~$resource" -LogPath $logFile -ReportingName 'INFO'
            }
        }
        else{
            $keyFileNam='\GraphDetailsKey.dat'
                    $keyPath=$writGDir+$keyFileNam
                    $unProtFile=$writGDir+'\GraphDetails.dat'
                    if(Test-Path $unProtFile -PathType Leaf){
                        $unProtPath=$writGDir+'\GraphDetails.dat'
                        $kvalue=Get-Content -Path $keyPath
                        Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
                    }

                    $chkNam="-"+$tenantName+"]"
                    $writPath=$writGDir+'\GraphDetails.txt'
                    if(Test-Path $writPath -PathType Leaf){
                        $dtls=Get-Content -Path $writPath
                        $j=0
                        $wpath1=$writGDir+'\GraphDetails1.txt'
                        for($i=0;$i -lt $dtls.Length;$i++){
                            if($dtls[$i] -match $chkNam){
                                $cnt=$i+7
                                if($dtls[$cnt].StartsWith('TenantId~')){
                                        $i=$i+9 
                                }else{
                                    $i=$i+8
                                }
                            }
                            Add-Content -Path $wpath1 -Value $dtls[$i]
                        }
                        Remove-Item $writPath
                        if(Test-Path $wpath1 -PathType Leaf){
                            Rename-Item $wpath1 'GraphDetails.txt'
                        }
                    }

                    '['+$applicationName+'-'+$tenantName+']'| Add-Content $writPath -PassThru
                    'client_id~'+$client_id| Add-Content $writPath -PassThru
                    'client_secret~'+$client_secret| Add-Content $writPath -PassThru
                    'TenantName~'+$tenantName| Add-Content $writPath -PassThru
                    'Authority~'+$authority| Add-Content $writPath -PassThru
                    'Resource~'+$resource| Add-Content $writPath -PassThru
                    'TenantId~'+$tenantId| Add-Content $writPath -PassThru
                    "`n"| Add-Content $writPath

                    $key=Get-CryptoKey -FileDir $writGDir -FileName $keyFileNam
                    $null=Protect-File $writPath -Algorithm AES -KeyAsPlainText $key -RemoveSource

                    Write-Host 'Permissions provided successfully'
                    Write-Host 'Graph API Permissions provided successfully'
                    O365-WriteLog -writString  "Graph API APP registered and Permissions provided successfully" -LogPath $logFile -ReportingName 'INFO'
        }
    }else{
        Write-Host 'Client ID is null or empty'
        O365-WriteLog -writString  "Client ID is null or empty" -LogPath $logFile -ReportingName 'INFO'
    }
    }
    else{
        if($ismbroleUser -ne $null -and $ismbroleUser -ne ''){
            if($ismbroleUser.Contains('@')){
                $mbroleNam='eGMBImportExport'
                Connect-MsolService -Credential $Credential -AzureEnvironment AzureCloud
                $mbUserDtls=Get-MsolUser -UserPrincipalName $ismbroleUser | select *
                $curMemNam=($mbUserDtls.DisplayName).Replace(' ','')
                Try{
                    Connect-ExchangeOnline  -ExchangeEnvironmentName $azureCloudArr[2] -ConnectionUri $azureCloudArr[1] -Credential $credential -PSSessionOption $sessionOption	-WarningAction SilentlyContinue -InformationAction SilentlyContinue -ShowBanner:$false -ErrorAction Stop
                }Catch{
                    $message= $_.Exception.Message + $_.ScriptStackTrace 
                    Write-Error -Message "[MBImportExport role] Exception occurred in Connect-ExchangeOnline - $message."
                    O365-WriteLog -writString  "[MBImportExport role] Exception occurred in Connect-ExchangeOnline - $message." -LogPath $logFile -ReportingName 'ERROR'
                }

                $mbRoleGrpDtls=Get-RoleGroup | Where-Object {($_.Identity) -eq $mbroleNam} | select *
                if($mbRoleGrpDtls){
                    $existedMembrs=$mbRoleGrpDtls.Members
                    if($existedMembrs -match $curMemNam){
                        Write-host "[MBImportExport role] $ismbroleUser member is existed in $mbroleNam role"
                        O365-WriteLog -writString  "[MBImportExport role] $ismbroleUser member is existed in $mbroleNam role" -LogPath $logFile -ReportingName 'INFO' 
                    }else{
                        Add-RoleGroupMember $mbroleNam -Member $ismbroleUser
                        $mbAddRoleGrpDtls=Get-RoleGroup | Where-Object {($_.Identity) -eq $mbroleNam} | select *
                        $chkMembrs=$mbAddRoleGrpDtls.Members
                        if($chkMembrs -match $curMemNam){
                            Write-host "[MBImportExport role] $ismbroleUser member is added in $mbroleNam role"
                            O365-WriteLog -writString  "[MBImportExport role] $ismbroleUser member is added in $mbroleNam role" -LogPath $logFile -ReportingName 'INFO'
                        }else{
                            Write-host "[MBImportExport role] Error occurred while adding $ismbroleUser member in $mbroleNam role"
                            O365-WriteLog -writString  "[MBImportExport role] Error occurred while adding $ismbroleUser member in $mbroleNam role" -LogPath $logFile -ReportingName 'ERROR'
                        }
                    }  
                }else{
                    Try{
                        New-RoleGroup -Name $mbroleNam -Roles 'Mailbox Import Export' -Members $ismbroleUser -ManagedBy $AdminuserName -ErrorAction Stop
                        Write-host "[MBImportExport role] $mbroleNam role created and $ismbroleUser member is added in $mbroleNam role"
                        O365-WriteLog -writString  "[MBImportExport role] $mbroleNam role created and $ismbroleUser member is added in $mbroleNam role" -LogPath $logFile -ReportingName 'INFO'
                    }Catch{
                        $message= $_.Exception.Message + $_.ScriptStackTrace 
                        Write-Error -Message "[MBImportExport role] Exception occurred while adding MailBox ImportExport Role - $message."
                        O365-WriteLog -writString  "[MBImportExport role] Exception occurred while adding MailBox ImportExport Role - $message." -LogPath $logFile -ReportingName 'ERROR' 
                    }
                }
                $getSession=Get-PSSession -ErrorAction SilentlyContinue
                if($getSession -ne $null -and $getSession -ne ''){
	                Disconnect-ExchangeOnline -Confirm:$false
                }
            }else{
                Write-Host 'Please provide MBImportExport role user name with domain... for example:xyz@domain.com'
                O365-WriteLog -writString  "Please provide MBImportExport role user name with domain... for example:xyz@domain.com" -LogPath $logFile -ReportingName 'ERROR'
            }
        }else{
            Write-Host 'Please enter the MBImportExport role user name'
            O365-WriteLog -writString  "Please enter the MBImportExport role user name" -LogPath $logFile -ReportingName 'ERROR'
        }
    }
}
else{
    Write-Host 'Given O365 Account is invalid or does not have Global Administrator role'
    O365-WriteLog -writString  "Given O365 Account is invalid or does not have Global Administrator role" -LogPath $logFile -ReportingName 'ERROR'
}

if(!$form.IsDisposed){
    $form.Close()
    $form.Dispose()
}

$edTim3=Get-Date
O365-WriteLog -writString "O365SetRolesAndpermissions ended at $edTim3" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString '************************************************************************************************' -LogPath $logFile -ReportingName 'INFO'



