Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue 
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

# Get details of SharePoint databases


$SiteLimitUsage = 0
$RecycleBinStorageSize=0
$TotalDiskSpace=0 
$SPDBSiteLmtUsage = 0
$SPDBRecycleBinStorageSize=0
#Get-SPDatabase | FL

$SQLSPDatabases = Get-SPDatabase
$TotalDiskSpace = $SQLSPDatabases| ForEach-Object {$db=0} {$db +=$_.disksizerequired; $_.name + " - " + $_.disksizerequired/1024/1024}{$SQLDiskSpace= ((($db/1024)/1024)/1024)}

foreach($SPDB in $SQLSPDatabases) 
{

    $SPDBName        = $SPDB.Name
    $DiskSpaceUsage=0
    $SPDBSize=0
    $SPDBSiteLimit=0
    $SPCurSiteCount=0
    $OrphanSite=-5
    $SPDBRecycleBinStorageSize=0
    

    #$SPDBActType     = $SPDB.Type
    #write-host $SPDBActType

    if ($SPDB.Type -eq "Content Database") 
    {
        $SPDBType = "Content Databases"
        $OrphanSite=0
    }
    elseif ($SPDB.Type -eq "Configuration Database")
    {
        $SPDBType = $SPDB.Type
    }
    else
    {
        $SPDBType = "Other Databases" 
    }
    
    

    $SPDBSize        = [Math]::Round(($SPDB.disksizerequired/1GB),4)
    $DiskSpaceUsage  = [Math]::Round(($SPDBSize/$SQLDiskSpace)*100,4);
   

    $SPDBStatus      = $SPDB.Status
    $SPDBSiteLimit   = $SPDB.MaximumSiteCount                                    
    $SPCurSiteCount  = $SPDB.currentsitecount
    $SPDBWebApps     = $SPDB.WebApplication
 
 # -------------------- Number of orphan items -----------------------------------------------------------------------------------------------

    if ($SPDB.Type -eq "Content Database") 
    {
        $tmpContentDB = $null
        $ErrorActionPreference = "Stop"
        try{ 
        $tmpContentDB = Get-SPContentDatabase $SPDB.Name 
        } catch { }
        $ErrorActionPreference = "SilentlyContinue"
        if ($tmpContentDB -ne $null) {
            $OrphanSite =  $tmpContentDB.Repair($false)
	    $StartIndex=$OrphanSite.IndexOf("Count=""")+7
            $EndIndx=$OrphanSite.IndexOf("""",$StartIndex)
            $EndIndex=$EndIndx-$StartIndex
            $OrphanSite=($OrphanSite.Substring($StartIndex,$EndIndex)).Trim()	
	    <#
            $StartIndex=$OrphanSite.LastIndexOf("Count=""")+7
            $orpSite=$OrphanSite.Substring($StartIndex)
            $EndIndex=$orpSite.IndexOf(""" />")
            $OrphanSite=($orpSite.Substring(0,$EndIndex)).Trim()
	    #>	
            
            <#$OrphanSite = $OrphanSite -replace '"',''
	        $pos = $OrphanSite.IndexOf("=")
            if ($pos -gt 0){
	            $OrphanSite = $OrphanSite.Substring($pos+1)
	            $pos1 = $OrphanSite.IndexOf("/>")
	            $OrphanSite = $OrphanSite.Substring(0, $pos1)
                $OrphanSite = $OrphanSite.Trim()
            }#>
        }
    }
    else 
    {
        $OrphanSite="-5"
    }

    # ------------------- Get the size of recycle bin -------------------------------------------------------------------------------------------


foreach ($SPDBSite in $SPDBWebApps.Sites)
{ 
    	if($SPDBSite -ne $null)
        {
        	$SPDBSiteLmtUsage = $SPDBSiteLmtUsage + $SPDBSite.CurrentResourceUsage;

        # SPRecycleBinQuery to Query Reycle bin 
        $SPDBRecycleBinQuery=new-object Microsoft.SharePoint.SPRecycleBinQuery
        $SPDBRecycleBinQuery.OrderBy = [Microsoft.SharePoint.SPRecycleBinOrderBy]::DeletedDate;
        $SPDBRecycleBinQuery.IsAscending = $false;
        $SPDBRecycleBinQuery.RowLimit = 2000
        $SPDBRecycleBinQuery.ItemState = [Microsoft.SharePoint.SPRecycleBinItemState]::SecondStageRecycleBin
        
        $SPDBPRecycleBinItemColl = $SPDBSite.GetRecycleBinItems($SPDBRecycleBinQuery)
        
        $Size=0
        
        for ($i=$SPDBPRecycleBinItemColl.Count-1; $i -GE 0; $i--)
        {
        $SPDBRecycleBinStorageSize+=$SPDBPRecycleBinItemColl[$i].Size
        }
        }
    }


	$SPDBRecycleBinStorageSize = $SPDBRecycleBinStorageSize/1GB
    $SPDBNeedsUpgrade          = $SPDB.NeedsUpgrade    

    if ($SPDBSiteLimit -eq $null) {$SPDBSiteLimit=-5}
    if ($SPCurSiteCount -eq $null) {$SPCurSiteCount=-5}

    write-output $SPDBType!$SPDBName~$SPDBStatus~$SPDBSize~$DiskSpaceUsage~$OrphanSite~$SPDBRecycleBinStorageSize~$SPDBSiteLimit~$SPCurSiteCount~$SPDBNeedsUpgrade '*}#'

    #Write-Host            "$CDBName~$CDBStatus~$ContentDatabaseSize~$DiskSpaceUsage~$OrphanSite~$RecycleBinStorageSize~$Sitelimit~$CurrentSiteCount" 
 
 #Remove-PSSnapin Microsoft.SharePoint.PowerShell 
    
}