﻿#Requires -Version 3.0
#This File is in Unicode format.  Do not edit in an ASCII editor.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#region help text

<#
.SYNOPSIS
	Creates an inventory of a Citrix PVS Farm details.
.DESCRIPTION
	Creates an inventory of a Citrix PVS Farm details using Microsoft PowerShell.
	
	The PVS Console must be installed and the snap-in registered on the computer running 
	the script.
	
	For Windows 8.x, Server 2012 and later, run:
	
	For 32-bit:
	%systemroot%\Microsoft.NET\Framework\v4.0.30319\installutil.exe "%ProgramFiles%\Citrix\Provisioning Services Console\Citrix.PVS.SnapIn.dll"
	
	For 64-bit:
	%systemroot%\Microsoft.NET\Framework64\v4.0.30319\installutil.exe "%ProgramFiles%\Citrix\Provisioning Services Console\Citrix.PVS.SnapIn.dll"
	
	
.INPUTS
	None.  You cannot pipe objects to this script.
.OUTPUTS
	No objects are output from this script.  
.NOTES
    Test	: PVSFarmTest
	
	Measures:
        1. License server availability
        2. Database server availability
        3. PVS sites count					- dd shows the active servers with serverName,ip
        4. PVS servers count				- dd shows the active servers with serverName,ip
        5. PVS stores count				    - dd shows the active servers with serverName,ip
        6. PVS farm views defined			-dd shows the active servers with serverName,ip

#>

#endregion

#region initialize variables
$SaveEAPreference = $ErrorActionPreference
$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False  

$global:CONST_SCRIPT_START = "***Start_Citrix_PVS_server_config_data_***";
$global:CONST_SCRIPT_END = "***End_Citrix_PVS_server_config_data_***";
$global:CONST_DELIMITER = "~#~";

Add-PSSnapin Citrix.PVS.SnapIn

#endregion

Function getPVSFarmDetails
{
    try
    {
        $pvsFarmFields = @('farmName','licenseServer','licenseServerPort','databaseServerName','databaseInstanceName','databaseName')
       
        $pvsFarm =  Get-PvsFarm -fields $pvsFarmFields
        
        If($? -and $pvsFarm -ne $Null)
        {
            Write-Host $($CONST_SCRIPT_START)

			$farmViewNameCount = "";
			$farmViewNames = "";
			$storeNameCount = "";
			$storeNames = "";
			$pvsServerIp = "";
			$pvsServerActive = "";
			$pvsServerNameCount = "";
			$pvsServerNames = "";
			$pvsSiteName = "";
			$pvsSiteNameCount = "";
			$pvsSiteNames = "";			
			$licenseServer = "";
			$licenseServerPort = "";
			$databaseServerName = "";
			$databaseInstanceName = "";
			$databaseName = "";
			$farmName = "";		
						
			$farmName = $pvsFarm.farmName
			$licenseServer = $pvsFarm.licenseServer -join ",";
			$licenseServerPort = $pvsFarm.licenseServerPort  -join ",";
			$databaseServerName = $pvsFarm.databaseServerName -join ",";
			$databaseInstanceName = $pvsFarm.databaseInstanceName -join ",";
			$databaseName = $pvsFarm.databaseName -join ",";
			
			$pvsFarmView = Get-PvsFarmView -fields FarmViewName
			If($? -and $pvsFarmView -ne $Null)
			{  
				$farmViewName = $pvsFarmView.FarmViewName

				if($pvsFarmView -ne $Null)
				{
					$farmViewNameCount = $farmViewName.Count
					$farmViewNames = $farmViewName -join ",";
				}
			}
		
			$pvsStore = Get-PvsStore -fields storeName

			If($? -and $pvsStore -ne $Null)
			{  
				$storeName = $pvsStore.storeName
				
				if($storeName -ne $Null)
				{
					$storeNameCount = $storeName.Count
					$storeNames = $storeName -join ",";
				}
			}
			
			$pvsSite = Get-PvsSite -fields siteName
			If($? -and $pvsSite -ne $Null)
			{ 
				$pvsSiteNameCount = $pvsSite.siteName.Count
			
				$pvsSiteName = $pvsSite.siteName  -join ",";
				if($pvsSiteName -ne $Null)
				{
					$pvsSiteNames = $pvsSiteName -join ",";
				}
			}
			
			$pvsServer = Get-PvsServer -fields serverName,ip,active

			If($? -and $pvsServer -ne $Null)
			{ 	   
				$pvsServerNames = "";
			    $pvsServerActive = "";
                $pvsServerIp = "";

				if($pvsServer -ne $Null)
				{
				   $pvsServerNameCount = $pvsServer.serverName.Count
									   
				   ForEach($currentPVSServer in $pvsServer)
				   {
						$pvsServerIp +=  $currentPVSServer.ip.IPAddressToString -join " ";

                        $pvsServerIp += ",";

						$pvsServerActive += $currentPVSServer.active.ToString() + ",";
						$pvsServerNames += $currentPVSServer.serverName.ToString() + ",";

						
					}
				}

                if($pvsServerNames.Trim().Length -gt 0)
                {
                    $pvsServerNames = $pvsServerNames.substring(0,$pvsServerNames.Trim().length-1)
                }

                if($pvsServerActive.Trim().Length -gt 0)
                {
                    $pvsServerActive = $pvsServerActive.substring(0,$pvsServerActive.Trim().length-1)
                }

                if($pvsServerIp.Trim().Length -gt 0)
                {
                    $pvsServerIp = $pvsServerIp.substring(0,$pvsServerIp.Trim().length-1)
                }				
			}
			
			Write-Host "farmName: $($farmName) $($CONST_DELIMITER) pvsServerIp: $($pvsServerIp) $($CONST_DELIMITER) pvsServerActive: $($pvsServerActive) $($CONST_DELIMITER) farmViewNameCount: $($farmViewNameCount) $($CONST_DELIMITER) farmViewNames: $($farmViewNames) $($CONST_DELIMITER) storeNameCount: $($storeNameCount) $($CONST_DELIMITER) storeNames: $($storeNames) $($CONST_DELIMITER) pvsServerNameCount: $($pvsServerNameCount) $($CONST_DELIMITER)  pvsServerNames: $($pvsServerNames) $($CONST_DELIMITER) pvsSiteNameCount: $($pvsSiteNameCount)  $($CONST_DELIMITER)  pvsSiteNames: $($pvsSiteNames) $($CONST_DELIMITER) licenseServer: $($licenseServer) $($CONST_DELIMITER) licenseServerPort: $($licenseServerPort) $($CONST_DELIMITER) databaseServerName: $($databaseServerName) $($CONST_DELIMITER) databaseInstanceName: $($databaseInstanceName) $($CONST_DELIMITER) databaseName: $($databaseName) $($CONST_DELIMITER)  pvsSiteName: $($pvsSiteName)";
        }

    }
    catch
    {
	    $global:isErrorOccured = $True
	    Write-Host " PVSFarmTest powershell script Exception ";
        Write-Host $_
    }

    If(-Not $isErrorOccured)
    {
	    Write-Host $CONST_SCRIPT_END
    }
}

getPVSFarmDetails
Remove-PSSnapin Citrix.PVS.SnapIn



