﻿$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin "Citrix.ConfigurationLogging.Admin.V1"

$flag = $args[0]
if(($flag -eq $null) -or ( $flag -ne "true" -and  $flag -ne "false"))
{
	Write-Host "1) To get completed task list and Currently running task list :"
	Write-Host "Format : <ps file name> true <measurement_period_in_seconds>"
	Write-Host "Example : XcXenDesktopAdminLogs.ps1 true '300'"
	Write-Host ""
	Write-Host "2) To get details of the given tasks only :"
	Write-Host "Format : <ps file name> false <prevStartTimeInSeconds>"
	Write-Host "Example : XcXenDesktopAdminLogs.ps1 false '900'"
	exit
}

if($flag -eq "true")
{
	$measurePeriod = $args[1]
	if($measurePeriod -eq $null)
	{
		Write-Host "To get details of the given tasks only :"
		Write-Host "Format : <ps file name> true <measurement_period_in_seconds>"
		Write-Host "Example : XcXenDesktopAdminLogs.ps1 true '300'"
		exit
	}
	$startTimeDate = (Get-Date).AddSeconds(-$measurePeriod)
	$endTimeDate = (Get-Date)

	Write-Host "Completed Task List :"
	Write-Host "----------------------"

	$HighLevelLogs = Get-LogHighLevelOperation -Filter{ StartTime -ge $startTimeDate -and EndTime -le $endTimeDate} -MaxRecordCount 2147483647

	foreach($HighLevelLog in $HighLevelLogs)
	{
		$HighLevelLogId = $HighLevelLog.Id
		if($HighLevelLogId -eq $null -or $HighLevelLogId.length -eq 0)
		{
			$HighLevelLogId = "-"
		}
		$HighLevelLogName = $HighLevelLog.Text
		if($HighLevelLogName -eq $null -or $HighLevelLogName.length -eq 0)
		{
			$HighLevelLogName = "-"
		}
		$HighLevelLogStartTime = $HighLevelLog.StartTime
		if($HighLevelLogStartTime -eq $null -or $HighLevelLogStartTime.length -eq 0)
		{
			$HighLevelLogStartTime = "-"
		}
		$HighLevelLogEndTime = $HighLevelLog.EndTime
		if($HighLevelLogEndTime -eq $null -or $HighLevelLogEndTime.length -eq 0)
		{
			$HighLevelLogEndTime = "-"
		}
		$HighLevelIsSuccessful = $HighLevelLog.IsSuccessful
		if($HighLevelIsSuccessful -eq $null -or $HighLevelIsSuccessful.length -eq 0)
		{
			$HighLevelIsSuccessful = "-"
		}
		$HighLevelLogUser = $HighLevelLog.User
		if($HighLevelLogUser -eq $null -or $HighLevelLogUser.length -eq 0)
		{
			$HighLevelLogUser = "-"
		}
		$HighLevelLogAdminIP = $HighLevelLog.AdminMachineIP
		if($HighLevelLogAdminIP -eq $null -or $HighLevelLogAdminIP.length -eq 0)
		{
			$HighLevelLogAdminIP = "-"
		}
		$HighLevelLogSource = $HighLevelLog.Source
		if($HighLevelLogSource -eq $null -or $HighLevelLogSource.length -eq 0)
		{
			$HighLevelLogSource = "-"
		}
		$HighLevelLogOperationType = $HighLevelLog.OperationType
		if($HighLevelLogOperationType -eq $null -or $HighLevelLogOperationType.length -eq 0)
		{
			$HighLevelLogOperationType = "-"
		}
		$HighLevelLogTargetTypes = $HighLevelLog.TargetTypes
		if($HighLevelLogTargetTypes -eq $null -or $HighLevelLogTargetTypes.length -eq 0)
		{
			$HighLevelLogTargetTypes = "-"
		}

		Write-Host "High Level Log :" ($HighLevelLogId, $HighLevelLogName, $HighLevelLogStartTime, $HighLevelLogEndTime, $HighLevelIsSuccessful,
				$HighLevelLogUser, $HighLevelLogAdminIP, $HighLevelLogSource, $HighLevelLogOperationType,
				$HighLevelLogTargetTypes) -Separator "#@#"

		$LowLevelLogs = Get-LogLowLevelOperation -MaxRecordCount 2147483647 -HighLevelOperationId $HighLevelLogId
		if($LowLevelLogs -eq $null)
		{
			continue
		}
		foreach($LowLevelLog in $LowLevelLogs)
		{
			$LowLevelLogName = $LowLevelLog.Text
			if($LowLevelLogName -eq $null -or $LowLevelLogName.length -eq 0)
			{
				$LowLevelLogName = "-"
			}
			$LowLevelLogStartTime = $LowLevelLog.StartTime
			if($LowLevelLogStartTime -eq $null -or $LowLevelLogStartTime.length -eq 0)
			{
				$LowLevelLogStartTime = "-"
			}
			$LowLevelLogEndTime = $LowLevelLog.EndTime
			if($LowLevelLogEndTime -eq $null -or $LowLevelLogEndTime.length -eq 0)
			{
				$LowLevelLogEndTime = "-"
			}
			$LowLevelLogIsSuccessful = $LowLevelLog.IsSuccessful
			if($LowLevelLogIsSuccessful -eq $null -or $LowLevelLogIsSuccessful.length -eq 0)
			{
				$LowLevelLogIsSuccessful = "-"
			}
			$LowLevelLogAdminSid = $LowLevelLog.AdminSid
			if($LowLevelLogAdminSid -eq $null -or $LowLevelLogAdminSid.length -eq 0)
			{
				$LowLevelLogAdminSid = "-"
			}
			$LowLevelLogAdminIP = $LowLevelLog.AdminMachineIP
			if($LowLevelLogAdminIP -eq $null -or $LowLevelLogAdminIP.length -eq 0)
			{
				$LowLevelLogAdminIP = "-"
			}
			$LowLevelLogSource = $LowLevelLog.Source
			if($LowLevelLogSource -eq $null -or $LowLevelLogSource.length -eq 0)
			{
				$LowLevelLogSource = "-"
			}
			$LowLevelLogSourceSdk = $LowLevelLog.SourceSdk
			if($LowLevelLogSourceSdk -eq $null -or $LowLevelLogSourceSdk.length -eq 0)
			{
				$LowLevelLogSourceSdk = "-"
			}
			$LowLevelLogOperationType = $LowLevelLog.OperationType
			if($LowLevelLogOperationType -eq $null -or $LowLevelLogOperationType.length -eq 0)
			{
				$LowLevelLogOperationType = "-"
			}
			$LowLevelLogTargetTypes = $LowLevelLog.TargetTypes
			if($LowLevelLogTargetTypes -eq $null -or $LowLevelLogTargetTypes.length -eq 0)
			{
				$LowLevelLogTargetTypes = "-"
			}
			Write-Host "Low Level Log :" ($HighLevelLogId, $LowLevelLogName, $LowLevelLogStartTime, $LowLevelLogEndTime, $LowLevelLogIsSuccessful,
				$LowLevelLogAdminSid, $LowLevelLogAdminIP, $LowLevelLogSource, $LowLevelLogSourceSdk,
				$LowLevelLogOperationType, $LowLevelLogTargetTypes) -Separator "#@#"
		}
	}

	Write-Host ""

	Write-Host "Currently Running Task List :"
	Write-Host "-----------------------------"

	$HighLevelLogs = Get-LogHighLevelOperation -Filter{ StartTime -ge $startTimeDate -and EndTime -eq $null} -MaxRecordCount 2147483647

	foreach($HighLevelLog in $HighLevelLogs)
	{
		$HighLevelLogId = $HighLevelLog.Id
		if($HighLevelLogId -eq $null -or $HighLevelLogId.length -eq 0)
		{
			$HighLevelLogId = "-"
		}
		$HighLevelLogName = $HighLevelLog.Text
		if($HighLevelLogName -eq $null -or $HighLevelLogName.length -eq 0)
		{
			$HighLevelLogName = "-"
		}
		$HighLevelLogStartTime = $HighLevelLog.StartTime
		if($HighLevelLogStartTime -eq $null -or $HighLevelLogStartTime.length -eq 0)
		{
			$HighLevelLogStartTime = "-"
		}
		$HighLevelLogEndTime = $HighLevelLog.EndTime
		if($HighLevelLogEndTime -eq $null -or $HighLevelLogEndTime.length -eq 0)
		{
			$HighLevelLogEndTime = "-"
		}
		$HighLevelIsSuccessful = $HighLevelLog.IsSuccessful
		if($HighLevelIsSuccessful -eq $null -or $HighLevelIsSuccessful.length -eq 0)
		{
			$HighLevelIsSuccessful = "-"
		}
		$HighLevelLogUser = $HighLevelLog.User
		if($HighLevelLogUser -eq $null -or $HighLevelLogUser.length -eq 0)
		{
			$HighLevelLogUser = "-"
		}
		$HighLevelLogAdminIP = $HighLevelLog.AdminMachineIP
		if($HighLevelLogAdminIP -eq $null -or $HighLevelLogAdminIP.length -eq 0)
		{
			$HighLevelLogAdminIP = "-"
		}
		$HighLevelLogSource = $HighLevelLog.Source
		if($HighLevelLogSource -eq $null -or $HighLevelLogSource.length -eq 0)
		{
			$HighLevelLogSource = "-"
		}
		$HighLevelLogOperationType = $HighLevelLog.OperationType
		if($HighLevelLogOperationType -eq $null -or $HighLevelLogOperationType.length -eq 0)
		{
			$HighLevelLogOperationType = "-"
		}
		$HighLevelLogTargetTypes = $HighLevelLog.TargetTypes
		if($HighLevelLogTargetTypes -eq $null -or $HighLevelLogTargetTypes.length -eq 0)
		{
			$HighLevelLogTargetTypes = "-"
		}

		Write-Host "High Level Log :" ($HighLevelLogId, $HighLevelLogName, $HighLevelLogStartTime, $HighLevelLogEndTime, $HighLevelIsSuccessful,
				$HighLevelLogUser, $HighLevelLogAdminIP, $HighLevelLogSource, $HighLevelLogOperationType,
				$HighLevelLogTargetTypes) -Separator "#@#"

		$LowLevelLogs = Get-LogLowLevelOperation -MaxRecordCount 2147483647 -HighLevelOperationId $HighLevelLogId
		if($LowLevelLogs -eq $null)
		{
			continue
		}
		foreach($LowLevelLog in $LowLevelLogs)
		{
			$LowLevelLogName = $LowLevelLog.Text
			if($LowLevelLogName -eq $null -or $LowLevelLogName.length -eq 0)
			{
				$LowLevelLogName = "-"
			}
			$LowLevelLogStartTime = $LowLevelLog.StartTime
			if($LowLevelLogStartTime -eq $null -or $LowLevelLogStartTime.length -eq 0)
			{
				$LowLevelLogStartTime = "-"
			}
			$LowLevelLogEndTime = $LowLevelLog.EndTime
			if($LowLevelLogEndTime -eq $null -or $LowLevelLogEndTime.length -eq 0)
			{
				$LowLevelLogEndTime = "-"
			}
			$LowLevelLogIsSuccessful = $LowLevelLog.IsSuccessful
			if($LowLevelLogIsSuccessful -eq $null -or $LowLevelLogIsSuccessful.length -eq 0)
			{
				$LowLevelLogIsSuccessful = "-"
			}
			$LowLevelLogAdminSid = $LowLevelLog.AdminSid
			if($LowLevelLogAdminSid -eq $null -or $LowLevelLogAdminSid.length -eq 0)
			{
				$LowLevelLogAdminSid = "-"
			}
			$LowLevelLogAdminIP = $LowLevelLog.AdminMachineIP
			if($LowLevelLogAdminIP -eq $null -or $LowLevelLogAdminIP.length -eq 0)
			{
				$LowLevelLogAdminIP = "-"
			}
			$LowLevelLogSource = $LowLevelLog.Source
			if($LowLevelLogSource -eq $null -or $LowLevelLogSource.length -eq 0)
			{
				$LowLevelLogSource = "-"
			}
			$LowLevelLogSourceSdk = $LowLevelLog.SourceSdk
			if($LowLevelLogSourceSdk -eq $null -or $LowLevelLogSourceSdk.length -eq 0)
			{
				$LowLevelLogSourceSdk = "-"
			}
			$LowLevelLogOperationType = $LowLevelLog.OperationType
			if($LowLevelLogOperationType -eq $null -or $LowLevelLogOperationType.length -eq 0)
			{
				$LowLevelLogOperationType = "-"
			}
			$LowLevelLogTargetTypes = $LowLevelLog.TargetTypes
			if($LowLevelLogTargetTypes -eq $null -or $LowLevelLogTargetTypes.length -eq 0)
			{
				$LowLevelLogTargetTypes = "-"
			}
			Write-Host "Low Level Log :" ($HighLevelLogId, $LowLevelLogName, $LowLevelLogStartTime, $LowLevelLogEndTime, $LowLevelLogIsSuccessful,
				$LowLevelLogAdminSid, $LowLevelLogAdminIP, $LowLevelLogSource, $LowLevelLogSourceSdk,
				$LowLevelLogOperationType, $LowLevelLogTargetTypes) -Separator "#@#"
		}
	}
}
ElseIf ($flag -eq "false")
{
	$startDate = $args[1]
	if($startDate -eq $null)
	{
		Write-Host "To get details of the given tasks only :"
		Write-Host "Format : <ps file name> false <prevStartTimeInSeconds>"
		Write-Host "Example : XcXenDesktopAdminLogs.ps1 false '900'"
		exit
	}
	$prevStartDate = (Get-Date).AddSeconds(-$startDate)

	Write-Host "Previously Running Task List :"
	Write-Host "----------------------------"
	$HighLevelLogs = Get-LogHighLevelOperation -Filter{ StartTime -ge $prevStartDate} -MaxRecordCount 2147483647
	foreach($HighLevelLog in $HighLevelLogs)
	{
		$HighLevelLogId = $HighLevelLog.Id
		if($HighLevelLogId -eq $null -or $HighLevelLogId.length -eq 0)
		{
			$HighLevelLogId = "-"
		}
		$HighLevelLogName = $HighLevelLog.Text
		if($HighLevelLogName -eq $null -or $HighLevelLogName.length -eq 0)
		{
			$HighLevelLogName = "-"
		}
		$HighLevelLogStartTime = $HighLevelLog.StartTime
		if($HighLevelLogStartTime -eq $null -or $HighLevelLogStartTime.length -eq 0)
		{
			$HighLevelLogStartTime = "-"
		}
		$HighLevelLogEndTime = $HighLevelLog.EndTime
		if($HighLevelLogEndTime -eq $null -or $HighLevelLogEndTime.length -eq 0)
		{
			$HighLevelLogEndTime = "-"
		}
		$HighLevelIsSuccessful = $HighLevelLog.IsSuccessful
		if($HighLevelIsSuccessful -eq $null -or $HighLevelIsSuccessful.length -eq 0)
		{
			$HighLevelIsSuccessful = "-"
		}
		$HighLevelLogUser = $HighLevelLog.User
		if($HighLevelLogUser -eq $null -or $HighLevelLogUser.length -eq 0)
		{
			$HighLevelLogUser = "-"
		}
		$HighLevelLogAdminIP = $HighLevelLog.AdminMachineIP
		if($HighLevelLogAdminIP -eq $null -or $HighLevelLogAdminIP.length -eq 0)
		{
			$HighLevelLogAdminIP = "-"
		}
		$HighLevelLogSource = $HighLevelLog.Source
		if($HighLevelLogSource -eq $null -or $HighLevelLogSource.length -eq 0)
		{
			$HighLevelLogSource = "-"
		}
		$HighLevelLogOperationType = $HighLevelLog.OperationType
		if($HighLevelLogOperationType -eq $null -or $HighLevelLogOperationType.length -eq 0)
		{
			$HighLevelLogOperationType = "-"
		}
		$HighLevelLogTargetTypes = $HighLevelLog.TargetTypes
		if($HighLevelLogTargetTypes -eq $null -or $HighLevelLogTargetTypes.length -eq 0)
		{
			$HighLevelLogTargetTypes = "-"
		}

		Write-Host "High Level Log :" ($HighLevelLogId, $HighLevelLogName, $HighLevelLogStartTime, $HighLevelLogEndTime, $HighLevelIsSuccessful,
				$HighLevelLogUser, $HighLevelLogAdminIP, $HighLevelLogSource, $HighLevelLogOperationType,
				$HighLevelLogTargetTypes) -Separator "#@#"

		$LowLevelLogs = Get-LogLowLevelOperation -MaxRecordCount 2147483647 -HighLevelOperationId $HighLevelLogId
		if($LowLevelLogs -eq $null)
		{
			continue
		}
		foreach($LowLevelLog in $LowLevelLogs)
		{
			$LowLevelLogName = $LowLevelLog.Text
			if($LowLevelLogName -eq $null -or $LowLevelLogName.length -eq 0)
			{
				$LowLevelLogName = "-"
			}
			$LowLevelLogStartTime = $LowLevelLog.StartTime
			if($LowLevelLogStartTime -eq $null -or $LowLevelLogStartTime.length -eq 0)
			{
				$LowLevelLogStartTime = "-"
			}
			$LowLevelLogEndTime = $LowLevelLog.EndTime
			if($LowLevelLogEndTime -eq $null -or $LowLevelLogEndTime.length -eq 0)
			{
				$LowLevelLogEndTime = "-"
			}
			$LowLevelLogIsSuccessful = $LowLevelLog.IsSuccessful
			if($LowLevelLogIsSuccessful -eq $null -or $LowLevelLogIsSuccessful.length -eq 0)
			{
				$LowLevelLogIsSuccessful = "-"
			}
			$LowLevelLogAdminSid = $LowLevelLog.AdminSid
			if($LowLevelLogAdminSid -eq $null -or $LowLevelLogAdminSid.length -eq 0)
			{
				$LowLevelLogAdminSid = "-"
			}
			$LowLevelLogAdminIP = $LowLevelLog.AdminMachineIP
			if($LowLevelLogAdminIP -eq $null -or $LowLevelLogAdminIP.length -eq 0)
			{
				$LowLevelLogAdminIP = "-"
			}
			$LowLevelLogSource = $LowLevelLog.Source
			if($LowLevelLogSource -eq $null -or $LowLevelLogSource.length -eq 0)
			{
				$LowLevelLogSource = "-"
			}
			$LowLevelLogSourceSdk = $LowLevelLog.SourceSdk
			if($LowLevelLogSourceSdk -eq $null -or $LowLevelLogSourceSdk.length -eq 0)
			{
				$LowLevelLogSourceSdk = "-"
			}
			$LowLevelLogOperationType = $LowLevelLog.OperationType
			if($LowLevelLogOperationType -eq $null -or $LowLevelLogOperationType.length -eq 0)
			{
				$LowLevelLogOperationType = "-"
			}
			$LowLevelLogTargetTypes = $LowLevelLog.TargetTypes
			if($LowLevelLogTargetTypes -eq $null -or $LowLevelLogTargetTypes.length -eq 0)
			{
				$LowLevelLogTargetTypes = "-"
			}
			Write-Host "Low Level Log :" ($HighLevelLogId, $LowLevelLogName, $LowLevelLogStartTime, $LowLevelLogEndTime, $LowLevelLogIsSuccessful,
				$LowLevelLogAdminSid, $LowLevelLogAdminIP, $LowLevelLogSource, $LowLevelLogSourceSdk,
				$LowLevelLogOperationType, $LowLevelLogTargetTypes) -Separator "#@#"
		}
	}
}

Remove-PSSnapin "Citrix.ConfigurationLogging.Admin.V1"




