# This Script will give all details of Citrix XenDesktop Site in Citrix Excalibur
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Add-PSSnapin "Citrix.Common.Commands"
Add-PSSnapin "Citrix.Host.Admin.V2"
Add-PSSnapin "Citrix.Broker.Admin.V2"
Add-PSSnapin "Citrix.ADIdentity.Admin.V2"
Add-PSSnapin "Citrix.Configuration.Admin.V2"
Add-PSSnapin "Citrix.MachineCreation.Admin.V2"
Add-PSSnapin "Citrix.Licensing.Admin.V1"
Add-PSSnapin "Citrix.DelegatedAdmin.Admin.V1"
Add-PSSnapin "Citrix.Monitor.Admin.V1"
Add-PSSnapin "Citrix.ConfigurationLogging.Admin.V1"
Add-PSSnapin "Citrix.AppLibrary.Admin.V1"

$ZoneControllersHash = @{}
$ConfiguredZones = Get-ConfigZone -EA 0
foreach($Zone in $ConfiguredZones)
{
	$ZoneControllersHash.Add($Zone.Name,$Zone.ControllerSids)
}

Write-Host "Site"
Write-Host "----"
$Site = Get-BrokerSite
if ($Site -ne $null)
{
	$LicenseEdition = $Site.LicenseEdition
	if ($LicenseEdition -eq $null -or $LicenseEdition.length -eq 0)
	{
		$LicenseEdition = "-"
	}

	$LicenseModel = $Site.LicenseModel
	if ($LicenseModel -eq $null -or $LicenseModel.length -eq 0)
	{
		$LicenseModel = "-"
	}

	$LicensingGraceHoursLeft = $Site.LicensingGraceHoursLeft
	if($LicensingGraceHoursLeft -eq $null -or $LicensingGraceHoursLeft.length -eq 0)
	{
		$LicensingGraceHoursLeft = "-"
	}
	Write-Host ($Site.Name,$Site.LicenseServerName,$Site.LicenseServerPort,$Site.LicensedSessionsActive,
	$LicenseEdition,$LicenseModel,$Site.LicensingBurnInDate,$Site.DnsResolutionEnabled,$Site.SecureIcaRequired,
	$Site.TrustRequestsSentToTheXmlServicePort,
	$Site.ConnectionLeasingEnabled,$Site.LicensingGracePeriodActive,$Site.LicensingOutOfBoxGracePeriodActive,$LicensingGraceHoursLeft) -Separator ";"
}

Write-Host "Hypervisor Details"
Write-Host "------------------"
$HypConnPath = "XDHyp:\Connections\"
$HypConnections = Get-ChildItem $HypConnPath
if ($HypConnections -ne $null)
{
	foreach ($HypConn in $HypConnections)
	{
		$ConnectionType = $HypConn.ConnectionType
		$HypervisorConnectionName = $HypConn.HypervisorConnectionName
		$HypervisorAddress = $HypConn.HypervisorAddress
		if ($HypervisorAddress -eq $null -or $HypervisorAddress.length -eq 0)
		{
			$HypervisorAddress = "-"
		}
		else
		{
			$HypvConn = ""
			$count = 0
			foreach ($key in $HypervisorAddress)
			{
				if ($count -eq 0)
				{
					$HypvConn = $key
				}
				else
				{
					$HypvConn = $HypvConn + "#" + $key
				}
				$count = $count + 1
			}
			if ($HypvConn -eq $null -or $HypvConn.length -eq 0)
			{
				$HypervisorAddress = "-"
			}
			else
			{
				$HypervisorAddress = $HypvConn
			}
		}
		$MaintenanceMode = $HypConn.MaintenanceMode
		$Persistent = $HypConn.Persistent
		$SupportsLocalStorageCaching = $HypConn.SupportsLocalStorageCaching
		$SupportsPvsVMs = $HypConn.SupportsPvsVMs
		$UserName = $HypConn.UserName
		$Scopes = $HypConn.Scopes
		if ($Scopes -eq $null -or $Scopes.length -eq 0)
		{
			$Scopes = "-"
		}
		$HypZone = $HypConn.ZoneName
		if($HypZone -eq $null -or $HypZone.length -eq 0)
		{
			$HypZone = "-"
		}
		# Hypervisor State
		# Unavailable - The broker is unable to contact the hypervisor.
		# InMaintenanceMode - The hosting server is in maintenance mode.
		# On - The broker is in contact with the hypervisor.
		$HyperConns = Get-BrokerHypervisorConnection -HypHypervisorConnectionUid $HypConn.HypervisorConnectionUid
		if($HyperConns -ne $null)
		{
			$State = $HyperConns.State
			$PreferredController = $HyperConns.PreferredController
			Write-Host ($HypervisorConnectionName,$State,$ConnectionType,$HypervisorAddress,$PreferredController,$MaintenanceMode,
			$Persistent,$SupportsLocalStorageCaching,$SupportsPvsVMs,$UserName,$Scopes,$HypZone) -Separator ";"
		}
	}
}

Write-Host "Controllers"
Write-Host "-----------"
$Controllers = Get-BrokerController
if($Controllers -ne $null)
{
	foreach($Controller in $Controllers)
	{
		$DNSName = $Controller.DNSName
		$ControllerSid = $Controller.SID
		if ($DNSName -eq $null -or $DNSName.length -eq 0)
		{
			$DNSName = "-"
		}
		$ControllerZoneName = "-"
		if($ZoneControllersHash.Count -gt 0)
		{
			$ZoneKeys = $ZoneControllersHash.KEYS.GetEnumerator()
			foreach($ZoneKey in $ZoneKeys)
			{
				$ZoneValues = $ZoneControllersHash[$ZoneKey]
				if($ZoneValues.Contains($ControllerSid) -eq $true)
				{
					$ControllerZoneName = $ZoneKey
				}
			}
		}
		$OSType = $Controller.OSType
		if ($OSType -eq $null -or $OSType.length -eq 0)
		{
			$OSType = "-"
		}
		$OSVersion = $Controller.OSVersion
		if ($OSVersion -eq $null -or $OSVersion.length -eq 0)
		{
			$OSVersion = "-"
		}

		Write-Host($DNSName,$Controller.MachineName,$Controller.State,$Controller.DesktopsRegistered,
		$Controller.ControllerVersion,$OSType,$OSVersion,$Controller.LastActivityTime,$Controller.LastStartTime,$ControllerZoneName) -Separator ";"
	}
}

Write-Host "Controller Services"
Write-Host "-------------------"
if($Controllers -ne $null)
{
	foreach($Controller in $Controllers)
	{
		$DNSName = $Controller.DNSName
		if ($DNSName -eq $null -or $DNSName.length -eq 0)
		{
			continue
		}
		#$DNSName = $DNSName.Substring($DNSName.indexOf('.'))
		$State = $Controller.State
		if ($State -eq $null -or $State.length -eq 0)
		{
			continue
		}
		if ($State -eq "Off" -or $State -eq "Failed")
		{
			continue
		}

		$ADIdentityStatus = Get-AcctServiceStatus -AdminAddress $DNSName
		if ($ADIdentityStatus -eq $null -or $ADIdentityStatus.length -eq 0)
		{
			$ADIdentityStatus = "-"
		}
		$BrokerStatus = Get-BrokerServiceStatus -AdminAddress $DNSName
		if ($BrokerStatus -eq $null -or $BrokerStatus.length -eq 0)
		{
			$BrokerStatus = "-"
		}
		$ConfigStatus = Get-ConfigServiceStatus -AdminAddress $DNSName
		if ($ConfigStatus -eq $null -or $ConfigStatus.length -eq 0)
		{
			$ConfigStatus = "-"
		}
		$HypStatus = Get-HypServiceStatus -AdminAddress $DNSName
		if ($HypStatus -eq $null -or $HypStatus.length -eq 0)
		{
			$HypStatus = "-"
		}
		$MachineCreationStatus = Get-ProvServiceStatus -AdminAddress $DNSName
		if ($MachineCreationStatus -eq $null -or $MachineCreationStatus.length -eq 0)
		{
			$MachineCreationStatus = "-"
		}
		$AdminServiceStatus = Get-AdminServiceStatus -AdminAddress $DNSName
		if ($AdminServiceStatus -eq $null -or $AdminServiceStatus.length -eq 0)
		{
			$AdminServiceStatus = "-"
		}
		#$LicServiceStatus = Get-LicServiceStatus -AdminAddress $DNSName
		#if ($LicServiceStatus -eq $null -or $LicServiceStatus.length -eq 0)
		#{
			$LicServiceStatus = "-"
		#}
		$MonitorServiceStatus = Get-MonitorServiceStatus -AdminAddress $DNSName
		if ($MonitorServiceStatus -eq $null -or $MonitorServiceStatus.length -eq 0)
		{
			$MonitorServiceStatus = "-"
		}
		$LogServiceStatus = "-"
		$LogServiceStatusObj = Get-LogServiceStatus -AdminAddress $DNSName
		if ($LogServiceStatusObj -ne $null)
		{
			$LogServiceStatus = $LogServiceStatusObj.ServiceStatus
			if ($LogServiceStatus -eq $null -or $LogServiceStatus.length -eq 0)
			{
				$LogServiceStatus = "-"
			}
		}
		Write-Host($DNSName,$ADIdentityStatus,$BrokerStatus,$ConfigStatus,$HypStatus,$MachineCreationStatus,
		$AdminServiceStatus,$LicServiceStatus,$MonitorServiceStatus,$LogServiceStatus) -Separator ";"
	}
}

Write-Host "Machine Catalogs"
Write-Host "----------------"
$Catalogs = Get-BrokerCatalog -MaxRecordCount 2147483647
if($Catalogs -ne $null)
{
	foreach($Catalog in $Catalogs)
	{
		$Description = "-"
		$PvsAddress = $Catalog.PvsAddress 
		if ($PvsAddress -eq $null -or $PvsAddress.length -eq 0)
		{
			$PvsAddress = "-"
		}
		$PvsDomain = $Catalog.PvsDomain
		if ($PvsDomain -eq $null -or $PvsDomain.length -eq 0)
		{
			$PvsDomain = "-"
		}
		$Description = $Catalog.Description
		if ($Description -eq $null -or $Description.length -eq 0)
		{
			$Description = "-"
		}
		$Scopes = $Catalog.Scopes
		if ($Scopes -eq $null -or $Scopes.length -eq 0)
		{
			$Scopes = "-"
		}
		$ZoneName = $Catalog.ZoneName
		if ($ZoneName -eq $null -or $ZoneName.length -eq 0)
		{
			$ZoneName = "-"
		}
		Write-Host ($Catalog.Name,$Catalog.AllocationType,$Catalog.AssignedCount,$Catalog.AvailableAssignedCount,$Catalog.AvailableCount,
		$Catalog.AvailableUnassignedCount,$Catalog.UnassignedCount,$Catalog.UsedCount,$Catalog.MachinesArePhysical,$PvsAddress,
		$PvsDomain,$Catalog.PersistUserChanges,$Catalog.ProvisioningType,$Catalog.SessionSupport,$Description,$Scopes,$ZoneName) -Separator ";"
	}
}


Write-Host "Zones"
Write-Host "------"
foreach($Zone in $ConfiguredZones)
{
	Write-Host($Zone.Name,$Zone.IsPrimary) -Separator ";"
}

Remove-PSSnapin "Citrix.Common.Commands"
Remove-PSSnapin "Citrix.Host.Admin.V2"
Remove-PSSnapin "Citrix.Broker.Admin.V2"
Remove-PSSnapin "Citrix.ADIdentity.Admin.V2"
Remove-PSSnapin "Citrix.Configuration.Admin.V2"
Remove-PSSnapin "Citrix.MachineCreation.Admin.V2"
Remove-PSSnapin "Citrix.Licensing.Admin.V1"
Remove-PSSnapin "Citrix.DelegatedAdmin.Admin.V1"
Remove-PSSnapin "Citrix.Monitor.Admin.V1"
Remove-PSSnapin "Citrix.ConfigurationLogging.Admin.V1"
Remove-PSSnapin "Citrix.AppLibrary.Admin.V1"


