﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$argsCount = $args.length
if ($argsCount -eq 0)
{
	Write-Host "Please supply Server name"
	break
}

$ServerName = $args[0]
$Global:ErrorActionPreference="SilentlyContinue"
$svr = Get-ExchangeServer $ServerName 
$version = $svr.AdminDisplayVersion

if($version.Major -lt 14)
{
	break
}

$mboxes = Get-Mailbox -Server $ServerName -ResultSize unlimited
foreach ($mbox in $mboxes) 
{
	$Database = $mbox.Database
	$casmbox = $mbox | Get-CASMailBox
	if ($casmbox -ne $null)
	{
		Write-Host ($Database,$casmbox.Name,$casmbox.PrimarySmtpAddress,$casmbox.ActiveSyncEnabled,$casmbox.OWAEnabled,
			    $casmbox.OWAMobileAppEnabled,$casmbox.PopEnabled,$casmbox.ImapEnabled,$casmbox.MAPIEnabled) -Separator ";"
	}
}


