''''''''''''''''''''''''''''''''''''
'
' ADSUTIL.VBS
'
' Author: Adam Stone
' Date:   7/24/97
' Revision History:
'     Date         Comment
'    7/24/97       Initial version started
'    5/8/98        Bug fixes and ENUM_ALL
'    12/1/98       Fixed display error on list data.
'    7/27/99	   AppCreate2 fix (sonaligu)
'    8/5/99 	   Dont display encrypted data (sonaligu)
''''''''''''''''''''''''''''''''''''
Option Explicit
On Error Resume Next

''''''''''''''''''
' Main Script Code
''''''''''''''''''
Dim ArgObj ' Object which contains the command line argument
Dim Result ' Result of the command function call
Dim Args(10) ' Array that contains all of the non-global arguments
Dim ArgCount ' Tracks the size of the Args array

' Used for string formatting
Dim Spacer
Dim SpacerSize

Const IIS_DATA_NO_INHERIT = 0
Const IIS_DATA_INHERIT = 1
Const GENERAL_FAILURE = 2
Const GENERAL_WARNING = 1
Const AppCreate_InProc = 0
Const AppCreate_OutOfProc = 1
Const AppCreate_PooledOutOfProc = 2

Const APPSTATUS_NOTDEFINED = 2   
Const APPSTATUS_RUNNING = 1    
Const APPSTATUS_STOPPED = 0    

Spacer = "                                " ' Used to format the strings
SpacerSize = Len(Spacer)

' Note: The default execution mode may be under WScript.exe.
' That would be very annoying since WScript has popups for Echo.
' So, I want to detect that, and warn the user that it may cause
' problems.
DetectExeType

' Get the Arguments object
Set ArgObj = WScript.Arguments

' Test to make sure there is at least one command line arg - the command
If ArgObj.Count < 1 Then
        DisplayHelpMessage
        WScript.Quit (GENERAL_FAILURE)
End If

'*****************************************************
' Modified by Matt Nicholson
Dim TargetServer 'The server to be examined/modified
Dim I
For I = 0 To ArgObj.Count - 1
        If LCase(Left(ArgObj.Item(I), 3)) = "-s:" Then
                TargetServer = Right(ArgObj.Item(I), Len(ArgObj.Item(I)) - 3)
        Else
                Args(ArgCount) = ArgObj.Item(I)
                ArgCount = ArgCount + 1
        End If
Next
If Len(TargetServer) = 0 Then
        TargetServer = "localhost"
End If
'*****************************************************

' Call the function associated with the given command
Select Case UCase(Args(0))
    Case "SET"
                Result = SetCommand()
    Case "CREATE"
                Result = CreateCommand("")
    Case "DELETE"
                Result = DeleteCommand()
    Case "GET"
                Result = GetCommand()
    Case "ENUM"
'                Result = EnumCommand()
                Result = EnumCommand(False, "")
    Case "ENUM_ALL"
'                Result = EnumAllCommand()
                Result = EnumCommand(True, "")
    Case "ENUMALL"
'                Result = EnumAllCommand()
                Result = EnumCommand(True, "")
    Case "COPY"
                Result = CopyMoveCommand(True)   ' The TRUE means COPY, not MOVE
    Case "MOVE"
                Result = CopyMoveCommand(False)   ' The FALSE means MOVE, not COPY
    Case "CREATE_VDIR"
                Result = CreateCommand("IIsWebVirtualDir")
    Case "CREATE_VSERV"
                Result = CreateCommand("IIsWebServer")
    Case "START_SERVER"
                Result = StartServerCommand()
    Case "STOP_SERVER"
                Result = StopServerCommand()
    Case "PAUSE_SERVER"
                Result = PauseServerCommand()
    Case "CONTINUE_SERVER"
                Result = ContinueServerCommand()
' New Stuff being added
        Case "FIND"
                Result = FindData()
        Case "COPY"
                WScript.Echo "COPY is not yet supported.  It will be soon."
        Case "APPCREATEINPROC"
                Result = AppCreateCommand(AppCreate_InProc)
        Case "APPCREATEOUTPROC"
                Result = AppCreateCommand(AppCreate_OutOfProc)
	Case "APPCREATEPOOLPROC"
		Result = AppCreateCommand(AppCreate_PooledOutOfProc)
        Case "APPDELETE"
                Result = AppDeleteCommand()
        Case "APPUNLOAD"
                Result = AppUnloadCommand()
        Case "APPDISABLE"
                Result = AppDisableCommand()
        Case "APPENABLE"
                Result = AppEnableCommand()
        Case "APPGETSTATUS"
                Result = AppGetStatusCommand()
        Case "HELP"
                DisplayHelpMessageEx
        
' End New Stuff

    Case Else
                WScript.Echo "Command not recognized: " & Args(0)
                WScript.Echo "For help, just type ""Cscript.exe adsutil.vbs""."
                Result = GENERAL_FAILURE

End Select

WScript.Quit (Result)

''''''''''
' End Main
''''''''''


''''''''''''''''''''''''''''
'
' Display Help Message
'
''''''''''''''''''''''''''''
Sub DisplayHelpMessage()
    WScript.Echo
    WScript.Echo "Usage:"
    WScript.Echo "      ADSUTIL.VBS <cmd> [<path> [<value>]]"
    WScript.Echo
    WScript.Echo "Note: ADSUTIL only supports the ""no switch"" option of MDUTIL"
    WScript.Echo
    WScript.Echo "Description:"
    WScript.Echo "IIS K2 administration utility that enables the manipulation with ADSI parameters"
    WScript.Echo
    WScript.Echo "Supported MDUTIL Commands:"
    WScript.Echo "  GET, SET, ENUM, DELETE, CREATE, COPY, "
    WScript.Echo "  APPCREATEINPROC, APPCREATEOUTPROC, APPCREATEPOOLPROC, APPDELETE, APPUNLOAD, APPGETSTATUS "
    WScript.Echo
    WScript.Echo "Samples:"
    WScript.Echo "  adsutil.vbs GET W3SVC/1/ServerBindings"
    WScript.Echo "  adsutil.vbs SET W3SVC/1/ServerBindings "":81:"""
    WScript.Echo "  adsutil.vbs CREATE W3SVC/1/Root/MyVdir ""IIsWebVirtualDir"""
    WScript.Echo "  adsutil.vbs START_SERVER W3SVC/1"
    WScript.Echo "  adsutil.vbs ENUM /P W3SVC"
        WScript.Echo
        WScript.Echo "For Extended Help type:"
        WScript.Echo "  adsutil.vbs HELP"


End Sub



''''''''''''''''''''''''''''
'
' Display Help Message
'
''''''''''''''''''''''''''''
Sub DisplayHelpMessageEx()

    WScript.Echo
    WScript.Echo "Usage:"
    WScript.Echo "      ADSUTIL.VBS CMD [param param]"
    WScript.Echo
    WScript.Echo "Note: ADSUTIL only supports the ""no switch"" option of MDUTIL"
    WScript.Echo
    WScript.Echo "Description:"
    WScript.Echo "IIS K2 administration utility that enables the manipulation with ADSI parameters"
    WScript.Echo
    WScript.Echo "Standard MDUTIL Commands:"
    WScript.Echo " adsutil.vbs GET      path             - display chosen parameter"
    WScript.Echo " adsutil.vbs SET      path value ...   - assign the new value"
    WScript.Echo " adsutil.vbs ENUM     path [""/P"" | ""/A""] - enumerate all parameters for given path"
    WScript.Echo " adsutil.vbs DELETE   path             - delete given path or parameter"
    WScript.Echo " adsutil.vbs CREATE   path [KeyType]   - create given path and assigns it the given KeyType"
    WScript.Echo
    WScript.Echo " adsutil.vbs APPCREATEINPROC  w3svc/1/root - Create an in-proc application"
    WScript.Echo " adsutil.vbs APPCREATEOUTPROC w3svc/1/root - Create an out-proc application"
    WScript.Echo " adsutil.vbs APPCREATEPOOLPROC w3svc/1/root- Create a pooled-proc application" 
    WScript.Echo " adsutil.vbs APPDELETE        w3svc/1/root - Delete the application if there is one"
    WScript.Echo " adsutil.vbs APPUNLOAD        w3svc/1/root - Unload an application from w3svc runtime lookup table."
    WScript.Echo " adsutil.vbs APPDISABLE       w3svc/1/root - Disable an application - appropriate for porting to another machine."
    WScript.Echo " adsutil.vbs APPENABLE        w3svc/1/root - Enable an application - appropriate for importing from another machine."
    WScript.Echo " adsutil.vbs APPGETSTATUS     w3svc/1/root - Get status of the application"
    WScript.Echo
    WScript.Echo "New ADSI Options:"
    WScript.Echo " /P - Valid for ENUM only.  Enumerates the paths only (no data)"
    WScript.Echo " /A - Valid for ENUM only.  Enumerates all data that CAN be set on the node"
    WScript.Echo " KeyType - Valide for CREATE only.  Assigns the valid KeyType to the path"
    WScript.Echo
    WScript.Echo "Extended ADSUTIL Commands:"
    WScript.Echo " adsutil.vbs FIND             path     - find the paths where a given parameter is set"
    WScript.Echo " adsutil.vbs CREATE_VDIR      path     - create given path as a Virtual Directory"
    WScript.Echo " adsutil.vbs CREATE_VSERV     path     - create given path as a Virtual Server"
    WScript.Echo " adsutil.vbs START_SERVER     path     - starts the given web site"
    WScript.Echo " adsutil.vbs STOP_SERVER      path     - stops the given web site"
    WScript.Echo " adsutil.vbs PAUSE_SERVER     path     - pauses the given web site"
    WScript.Echo " adsutil.vbs CONTINUE_SERVER  path     - continues the given web site"
    WScript.Echo
    WScript.Echo
    WScript.Echo "Samples:"
    WScript.Echo "  adsutil.vbs GET W3SVC/1/ServerBindings"
    WScript.Echo "  adsutil.vbs SET W3SVC/1/ServerBindings "":81:"""
    WScript.Echo "  adsutil.vbs CREATE W3SVC/1/Root/MyVdir ""IIsWebVirtualDir"""
    WScript.Echo "  adsutil.vbs START_SERVER W3SVC/1"
    WScript.Echo "  adsutil.vbs ENUM /P W3SVC"

    WScript.Echo "Extended ADSUTIL Commands:"
    WScript.Echo " adsutil.vbs FIND             path     - find the paths where a given parameter is set"
    WScript.Echo " adsutil.vbs CREATE_VDIR      path     - create given path as a Virtual Directory"
    WScript.Echo " adsutil.vbs CREATE_VSERV     path     - create given path as a Virtual Server"
    WScript.Echo " adsutil.vbs START_SERVER     path     - starts the given web site"
    WScript.Echo " adsutil.vbs STOP_SERVER      path     - stops the given web site"
    WScript.Echo " adsutil.vbs PAUSE_SERVER     path     - pauses the given web site"
    WScript.Echo " adsutil.vbs CONTINUE_SERVER  path     - continues the given web site"
    WScript.Echo
    WScript.Echo
    WScript.Echo "Samples:"
    WScript.Echo "  adsutil.vbs GET W3SVC/1/ServerBindings"
    WScript.Echo "  adsutil.vbs SET W3SVC/1/ServerBindings "":81:"""
    WScript.Echo "  adsutil.vbs CREATE W3SVC/1/Root/MyVdir ""IIsWebVirtualDir"""
    WScript.Echo "  adsutil.vbs START_SERVER W3SVC/1"
    WScript.Echo "  adsutil.vbs ENUM /P W3SVC"

' adsutil.vbs ENUM_ALL path             - recursively enumerate all parameters
' adsutil.vbs COPY     pathsrc pathdst  - copy all from pathsrc to pathdst (will create pathdst)
' adsutil.vbs SCRIPT   scriptname       - runs the script

'  -path has format: {computer}/{service}/{instance}/{URL}/{Parameter}

End Sub






'''''''''''''''''''''''''''
'
' DetectExeType
'
' This can detect the type of exe the
' script is running under and warns the
' user of the popups.
'
'''''''''''''''''''''''''''
Sub DetectExeType()
        Dim ScriptHost
        Dim ShellObject

        Dim CurrentPathExt
        Dim EnvObject

        Dim RegCScript
        Dim RegPopupType ' This is used to set the pop-up box flags.
                                                ' I couldn't find the pre-defined names
        RegPopupType = 32 + 4

        On Error Resume Next

        ScriptHost = WScript.FullName
        ScriptHost = Right(ScriptHost, Len(ScriptHost) - InStrRev(ScriptHost, "\"))

        If (UCase(ScriptHost) = "WSCRIPT.EXE") Then
                WScript.Echo ("This script does not work with WScript.")

                ' Create a pop-up box and ask if they want to register cscript as the default host.
                Set ShellObject = WScript.CreateObject("WScript.Shell")
                ' -1 is the time to wait.  0 means wait forever.
                RegCScript = ShellObject.PopUp("Would you like to register CScript as your default host for VBscript?", 0, "Register CScript", RegPopupType)
                                                                                
                If (Err.Number <> 0) Then
                        ReportError ()
                        WScript.Echo "To run this script using CScript, type: ""CScript.exe " & WScript.ScriptName & """"
                        WScript.Quit (GENERAL_FAILURE)
                        WScript.Quit (Err.Number)
                End If

                ' Check to see if the user pressed yes or no.  Yes is 6, no is 7
                If (RegCScript = 6) Then
                        ShellObject.RegWrite "HKEY_CLASSES_ROOT\VBSFile\Shell\Open\Command\", "%WINDIR%\System32\CScript.exe //nologo ""%1"" %*", "REG_EXPAND_SZ"
                        ShellObject.RegWrite "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\VBSFile\Shell\Open\Command\", "%WINDIR%\System32\CScript.exe //nologo ""%1"" %*", "REG_EXPAND_SZ"
                        ' Check if PathExt already existed
                        CurrentPathExt = ShellObject.RegRead("HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment\PATHEXT")
                        If Err.Number = &H80070002 Then
                                Err.Clear
                                Set EnvObject = ShellObject.Environment("PROCESS")
                                CurrentPathExt = EnvObject.Item("PATHEXT")
                        End If

                        ShellObject.RegWrite "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment\PATHEXT", CurrentPathExt & ";.VBS", "REG_SZ"

                        If (Err.Number <> 0) Then
                                ReportError ()
                                WScript.Echo "Error Trying to write the registry settings!"
                                WScript.Quit (Err.Number)
                        Else
                                WScript.Echo "Successfully registered CScript"
                        End If
                Else
                        WScript.Echo "To run this script type: ""CScript.Exe adsutil.vbs <cmd> <params>"""
                End If

                Dim ProcString
                Dim ArgIndex
                Dim ArgObj
                Dim Result

                ProcString = "Cscript //nologo " & WScript.ScriptFullName

                Set ArgObj = WScript.Arguments

                For ArgIndex = 0 To ArgCount - 1
                        ProcString = ProcString & " " & Args(ArgIndex)
                Next

                'Now, run the original executable under CScript.exe
                Result = ShellObject.Run(ProcString, 0, True)

                WScript.Quit (Result)
        End If

End Sub


''''''''''''''''''''''''''
'
' SetCommand Function
'
' Sets the value of a property in the metabase.
'
''''''''''''''''''''''''''
Function SetCommand()
        Dim IIsObject
        Dim IIsObjectPath
        Dim IIsSchemaObject
        Dim IIsSchemaPath
        Dim ObjectPath
        Dim ObjectParameter
        Dim MachineName
        Dim ValueIndex
        Dim ValueList
        Dim ValueDisplay
        Dim ValueDisplayLen
        Dim ValueDataType

        Dim ValueData

        Dim ObjectDataType

        On Error Resume Next

        SetCommand = 0 ' Assume Success

        If ArgCount < 3 Then
                WScript.Echo "Error: Wrong number of Args for the SET command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)
        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)
        ObjectParameter = SplitParam(ObjectPath)

        ' Some Property Types have special needs - like ServerCommand.
        ' Check to see if this is a special command.  If it is, then process it special.
        If (IsSpecialSetProperty(ObjectParameter)) Then
                SetCommand = DoSpecialSetProp(ObjectPath, ObjectParameter, MachineName)
                Exit Function
        End If

        IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying To Get the Object: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        ' Get the Schema of the property and determine if it's multivalued
        IIsSchemaPath = "IIS://" & MachineName & "/Schema/" & ObjectParameter
        Set IIsSchemaObject = GetObject(IIsSchemaPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying To GET the Schema of the property: " & IIsSchemaPath
                WScript.Quit (Err.Number)
        End If

        ObjectDataType = UCase(IIsSchemaObject.Syntax)
        SanitizePath ObjectDataType

        Select Case (ObjectDataType)

        Case "STRING"
                ValueList = Args(2)
                IIsObject.Put ObjectParameter, (ValueList)

        Case "EXPANDSZ"
                ValueList = Args(2)
                IIsObject.Put ObjectParameter, (ValueList)

        Case "INTEGER"
                ' Added to convert hex values to integers
                ValueData = Args(2)

                If (UCase(Left(ValueData, 2))) = "0X" Then
                        ValueData = "&h" & Right(ValueData, Len(ValueData) - 2)
                End If

                ValueList = CLng(ValueData)
                IIsObject.Put ObjectParameter, (ValueList)

        Case "BOOLEAN"
                ValueList = CBool(Args(2))
                IIsObject.Put ObjectParameter, (ValueList)

        Case "LIST"
                ReDim ValueList(ArgCount - 3)
                For ValueIndex = 2 To ArgCount - 1
                        ValueList(ValueIndex - 2) = Args(ValueIndex)
                Next

                IIsObject.Put ObjectParameter, (ValueList)

        Case Else
                WScript.Echo "Error: Unknown data type in schema: " & IIsSchemaObject.Syntax

        End Select

        IIsObject.Setinfo

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying To SET the Property: " & ObjectParameter
                WScript.Quit (Err.Number)
        End If

        ' The function call succeeded, so display the output
        ' Set up the initial part of the display - the property name and data type
        ValueDisplay = ObjectParameter
        ValueDisplayLen = Len(ValueDisplay)

        If (ValueDisplayLen < SpacerSize) Then
                'ValueDisplay = ValueDisplay & (Right (Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & TypeName (ValueList) & ") "
                ValueDisplay = ValueDisplay & (Right(Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & ObjectDataType & ") "
        Else
                ValueDisplay = ValueDisplay & ": " & "(" & TypeName(ValueList) & ") "
        End If

        ' Create the rest of the display - The actual data
        If (IIsSchemaObject.MultiValued) Then
                For ValueIndex = 0 To UBound(ValueList)
                        'WScript.Echo """" & ValueList(ValueIndex) & """"
                        ValueDisplay = ValueDisplay & """" & ValueList(ValueIndex) & """ "
                Next
        Else
                If (UCase(IIsSchemaObject.Syntax) = "STRING") Then
                        'WScript.Echo """" & ValueList & """"
			If (IsSecureProperty(ObjectParameter,MachineName) = True) Then
                   		ValueDisplay = ValueDisplay & """" & "**********" & """"
			Else
                        	ValueDisplay = ValueDisplay & """" & ValueList & """"
			End If
                Else
                        'WScript.Echo ValueList
                        ValueDisplay = ValueDisplay & ValueList
                End If
        End If

        ' Display the output
        WScript.Echo ValueDisplay

        SetCommand = 0 ' Success

End Function


''''''''''''''''''''''''''
'
' GetCommand Function
'
' Gets the value of a property in the metabase.
'
''''''''''''''''''''''''''
Function GetCommand()

        Dim IIsObject
        Dim IIsObjectPath
        Dim IIsSchemaObject
        Dim IIsSchemaPath
        Dim ObjectPath
        Dim ObjectParameter
        Dim MachineName
        Dim ValueIndex
        Dim ValueList
        Dim ValueDisplay
        Dim ValueDisplayLen
        Dim NewObjectparameter

        Dim DataPathList
        Dim DataPath

        On Error Resume Next

        GetCommand = 0 ' Assume Success

        If ArgCount <> 2 Then
                WScript.Echo "Error: Wrong number of Args for the GET command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)

        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)
        ObjectParameter = SplitParam(ObjectPath)

        NewObjectparameter = MapSpecGetParamName(ObjectParameter)
        ObjectParameter = NewObjectparameter

        If (IsSpecialGetProperty(ObjectParameter)) Then
                GetCommand = DoSpecialGetProp(ObjectPath, ObjectParameter, MachineName)
                Exit Function
        End If

        If ObjectPath = "" Then
                IIsObjectPath = "IIS://" & MachineName
        Else
                IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
        End If

        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying To GET the Object (GetObject Failed): " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        ' Get the Schema of the property and determine if it's multivalued
        IIsSchemaPath = "IIS://" & MachineName & "/Schema/" & ObjectParameter
        Set IIsSchemaObject = GetObject(IIsSchemaPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying To GET the Schema of the property: " & IIsSchemaPath
                WScript.Quit (Err.Number)
        End If

        ' First, attempt to retrieve the property - this will tell us
        ' if you are even allowed to set the property at this node.
        ' Retrieve the property
        ValueList = IIsObject.Get(ObjectParameter)
        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying To GET the property: (Get Method Failed) " & ObjectParameter
                WScript.Echo "  (This property is probably not allowed at this node)"
                WScript.Quit (Err.Number)
        End If

        ' Test to see if the property is ACTUALLY set at this node
        DataPathList = IIsObject.GetDataPaths(ObjectParameter, IIS_DATA_INHERIT)
        If Err.Number <> 0 Then DataPathList = IIsObject.GetDataPaths(ObjectParameter, IIS_DATA_NO_INHERIT)
        Err.Clear

        ' If the data is not set anywhere, then stop the madness
        If (UBound(DataPathList) < 0) Then
                WScript.Echo "The parameter """ & ObjectParameter & """ is not set at this node."
                WScript.Quit (&H80005006) ' end with property not set error
        End If

        DataPath = DataPathList(0)
        SanitizePath DataPath

        ' Test to see if the item is actually set HERE
        If UCase(DataPath) <> UCase(IIsObjectPath) Then
                WScript.Echo "The parameter """ & ObjectParameter & """ is not set at this node."
                WScript.Quit (&H80005006) ' end with property not set error
        End If

        ' Set up the initial part of the display - the property name and data type
        ValueDisplay = ObjectParameter
        ValueDisplayLen = Len(ValueDisplay)

        If (ValueDisplayLen < SpacerSize) Then
                'ValueDisplay = ValueDisplay & (Right (Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & TypeName (ValueList) & ") "
                ValueDisplay = ValueDisplay & (Right(Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & UCase(IIsSchemaObject.Syntax) & ") "
        Else
                ValueDisplay = ValueDisplay & ": " & "(" & TypeName(ValueList) & ") "
        End If

        ' Create the rest of the display - The actual data
        If (IIsSchemaObject.MultiValued) Then
					 WScript.Echo ValueDisplay & " (" & UBound (ValueList) + 1 & " Items)"
                For ValueIndex = 0 To UBound(ValueList)
                        WScript.Echo "  """ & ValueList(ValueIndex) & """"
                        'ValueDisplay = ValueDisplay & """" & ValueList(ValueIndex) & """ "
                Next
        Else
                If (UCase(IIsSchemaObject.Syntax) = "STRING") Then
                        If (IsSecureProperty(ObjectParameter,MachineName) = True) Then
                   		ValueDisplay = ValueDisplay & """" & "**********" & """"
			Else
                        	ValueDisplay = ValueDisplay & """" & ValueList & """"
			End If
                Else
                        'WScript.Echo ValueList
                        ValueDisplay = ValueDisplay & ValueList
                End If
	   	   	  ' Display the output
	   	   	  WScript.Echo ValueDisplay
        End If


        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying To GET the Property: " & ObjectParameter
                WScript.Quit (Err.Number)
        End If

        GetCommand = 0 ' Success

End Function


''''''''''''''''''''''''''
'
' EnumCommand Function
'
' Enumerates all properties at a path in the metabase.
'
''''''''''''''''''''''''''
Function EnumCommand(Recurse, StartPath)

        On Error Resume Next

        Dim IIsObject
        Dim IIsObjectPath
        Dim IIsSchemaObject
        Dim IIsSchemaPath
        Dim ObjectPath
        Dim MachineName
        Dim ValueIndex
        Dim ValueList
        Dim ValueString
        Dim PropertyName
        Dim PropertyListSet
        Dim PropertyList
        Dim PropertyObjPath
        Dim PropertyObject
        Dim ChildObject
        Dim ChildObjectName
        Dim EnumPathsOnly
        Dim EnumAllData
        Dim ErrMask

        Dim PropertyDataType

        Dim DataPathList
        Dim DataPath

        Dim SpecialResult

        Dim PathOnlyOption
        PathOnlyOption = "/P"
        Dim AllDataOption
        AllDataOption = "/A"

        EnumCommand = 0 ' Assume Success
        EnumPathsOnly = False ' Assume that the user wants all of the data items
        EnumAllData = False ' Assume that the user wants only the actual data items

'Debug
'Dim TestObjectPath
'Dim TestNumber
'Dim TestIndex
'Dim SetIndex

'debug
'WScript.Echo "ArgCount: " & ArgCount
'For TestIndex = 0 to ArgCount - 1
'       WScript.Echo "Args(" & TestIndex & "): " & Args(TestIndex)
'Next

        If (ArgCount = 1) Then
                ObjectPath = ""
                EnumPathsOnly = False
                                ArgCount = 2
        ElseIf (ArgCount = 2) Then
                If UCase(Args(1)) = PathOnlyOption Then
                        ObjectPath = ""
                        EnumPathsOnly = True
                ElseIf UCase(Args(1)) = AllDataOption Then
                        ObjectPath = ""
                        EnumAllData = True
                Else
                        ObjectPath = Args(1)
                        EnumPathsOnly = False
                End If
        ElseIf (ArgCount = 3) Then

                If UCase(Args(1)) = PathOnlyOption Then
                        ObjectPath = Args(2)
                        EnumPathsOnly = True
                ElseIf UCase(Args(2)) = PathOnlyOption Then
                        ObjectPath = Args(1)
                        EnumPathsOnly = True
                ElseIf UCase(Args(1)) = AllDataOption Then
                        ObjectPath = Args(2)
                        EnumAllData = True
                ElseIf UCase(Args(2)) = AllDataOption Then
                        ObjectPath = Args(1)
                        EnumAllData = True
                Else
                        WScript.Echo "Error: Invalid arguments for the ENUM command"
                        WScript.Quit (GENERAL_FAILURE)
                End If
        Else
                WScript.Echo "Error: Wrong number of Args for the ENUM command"
                WScript.Quit (GENERAL_FAILURE)
        End If

                If StartPath <> "" Then ObjectPath = StartPath

        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)

'debug
'WScript.Echo "EnumPathsOnly: " & EnumPathsOnly
'WScript.Echo "EnumAllData: " & EnumAllData
'WScript.Echo "ObjectPath: """ & ObjectPath & """"
'WScript.Echo "Recurse: """ & Recurse & """"
'WScript.Echo "Last Error: " & Err & " (" & Hex (Err) & "): " & Err.Description
'WScript.Quit (Err.Number)

        IIsObjectPath = "IIS://" & MachineName
        If (ObjectPath <> "") Then
                IIsObjectPath = IIsObjectPath & "/" & ObjectPath
        End If
'debug
'WScript.Echo "IIsObjectPath: " & IIsObjectPath
        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                WScript.Echo
                ReportError ()
                WScript.Echo "Error Trying To ENUM the Object (GetObject Failed): " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        ' Get the Schema of the object and enumerate through all of the properties
        IIsSchemaPath = IIsObject.Schema
        Set IIsSchemaObject = GetObject(IIsSchemaPath)

        If (Err.Number <> 0) Then
                WScript.Echo
                ReportError ()
                WScript.Echo "Error Trying To GET the Schema of the class: " & IIsSchemaPath
                WScript.Quit (Err.Number)
        End If

        ReDim PropertyListSet(1)
        PropertyListSet(0) = IIsSchemaObject.MandatoryProperties
        PropertyListSet(1) = IIsSchemaObject.OptionalProperties

        If (Err.Number <> 0) Then
                WScript.Echo
                ReportError ()
                WScript.Echo "Error trying to get the list of properties: " & IIsSchemaPath
                WScript.Quit (Err.Number)
        End If

		' added by Adam Stone - 5/31/98
		' This now checks for an empty OptionalProperties list
		If TypeName (PropertyListSet(1)) <> "Variant()" Then
			WScript.Echo
			WScript.Echo "Warning: The optionalproperties list is of an invalid type"
			WScript.Echo
		ElseIf (UBound (PropertyListSet(1)) = -1) Then
			WScript.Echo
			WScript.Echo "Warning: The OptionalProperties list for this node is empty."
			WScript.Echo
		End If


        If (Not EnumPathsOnly) Then
        For Each PropertyList In PropertyListSet

                For Each PropertyName In PropertyList
						If Err <> 0 Then
							Exit For
						End If

                        ' Test to see if the property is even set at this node
                        DataPathList = IIsObject.GetDataPaths(PropertyName, IIS_DATA_INHERIT)
                        If Err.Number <> 0 Then DataPathList = IIsObject.GetDataPaths(PropertyName, IIS_DATA_NO_INHERIT)
                        Err.Clear

                        If (UBound(DataPathList) >= 0) Or (EnumAllData) Then
                         DataPath = DataPathList(0)
                         SanitizePath DataPath
                         If (UCase(DataPath) = UCase(IIsObjectPath)) Or (EnumAllData) Then
                         ' If the above statement is true, then the data exists here or the user wants it anyway.

                        PropertyObjPath = "IIS://" & MachineName & "/Schema/" & PropertyName
                        Set PropertyObject = GetObject(PropertyObjPath)

                        If (Err.Number <> 0) Then
                                WScript.Echo
                                ReportError ()
                                WScript.Echo "Error trying to enumerate the Optional properties (Couldn't Get Property Information): " & PropertyObjPath
                                WScript.Echo "Last Property Name: " & PropertyName
                                WScript.Echo "PropertyObjPath: " & PropertyObjPath
                                'WScript.Quit (Err.Number)
                                WScript.Echo
                                EnumCommand = Err.Number
                                Err.Clear
                        End If

                        ValueList = ""

                        PropertyDataType = UCase(PropertyObject.Syntax)
                        Select Case PropertyDataType
                                Case "STRING"
                                        ValueList = IIsObject.Get(PropertyName)
					If (IsSecureProperty(PropertyName,MachineName) = True) Then
							WScript.Echo PropertyName & Left(Spacer, Len(Spacer) - Len(PropertyName)) & " : " & "(" & PropertyDataType & ")" & """" & "**********" & """"
					Else
                                        	If (Len(PropertyName) < SpacerSize) Then
                                                	WScript.Echo PropertyName & Left(Spacer, Len(Spacer) - Len(PropertyName)) & ": " & "(" & PropertyDataType & ") """ & ValueList & """"
                                        	Else
                                                	WScript.Echo PropertyName & " : " & "(" & PropertyDataType & ")" & """" & ValueList & """"
                                        	End If
					End If

                                Case "EXPANDSZ"
                                        ValueList = IIsObject.Get(PropertyName)
                                        If (Len(PropertyName) < SpacerSize) Then
                                                WScript.Echo PropertyName & Left(Spacer, Len(Spacer) - Len(PropertyName)) & ": " & "(" & PropertyDataType & ") """ & ValueList & """"
                                        Else
                                                WScript.Echo PropertyName & " : " & "(" & PropertyDataType & ") """ & ValueList & """"
                                        End If
                                Case "INTEGER"
                                        ValueList = IIsObject.Get(PropertyName)
                                        If (Len(PropertyName) < SpacerSize) Then
                                                WScript.Echo PropertyName & Left(Spacer, Len(Spacer) - Len(PropertyName)) & ": " & "(" & PropertyDataType & ") " & ValueList
                                        Else
                                                WScript.Echo PropertyName & " : " & "(" & PropertyDataType & ") " & ValueList
                                        End If
                                Case "BOOLEAN"
                                        ValueList = IIsObject.Get(PropertyName)
                                        If (Len(PropertyName) < SpacerSize) Then
                                                WScript.Echo PropertyName & Left(Spacer, Len(Spacer) - Len(PropertyName)) & ": " & "(" & PropertyDataType & ") " & ValueList
                                        Else
                                                WScript.Echo PropertyName & " : " & "(" & PropertyDataType & ") " & ValueList
                                        End If

                                Case "LIST"
                                        ValueList = IIsObject.Get(PropertyName)
                                        If (Len(PropertyName) < SpacerSize) Then
                                                WScript.Echo PropertyName & _
																Left(Spacer, Len(Spacer) - Len(PropertyName)) & _
																": " & "(" & PropertyDataType & ") (" & _
																(UBound (ValueList) + 1) & " Items)"
                                        Else
                                                WScript.Echo PropertyName & " : " & "(" & PropertyDataType & ") (" & (UBound (ValueList) + 1) & " Items)"
                                        End If
                                        ValueString = ""

                                        For ValueIndex = 0 To UBound(ValueList)
																WScript.Echo "  """ & ValueList(ValueIndex) & """"
                                        Next
													 WScript.Echo

                                Case Else

                                        If (IsSpecialGetProperty(PropertyName)) Then

                                                SpecialResult = DoSpecialGetProp(ObjectPath, PropertyName, MachineName)
                                                Err.Clear

                                        Else
                                                WScript.Echo
                                                WScript.Echo "DataType: " & """" & PropertyObject.Syntax & """" & " Not Yet Supported on property: " & PropertyName
                                                ReportError
                                                WScript.Echo
                                        End If

                        End Select

                         End If ' End if data exists at the current node
                        End If ' End If data list > 0

                        If (Err.Number <> 0) Then
                                WScript.Echo
                                ReportError ()
                                WScript.Echo "Error trying to enumerate the Optional properties (Error trying to get property value): " & PropertyObjPath
                                WScript.Echo "Last Property Name: " & PropertyName
                                WScript.Echo "PropertyObjPath: " & PropertyObjPath
                                ' If there is an ADS error, just ignore it and move on
                                ' otherwise, quit
                                If ((Err.Number) >= &H80005000) And ((Err.Number) < &H80006000) Then
                                        Err.Clear
                                        WScript.Echo "Continuing..."
                                Else
                                        WScript.Quit (Err.Number)
                                End If
                                WScript.Echo
                        End If
                Next
        Next

        If (Err.Number <> 0) Then
            WScript.Echo "Error trying to enumerate the properties lists:"
            ReportError ()
            WScript.Echo
            EnumCommand = Err.Number
			Err.Clear
        End If

        End If ' End if (Not EnumPathsOnly)

'WScript.Echo "Last Error: " & Err & " (" & Hex (Err) & "): " & Err.Description
        ' Now, enumerate the data paths
        For Each ChildObject In IIsObject
	        If (Err.Number <> 0) Then Exit For

'WScript.Echo "Parent Name: " & IIsObject.Name
'WScript.Echo "Child Name: " & ChildObject.Name
'WScript.Echo "Last Error: " & Err & " (" & Hex (Err) & "): " & Err.Description
'Err.Clear
                ChildObjectName = Right(ChildObject.AdsPath, Len(ChildObject.AdsPath) - 6)
                ChildObjectName = Right(ChildObjectName, Len(ChildObjectName) - InStr(ChildObjectName, "/") + 1)
                WScript.Echo "[" & ChildObjectName & "]"
                If (Recurse = True) And (ChildObjectName <> Args(1)) Then
                        EnumCommand = EnumCommand(True, ChildObjectName)
                End If
        Next

        If (Err.Number <> 0) Then
            WScript.Echo "Error trying to enumerate the child nodes"
            ReportError ()
            WScript.Echo
            EnumCommand = Err.Number
			Err.Clear
        End If

WScript.Echo ""

End Function


''''''''''''''''''''''''''
'
' Create Function
'
' Creates a path in the metabase.  An additional parameter that is
' not found in mdutil is optional.  That is the Object Type (KeyType)
' If this is not specified, the object type will be assumed to be
' IIsObject (which, of course, is useless).
'
''''''''''''''''''''''''''
Function CreateCommand(ObjectTypeParam)

        On Error Resume Next

        Dim IIsObject
        Dim IIsObjectPath
        Dim IIsObjectRelativePath
        Dim NewObject
        Dim ObjectTypeName
        Dim ParentObjPath
        Dim ParentObjSize
        Dim FullAdsParentPath
        Dim MachineName
        Dim OpenErr

        ' Set the return code - assume success
        CreateCommand = 0

        ' Setup the parameters
        If (ArgCount = 2) Then
                If (ObjectTypeParam = "") Then
                        ObjectTypeName = "IIsObject"
                Else
                        ObjectTypeName = ObjectTypeParam
                End If
        ElseIf (ArgCount = 3) Then
                ObjectTypeName = Args(2)
        Else
                WScript.Echo "Error: Wrong number of Args for the CREATE command"
                DisplayHelpMessage
                WScript.Quit (GENERAL_FAILURE)
        End If

        IIsObjectPath = Args(1)
        SanitizePath IIsObjectPath
        MachineName = SeparateMachineName(IIsObjectPath)

        ' Parse the path and determine if the parent exists.
        ParentObjSize = InStrRev(IIsObjectPath, "/")
        ParentObjPath = ""

        If ParentObjSize <> 0 Then
                ParentObjPath = Left(IIsObjectPath, ParentObjSize - 1)
                IIsObjectRelativePath = Right(IIsObjectPath, Len(IIsObjectPath) - ParentObjSize)
        Else
                IIsObjectRelativePath = IIsObjectPath
        End If

        If ParentObjPath <> "" Then
                FullAdsParentPath = "IIS://" & MachineName & "/" & ParentObjPath
        Else
                FullAdsParentPath = "IIS://" & MachineName
        End If
'debug
'WScript.Echo "Last Error: " & Err.Number
'WScript.Echo "MachineName: " & MachineName
'WScript.Echo "ParentObjPath: " & ParentObjPath
'WScript.Echo "FullAdsParentPath: " & FullAdsParentPath
'WScript.Echo "IIsObjectPath: " & IIsObjectPath
'WScript.Echo "IIsObjectRelativePath: " & IIsObjectRelativePath
'WScript.Echo "ObjectTypeName: " & ObjectTypeName

        ' First, attempt to open the parent path and add the new path.
        Set IIsObject = GetObject(FullAdsParentPath)
        If Err.Number <> 0 Then
                OpenErr = Err.Number
                OpenErrDesc = Err.Description
                Err.Clear
                ' Attempt to get the Computer Object (IIS://LocalHost)
                Set IIsObject = GetObject("IIS://" & MachineName)
                If Err.Number <> 0 Then
                        WScript.Echo
                        ReportError ()
                        WScript.Echo "Error accessing the object: " & IIsObjectPath
                        WScript.Quit (Err.Number)
                End If
        End If

        'Now, attempt to add the new object.
        If (OpenErr <> 0) Then
                Set NewObject = IIsObject.Create(ObjectTypeName, IIsObjectPath)
        Else
                Set NewObject = IIsObject.Create(ObjectTypeName, IIsObjectRelativePath)
        End If

        If Err.Number <> 0 Then
                WScript.Echo
                ReportError ()
                WScript.Echo "Error creating the object: " & IIsObjectPath
                WScript.Quit (Err.Number)
        End If

        NewObject.Setinfo

        If Err.Number <> 0 Then
                WScript.Echo
                ReportError ()
                WScript.Echo "Error creating the object: " & IIsObjectPath
                WScript.Quit (Err.Number)
        End If


        ' Now, if the parent object was not created, generate a warning.
        If OpenErr <> 0 Then
                WScript.Echo
                WScript.Echo "WARNING: The parent path (" & ParentObjPath & ") was not already created."
                WScript.Echo "    This means that some of the intermediate objects will not have an accurate"
                WScript.Echo "    Object Type. You should fix this by setting the KeyType on the intermediate"
                WScript.Echo "    objects."
                WScript.Echo
                CreateCommand = GENERAL_WARNING
        End If

        If UCase(ObjectTypeName) = "IISOBJECT" Then
                WScript.Echo
                WScript.Echo "WARNING: The Object Type of this object was not specified or was specified as"
                WScript.Echo "    IIsObject.  This means that you will not be able to set or get properties"
                WScript.Echo "    on the object until the KeyType property is set."
                WScript.Echo
                CreateCommand = GENERAL_WARNING
        End If

        WScript.Echo "created filter path """ & IIsObjectPath & """"
End Function

''''''''''''''''''''''''''
'
' Delete Function
'
' Deletes a path in the metabase.
'
''''''''''''''''''''''''''
Function DeleteCommand()

        On Error Resume Next

        Dim IIsObject
        Dim IIsObjectPath

        Dim ObjectPath
        Dim ObjectParam
        Dim MachineName

        Dim DummyVariant
        Dim DeletePathOnly
        ReDim DummyVariant(0)
        DummyVariant(0) = "Crap"

        ' Set the return code - assume success
        DeleteCommand = 0

        ' Setup the parameters
        If (ArgCount <> 2) Then
                WScript.Echo "Error: Wrong number of Args for the DELETE command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)

        ' Check and see if the user is specifically asking to delete the path
        DeletePathOnly = False
        If Right(ObjectPath, 1) = "/" Then
                DeletePathOnly = True
        End If

        ' Sanitize the path and split parameter and path
        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)
        ObjectParam = SplitParam(ObjectPath)

        ' Open the parent object
        IIsObjectPath = "IIS://" & MachineName
        If ObjectPath <> "" Then
                IIsObjectPath = IIsObjectPath & "/" & ObjectPath
        End If

        Set IIsObject = GetObject(IIsObjectPath)

        If Err.Number <> 0 Then
                WScript.Echo
                ReportError ()
                WScript.Echo "Error deleting the object: " & ObjectPath & "/" & ObjectParam
                WScript.Quit (Err.Number)
        End If

        ' If they did not specifically ask to delete the path, then attempt to delete the property
        If Not DeletePathOnly Then
                ' Try to delete the property

                ' ADS_PROPERTY_CLEAR used to be defined, but it isn't anymore.
                'IIsObject.PutEx ADS_PROPERTY_CLEAR, ObjectParam, DummyVariant
                IIsObject.PutEx "1", ObjectParam, DummyVariant

                ' If it succeeded, then just return, else continue and try to delete the path
                If Err.Number = 0 Then
                        WScript.Echo "deleted property """ & ObjectParam & """"
                        Exit Function
                End If
                Err.Clear
        End If

        ' Try to just delete the path
        IIsObject.Delete "IIsObject", ObjectParam

        If Err.Number <> 0 Then
                WScript.Echo
                ReportError ()
                WScript.Echo "Error deleting the object: " & ObjectPath & "/" & ObjectParam
                WScript.Quit (Err.Number)
        End If

        WScript.Echo "deleted path """ & ObjectPath & "/" & ObjectParam & """"

        Exit Function

End Function


''''''''''''''''''''''''''
'
' EnumAllCommand
'
' Enumerates all data and all properties in the metabase under the current path.
'
''''''''''''''''''''''''''
Function EnumAllCommand()
        On Error Resume Next

        WScript.Echo "ENUM_ALL Command not yet supported"
        

End Function


''''''''''''''''''''''''''
'
' CopyMoveCommand
'
' Copies a path in the metabase to another path.
'
''''''''''''''''''''''''''
Function CopyMoveCommand(bCopyFlag)
        On Error Resume Next

        Dim SrcObjectPath
        Dim DestObjectPath
        Dim DestObject

        Dim ParentObjectPath
        Dim ParentRelativePath
        Dim ParentObject

        Dim MachineName

        Dim TmpDestLeftPath
        Dim TmpSrcLeftPath

        CopyMoveCommand = 0 ' Assume Success

        If ArgCount <> 3 Then
                WScript.Echo "Error: Wrong number of Args for the Copy/Move command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        SrcObjectPath = Args(1)
        DestObjectPath = Args(2)

        SanitizePath SrcObjectPath
        SanitizePath DestObjectPath
        MachineName = SeparateMachineName(SrcObjectPath)
        ParentObjectPath = "IIS://" & MachineName

        ' Extract the left part of the paths until there are no more left parts to extract
        Do
                TmpSrcLeftPath = SplitLeftPath(SrcObjectPath)
                TmpDestLeftPath = SplitLeftPath(DestObjectPath)

                If (SrcObjectPath = "") Or (DestObjectPath = "") Then
                        SrcObjectPath = TmpSrcLeftPath & "/" & SrcObjectPath
                        DestObjectPath = TmpDestLeftPath & "/" & DestObjectPath
                        Exit Do
                End If

                If (TmpSrcLeftPath <> TmpDestLeftPath) Then
                        SrcObjectPath = TmpSrcLeftPath & "/" & SrcObjectPath
                        DestObjectPath = TmpDestLeftPath & "/" & DestObjectPath
                        Exit Do
                End If

                ParentObjectPath = ParentObjectPath & "/" & TmpSrcLeftPath
                ParentRelativePath = ParentRelativePath & "/" & TmpSrcLeftPath

        Loop

        SanitizePath SrcObjectPath
        SanitizePath DestObjectPath
        SanitizePath ParentObjectPath

        ' Now, open the parent object and Copy/Move the objects
        Set ParentObject = GetObject(ParentObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to open the object: " & ParentObjectPath
                WScript.Quit (Err.Number)
        End If

        If (bCopyFlag) Then
                Set DestObject = ParentObject.CopyHere(SrcObjectPath, DestObjectPath)
        Else
                Set DestObject = ParentObject.MoveHere(SrcObjectPath, DestObjectPath)
        End If

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to Copy/Move Source to Dest."
                WScript.Quit (Err.Number)
        End If

        If (bCopyFlag) Then
                WScript.Echo "copied from " & ParentRelativePath & "/" & SrcObjectPath & " to " & ParentRelativePath & "/" & DestObjectPath
        Else
                WScript.Echo "moved from " & ParentRelativePath & "/" & SrcObjectPath & " to " & ParentRelativePath & "/" & DestObjectPath
        End If

End Function

''''''''''''''''''''''''''
'
' StartServerCommand
'
' Starts a server in the metabase.
'
''''''''''''''''''''''''''
Function StartServerCommand()

        On Error Resume Next

        Dim IIsObject
        Dim IIsObjectPath
        Dim ObjectPath
        Dim MachineName

        If ArgCount <> 2 Then
                WScript.Echo "Error: Wrong number of Args for the START_SERVER command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)
        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)
        IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath

        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to open the object: " & ObjectPath
                WScript.Quit (Err.Number)
        End If
'debug
'WScript.echo "About to start server.  Last Error: " & Err.Number
        IIsObject.Start
'WScript.echo "After starting server.  Last Error: " & Err.Number
        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to START the server: " & ObjectPath
                WScript.Quit (Err.Number)
        End If
        WScript.Echo "Server " & ObjectPath & " Successfully STARTED"

End Function

''''''''''''''''''''''''''
'
' StopServerCommand
'
' Stops a server in the metabase.
'
''''''''''''''''''''''''''
Function StopServerCommand()

        On Error Resume Next

        Dim IIsObject
        Dim IIsObjectPath
        Dim ObjectPath
        Dim MachineName

        If ArgCount <> 2 Then
                WScript.Echo "Error: Wrong number of Args for the STOP_SERVER command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)
        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)
        IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath

        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to open the object: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        IIsObject.Stop
        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to STOP the server: " & ObjectPath
                WScript.Quit (Err.Number)
        End If
        WScript.Echo "Server " & ObjectPath & " Successfully STOPPED"

End Function

''''''''''''''''''''''''''
'
' PauseServerCommand
'
' Pauses a server in the metabase.
'
''''''''''''''''''''''''''
Function PauseServerCommand()

        On Error Resume Next

        Dim IIsObject
        Dim IIsObjectPath
        Dim ObjectPath
        Dim MachineName

        If ArgCount <> 2 Then
                WScript.Echo "Error: Wrong number of Args for the PAUSE_SERVER command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)
        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)
        IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath

        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to open the object: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        IIsObject.Pause
        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to PAUSE the server: " & ObjectPath
                WScript.Quit (Err.Number)
        End If
        WScript.Echo "Server " & ObjectPath & " Successfully PAUSED"

End Function

''''''''''''''''''''''''''
'
' ContinueServerCommand
'
' Continues a server in the metabase.
'
''''''''''''''''''''''''''
Function ContinueServerCommand()

        On Error Resume Next

        Dim IIsObject
        Dim IIsObjectPath
        Dim ObjectPath
        Dim MachineName

        If ArgCount <> 2 Then
                WScript.Echo "Error: Wrong number of Args for the CONTINUE_SERVER command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)
        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)
        IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath

        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to open the object: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        IIsObject.Continue
        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to CONTINUE the server: " & ObjectPath
                WScript.Quit (Err.Number)
        End If
        WScript.Echo "Server " & ObjectPath & " Successfully CONTINUED"

End Function


Function FindData()
        ' FindData will accept 1 parameter from the command line - the node and
        ' property to search for (i.e. w3svc/1/ServerComment)

        On Error Resume Next

        Dim ObjectPath
        Dim ObjectParameter
        Dim NewObjectparameter
        Dim MachineName

        Dim IIsObjectPath
        Dim IIsObject

        Dim Path
        Dim PathList
        Dim I

        FindData = 0 ' Assume Success

        If ArgCount <> 2 Then
                WScript.Echo "Error: Wrong number of Args for the FIND_DATA command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)

        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)
        ObjectParameter = SplitParam(ObjectPath)

        ' Since people may still want to use MDUTIL parameter names
        ' we should still do the GET translation of parameter names.
        NewObjectparameter = MapSpecGetParamName(ObjectParameter)
        ObjectParameter = NewObjectparameter

        If ObjectPath = "" Then
                IIsObjectPath = "IIS://" & MachineName
        Else
                IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
        End If

        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to find data paths for the Object (GetObject Failed): " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        ' Now, list out all the places where this property exists.
        PathList = IIsObject.GetDataPaths(ObjectParameter, IIS_DATA_INHERIT)
        If Err.Number <> 0 Then PathList = IIsObject.GetDataPaths(ObjectParameter, IIS_DATA_NO_INHERIT)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to get a path list (GetDataPaths Failed): " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        If UBound(PathList) < 0 Then
                WScript.Echo "Property " & ObjectParameter & " was not found at any node beneath " & ObjectPath
        Else
                WScript.Echo "Property " & ObjectParameter & " found at:"

                For Each Path In PathList
                        Path = Right(Path, Len(Path) - 6)
                        Path = Right(Path, Len(Path) - InStr(Path, "/"))
                        WScript.Echo "  " & Path
                Next
        End If

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error listing the data paths (_newEnum Failed): " & ObjectPath
                WScript.Quit (Err.Number)
        End If

End Function

'''''''''''''''''''''
'
' MimeMapGet
'
' Special function for displaying a MimeMap property
'
'''''''''''''''''''''
Function MimeMapGet(ObjectPath, MachineName)
        On Error Resume Next

        Dim MimePath

        Dim MimeMapList
        Dim MimeMapObject
        Dim MimeEntry
        Dim MimeEntryIndex

        Dim MimeStr
        Dim MimeOutPutStr

        Dim DataPathList
        Dim DataPath

        MimeMapGet = 0 ' Assume Success

        MimePath = "IIS://" & MachineName
        If ObjectPath <> "" Then MimePath = MimePath & "/" & ObjectPath

        ' Get the object that contains the mimemap
        Set MimeMapObject = GetObject(MimePath)
        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to get the Object: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        ' Test to see if the property is ACTUALLY set at this node
        DataPathList = MimeMapObject.GetDataPaths("MimeMap", IIS_DATA_INHERIT)
        If Err.Number <> 0 Then DataPathList = IIsObject.GetDataPaths(MimeMap, IIS_DATA_NO_INHERIT)
        Err.Clear

        ' If the data is not set anywhere, then stop the madness
        If (UBound(DataPathList) < 0) Then
                MimeMapGet = &H80005006  ' end with property not set error
                Exit Function
        End If

        DataPath = DataPathList(0)
        SanitizePath DataPath

        ' Test to see if the item is actually set HERE
        If UCase(DataPath) <> UCase(MimePath) Then
                MimeMapGet = &H80005006  ' end with property not set error
                Exit Function
        End If

        ' Get the mime map list from the object
        MimeMapList = MimeMapObject.Get("MimeMap")
        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to get the Object: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        MimeOutPutStr = "MimeMap                         : (MimeMapList) "

        ' Enumerate the Mime Entries
        For MimeEntryIndex = 0 To UBound(MimeMapList)
                Set MimeEntry = MimeMapList(MimeEntryIndex)
                MimeOutPutStr = MimeOutPutStr & """" & MimeEntry.Extension & "," & MimeEntry.MimeType & """ "
        Next

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to Create the Mime Map List."
                WScript.Quit (Err.Number)
        End If

        WScript.Echo MimeOutPutStr

End Function



Function MimeMapSet(ObjectPath, ObjectParameter, MachineName)
        On Error Resume Next

        Dim MimePath

        Dim MimeEntryIndex
        Dim MimeMapList()
        Dim MimeMapObject
        Dim MimeEntry

        Dim MimeStr
        Dim MimeOutPutStr

        MimeMapSet = 0 ' Assume Success

        ' First, check the number of args
        If ArgCount < 3 Then
                WScript.Echo "Error: Wrong number of Args for the Set MIMEMAP command"
                WScript.Quit (GENERAL_FAILURE)
        End If


        MimePath = "IIS://" & MachineName
        If ObjectPath <> "" Then MimePath = MimePath & "/" & ObjectPath

        ' Get the object that contains the mimemap
        Set MimeMapObject = GetObject(MimePath)
        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to get the Object: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        ' Create a new MimeMapList of Mime Entries
        ReDim MimeMapList(ArgCount - 3)

        MimeOutPutStr = "MimeMap                         : (MimeMapList) "

        ' Fill the list with mime entries
        For MimeEntryIndex = 0 To UBound(MimeMapList)

                MimeStr = Args(2 + MimeEntryIndex)
                MimeOutPutStr = MimeOutPutStr & """" & MimeStr & """ "

                Set MimeEntry = CreateObject("MimeMap")

                MimeEntry.MimeType = Right(MimeStr, InStr(MimeStr, ",") - 1)
                MimeEntry.Extension = Left(MimeStr, InStr(MimeStr, ",") - 1)

                Set MimeMapList(MimeEntryIndex) = MimeEntry
        Next

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to Create the Mime Map List."
                WScript.Quit (Err.Number)
        End If

        MimeMapObject.MimeMap = MimeMapList
        MimeMapObject.Setinfo

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying to set the Object's ""MimeMap"" property to the new mimemap list."
                WScript.Quit (Err.Number)
        End If

        WScript.Echo MimeOutPutStr

End Function

''''''''''''''''''''''''''
'
' IsSpecialGetProperty
'
' Checks to see if the property requires special processing in order to
' display its contents.
'
''''''''''''''''''''''''''
Function IsSpecialGetProperty(ObjectParameter)

        On Error Resume Next

        Select Case UCase(ObjectParameter)
                Case "MIMEMAP"
                        IsSpecialGetProperty = True
                Case Else
                        IsSpecialGetProperty = False
        End Select

End Function

''''''''''''''''''''''''''
'
' DoSpecialGetProp
'
' Checks to see if the property requires special processing in order to
' display its contents.
'
''''''''''''''''''''''''''
Function DoSpecialGetProp(ObjectPath, ObjectParameter, MachineName)

        On Error Resume Next

        Select Case UCase(ObjectParameter)
                Case "MIMEMAP"
                        DoSpecialGetProp = MimeMapGet(ObjectPath, MachineName)
                Case Else
                        DoSpecialGetProp = False
        End Select

End Function



''''''''''''''''''''''''''
'
' IsSpecialSetProperty
'
' Checks to see if the property is a type that needs to be handled
' specially for compatibility with mdutil
'
''''''''''''''''''''''''''
Function IsSpecialSetProperty(ObjectParameter)

        On Error Resume Next

        Select Case UCase(ObjectParameter)
                Case "SERVERCOMMAND"
                        IsSpecialSetProperty = True
                Case "ACCESSPERM"
                        IsSpecialSetProperty = True
                Case "VRPATH"
                        IsSpecialSetProperty = True
                Case "AUTHORIZATION"
                        IsSpecialSetProperty = True
                Case "MIMEMAP"
                        IsSpecialSetProperty = True
                Case Else
                        IsSpecialSetProperty = False
        End Select
End Function

''''''''''''''''''''''''''
'
' DoSpecialSetProp
'
' Handles datatypes that need to be handled
' specially for compatibility with mdutil
'
''''''''''''''''''''''''''
Function DoSpecialSetProp(ObjectPath, ObjectParameter, MachineName)
        Dim IIsObjectPath
        Dim IIsObject
        Dim ValueList
        Dim ValueDisplay
        Dim PermIndex

        On Error Resume Next

        DoSpecialSetProp = 0 ' Assume Success
        Select Case UCase(ObjectParameter)
                Case "SERVERCOMMAND"

                        IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
                        Set IIsObject = GetObject(IIsObjectPath)

                        If (Err.Number <> 0) Then
                                ReportError ()
                                WScript.Echo "Error Trying To Get the Object: " & ObjectPath
                                WScript.Quit (Err.Number)
                        End If

                        ValueList = CLng(Args(2))
                        Select Case ValueList
                                Case 1
                                        IIsObject.Start
                                        If (Err.Number <> 0) Then
                                                ReportError ()
                                                WScript.Echo "Error Trying To Start the server: " & ObjectPath
                                                WScript.Quit (Err.Number)
                                        End If
                                        WScript.Echo "Server " & ObjectPath & " Successfully STARTED"
                                Case 2
                                        IIsObject.Stop
                                        If (Err.Number <> 0) Then
                                                ReportError ()
                                                WScript.Echo "Error Trying To Stop the server: " & ObjectPath
                                                WScript.Quit (Err.Number)
                                        End If
                                        WScript.Echo "Server " & ObjectPath & " Successfully STOPPED"
                                Case 3
                                        IIsObject.Pause
                                        If (Err.Number <> 0) Then
                                                ReportError ()
                                                WScript.Echo "Error Trying To Pause the server: " & ObjectPath
                                                WScript.Quit (Err.Number)
                                        End If
                                        WScript.Echo "Server " & ObjectPath & " Successfully PAUSED"
                                Case 4
                                        IIsObject.Continue
                                        If (Err.Number <> 0) Then
                                                ReportError ()
                                                WScript.Echo "Error Trying To Continue the server: " & ObjectPath
                                                WScript.Quit (Err.Number)
                                        End If
                                        WScript.Echo "Server " & ObjectPath & " Successfully Continued"
                                Case Else
                                        WScript.Echo "Invalid ServerCommand: " & ValueList
                                        DoSpecialSetProp = GENERAL_FAILURE
                        End Select
                        Exit Function

                Case "ACCESSPERM"
                        IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
                        Set IIsObject = GetObject(IIsObjectPath)

                        If (Err.Number <> 0) Then
                                ReportError ()
                                WScript.Echo "Error Trying To Get the Object: " & ObjectPath
                                WScript.Quit (Err.Number)
                        End If

                        ' Set the access flags to None, first, and then add them back, as necessary
                        IIsObject.AccessFlags = 0

                        ' Set up the display output
                        ValueDisplay = "AccessFlags (AccessPerm)" & (Right(Spacer, SpacerSize - Len("AccessFlags (AccessPerm)")) & ": " & "(" & TypeName(IIsObject.AccessFlags) & ") ")

                        ' Attempt to convert parameter to number
                        Dim APValue
                        Dim TempValStr

                        TempValStr = Args(2)

                        ' Check for Hex
                        If (UCase(Left(Args(2), 2)) = "0X") Then
                                TempValStr = "&H" & Right(TempValStr, Len(TempValStr) - 2)
                        End If

                        APValue = CLng(TempValStr)

                        If (Err.Number = 0) Then
                                IIsObject.AccessFlags = APValue
                                ValueDisplay = ValueDisplay & " " & APValue & " (0x" & Hex(APValue) & ")"
                        Else
                                Err.Clear
                                For PermIndex = 2 To ArgCount - 1
                                        Select Case UCase(Args(PermIndex))
                                                Case "READ"
                                                        IIsObject.AccessRead = True
                                                        ValueDisplay = ValueDisplay & " Read"
                                                Case "WRITE"
                                                        IIsObject.AccessWrite = True
                                                        ValueDisplay = ValueDisplay & " Write"
                                                Case "EXECUTE"
                                                        IIsObject.AccessExecute = True
                                                        ValueDisplay = ValueDisplay & " Execute"
                                                Case "SCRIPT"
                                                        IIsObject.AccessScript = True
                                                        ValueDisplay = ValueDisplay & " Script"
                                                Case Else
                                                        WScript.Echo "Error: Setting not supported: " & Args(PermIndex)
                                                        WScript.Quit (GENERAL_FAILURE)
                                        End Select
                                Next
                        End If

                        If (Err.Number <> 0) Then
                                ReportError ()
                                WScript.Echo "Error Trying To Set data on the Object: " & ObjectPath
                                WScript.Quit (Err.Number)
                        End If

                        IIsObject.Setinfo

                        If (Err.Number <> 0) Then
                                ReportError ()
                                WScript.Echo "Error Trying To Set data on the Object: " & ObjectPath
                                WScript.Quit (Err.Number)
                        End If

                        ' Send the current settings to the screen
                        WScript.Echo ValueDisplay

                Case "VRPATH"
                        IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
                        Set IIsObject = GetObject(IIsObjectPath)

                        If (Err.Number <> 0) Then
                                ReportError ()
                                WScript.Echo "Error Trying To Get the Object: " & ObjectPath
                                WScript.Quit (Err.Number)
                        End If

                        ' Set the access flags to None, first, and then add them back, as necessary
                        IIsObject.Path = Args(2)

                        If (Err.Number <> 0) Then
                                ReportError ()
                                WScript.Echo "Error Trying To Set data on the Object: " & ObjectPath
                                WScript.Quit (Err.Number)
                        End If

                        ' Set up the display output
                        ValueDisplay = "Path (VRPath)" & (Right(Spacer, SpacerSize - Len("Path (VRPath)")) & ": " & "(" & TypeName(IIsObject.Path) & ") " & IIsObject.Path)

                        IIsObject.Setinfo

                        If (Err.Number <> 0) Then
                                ReportError ()
                                WScript.Echo "Error Trying To Set data on the Object: " & ObjectPath
                                WScript.Quit (Err.Number)
                        End If

                        ' Send the current settings to the screen
                        WScript.Echo ValueDisplay

                Case "AUTHORIZATION"
                        IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
                        Set IIsObject = GetObject(IIsObjectPath)

                        If (Err.Number <> 0) Then
                                ReportError ()
                                WScript.Echo "Error Trying To Get the Object: " & ObjectPath
                                WScript.Quit (Err.Number)
                        End If

                        ' Set the auth flags to None, first, and then add them back, as necessary
                        IIsObject.AuthFlags = 0

                        ' Set up the display output
                        ValueDisplay = "Authorization" & (Right(Spacer, SpacerSize - Len("Authorization")) & ": " & "(" & TypeName(IIsObject.AuthFlags) & ") ")

                        For PermIndex = 2 To ArgCount - 1
                                Select Case UCase(Args(PermIndex))
                                        Case "NT"
                                                IIsObject.AuthNTLM = True
                                                ValueDisplay = ValueDisplay & " NT"
                                        Case "ANONYMOUS"
                                                IIsObject.AuthAnonymous = True
                                                ValueDisplay = ValueDisplay & " Anonymous"
                                        Case "BASIC"
                                                IIsObject.AuthBasic = True
                                                ValueDisplay = ValueDisplay & " Basic"
                                        Case Else
                                                WScript.Echo "Error: Setting not supported: " & Args(PermIndex)
                                                WScript.Quit (GENERAL_FAILURE)
                                End Select
                        Next

                        If (Err.Number <> 0) Then
                                ReportError ()
                                WScript.Echo "Error Trying To Set data on the Object: " & ObjectPath
                                WScript.Quit (Err.Number)
                        End If

                        IIsObject.Setinfo

                        If (Err.Number <> 0) Then
                                ReportError ()
                                WScript.Echo "Error Trying To Set data on the Object: " & ObjectPath
                                WScript.Quit (Err.Number)
                        End If

                        ' Send the current settings to the screen
                        WScript.Echo ValueDisplay

                Case "MIMEMAP"
                        DoSpecialSetProp = MimeMapSet(ObjectPath, ObjectParameter, MachineName)
'               Case "FILTER"
'                       DoSpecialSetProp = FiltersSet()
                Case Else
                        DoSpecialSetProp = GENERAL_FAILURE
        End Select
End Function

''''''''''''''''''''''''''''''
'
' Function SeparateMachineName
'
' This function will get the machine name from the Path parameter
' that was passed into the script.  It will also alter the passed in
' path so that it contains only the rest of the path - not the machine
' name.  If there is no machine name in the path, then the script
' will assume LocalHost.
'
''''''''''''''''''''''''''''''
Function SeparateMachineName(Path)
        On Error Resume Next

        ' Temporarily, just return LocalHost
        ' SeparateMachineName = "LocalHost"

        SeparateMachineName = TargetServer

        Exit Function
End Function

''''''''''''''''''''''''''''''
'
' Function MapSpecGetParamName
'
' Some parameters in MDUTIL are named differently in ADSI.
' This function maps the improtant parameter names to ADSI
' names.
'
''''''''''''''''''''''''''''''
Function MapSpecGetParamName(ObjectParameter)
        On Error Resume Next

        Select Case UCase(ObjectParameter)
                Case "ACCESSPERM"
                        WScript.Echo "Note: Your parameter """ & ObjectParameter & """ is being mapped to AccessFlags"
                        WScript.Echo "      Check individual perms using ""GET AccessRead"", ""GET AccessWrite"", etc."
                        MapSpecGetParamName = "AccessFlags"
                Case "VRPATH"
                        'WScript.Echo "Note: Your parameter """ & ObjectParameter & """ is being mapped to PATH"
                        MapSpecGetParamName = "Path"
                Case "AUTHORIZATION"
                        WScript.Echo "Note: Your parameter """ & ObjectParameter & """ is being mapped to AuthFlags"
                        WScript.Echo "      Check individual auths using ""GET AuthNTLM"", ""GET AuthBasic"", etc."
                        MapSpecGetParamName = "AuthFlags"
                Case Else
                        ' Do nothing - the parameter doesn't map to anything special
                        MapSpecGetParamName = ObjectParameter
        End Select
End Function

Sub ReportError()
'       On Error Resume Next

        Dim ErrorDescription

        Select Case (Err.Number)
                Case &H80070003
                        ErrorDescription = "The path requested could not be found."
                Case &H80070005
                        ErrorDescription = "Access is denied for the requested path or property."
                Case &H80070094
                        ErrorDescription = "The requested path is being used by another application."
                Case Else
                        ErrorDescription = Err.Description
        End Select

        WScript.Echo ErrorDescription
        WScript.Echo "ErrNumber: " & Err.Number & " (0x" & Hex(Err.Number) & ")"
End Sub




Function SplitParam(ObjectPath)
' Note: Assume the string has been sanitized (no leading or trailing slashes)
        On Error Resume Next

        Dim SlashIndex
        Dim TempParam
        Dim ObjectPathLen

        SplitParam = ""  ' Assume no parameter
        ObjectPathLen = Len(ObjectPath)

        ' Separate the path of the node from the parameter
        SlashIndex = InStrRev(ObjectPath, "/")

        If (SlashIndex = 0) Or (SlashIndex = ObjectPathLen) Then
                TempParam = ObjectPath
                ObjectPath = "" ' ObjectParameter is more important
        Else
                TempParam = ObjectPath
                ObjectPath = Left(ObjectPath, SlashIndex - 1)
                TempParam = Right(TempParam, Len(TempParam) - SlashIndex)
        End If

        SplitParam = TempParam

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to Split the parameter from the object: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

End Function



Function SplitLeftPath(ObjectPath)
' Note: Assume the string has been sanitized (no leading or trailing slashes)
        On Error Resume Next

        Dim SlashIndex
        Dim TmpLeftPath
        Dim ObjectPathLen

'WScript.Echo "SplitLeftPath: ObjectPath: " & ObjectPath
'WScript.Echo "LastError: " & Err.Number & " (" & Hex (Err.Number) & ")"

        SplitLeftPath = ""  ' Assume no LeftPath
        ObjectPathLen = Len(ObjectPath)

        ' Separate the left part of the path from the remaining path
        SlashIndex = InStr(ObjectPath, "/")

        If (SlashIndex = 0) Or (SlashIndex = ObjectPathLen) Then
                TmpLeftPath = ObjectPath
                ObjectPath = ""
        Else
                TmpLeftPath = Left(ObjectPath, SlashIndex - 1)
                ObjectPath = Right(ObjectPath, Len(ObjectPath) - SlashIndex)
        End If

'WScript.Echo "SplitLeftPath: ObjectPath: " & ObjectPath
'WScript.Echo "SplitLeftPath: TmpLeftPath: " & TmpLeftPath
'WScript.Echo "LastError: " & Err.Number & " (" & Hex (Err.Number) & ")"

        SplitLeftPath = TmpLeftPath

'WScript.Echo "SplitLeftPath: ObjectPath: " & ObjectPath
'WScript.Echo "LastError: " & Err.Number & " (" & Hex (Err.Number) & ")"
'WScript.Echo "SplitLeftPath: TmpLeftPath: " & TmpLeftPath

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to split the left part of the path: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

End Function




Sub SanitizePath(ObjectPath)
        On Error Resume Next

        ' Remove WhiteSpace
        Do While (Left(ObjectPath, 1) = " ")
                ObjectPath = Right(ObjectPath, Len(ObjectPath) - 1)
        Loop

        Do While (Right(ObjectPath, 1) = " ")
                ObjectPath = Left(ObjectPath, Len(ObjectPath) - 1)
        Loop

        If Left(ObjectPath, 1) = "/" Then
                ObjectPath = Right(ObjectPath, Len(ObjectPath) - 1)
        End If

        If Right(ObjectPath, 1) = "/" Then
                ObjectPath = Left(ObjectPath, Len(ObjectPath) - 1)
        End If

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying To Sanitize the path: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

End Sub


'''''''''''''''''''''''''''''
' AppCreateCommand
'''''''''''''''''''''''''''''
Function AppCreateCommand(InProcFlag)
        On Error Resume Next

        Dim IIsObject
        Dim IIsObjectPath
        Dim ObjectPath
        Dim MachineName

        AppCreateCommand = 0 ' Assume Success

        If ArgCount <> 2 Then
                WScript.Echo "Error: Wrong number of Args for the APPCREATE command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)
        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)

        IIsObjectPath = "IIS://" & MachineName
        If ObjectPath <> "" Then
                IIsObjectPath = IIsObjectPath & "/" & ObjectPath
        End If

        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to get the path of the application: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        IIsObject.AppCreate2 (InProcFlag)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to create the application: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        WScript.Echo "Application Created."

End Function


'''''''''''''''''''''''''''''
' AppDeleteCommand
'''''''''''''''''''''''''''''
Function AppDeleteCommand()
        On Error Resume Next

        Dim IIsObject
        Dim IIsObjectPath
        Dim ObjectPath
        Dim MachineName

        AppDeleteCommand = 0 ' Assume Success

        If ArgCount <> 2 Then
                WScript.Echo "Error: Wrong number of Args for the APPDELETE command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)
        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)

        IIsObjectPath = "IIS://" & MachineName
        If ObjectPath <> "" Then
                IIsObjectPath = IIsObjectPath & "/" & ObjectPath
        End If

        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to get the path of the application: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        IIsObject.AppDelete

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to DELETE the application: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        WScript.Echo "Application Deleted."

End Function


'''''''''''''''''''''''''''''
' AppUnloadCommand
'''''''''''''''''''''''''''''
Function AppUnloadCommand()
        On Error Resume Next

        Dim IIsObject
        Dim IIsObjectPath
        Dim ObjectPath
        Dim MachineName

        AppUnloadCommand = 0 ' Assume Success

        If ArgCount <> 2 Then
                WScript.Echo "Error: Wrong number of Args for the APPUNLOAD command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)
        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)

        IIsObjectPath = "IIS://" & MachineName
        If ObjectPath <> "" Then
                IIsObjectPath = IIsObjectPath & "/" & ObjectPath
        End If

        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to get the path of the application: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        IIsObject.AppUnload

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to UNLOAD the application: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        WScript.Echo "Application Unloaded."

End Function


Function AppDisableCommand()
        On Error Resume Next

        Dim IIsObject
        Dim IIsObjectPath
        Dim ObjectPath
        Dim MachineName

        AppDisableCommand = 0 ' Assume Success

        If ArgCount <> 2 Then
                WScript.Echo "Error: Wrong number of Args for the APPDISABLE command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)
        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)

'debug
'WScript.Echo "Last Error: " & Err & " (" & Hex (Err) & "): " & Err.Description

        IIsObjectPath = "IIS://" & MachineName
        If ObjectPath <> "" Then
            IIsObjectPath = IIsObjectPath & "/" & ObjectPath
        End If

        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to get the path of the application: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        IIsObject.AppDisable

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to disable the application: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

'debug
'WScript.Echo "Last Error: " & Err & " (" & Hex (Err) & "): " & Err.Description

        WScript.Echo "Application Disabled."

End Function

Function AppEnableCommand()
        On Error Resume Next

        Dim IIsObject
        Dim IIsObjectPath
        Dim ObjectPath
        Dim MachineName

        AppEnableCommand = 0 ' Assume Success

        If ArgCount <> 2 Then
                WScript.Echo "Error: Wrong number of Args for the APPENABLE command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)
        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)

'debug
'WScript.Echo "Last Error: " & Err & " (" & Hex (Err) & "): " & Err.Description

        IIsObjectPath = "IIS://" & MachineName
        If ObjectPath <> "" Then
            IIsObjectPath = IIsObjectPath & "/" & ObjectPath
        End If

        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to get the path of the application: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        IIsObject.AppEnable

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to Enable the application: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

'debug
'WScript.Echo "Last Error: " & Err & " (" & Hex (Err) & "): " & Err.Description

        WScript.Echo "Application Enabled."

End Function

'''''''''''''''''''''''''''''
' AppGetStatusCommand
'''''''''''''''''''''''''''''
Function AppGetStatusCommand()
        On Error Resume Next

        Dim IIsObject
        Dim IIsObjectPath
        Dim ObjectPath
        Dim MachineName
        Dim Status

        AppGetStatusCommand = 0 ' Assume Success

        If ArgCount <> 2 Then
                WScript.Echo "Error: Wrong number of Args for the APPGETSTATUS command"
                WScript.Quit (GENERAL_FAILURE)
        End If

        ObjectPath = Args(1)
        SanitizePath ObjectPath
        MachineName = SeparateMachineName(ObjectPath)

        IIsObjectPath = "IIS://" & MachineName
        If ObjectPath <> "" Then
                IIsObjectPath = IIsObjectPath & "/" & ObjectPath
        End If

        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to get the path of the application: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        Status = IIsObject.AppGetStatus2

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to retrieve the application STATUS: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

        WScript.Echo "Application Status: " & Status

End Function

                

 ''''''''''''''''''''''''''
'
' IsSecureProperty
'
' Checks to see if the property requires special processing in order to
' display its contents.
'
''''''''''''''''''''''''''
Function IsSecureProperty(ObjectParameter,MachineName)

        On Error Resume Next
	Dim PropObj,Attribute
	Set PropObj = GetObject("IIS://" & MachineName & "/schema/" & ObjectParameter)
	If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to get the property: " & err.number
                WScript.Quit (Err.Number)
        End If
	Attribute = PropObj.Secure
	If (Attribute = True) Then
		IsSecureProperty = True
	Else
		IsSecureProperty = False
	End If 
End Function
'' SIG '' Begin signature block
'' SIG '' MIIlSgYJKoZIhvcNAQcCoIIlOzCCJTcCAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFPFoaDxwka+Y
'' SIG '' efoh3KlQRrh4yoipoIIecjCCBTAwggQYoAMCAQICEAQJ
'' SIG '' GBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTEL
'' SIG '' MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IElu
'' SIG '' YzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
'' SIG '' A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENB
'' SIG '' MB4XDTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFow
'' SIG '' cjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0
'' SIG '' IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
'' SIG '' MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
'' SIG '' IENvZGUgU2lnbmluZyBDQTCCASIwDQYJKoZIhvcNAQEB
'' SIG '' BQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsxSRnP
'' SIG '' 0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3
'' SIG '' Gde2qvCchqXYJawOeSg6funRZ9PG+yknx9N7I5TkkSOW
'' SIG '' kHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJRdQtoaPp
'' SIG '' iCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/
'' SIG '' 6XzLkqHlOzEcz+ryCuRXu0q16XTmK/5sy350OTYNkO/k
'' SIG '' tU6kqepqCquE86xnTrXE94zRICUj6whkPlKWwfIPEvTF
'' SIG '' jg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+m
'' SIG '' M6n9Gd8lk9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQI
'' SIG '' MAYBAf8CAQAwDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQM
'' SIG '' MAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggr
'' SIG '' BgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
'' SIG '' MEMGCCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3Js
'' SIG '' NC5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURS
'' SIG '' b290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3JsME8GA1UdIARIMEYwOAYKYIZIAYb9bAACBDAqMCgG
'' SIG '' CCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdpY2VydC5j
'' SIG '' b20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7
'' SIG '' KgqjpepxA8Bg+S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv
'' SIG '' 9JLLgjEtUYunpyGd823IDzANBgkqhkiG9w0BAQsFAAOC
'' SIG '' AQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134L
'' SIG '' YP3DPQ/Er4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFO
'' SIG '' EKTuP3GOYw4TS63XX0R58zYUBor3nEZOXP+QsRsHDpEV
'' SIG '' +7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRH
'' SIG '' oXpoaK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQM
'' SIG '' JQhCMrI2iiQC/i9yfhzXSUWW6Fkd6fp0ZGuy62ZD2rOw
'' SIG '' jNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
'' SIG '' 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBY0w
'' SIG '' ggR1oAMCAQICEA6bGI750C3n79tQ4ghAGFowDQYJKoZI
'' SIG '' hvcNAQEMBQAwZTELMAkGA1UEBhMCVVMxFTATBgNVBAoT
'' SIG '' DERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
'' SIG '' ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJl
'' SIG '' ZCBJRCBSb290IENBMB4XDTIyMDgwMTAwMDAwMFoXDTMx
'' SIG '' MTEwOTIzNTk1OVowYjELMAkGA1UEBhMCVVMxFTATBgNV
'' SIG '' BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRp
'' SIG '' Z2ljZXJ0LmNvbTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1
'' SIG '' c3RlZCBSb290IEc0MIICIjANBgkqhkiG9w0BAQEFAAOC
'' SIG '' Ag8AMIICCgKCAgEAv+aQc2jeu+RdSjwwIjBpM+zCpyUu
'' SIG '' ySE98orYWcLhKac9WKt2ms2uexuEDcQwH/MbpDgW61bG
'' SIG '' l20dq7J58soR0uRf1gU8Ug9SH8aeFaV+vp+pVxZZVXKv
'' SIG '' aJNwwrK6dZlqczKU0RBEEC7fgvMHhOZ0O21x4i0MG+4g
'' SIG '' 1ckgHWMpLc7sXk7Ik/ghYZs06wXGXuxbGrzryc/NrDRA
'' SIG '' X7F6Zu53yEioZldXn1RYjgwrt0+nMNlW7sp7XeOtyU9e
'' SIG '' 5TXnMcvak17cjo+A2raRmECQecN4x7axxLVqGDgDEI3Y
'' SIG '' 1DekLgV9iPWCPhCRcKtVgkEy19sEcypukQF8IUzUvK4b
'' SIG '' A3VdeGbZOjFEmjNAvwjXWkmkwuapoGfdpCe8oU85tRFY
'' SIG '' F/ckXEaPZPfBaYh2mHY9WV1CdoeJl2l6SPDgohIbZpp0
'' SIG '' yt5LHucOY67m1O+SkjqePdwA5EUlibaaRBkrfsCUtNJh
'' SIG '' besz2cXfSwQAzH0clcOP9yGyshG3u3/y1YxwLEFgqrFj
'' SIG '' GESVGnZifvaAsPvoZKYz0YkH4b235kOkGLimdwHhD5QM
'' SIG '' IR2yVCkliWzlDlJRR3S+Jqy2QXXeeqxfjT/JvNNBERJb
'' SIG '' 5RBQ6zHFynIWIgnffEx1P2PsIV/EIFFrb7GrhotPwtZF
'' SIG '' X50g/KEexcCPorF+CiaZ9eRpL5gdLfXZqbId5RsCAwEA
'' SIG '' AaOCATowggE2MA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0O
'' SIG '' BBYEFOzX44LScV1kTN8uZz/nupiuHA9PMB8GA1UdIwQY
'' SIG '' MBaAFEXroq/0ksuCMS1Ri6enIZ3zbcgPMA4GA1UdDwEB
'' SIG '' /wQEAwIBhjB5BggrBgEFBQcBAQRtMGswJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggr
'' SIG '' BgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDBF
'' SIG '' BgNVHR8EPjA8MDqgOKA2hjRodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3JsMBEGA1UdIAQKMAgwBgYEVR0gADANBgkqhkiG9w0B
'' SIG '' AQwFAAOCAQEAcKC/Q1xV5zhfoKN0Gz22Ftf3v1cHvZqs
'' SIG '' oYcs7IVeqRq7IviHGmlUIu2kiHdtvRoU9BNKei8ttzjv
'' SIG '' 9P+Aufih9/Jy3iS8UgPITtAq3votVs/59PesMHqai7Je
'' SIG '' 1M/RQ0SbQyHrlnKhSLSZy51PpwYDE3cnRNTnf+hZqPC/
'' SIG '' Lwum6fI0POz3A8eHqNJMQBk1RmppVLC4oVaO7KTVPeix
'' SIG '' 3P0c2PR3WlxUjG/voVA9/HYJaISfb8rbII01YBwCA8sg
'' SIG '' sKxYoA5AY8WYIsGyWfVVa88nq2x2zm8jLfR+cWojayL/
'' SIG '' ErhULSd+2DrZ8LaHlv1b0VysGMNNn3O3AamfV6peKOK5
'' SIG '' lDCCBjMwggUboAMCAQICEAiadJ64LcPsJ+pl6tv4NTEw
'' SIG '' DQYJKoZIhvcNAQELBQAwcjELMAkGA1UEBhMCVVMxFTAT
'' SIG '' BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQg
'' SIG '' U0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBDQTAe
'' SIG '' Fw0yMTA1MjUwMDAwMDBaFw0yNDA1MjkyMzU5NTlaMHEx
'' SIG '' CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpOZXcgSmVyc2V5
'' SIG '' MQ8wDQYDVQQHEwZJc2VsaW4xHTAbBgNVBAoTFGVHIElu
'' SIG '' bm92YXRpb25zLCBJbmMuMR0wGwYDVQQDExRlRyBJbm5v
'' SIG '' dmF0aW9ucywgSW5jLjCCAiIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggIPADCCAgoCggIBAMRlCdKa4238XJoGRo3eyQ8TrO7M
'' SIG '' kh72kN8Bkdimw92mWoHkhPpBtLSpBLEOJ2vG5zVYmP8x
'' SIG '' eD26NGZGLTMySJNAGVw0zL16/5hL5isQm4iRUwqSpJme
'' SIG '' LGuQWXzu4oCL3DUmtMyCNmuY4kCRcvOY/n/SOBIE6PTn
'' SIG '' HVXiDV4YENsWek4xCvqW4aplV76/AwduiXJTmnndC+Vb
'' SIG '' O/gmxs2bion4MS9ovHeRQ85IWUmX3QrRrRLxOaS3rF0l
'' SIG '' n6c1HXbwjUYrCDxge5oPkZZ9l71GcsmkVEbZcddaWHyf
'' SIG '' yjWAJFAi9t654d/P5msbUr3XoqGAY+MS8re6aEARvm9L
'' SIG '' swo4EQA3t/5NDbYlcCSKNGRLFMgwDaeySCIzHj87DjGM
'' SIG '' 3zD8ovHJQMHwWHNl4UrlHF98in+JKURZgpWHyuS7LRkE
'' SIG '' TWzjY6bAgUxIGbsBH5HTlNK5mjMsGRVSxxKZqWGXj8+z
'' SIG '' N1YTfmleepEf3n6PHg/NROVQ0KpiYhliqv7PY4W5GB+4
'' SIG '' NroS9jF2/7kbIVQ0jpBUbyCA/5fsgyaIAwaWnt8dqL+W
'' SIG '' L42PGaPERdLV78ktK37A7wDWcO5qbcx59AZZsOZboNxd
'' SIG '' glSaTW829R5gB+pNMhR5lmAqFADWwQdGEf5OCb4GNm8r
'' SIG '' bRe3EDycpe1CPQruCkwIO0TphpMHS4Zl6DwgXKNBAgMB
'' SIG '' AAGjggHEMIIBwDAfBgNVHSMEGDAWgBRaxLl7Kgqjpepx
'' SIG '' A8Bg+S32ZXUOWDAdBgNVHQ4EFgQU+chEms/YE0kvGgTW
'' SIG '' ta9+DDAONkowDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQM
'' SIG '' MAoGCCsGAQUFBwMDMHcGA1UdHwRwMG4wNaAzoDGGL2h0
'' SIG '' dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
'' SIG '' ZWQtY3MtZzEuY3JsMDWgM6Axhi9odHRwOi8vY3JsNC5k
'' SIG '' aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNy
'' SIG '' bDBLBgNVHSAERDBCMDYGCWCGSAGG/WwDATApMCcGCCsG
'' SIG '' AQUFBwIBFhtodHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9D
'' SIG '' UFMwCAYGZ4EMAQQBMIGEBggrBgEFBQcBAQR4MHYwJAYI
'' SIG '' KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNv
'' SIG '' bTBOBggrBgEFBQcwAoZCaHR0cDovL2NhY2VydHMuZGln
'' SIG '' aWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRENv
'' SIG '' ZGVTaWduaW5nQ0EuY3J0MAwGA1UdEwEB/wQCMAAwDQYJ
'' SIG '' KoZIhvcNAQELBQADggEBAJQI53BT7yyssE/+AxAhu2x2
'' SIG '' 7YlZfrrpn0Y9mKxbgobIJL9T5kKYH8qcQt4PhK1fckVf
'' SIG '' Pl10gsDmiid7+kS536YS4RMGHNvtELPzZYm+TQMQxriH
'' SIG '' MwCHlznOZEUabxbENl0jbTO1y9bSw5uqf1RuwaFAMqkV
'' SIG '' 7DD3Vm05Df/Z3QphkrKnMYxtrnfDulYbXvSeS2hwVZN5
'' SIG '' SGQDLR+gAnaOUE6zOPZ2yFPEBrkWDV2SkSwFLuiIA+li
'' SIG '' SjFX2V1pcnw/HWdq93o+kNbgDvzW7Xd/e0/gVUKw1jDh
'' SIG '' vPhnkYicKHr8WyFodEnp2TlKwKvb0yWkrxTEr3LZCZv6
'' SIG '' MS1HFHRBkt8wggauMIIElqADAgECAhAHNje3JFR82Ees
'' SIG '' /ShmKl5bMA0GCSqGSIb3DQEBCwUAMGIxCzAJBgNVBAYT
'' SIG '' AlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNV
'' SIG '' BAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERp
'' SIG '' Z2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMjAzMjMw
'' SIG '' MDAwMDBaFw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYT
'' SIG '' AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkG
'' SIG '' A1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
'' SIG '' IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqG
'' SIG '' SIb3DQEBAQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJ
'' SIG '' UVXHJQPE8pE3qZdRodbSg9GeTKJtoLDMg/la9hGhRBVC
'' SIG '' X6SI82j6ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0
'' SIG '' hNoR8XOxs+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w
'' SIG '' 1lbU5ygt69OxtXXnHwZljZQp09nsad/ZkIdGAHvbREGJ
'' SIG '' 3HxqV3rwN3mfXazL6IRktFLydkf3YYMZ3V+0VAshaG43
'' SIG '' IbtArF+y3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFk
'' SIG '' dECnwHLFuk4fsbVYTXn+149zk6wsOeKlSNbwsDETqVcp
'' SIG '' licu9Yemj052FVUmcJgmf6AaRyBD40NjgHt1biclkJg6
'' SIG '' OBGz9vae5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTy
'' SIG '' UpURK1h0QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZGs506
'' SIG '' o9UD4L/wojzKQtwYSH8UNM/STKvvmz3+DrhkKvp1KCRB
'' SIG '' 7UK/BZxmSVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfc
'' SIG '' Yd6T/jnA+bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwM
'' SIG '' O1uKIqjBJgj5FBASA31fI7tk42PgpuE+9sJ0sj8eCXbs
'' SIG '' q11GdeJgo1gJASgADoRU7s7pXcheMBK9Rp6103a50g5r
'' SIG '' mQzSM7TNsQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgw
'' SIG '' BgEB/wIBADAdBgNVHQ4EFgQUuhbZbU2FL3MpdpovdYxq
'' SIG '' II+eyG8wHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6
'' SIG '' mK4cD08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoG
'' SIG '' CCsGAQUFBwMIMHcGCCsGAQUFBwEBBGswaTAkBggrBgEF
'' SIG '' BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEG
'' SIG '' CCsGAQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2Vy
'' SIG '' dC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBD
'' SIG '' BgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNy
'' SIG '' bDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1s
'' SIG '' BwEwDQYJKoZIhvcNAQELBQADggIBAH1ZjsCTtm+YqUQi
'' SIG '' AX5m1tghQuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaop
'' SIG '' afxpwc8dB+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQ
'' SIG '' TGIdDAiCqBa9qVbPFXONASIlzpVpP0d3+3J0FNf/q0+K
'' SIG '' LHqrhc1DX+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQ
'' SIG '' cAp876i8dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6
'' SIG '' wCeCRK6ZJxurJB4mwbfeKuv2nrF5mYGjVoarCkXJ38SN
'' SIG '' oOeY+/umnXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3
'' SIG '' ZpHxcpzpSwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/
'' SIG '' a6fxZsNBzU+2QJshIUDQtxMkzdwdeDrknq3lNHGS1yZr
'' SIG '' 5Dhzq6YBT70/O3itTK37xJV77QpfMzmHQXh6OOmc4d0j
'' SIG '' /R0o08f56PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT
'' SIG '' 1ObyF5lZynDwN7+YAN8gFk8n+2BnFqFmut1VwDophrCY
'' SIG '' oCvtlUG3OtUVmDG0YgkPCr2B2RP+v6TR81fZvAT6gt4y
'' SIG '' 3wSJ8ADNXcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqk
'' SIG '' hQ/8mJb2VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3OBqh
'' SIG '' K/bt1nz8MIIGwDCCBKigAwIBAgIQDE1pckuU+jwqSj0p
'' SIG '' B4A9WjANBgkqhkiG9w0BAQsFADBjMQswCQYDVQQGEwJV
'' SIG '' UzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNV
'' SIG '' BAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBT
'' SIG '' SEEyNTYgVGltZVN0YW1waW5nIENBMB4XDTIyMDkyMTAw
'' SIG '' MDAwMFoXDTMzMTEyMTIzNTk1OVowRjELMAkGA1UEBhMC
'' SIG '' VVMxETAPBgNVBAoTCERpZ2lDZXJ0MSQwIgYDVQQDExtE
'' SIG '' aWdpQ2VydCBUaW1lc3RhbXAgMjAyMiAtIDIwggIiMA0G
'' SIG '' CSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDP7KUmOsap
'' SIG '' 8mu7jcENmtuh6BSFdDMaJqzQHFUeHjZtvJJVDGH0nQl3
'' SIG '' PRWWCC9rZKT9BoMW15GSOBwxApb7crGXOlWvM+xhiumm
'' SIG '' KNuQY1y9iVPgOi2Mh0KuJqTku3h4uXoW4VbGwLpkU7sq
'' SIG '' FudQSLuIaQyIxvG+4C99O7HKU41Agx7ny3JJKB5MgB6F
'' SIG '' VueF7fJhvKo6B332q27lZt3iXPUv7Y3UTZWEaOOAy2p5
'' SIG '' 0dIQkUYp6z4m8rSMzUy5Zsi7qlA4DeWMlF0ZWr/1e0Bu
'' SIG '' bxaompyVR4aFeT4MXmaMGgokvpyq0py2909ueMQoP6Mc
'' SIG '' D1AGN7oI2TWmtR7aeFgdOej4TJEQln5N4d3CraV++C0b
'' SIG '' H+wrRhijGfY59/XBT3EuiQMRoku7mL/6T+R7Nu8GRORV
'' SIG '' /zbq5Xwx5/PCUsTmFntafqUlc9vAapkhLWPlWfVNL5Af
'' SIG '' J7fSqxTlOGaHUQhr+1NDOdBk+lbP4PQK5hRtZHi7mP2U
'' SIG '' w3Mh8y/CLiDXgazT8QfU4b3ZXUtuMZQpi+ZBpGWUwFjl
'' SIG '' 5S4pkKa3YWT62SBsGFFguqaBDwklU/G/O+mrBw5qBzli
'' SIG '' GcnWhX8T2Y15z2LF7OF7ucxnEweawXjtxojIsG4yeccL
'' SIG '' WYONxu71LHx7jstkifGxxLjnU15fVdJ9GSlZA076XepF
'' SIG '' cxyEftfO4tQ6dwIDAQABo4IBizCCAYcwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/BAww
'' SIG '' CgYIKwYBBQUHAwgwIAYDVR0gBBkwFzAIBgZngQwBBAIw
'' SIG '' CwYJYIZIAYb9bAcBMB8GA1UdIwQYMBaAFLoW2W1NhS9z
'' SIG '' KXaaL3WMaiCPnshvMB0GA1UdDgQWBBRiit7QYfyPMRTt
'' SIG '' lwvNPSqUFN9SnDBaBgNVHR8EUzBRME+gTaBLhklodHRw
'' SIG '' Oi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
'' SIG '' dGVkRzRSU0E0MDk2U0hBMjU2VGltZVN0YW1waW5nQ0Eu
'' SIG '' Y3JsMIGQBggrBgEFBQcBAQSBgzCBgDAkBggrBgEFBQcw
'' SIG '' AYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMFgGCCsG
'' SIG '' AQUFBzAChkxodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5j
'' SIG '' b20vRGlnaUNlcnRUcnVzdGVkRzRSU0E0MDk2U0hBMjU2
'' SIG '' VGltZVN0YW1waW5nQ0EuY3J0MA0GCSqGSIb3DQEBCwUA
'' SIG '' A4ICAQBVqioa80bzeFc3MPx140/WhSPx/PmVOZsl5vdy
'' SIG '' ipjDd9Rk/BX7NsJJUSx4iGNVCUY5APxp1MqbKfujP8DJ
'' SIG '' AJsTHbCYidx48s18hc1Tna9i4mFmoxQqRYdKmEIrUPwb
'' SIG '' tZ4IMAn65C3XCYl5+QnmiM59G7hqopvBU2AJ6KO4ndet
'' SIG '' Hxy47JhB8PYOgPvk/9+dEKfrALpfSo8aOlK06r8JSRU1
'' SIG '' NlmaD1TSsht/fl4JrXZUinRtytIFZyt26/+YsiaVOBmI
'' SIG '' RBTlClmia+ciPkQh0j8cwJvtfEiy2JIMkU88ZpSvXQJT
'' SIG '' 657inuTTH4YBZJwAwuladHUNPeF5iL8cAZfJGSOA1zZa
'' SIG '' X5YWsWMMxkZAO85dNdRZPkOaGK7DycvD+5sTX2q1x+Dz
'' SIG '' BcNZ3ydiK95ByVO5/zQQZ/YmMph7/lxClIGUgp2sCovG
'' SIG '' SxVK05iQRWAzgOAj3vgDpPZFR+XOuANCR+hBNnF3rf2i
'' SIG '' 6Jd0Ti7aHh2MWsgemtXC8MYiqE+bvdgcmlHEL5r2X6cn
'' SIG '' l7qWLoVXwGDneFZ/au/ClZpLEQLIgpzJGgV8unG1TnqZ
'' SIG '' bPTontRamMifv427GFxD9dAq6OJi7ngE273R+1sKqHB+
'' SIG '' 8JeEeOMIA11HLGOoJTiXAdI/Otrl5fbmm9x+LMz/F0xN
'' SIG '' AKLY1gEOuIvu5uByVYksJxlh9ncBjDGCBkQwggZAAgEB
'' SIG '' MIGGMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJl
'' SIG '' ZCBJRCBDb2RlIFNpZ25pbmcgQ0ECEAiadJ64LcPsJ+pl
'' SIG '' 6tv4NTEwCQYFKw4DAhoFAKBwMBAGCisGAQQBgjcCAQwx
'' SIG '' AjAAMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwG
'' SIG '' CisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMCMGCSqG
'' SIG '' SIb3DQEJBDEWBBS+ODZppy9g0qayTqtUFbuTBcD1ETAN
'' SIG '' BgkqhkiG9w0BAQEFAASCAgA+W74nHbWZOB1zZG6Kuagj
'' SIG '' ISc0LH3xW1soJPnYr+0KDAhkgAh6Agg2DNMm+BQcy3i1
'' SIG '' 57q34c+6Y7nFkK38B6L+XdXzkY3FtTyB/XWgKZRL1+cs
'' SIG '' 1dV39+dXwyOI4ymxrt5mMt6KeG9RT/Jo/B3rbmR5RBhW
'' SIG '' TXFxzVFr/2bcDUlPW/C3O6KyI/59FQc9xAKydruGggUk
'' SIG '' oHkBwMwUQABBwv70bOMGCa66qAn7LFSllkUB3twRf1+l
'' SIG '' f1cer29jvwyj+TocS5ZaXGS9qSk30Cw4xCIuUWkINyf/
'' SIG '' QkKn5bfvTSvYMgv/9iY67IKBwNt9Z7is2QPbMNw4atGB
'' SIG '' 29/IPnFcA6E7MaQPIlaLTBZeAYkXsSt1aKsgKVfZ7N0j
'' SIG '' U+9FgtHR8qRA1Ab5ZsMAKhpDQ1mt5bOfRvmXa/OkHIdJ
'' SIG '' w2RkE9CIc9uXkR0R7sC73GGxfkI1qM9Zar03ZXHdsRkL
'' SIG '' GMQaUFGcpTmJPUpuKwlpVOq9j+On48cJWZwx7JXQu821
'' SIG '' oFFZguJxcuDjuAmBFkYByTDT6x0JPiz4HYlJ34SgZqkU
'' SIG '' aAnye7+FwV1UyCd+y7+9PuIZ8I3iD+bfP19UDTEGRatC
'' SIG '' Zjcqgyd1XhtAVngE/rjDabPzUOCydGibjDt3/Nnscy7k
'' SIG '' ZhWNxMG3QTFpwxfMREvU92LBn+BiDo942sHoz5PgTZ+G
'' SIG '' S6GCAyAwggMcBgkqhkiG9w0BCQYxggMNMIIDCQIBATB3
'' SIG '' MGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2Vy
'' SIG '' dCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3Rl
'' SIG '' ZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcg
'' SIG '' Q0ECEAxNaXJLlPo8Kko9KQeAPVowDQYJYIZIAWUDBAIB
'' SIG '' BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwG
'' SIG '' CSqGSIb3DQEJBTEPFw0yMjEyMTQwODU3MzBaMC8GCSqG
'' SIG '' SIb3DQEJBDEiBCDARZSGT9azcXmgs8Gx/ax1RZUCbaM/
'' SIG '' m8gzqCTA1wa8GzANBgkqhkiG9w0BAQEFAASCAgBOw6BQ
'' SIG '' 9KDVy5Lnxf1SM9vlyeE53PQkRBY5s6xkBzQDIcf4at6D
'' SIG '' u0NHE6YjeEPLyk5xoJITf2XzGuzzrcDNIxAAs/0OwoYT
'' SIG '' I9yZ501ifNI+zFm2xeLurf/E0Ynv2rQi1owfMJSJlM5k
'' SIG '' 2TWMwueHn9S+Vy8GMQcEHzizuBRHIeB9JiBZYJHbi0ES
'' SIG '' 17XBDcQ6WtQ1uqx4fbtsYh7DLnpFOodTkDdY5cvzNA+g
'' SIG '' tSzA6CIZO00F2g7ui6sz8gqVT22pC/3dTLOxi7AyVKVu
'' SIG '' /2BaFK2dU30OHkhsusLMe8pg5F6iSe6YigOwrgz9hqBM
'' SIG '' 2kAxDVtlIgg22QBtMW6bOSloa+SX/oi4HfjoIjPamsv+
'' SIG '' 8tYg8hWJfG7J+rmn0edBmBeuJnbNcsjEj4Hnacp+ixyh
'' SIG '' mGSSh78MrxF/7mNZ2NT+GIsoAGw8FHcG1+iL7Clxb9Jx
'' SIG '' besZsBs04iwFPxWwLDLlw0bUDDcvyzcQ0ICElk6Mbdgv
'' SIG '' cWcK4p0VOSDcZ33hEb5YiEXCQnJJvWXbKP1nW7YkcKZ3
'' SIG '' DJ9514FvEyRoHtscddRcrBuzH0gq5Zw3X88LvLMWumjz
'' SIG '' 2DErM2SKWJlWy6REd6hX+xO/9obf88hhQeK7mzNIxp8F
'' SIG '' L8KtEkz92zZJp90iroXlEptiFhYlhmh++1Z2og7K7Jnx
'' SIG '' sv4SOJGJHoGQrdWwrw==
'' SIG '' End signature block
