$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Import-module ActiveDirectory
$Domain = Get-ADDomain -Current LocalComputer 
$ADDomainTrusts = Get-ADObject -Filter {ObjectClass -eq "trustedDomain"} -Server $Domain.Name -Properties * -EA 0 

If($? -and $ADDomainTrusts -ne $Null) {
    If($ADDomainTrusts -is [array])
	{
	    [int]$ADDomainTrustsCount = $ADDomainTrusts.Count 
	}
	Else
	{
	    [int]$ADDomainTrustsCount = 1
	}
    Write-host "Discovered $ADDomainTrustsCount trusts in $Domain.Name"
    Write-host 
    ForEach($Trust in $ADDomainTrusts) 
	{ 
	    $TrustName = $Trust.Name 
		$TrustDescription = $Trust.Description 
		$TrustCreated = $Trust.Created 
		$TrustModified = $Trust.Modified 
		$TrustDirectionNumber = $Trust.TrustDirection
		$TrustTypeNumber = $Trust.TrustType
		$TrustAttributesNumber = $Trust.TrustAttributes

        Switch ($TrustTypeNumber) 
		{ 
		    1 { $TrustType = "Downlevel (Windows NT domain external)"} 
			2 { $TrustType = "Uplevel (Active Directory domain - parent-child, root domain, shortcut, external, or forest)"} 
			3 { $TrustType = "MIT (non-Windows) Kerberos version 5 realm"} 
			4 { $TrustType = "DCE (Theoretical trust type - DCE refers to Open Group's Distributed Computing Environment specification)"} 
			Default { $TrustType = $TrustTypeNumber }
		}

        Switch ($TrustAttributesNumber) 
		{ 
			1 { $TrustAttributes = "Non-Transitive"} 
			2 { $TrustAttributes = "Uplevel clients only (Windows 2000 or newer"} 
			4 { $TrustAttributes = "Quarantined Domain (External)"} 
			8 { $TrustAttributes = "Forest Trust"} 
			16 { $TrustAttributes = "Cross-Organizational Trust (Selective Authentication)"} 
			32 { $TrustAttributes = "Intra-Forest Trust (trust within the forest)"} 
			64 { $TrustAttributes = "Inter-Forest Trust (trust with another forest)"} 
			Default { $TrustAttributes = $TrustAttributesNumber }
		}  

        Switch ($TrustDirectionNumber) 
		{ 
			0 { $TrustDirection = "Disabled (The trust relationship exists but has been disabled)"} 
			1 { $TrustDirection = "Inbound (TrustING domain)"} 
			2 { $TrustDirection = "Outbound (TrustED domain)"} 
			3 { $TrustDirection = "Bidirectional (two-way trust)"} 
			Default { $TrustDirection = $TrustDirectionNumber }
		}

        Write-host "Trust Name: $TrustName"
        Write-host "Trust Description: $TrustDescription"
        Write-host "Trust Created: $TrustCreated"
        Write-host "Trust Modified: $TrustModified"
        Write-host "Trust Direction: $TrustDirection"
        Write-host "Trust Type: $TrustType"
        write-host "Trust Attribute: $TrustAttributes"
        Write-Host 
    }
}
ElseIf(!$?)
{
	#error retrieving domain trusts
	Write-host "Error retrieving domain trusts for $Domain.Name"
}
Else
{
	#no domain trust data
	Write-host "No domain trust data for $Domain.Name"
}